/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.protobuf.generated.VisibilityLabelsProtos;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.visibility.VisibilityClient;
import org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
import org.apache.hadoop.hbase.security.visibility.VisibilityController;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MediumTests.class})
public class TestVisibilityLabelsOpWithDifferentUsersNoACL {
    private static final String PRIVATE = "private";
    private static final String CONFIDENTIAL = "confidential";
    private static final String SECRET = "secret";
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static Configuration conf;
    @Rule
    public final TestName TEST_NAME = new TestName();
    private static User SUPERUSER;
    private static User NORMAL_USER;
    private static User NORMAL_USER1;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        conf.setInt("hfile.format.version", 3);
        String currentUser = User.getCurrent().getName();
        conf.set("hbase.superuser", "admin," + currentUser);
        conf.set("hbase.coprocessor.master.classes", VisibilityController.class.getName());
        conf.set("hbase.coprocessor.region.classes", VisibilityController.class.getName());
        TEST_UTIL.startMiniCluster(2);
        TEST_UTIL.waitTableEnabled(VisibilityConstants.LABELS_TABLE_NAME.getName(), 50000L);
        SUPERUSER = User.createUserForTesting(conf, "admin", new String[]{"supergroup"});
        NORMAL_USER = User.createUserForTesting(conf, "user1", new String[0]);
        NORMAL_USER1 = User.createUserForTesting(conf, "user2", new String[0]);
        TestVisibilityLabelsOpWithDifferentUsersNoACL.addLabels();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testLabelsTableOpsWithDifferentUsers() throws Throwable {
        PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse> action = new PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse>(){

            @Override
            public VisibilityLabelsProtos.VisibilityLabelsResponse run() throws Exception {
                try {
                    return VisibilityClient.setAuths(conf, new String[]{TestVisibilityLabelsOpWithDifferentUsersNoACL.CONFIDENTIAL, TestVisibilityLabelsOpWithDifferentUsersNoACL.PRIVATE}, "user1");
                }
                catch (Throwable throwable) {
                    return null;
                }
            }
        };
        VisibilityLabelsProtos.VisibilityLabelsResponse response = SUPERUSER.runAs(action);
        Assert.assertTrue((boolean)response.getResult(0).getException().getValue().isEmpty());
        Assert.assertTrue((boolean)response.getResult(1).getException().getValue().isEmpty());
        action = new PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse>(){

            @Override
            public VisibilityLabelsProtos.VisibilityLabelsResponse run() throws Exception {
                try {
                    return VisibilityClient.setAuths(conf, new String[]{TestVisibilityLabelsOpWithDifferentUsersNoACL.CONFIDENTIAL, TestVisibilityLabelsOpWithDifferentUsersNoACL.PRIVATE}, "user3");
                }
                catch (Throwable throwable) {
                    return null;
                }
            }
        };
        response = NORMAL_USER1.runAs(action);
        Assert.assertEquals((Object)"org.apache.hadoop.hbase.security.AccessDeniedException", (Object)response.getResult(0).getException().getName());
        Assert.assertEquals((Object)"org.apache.hadoop.hbase.security.AccessDeniedException", (Object)response.getResult(1).getException().getName());
        PrivilegedExceptionAction<VisibilityLabelsProtos.GetAuthsResponse> action1 = new PrivilegedExceptionAction<VisibilityLabelsProtos.GetAuthsResponse>(){

            @Override
            public VisibilityLabelsProtos.GetAuthsResponse run() throws Exception {
                try {
                    return VisibilityClient.getAuths(conf, "user1");
                }
                catch (Throwable throwable) {
                    return null;
                }
            }
        };
        VisibilityLabelsProtos.GetAuthsResponse authsResponse = NORMAL_USER.runAs(action1);
        Assert.assertTrue((boolean)authsResponse.getAuthList().isEmpty());
        authsResponse = NORMAL_USER1.runAs(action1);
        Assert.assertTrue((boolean)authsResponse.getAuthList().isEmpty());
        authsResponse = SUPERUSER.runAs(action1);
        ArrayList<String> authsList = new ArrayList<String>();
        for (ByteString authBS : authsResponse.getAuthList()) {
            authsList.add(Bytes.toString(authBS.toByteArray()));
        }
        Assert.assertEquals((long)2L, (long)authsList.size());
        Assert.assertTrue((boolean)authsList.contains(CONFIDENTIAL));
        Assert.assertTrue((boolean)authsList.contains(PRIVATE));
        PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse> action2 = new PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse>(){

            @Override
            public VisibilityLabelsProtos.VisibilityLabelsResponse run() throws Exception {
                try {
                    return VisibilityClient.clearAuths(conf, new String[]{TestVisibilityLabelsOpWithDifferentUsersNoACL.CONFIDENTIAL, TestVisibilityLabelsOpWithDifferentUsersNoACL.PRIVATE}, "user1");
                }
                catch (Throwable throwable) {
                    return null;
                }
            }
        };
        response = NORMAL_USER1.runAs(action2);
        Assert.assertEquals((Object)"org.apache.hadoop.hbase.security.AccessDeniedException", (Object)response.getResult(0).getException().getName());
        Assert.assertEquals((Object)"org.apache.hadoop.hbase.security.AccessDeniedException", (Object)response.getResult(1).getException().getName());
        response = SUPERUSER.runAs(action2);
        Assert.assertTrue((boolean)response.getResult(0).getException().getValue().isEmpty());
        Assert.assertTrue((boolean)response.getResult(1).getException().getValue().isEmpty());
        authsResponse = SUPERUSER.runAs(action1);
        Assert.assertTrue((boolean)authsResponse.getAuthList().isEmpty());
    }

    private static void addLabels() throws Exception {
        PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse> action = new PrivilegedExceptionAction<VisibilityLabelsProtos.VisibilityLabelsResponse>(){

            @Override
            public VisibilityLabelsProtos.VisibilityLabelsResponse run() throws Exception {
                String[] labels = new String[]{TestVisibilityLabelsOpWithDifferentUsersNoACL.SECRET, TestVisibilityLabelsOpWithDifferentUsersNoACL.CONFIDENTIAL, TestVisibilityLabelsOpWithDifferentUsersNoACL.PRIVATE};
                try {
                    VisibilityClient.addLabels(conf, labels);
                }
                catch (Throwable t) {
                    throw new IOException(t);
                }
                return null;
            }
        };
        SUPERUSER.runAs(action);
    }
}

