/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.visibility.ScanLabelGenerator;
import org.apache.hadoop.hbase.security.visibility.SimpleScanLabelGenerator;
import org.apache.hadoop.hbase.security.visibility.TestVisibilityLabels;
import org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
import org.apache.hadoop.hbase.security.visibility.VisibilityController;
import org.junit.BeforeClass;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestVisibilityLabelsWithDistributedLogReplay
extends TestVisibilityLabels {
    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("hbase.master.distributed.log.replay", true);
        conf.setInt("hfile.format.version", 3);
        conf.set("hbase.coprocessor.master.classes", VisibilityController.class.getName());
        conf.set("hbase.coprocessor.region.classes", VisibilityController.class.getName());
        conf.setClass("hbase.regionserver.scan.visibility.label.generator.class", SimpleScanLabelGenerator.class, ScanLabelGenerator.class);
        conf.set("hbase.superuser", "admin");
        TEST_UTIL.startMiniCluster(2);
        SUPERUSER = User.createUserForTesting(conf, "admin", new String[]{"supergroup"});
        TEST_UTIL.waitTableEnabled(VisibilityConstants.LABELS_TABLE_NAME.getName(), 50000L);
        TestVisibilityLabelsWithDistributedLogReplay.addLabels();
    }
}

