/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import java.io.IOException;
import java.util.BitSet;
import java.util.Iterator;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.io.util.StreamUtils;
import org.apache.hadoop.hbase.util.Pair;

@InterfaceAudience.Private
class VisibilityLabelFilter
extends FilterBase {
    private BitSet authLabels;

    public VisibilityLabelFilter(BitSet authLabels) {
        this.authLabels = authLabels;
    }

    @Override
    public Filter.ReturnCode filterKeyValue(Cell cell) throws IOException {
        Iterator<Tag> tagsItr = CellUtil.tagsIterator(cell.getTagsArray(), cell.getTagsOffset(), cell.getTagsLength());
        boolean visibilityTagPresent = false;
        while (tagsItr.hasNext()) {
            Pair<Integer, Integer> result;
            int offset;
            boolean includeKV = true;
            Tag tag = tagsItr.next();
            if (tag.getType() != 2) continue;
            visibilityTagPresent = true;
            int endOffset = offset + tag.getTagLength();
            for (offset = tag.getTagOffset(); offset < endOffset; offset += result.getSecond().intValue()) {
                result = StreamUtils.readRawVarint32(tag.getBuffer(), offset);
                int currLabelOrdinal = result.getFirst();
                if (currLabelOrdinal < 0) {
                    int temp = -currLabelOrdinal;
                    if (!this.authLabels.get(temp)) continue;
                    includeKV = false;
                    break;
                }
                if (this.authLabels.get(currLabelOrdinal)) continue;
                includeKV = false;
                break;
            }
            if (!includeKV) continue;
            return Filter.ReturnCode.INCLUDE;
        }
        return visibilityTagPresent ? Filter.ReturnCode.SKIP : Filter.ReturnCode.INCLUDE;
    }
}

