/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.protobuf.generated.VisibilityLabelsProtos;
import org.apache.hadoop.hbase.security.visibility.VisibilityUtils;
import org.apache.hadoop.hbase.security.visibility.ZKVisibilityLabelWatcher;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class VisibilityLabelsManager {
    private static final Log LOG = LogFactory.getLog(VisibilityLabelsManager.class);
    private static final List<String> EMPTY_LIST = new ArrayList<String>(0);
    private static VisibilityLabelsManager instance;
    private ZKVisibilityLabelWatcher zkVisibilityWatcher;
    private Map<String, Integer> labels = new HashMap<String, Integer>();
    private Map<Integer, String> ordinalVsLabels = new HashMap<Integer, String>();
    private Map<String, Set<Integer>> userAuths = new HashMap<String, Set<Integer>>();
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    private VisibilityLabelsManager(ZooKeeperWatcher watcher, Configuration conf) throws IOException {
        this.zkVisibilityWatcher = new ZKVisibilityLabelWatcher(watcher, this, conf);
        try {
            this.zkVisibilityWatcher.start();
        }
        catch (KeeperException ke) {
            LOG.error("ZooKeeper initialization failed", ke);
            throw new IOException(ke);
        }
    }

    public static synchronized VisibilityLabelsManager get(ZooKeeperWatcher watcher, Configuration conf) throws IOException {
        if (instance == null) {
            instance = new VisibilityLabelsManager(watcher, conf);
        }
        return instance;
    }

    public static VisibilityLabelsManager get() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshLabelsCache(byte[] data) throws IOException {
        List<VisibilityLabelsProtos.VisibilityLabel> visibilityLabels = null;
        try {
            visibilityLabels = VisibilityUtils.readLabelsFromZKData(data);
        }
        catch (DeserializationException dse) {
            throw new IOException(dse);
        }
        this.lock.writeLock().lock();
        try {
            for (VisibilityLabelsProtos.VisibilityLabel visLabel : visibilityLabels) {
                String label = Bytes.toString(visLabel.getLabel().toByteArray());
                this.labels.put(label, visLabel.getOrdinal());
                this.ordinalVsLabels.put(visLabel.getOrdinal(), label);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshUserAuthsCache(byte[] data) throws IOException {
        VisibilityLabelsProtos.MultiUserAuthorizations multiUserAuths = null;
        try {
            multiUserAuths = VisibilityUtils.readUserAuthsFromZKData(data);
        }
        catch (DeserializationException dse) {
            throw new IOException(dse);
        }
        this.lock.writeLock().lock();
        try {
            for (VisibilityLabelsProtos.UserAuthorizations userAuths : multiUserAuths.getUserAuthsList()) {
                String user = Bytes.toString(userAuths.getUser().toByteArray());
                this.userAuths.put(user, new HashSet<Integer>(userAuths.getAuthList()));
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLabelOrdinal(String label) {
        Integer ordinal = null;
        this.lock.readLock().lock();
        try {
            ordinal = this.labels.get(label);
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (ordinal != null) {
            return ordinal;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getLabel(int ordinal) {
        this.lock.readLock().lock();
        try {
            String string = this.ordinalVsLabels.get(ordinal);
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int getLabelsCount() {
        return this.labels.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAuths(String user) {
        List<String> auths = EMPTY_LIST;
        this.lock.readLock().lock();
        try {
            Set<Integer> authOrdinals = this.userAuths.get(user);
            if (authOrdinals != null) {
                auths = new ArrayList<String>(authOrdinals.size());
                for (Integer authOrdinal : authOrdinals) {
                    auths.add(this.ordinalVsLabels.get(authOrdinal));
                }
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return auths;
    }

    public void writeToZookeeper(byte[] data, boolean labelsOrUserAuths) {
        this.zkVisibilityWatcher.writeToZookeeper(data, labelsOrUserAuths);
    }
}

