/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import com.google.protobuf.HBaseZeroCopyByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.VisibilityLabelsProtos;
import org.apache.hadoop.hbase.security.visibility.DefaultScanLabelGenerator;
import org.apache.hadoop.hbase.security.visibility.ScanLabelGenerator;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.util.ReflectionUtils;

@InterfaceAudience.Private
public class VisibilityUtils {
    public static final String VISIBILITY_LABEL_GENERATOR_CLASS = "hbase.regionserver.scan.visibility.label.generator.class";
    public static final byte VISIBILITY_TAG_TYPE = 2;
    public static final String SYSTEM_LABEL = "system";

    public static byte[] getDataToWriteToZooKeeper(Map<String, Integer> existingLabels) {
        VisibilityLabelsProtos.VisibilityLabelsRequest.Builder visReqBuilder = VisibilityLabelsProtos.VisibilityLabelsRequest.newBuilder();
        for (Map.Entry<String, Integer> entry : existingLabels.entrySet()) {
            VisibilityLabelsProtos.VisibilityLabel.Builder visLabBuilder = VisibilityLabelsProtos.VisibilityLabel.newBuilder();
            visLabBuilder.setLabel(HBaseZeroCopyByteString.wrap(Bytes.toBytes(entry.getKey())));
            visLabBuilder.setOrdinal(entry.getValue());
            visReqBuilder.addVisLabel(visLabBuilder.build());
        }
        return ProtobufUtil.prependPBMagic(visReqBuilder.build().toByteArray());
    }

    public static byte[] getUserAuthsDataToWriteToZooKeeper(Map<String, List<Integer>> userAuths) {
        VisibilityLabelsProtos.MultiUserAuthorizations.Builder builder = VisibilityLabelsProtos.MultiUserAuthorizations.newBuilder();
        for (Map.Entry<String, List<Integer>> entry : userAuths.entrySet()) {
            VisibilityLabelsProtos.UserAuthorizations.Builder userAuthsBuilder = VisibilityLabelsProtos.UserAuthorizations.newBuilder();
            userAuthsBuilder.setUser(HBaseZeroCopyByteString.wrap(Bytes.toBytes(entry.getKey())));
            for (Integer label : entry.getValue()) {
                userAuthsBuilder.addAuth(label);
            }
            builder.addUserAuths(userAuthsBuilder.build());
        }
        return ProtobufUtil.prependPBMagic(builder.build().toByteArray());
    }

    public static List<VisibilityLabelsProtos.VisibilityLabel> readLabelsFromZKData(byte[] data) throws DeserializationException {
        if (ProtobufUtil.isPBMagicPrefix(data)) {
            int pblen = ProtobufUtil.lengthOfPBMagic();
            try {
                VisibilityLabelsProtos.VisibilityLabelsRequest request = ((VisibilityLabelsProtos.VisibilityLabelsRequest.Builder)VisibilityLabelsProtos.VisibilityLabelsRequest.newBuilder().mergeFrom(data, pblen, data.length - pblen)).build();
                return request.getVisLabelList();
            }
            catch (InvalidProtocolBufferException e) {
                throw new DeserializationException(e);
            }
        }
        return null;
    }

    public static VisibilityLabelsProtos.MultiUserAuthorizations readUserAuthsFromZKData(byte[] data) throws DeserializationException {
        if (ProtobufUtil.isPBMagicPrefix(data)) {
            int pblen = ProtobufUtil.lengthOfPBMagic();
            try {
                VisibilityLabelsProtos.MultiUserAuthorizations multiUserAuths = ((VisibilityLabelsProtos.MultiUserAuthorizations.Builder)VisibilityLabelsProtos.MultiUserAuthorizations.newBuilder().mergeFrom(data, pblen, data.length - pblen)).build();
                return multiUserAuths;
            }
            catch (InvalidProtocolBufferException e) {
                throw new DeserializationException(e);
            }
        }
        return null;
    }

    public static ScanLabelGenerator getScanLabelGenerator(Configuration conf) {
        Class<ScanLabelGenerator> scanLabelGeneratorKlass = conf.getClass(VISIBILITY_LABEL_GENERATOR_CLASS, DefaultScanLabelGenerator.class, ScanLabelGenerator.class);
        return ReflectionUtils.newInstance(scanLabelGeneratorKlass, conf);
    }
}

