/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.visibility;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.security.visibility.VisibilityLabelsManager;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class ZKVisibilityLabelWatcher
extends ZooKeeperListener {
    private static final Log LOG = LogFactory.getLog(ZKVisibilityLabelWatcher.class);
    private static final String VISIBILITY_LABEL_ZK_PATH = "zookeeper.znode.visibility.label.parent";
    private static final String DEFAULT_VISIBILITY_LABEL_NODE = "visibility/labels";
    private static final String VISIBILITY_USER_AUTHS_ZK_PATH = "zookeeper.znode.visibility.user.auths.parent";
    private static final String DEFAULT_VISIBILITY_USER_AUTHS_NODE = "visibility/user_auths";
    private VisibilityLabelsManager labelsManager;
    private String labelZnode;
    private String userAuthsZnode;

    public ZKVisibilityLabelWatcher(ZooKeeperWatcher watcher, VisibilityLabelsManager labelsManager, Configuration conf) {
        super(watcher);
        this.labelsManager = labelsManager;
        String labelZnodeParent = conf.get(VISIBILITY_LABEL_ZK_PATH, DEFAULT_VISIBILITY_LABEL_NODE);
        String userAuthsZnodeParent = conf.get(VISIBILITY_USER_AUTHS_ZK_PATH, DEFAULT_VISIBILITY_USER_AUTHS_NODE);
        this.labelZnode = ZKUtil.joinZNode(watcher.baseZNode, labelZnodeParent);
        this.userAuthsZnode = ZKUtil.joinZNode(watcher.baseZNode, userAuthsZnodeParent);
    }

    public void start() throws KeeperException {
        byte[] data;
        this.watcher.registerListener(this);
        if (ZKUtil.watchAndCheckExists(this.watcher, this.labelZnode) && (data = ZKUtil.getDataAndWatch(this.watcher, this.labelZnode)) != null) {
            this.refreshVisibilityLabelsCache(data);
        }
        if (ZKUtil.watchAndCheckExists(this.watcher, this.userAuthsZnode) && (data = ZKUtil.getDataAndWatch(this.watcher, this.userAuthsZnode)) != null) {
            this.refreshUserAuthsCache(data);
        }
    }

    private void refreshVisibilityLabelsCache(byte[] data) {
        try {
            this.labelsManager.refreshLabelsCache(data);
        }
        catch (IOException ioe) {
            LOG.error("Failed parsing data from labels table  from zk", ioe);
        }
    }

    private void refreshUserAuthsCache(byte[] data) {
        try {
            this.labelsManager.refreshUserAuthsCache(data);
        }
        catch (IOException ioe) {
            LOG.error("Failed parsing data from labels table  from zk", ioe);
        }
    }

    @Override
    public void nodeCreated(String path) {
        if (path.equals(this.labelZnode) || path.equals(this.userAuthsZnode)) {
            try {
                ZKUtil.watchAndCheckExists(this.watcher, path);
            }
            catch (KeeperException ke) {
                LOG.error("Error setting watcher on node " + path, ke);
                this.watcher.abort("Zookeeper error obtaining label node children", ke);
            }
        }
    }

    @Override
    public void nodeDeleted(String path) {
    }

    @Override
    public void nodeDataChanged(String path) {
        if (path.equals(this.labelZnode) || path.equals(this.userAuthsZnode)) {
            try {
                this.watcher.sync(path);
                byte[] data = ZKUtil.getDataAndWatch(this.watcher, path);
                if (path.equals(this.labelZnode)) {
                    this.refreshVisibilityLabelsCache(data);
                } else {
                    this.refreshUserAuthsCache(data);
                }
            }
            catch (KeeperException ke) {
                LOG.error("Error reading data from zookeeper for node " + path, ke);
                this.watcher.abort("Zookeeper error getting data for node " + path, ke);
            }
        }
    }

    @Override
    public void nodeChildrenChanged(String path) {
    }

    public void writeToZookeeper(byte[] data, boolean labelsOrUserAuths) {
        String znode = this.labelZnode;
        if (!labelsOrUserAuths) {
            znode = this.userAuthsZnode;
        }
        try {
            ZKUtil.createWithParents(this.watcher, znode);
            ZKUtil.updateExistingNodeData(this.watcher, znode, data, -1);
        }
        catch (KeeperException e) {
            LOG.error("Failed writing to " + znode, e);
            this.watcher.abort("Failed writing node " + znode + " to zookeeper", e);
        }
    }
}

