/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class ClientSnapshotDescriptionUtils {
    public static void assertSnapshotRequestIsValid(HBaseProtos.SnapshotDescription snapshot) throws IllegalArgumentException {
        TableName tableName;
        TableName.isLegalTableQualifierName(Bytes.toBytes(snapshot.getName()), true);
        if (snapshot.hasTable() && (tableName = TableName.valueOf(snapshot.getTable())).isSystemTable()) {
            throw new IllegalArgumentException("System table snapshots are not allowed");
        }
    }

    public static String toString(HBaseProtos.SnapshotDescription ssd) {
        if (ssd == null) {
            return null;
        }
        return "{ ss=" + ssd.getName() + " table=" + (ssd.hasTable() ? TableName.valueOf(ssd.getTable()) : "") + " type=" + ssd.getType() + " }";
    }
}

