/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.io.IOException;
import java.util.NavigableSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.regionserver.wal.HLogUtil;
import org.apache.hadoop.hbase.snapshot.SnapshotTask;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class CopyRecoveredEditsTask
extends SnapshotTask {
    private static final Log LOG = LogFactory.getLog(CopyRecoveredEditsTask.class);
    private final FileSystem fs;
    private final Path regiondir;
    private final Path outputDir;

    public CopyRecoveredEditsTask(HBaseProtos.SnapshotDescription snapshot, ForeignExceptionDispatcher monitor, FileSystem fs, Path regionDir, Path snapshotRegionDir) {
        super(snapshot, monitor);
        this.fs = fs;
        this.regiondir = regionDir;
        this.outputDir = HLogUtil.getRegionDirRecoveredEditsDir(snapshotRegionDir);
    }

    @Override
    public Void call() throws IOException {
        NavigableSet<Path> files = HLogUtil.getSplitEditFilesSorted(this.fs, this.regiondir);
        if (files == null || files.size() == 0) {
            return null;
        }
        for (Path source : files) {
            FileStatus stat = this.fs.getFileStatus(source);
            if (stat.getLen() <= 0L) continue;
            Path out = new Path(this.outputDir, source.getName());
            LOG.debug("Copying " + source + " to " + out);
            FileUtil.copy(this.fs, source, this.fs, out, true, this.fs.getConf());
            this.rethrowException();
        }
        return null;
    }
}

