/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.snapshot.SnapshotTask;
import org.apache.hadoop.hbase.snapshot.TakeSnapshotUtils;
import org.apache.hadoop.hbase.util.FSUtils;

public class ReferenceRegionHFilesTask
extends SnapshotTask {
    public static final Log LOG = LogFactory.getLog(ReferenceRegionHFilesTask.class);
    private final Path regiondir;
    private final FileSystem fs;
    private final PathFilter fileFilter;
    private final Path snapshotDir;

    public ReferenceRegionHFilesTask(HBaseProtos.SnapshotDescription snapshot, ForeignExceptionDispatcher monitor, Path regionDir, final FileSystem fs, Path regionSnapshotDir) {
        super(snapshot, monitor);
        this.regiondir = regionDir;
        this.fs = fs;
        this.fileFilter = new PathFilter(){

            @Override
            public boolean accept(Path path) {
                try {
                    return fs.isFile(path);
                }
                catch (IOException e) {
                    LOG.error("Failed to reach fs to check file:" + path + ", marking as not file");
                    ReferenceRegionHFilesTask.this.snapshotFailure("Failed to reach fs to check file status", e);
                    return false;
                }
            }
        };
        this.snapshotDir = regionSnapshotDir;
    }

    @Override
    public Void call() throws IOException {
        FileStatus[] families = FSUtils.listStatus(this.fs, this.regiondir, new FSUtils.FamilyDirFilter(this.fs));
        if (families == null || families.length == 0) {
            LOG.info("No families under region directory:" + this.regiondir + ", not attempting to add references.");
            return null;
        }
        List<Path> snapshotFamilyDirs = TakeSnapshotUtils.getFamilySnapshotDirectories(this.snapshot, this.snapshotDir, families);
        LOG.debug("Add hfile references to snapshot directories:" + snapshotFamilyDirs);
        for (int i = 0; i < families.length; ++i) {
            FileStatus family = families[i];
            Path familyDir = family.getPath();
            FileStatus[] hfiles = FSUtils.listStatus(this.fs, familyDir, this.fileFilter);
            if (hfiles == null || hfiles.length == 0) {
                LOG.debug("Not hfiles found for family: " + familyDir + ", skipping.");
                continue;
            }
            Path snapshotFamilyDir = snapshotFamilyDirs.get(i);
            this.fs.mkdirs(snapshotFamilyDir);
            for (FileStatus hfile : hfiles) {
                Path referenceFile = new Path(snapshotFamilyDir, hfile.getPath().getName());
                LOG.debug("Creating reference for:" + hfile.getPath() + " at " + referenceFile);
                if (this.fs.createNewFile(referenceFile)) continue;
                throw new IOException("Failed to create reference file:" + referenceFile);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Finished referencing hfiles, current region state:");
            FSUtils.logFileSystemState(this.fs, this.regiondir, LOG);
            LOG.debug("and the snapshot directory:");
            FSUtils.logFileSystemState(this.fs, this.snapshotDir, LOG);
        }
        return null;
    }
}

