/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.errorhandling.ForeignException;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.regionserver.wal.HLogUtil;
import org.apache.hadoop.hbase.snapshot.CopyRecoveredEditsTask;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.util.FSUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={SmallTests.class})
public class TestCopyRecoveredEditsTask {
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testCopyFiles() throws Exception {
        HBaseProtos.SnapshotDescription snapshot = HBaseProtos.SnapshotDescription.newBuilder().setName("snapshot").build();
        ForeignExceptionDispatcher monitor = (ForeignExceptionDispatcher)Mockito.mock(ForeignExceptionDispatcher.class);
        FileSystem fs = UTIL.getTestFileSystem();
        Path root = UTIL.getDataTestDir();
        String regionName = "regionA";
        Path regionDir = new Path(root, regionName);
        Path workingDir = SnapshotDescriptionUtils.getWorkingSnapshotDir(snapshot, root);
        try {
            Path snapshotRegionDir = new Path(workingDir, regionName);
            fs.mkdirs(snapshotRegionDir);
            Path edits = HLogUtil.getRegionDirRecoveredEditsDir(regionDir);
            fs.mkdirs(edits);
            Path file1 = new Path(edits, "0000000000000002352");
            FSDataOutputStream out = fs.create(file1);
            byte[] data = new byte[]{1, 2, 3, 4};
            out.write(data);
            out.close();
            Path empty = new Path(edits, "empty");
            fs.createNewFile(empty);
            CopyRecoveredEditsTask task = new CopyRecoveredEditsTask(snapshot, monitor, fs, regionDir, snapshotRegionDir);
            CopyRecoveredEditsTask taskSpy = (CopyRecoveredEditsTask)Mockito.spy((Object)task);
            taskSpy.call();
            Path snapshotEdits = HLogUtil.getRegionDirRecoveredEditsDir(snapshotRegionDir);
            FileStatus[] snapshotEditFiles = FSUtils.listStatus(fs, snapshotEdits);
            Assert.assertEquals((String)"Got wrong number of files in the snapshot edits", (long)1L, (long)snapshotEditFiles.length);
            FileStatus file = snapshotEditFiles[0];
            Assert.assertEquals((String)"Didn't copy expected file", (Object)file1.getName(), (Object)file.getPath().getName());
            ((ForeignExceptionDispatcher)Mockito.verify((Object)monitor, (VerificationMode)Mockito.never())).receive((ForeignException)Mockito.any(ForeignException.class));
            ((CopyRecoveredEditsTask)Mockito.verify((Object)taskSpy, (VerificationMode)Mockito.never())).snapshotFailure(Mockito.anyString(), (Exception)Mockito.any(Exception.class));
        }
        finally {
            FSUtils.delete(fs, regionDir, true);
            FSUtils.delete(fs, workingDir, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testNoEditsDir() throws Exception {
        HBaseProtos.SnapshotDescription snapshot = HBaseProtos.SnapshotDescription.newBuilder().setName("snapshot").build();
        ForeignExceptionDispatcher monitor = (ForeignExceptionDispatcher)Mockito.mock(ForeignExceptionDispatcher.class);
        FileSystem fs = UTIL.getTestFileSystem();
        Path root = UTIL.getDataTestDir();
        String regionName = "regionA";
        Path regionDir = new Path(root, regionName);
        Path workingDir = SnapshotDescriptionUtils.getWorkingSnapshotDir(snapshot, root);
        try {
            Path snapshotRegionDir = new Path(workingDir, regionName);
            fs.mkdirs(snapshotRegionDir);
            Path regionEdits = HLogUtil.getRegionDirRecoveredEditsDir(regionDir);
            Assert.assertFalse((String)"Edits dir exists already - it shouldn't", (boolean)fs.exists(regionEdits));
            CopyRecoveredEditsTask task = new CopyRecoveredEditsTask(snapshot, monitor, fs, regionDir, snapshotRegionDir);
            task.call();
        }
        finally {
            FSUtils.delete(fs, regionDir, true);
            FSUtils.delete(fs, workingDir, true);
        }
    }
}

