/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.snapshot;

import java.io.IOException;
import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionDispatcher;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.snapshot.ReferenceServerWALsTask;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.TakeSnapshotUtils;
import org.apache.hadoop.hbase.util.FSUtils;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={SmallTests.class})
public class TestWALReferenceTask {
    private static final Log LOG = LogFactory.getLog(TestWALReferenceTask.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();

    @Test
    public void testRun() throws IOException {
        Configuration conf = UTIL.getConfiguration();
        FileSystem fs = UTIL.getTestFileSystem();
        Path testDir = UTIL.getDataTestDir();
        HashSet<String> servers = new HashSet<String>();
        Path logDir = new Path(testDir, "WALs");
        Path server1Dir = new Path(logDir, "Server1");
        servers.add(server1Dir.getName());
        Path server2Dir = new Path(logDir, "me.hbase.com,56073,1348618509968");
        servers.add(server2Dir.getName());
        Path log1_1 = new Path(server1Dir, "me.hbase.com%2C56073%2C1348618509968.1348618520536");
        Path log1_2 = new Path(server1Dir, "me.hbase.com%2C56073%2C1348618509968.1234567890123");
        Path log2_1 = new Path(server2Dir, "me.hbase.com%2C56074%2C1348618509998.1348618515589");
        Path log2_2 = new Path(server2Dir, "me.hbase.com%2C56073%2C1348618509968.1234567890123");
        fs.createNewFile(log1_1);
        fs.createNewFile(log1_2);
        fs.createNewFile(log2_1);
        fs.createNewFile(log2_2);
        FSUtils.logFileSystemState(fs, testDir, LOG);
        FSUtils.setRootDir(conf, testDir);
        HBaseProtos.SnapshotDescription snapshot = HBaseProtos.SnapshotDescription.newBuilder().setName("testWALReferenceSnapshot").build();
        ForeignExceptionDispatcher listener = (ForeignExceptionDispatcher)Mockito.mock(ForeignExceptionDispatcher.class);
        ReferenceServerWALsTask task = new ReferenceServerWALsTask(snapshot, listener, server1Dir, conf, fs);
        task.call();
        task = new ReferenceServerWALsTask(snapshot, listener, server2Dir, conf, fs);
        task.call();
        FSUtils.logFileSystemState(fs, testDir, LOG);
        Path workingDir = SnapshotDescriptionUtils.getWorkingSnapshotDir(snapshot, testDir);
        Path snapshotLogDir = new Path(workingDir, "WALs");
        TakeSnapshotUtils.verifyAllLogsGotReferenced(fs, logDir, servers, snapshot, snapshotLogDir);
        ((ForeignExceptionDispatcher)Mockito.verify((Object)listener, (VerificationMode)Mockito.atLeastOnce())).rethrowException();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{listener});
    }
}

