/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.types;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.types.DataType;
import org.apache.hadoop.hbase.types.RawBytes;
import org.apache.hadoop.hbase.types.RawBytesTerminated;
import org.apache.hadoop.hbase.types.RawDouble;
import org.apache.hadoop.hbase.types.RawInteger;
import org.apache.hadoop.hbase.types.RawStringTerminated;
import org.apache.hadoop.hbase.types.Struct;
import org.apache.hadoop.hbase.types.StructBuilder;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Order;
import org.apache.hadoop.hbase.util.PositionedByteRange;
import org.apache.hadoop.hbase.util.SimplePositionedByteRange;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
@Category(value={SmallTests.class})
public class TestStruct {
    private Struct generic;
    private DataType specialized;
    private Object[][] constructorArgs;
    static final Comparator<byte[]> NULL_SAFE_BYTES_COMPARATOR = new Comparator<byte[]>(){

        @Override
        public int compare(byte[] o1, byte[] o2) {
            if (o1 == o2) {
                return 0;
            }
            if (null == o1) {
                return -1;
            }
            if (null == o2) {
                return 1;
            }
            return Bytes.compareTo(o1, o2);
        }
    };

    public TestStruct(Struct generic, DataType specialized, Object[][] constructorArgs) {
        this.generic = generic;
        this.specialized = specialized;
        this.constructorArgs = constructorArgs;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> params() {
        Object[][] pojo1Args = new Object[][]{{"foo", 5, 10.001}, {"foo", 100, 7.0}, {"foo", 100, 10.001}, {"bar", 5, 10.001}, {"bar", 100, 10.001}, {"baz", 5, 10.001}};
        Object[][] pojo2Args = new Object[][]{{new byte[0], "it".getBytes(), "was", "the".getBytes()}, {"best".getBytes(), new byte[0], "of", "times,".getBytes()}, {"it".getBytes(), "was".getBytes(), "", "the".getBytes()}, {"worst".getBytes(), "of".getBytes(), "times,", new byte[0]}, {new byte[0], new byte[0], "", new byte[0]}};
        Object[][] params = new Object[][]{{SpecializedPojo1Type1.GENERIC, new SpecializedPojo1Type1(), pojo1Args}, {SpecializedPojo2Type1.GENERIC, new SpecializedPojo2Type1(), pojo2Args}};
        return Arrays.asList(params);
    }

    @Test
    public void testOrderPreservation() throws Exception {
        int i;
        Object[] vals = new Object[this.constructorArgs.length];
        Object[] encodedGeneric = new PositionedByteRange[this.constructorArgs.length];
        Object[] encodedSpecialized = new PositionedByteRange[this.constructorArgs.length];
        Constructor ctor = this.specialized.encodedClass().getConstructor(Object[].class);
        for (i = 0; i < vals.length; ++i) {
            vals[i] = ctor.newInstance(new Object[]{this.constructorArgs[i]});
            encodedGeneric[i] = new SimplePositionedByteRange(this.generic.encodedLength(this.constructorArgs[i]));
            encodedSpecialized[i] = new SimplePositionedByteRange(this.specialized.encodedLength(vals[i]));
        }
        for (i = 0; i < vals.length; ++i) {
            this.generic.encode((PositionedByteRange)encodedGeneric[i], this.constructorArgs[i]);
            encodedGeneric[i].setPosition(0);
            this.specialized.encode((PositionedByteRange)encodedSpecialized[i], vals[i]);
            encodedSpecialized[i].setPosition(0);
            Assert.assertArrayEquals((byte[])encodedGeneric[i].getBytes(), (byte[])encodedSpecialized[i].getBytes());
        }
        Arrays.sort(vals);
        Arrays.sort(encodedGeneric);
        Arrays.sort(encodedSpecialized);
        for (i = 0; i < vals.length; ++i) {
            Assert.assertEquals((String)("Struct encoder does not preserve sort order at position " + i), (Object)vals[i], ctor.newInstance(new Object[]{this.generic.decode((PositionedByteRange)encodedGeneric[i])}));
            Assert.assertEquals((String)("Specialized encoder does not preserve sort order at position " + i), (Object)vals[i], this.specialized.decode((PositionedByteRange)encodedSpecialized[i]));
        }
    }

    private static class SpecializedPojo2Type1
    implements DataType<Pojo2> {
        private static RawBytesTerminated byteField1 = new RawBytesTerminated("/");
        private static RawBytesTerminated byteField2 = new RawBytesTerminated(Order.DESCENDING, "/");
        private static RawStringTerminated stringField = new RawStringTerminated(Order.DESCENDING, new byte[]{0});
        private static RawBytes byteField3 = RawBytes.DESCENDING;
        public static Struct GENERIC = new StructBuilder().add(byteField1).add(byteField2).add(stringField).add(byteField3).toStruct();

        private SpecializedPojo2Type1() {
        }

        @Override
        public boolean isOrderPreserving() {
            return true;
        }

        @Override
        public Order getOrder() {
            return null;
        }

        @Override
        public boolean isNullable() {
            return false;
        }

        @Override
        public boolean isSkippable() {
            return true;
        }

        @Override
        public int encodedLength(Pojo2 val) {
            return byteField1.encodedLength(val.byteField1Asc) + byteField2.encodedLength(val.byteField2Dsc) + stringField.encodedLength(val.stringFieldDsc) + byteField3.encodedLength(val.byteField3Dsc);
        }

        @Override
        public Class<Pojo2> encodedClass() {
            return Pojo2.class;
        }

        @Override
        public int skip(PositionedByteRange src) {
            int skipped = byteField1.skip(src);
            skipped += byteField2.skip(src);
            skipped += stringField.skip(src);
            return skipped += byteField3.skip(src);
        }

        @Override
        public Pojo2 decode(PositionedByteRange src) {
            Object[] ret = new Object[]{byteField1.decode(src), byteField2.decode(src), stringField.decode(src), byteField3.decode(src)};
            return new Pojo2(ret);
        }

        @Override
        public int encode(PositionedByteRange dst, Pojo2 val) {
            int written = byteField1.encode(dst, val.byteField1Asc);
            written += byteField2.encode(dst, val.byteField2Dsc);
            written += stringField.encode(dst, val.stringFieldDsc);
            return written += byteField3.encode(dst, val.byteField3Dsc);
        }
    }

    private static class SpecializedPojo1Type1
    implements DataType<Pojo1> {
        private static final RawStringTerminated stringField = new RawStringTerminated("/");
        private static final RawInteger intField = new RawInteger();
        private static final RawDouble doubleField = new RawDouble();
        public static Struct GENERIC = new StructBuilder().add(stringField).add(intField).add(doubleField).toStruct();

        private SpecializedPojo1Type1() {
        }

        @Override
        public boolean isOrderPreserving() {
            return true;
        }

        @Override
        public Order getOrder() {
            return null;
        }

        @Override
        public boolean isNullable() {
            return false;
        }

        @Override
        public boolean isSkippable() {
            return true;
        }

        @Override
        public int encodedLength(Pojo1 val) {
            return stringField.encodedLength(val.stringFieldAsc) + intField.encodedLength(val.intFieldAsc) + doubleField.encodedLength(val.doubleFieldAsc);
        }

        @Override
        public Class<Pojo1> encodedClass() {
            return Pojo1.class;
        }

        @Override
        public int skip(PositionedByteRange src) {
            int skipped = stringField.skip(src);
            skipped += intField.skip(src);
            return skipped += doubleField.skip(src);
        }

        @Override
        public Pojo1 decode(PositionedByteRange src) {
            Object[] ret = new Object[]{stringField.decode(src), intField.decode(src), doubleField.decode(src)};
            return new Pojo1(ret);
        }

        @Override
        public int encode(PositionedByteRange dst, Pojo1 val) {
            int written = stringField.encode(dst, val.stringFieldAsc);
            written += intField.encode(dst, val.intFieldAsc);
            return written += doubleField.encode(dst, val.doubleFieldAsc);
        }
    }

    private static class Pojo2
    implements Comparable<Pojo2> {
        final byte[] byteField1Asc;
        final byte[] byteField2Dsc;
        final String stringFieldDsc;
        final byte[] byteField3Dsc;
        final transient String str;

        public Pojo2(Object ... vals) {
            this.byteField1Asc = vals.length > 0 ? (byte[])vals[0] : null;
            this.byteField2Dsc = vals.length > 1 ? (byte[])vals[1] : null;
            this.stringFieldDsc = vals.length > 2 ? (String)vals[2] : null;
            this.byteField3Dsc = vals.length > 3 ? (byte[])vals[3] : null;
            this.str = "{ " + Bytes.toStringBinary(this.byteField1Asc) + ", " + Bytes.toStringBinary(this.byteField2Dsc) + ", " + (null == this.stringFieldDsc ? "" : "\"") + this.stringFieldDsc + (null == this.stringFieldDsc ? "" : "\"") + ", " + Bytes.toStringBinary(this.byteField3Dsc) + " }";
        }

        public String toString() {
            return this.str;
        }

        @Override
        public int compareTo(Pojo2 o) {
            int cmp = NULL_SAFE_BYTES_COMPARATOR.compare(this.byteField1Asc, o.byteField1Asc);
            if (cmp != 0) {
                return cmp;
            }
            cmp = -NULL_SAFE_BYTES_COMPARATOR.compare(this.byteField2Dsc, o.byteField2Dsc);
            if (cmp != 0) {
                return cmp;
            }
            cmp = this.stringFieldDsc == o.stringFieldDsc ? 0 : (null == this.stringFieldDsc ? 1 : (null == o.stringFieldDsc ? -1 : -this.stringFieldDsc.compareTo(o.stringFieldDsc)));
            if (cmp != 0) {
                return cmp;
            }
            return -NULL_SAFE_BYTES_COMPARATOR.compare(this.byteField3Dsc, o.byteField3Dsc);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (null == o) {
                return false;
            }
            if (!(o instanceof Pojo2)) {
                return false;
            }
            Pojo2 that = (Pojo2)o;
            return 0 == this.compareTo(that);
        }
    }

    private static class Pojo1
    implements Comparable<Pojo1> {
        final String stringFieldAsc;
        final int intFieldAsc;
        final double doubleFieldAsc;
        final transient String str;

        public Pojo1(Object ... argv) {
            this.stringFieldAsc = (String)argv[0];
            this.intFieldAsc = (Integer)argv[1];
            this.doubleFieldAsc = (Double)argv[2];
            this.str = "{ " + (null == this.stringFieldAsc ? "" : "\"") + this.stringFieldAsc + (null == this.stringFieldAsc ? "" : "\"") + ", " + this.intFieldAsc + ", " + this.doubleFieldAsc + " }";
        }

        public String toString() {
            return this.str;
        }

        @Override
        public int compareTo(Pojo1 o) {
            int cmp = this.stringFieldAsc.compareTo(o.stringFieldAsc);
            if (cmp != 0) {
                return cmp;
            }
            cmp = Integer.valueOf(this.intFieldAsc).compareTo(o.intFieldAsc);
            if (cmp != 0) {
                return cmp;
            }
            return Double.compare(this.doubleFieldAsc, o.doubleFieldAsc);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (null == o) {
                return false;
            }
            if (!(o instanceof Pojo1)) {
                return false;
            }
            Pojo1 that = (Pojo1)o;
            return 0 == this.compareTo(that);
        }
    }
}

