/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestBytes
extends TestCase {
    public void testNullHashCode() {
        byte[] b = null;
        Exception ee = null;
        try {
            Bytes.hashCode(b);
        }
        catch (Exception e) {
            ee = e;
        }
        TestBytes.assertNotNull((Object)ee);
    }

    public void testSplit() throws Exception {
        int i;
        byte[] lowest = Bytes.toBytes("AAA");
        byte[] middle = Bytes.toBytes("CCC");
        byte[] highest = Bytes.toBytes("EEE");
        byte[][] parts = Bytes.split(lowest, highest, 1);
        for (i = 0; i < parts.length; ++i) {
            System.out.println(Bytes.toString(parts[i]));
        }
        TestBytes.assertEquals((int)3, (int)parts.length);
        TestBytes.assertTrue((boolean)Bytes.equals(parts[1], middle));
        highest = Bytes.toBytes("DDD");
        parts = Bytes.split(lowest, highest, 2);
        for (i = 0; i < parts.length; ++i) {
            System.out.println(Bytes.toString(parts[i]));
        }
        TestBytes.assertEquals((int)4, (int)parts.length);
        TestBytes.assertTrue((boolean)Bytes.equals(parts[2], middle));
    }

    public void testSplit2() throws Exception {
        byte[] lowest = Bytes.toBytes("http://A");
        byte[] highest = Bytes.toBytes("http://z");
        byte[] middle = Bytes.toBytes("http://]");
        byte[][] parts = Bytes.split(lowest, highest, 1);
        for (int i = 0; i < parts.length; ++i) {
            System.out.println(Bytes.toString(parts[i]));
        }
        TestBytes.assertEquals((int)3, (int)parts.length);
        TestBytes.assertTrue((boolean)Bytes.equals(parts[1], middle));
    }

    public void testSplit3() throws Exception {
        byte[] low = new byte[]{1, 1, 1};
        byte[] high = new byte[]{1, 1, 3};
        try {
            Bytes.split(high, low, 1);
            TestBytes.assertTrue((String)"Should not be able to split if low > high", (boolean)false);
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
        byte[][] parts = Bytes.split(low, high, 1);
        for (int i = 0; i < parts.length; ++i) {
            System.out.println("" + i + " -> " + Bytes.toStringBinary(parts[i]));
        }
        TestBytes.assertTrue((String)("Returned split should have 3 parts but has " + parts.length), (parts.length == 3 ? 1 : 0) != 0);
        parts = Bytes.split(low, high, 2);
        TestBytes.assertTrue((String)"Returned split but should have failed", (parts == null ? 1 : 0) != 0);
        try {
            parts = Bytes.split(low, high, 0);
            TestBytes.assertTrue((String)"Should not be able to split 0 times", (boolean)false);
        }
        catch (IllegalArgumentException iae) {
            // empty catch block
        }
    }

    public void testToInt() throws Exception {
        int[] ints = new int[]{-1, 123, Integer.MIN_VALUE, Integer.MAX_VALUE};
        for (int i = 0; i < ints.length; ++i) {
            byte[] b = Bytes.toBytes(ints[i]);
            TestBytes.assertEquals((int)ints[i], (int)Bytes.toInt(b));
            byte[] b2 = this.bytesWithOffset(b);
            TestBytes.assertEquals((int)ints[i], (int)Bytes.toInt(b2, 1));
            TestBytes.assertEquals((int)ints[i], (int)Bytes.toInt(b2, 1, 4));
        }
    }

    public void testToLong() throws Exception {
        long[] longs = new long[]{-1L, 123L, Long.MIN_VALUE, Long.MAX_VALUE};
        for (int i = 0; i < longs.length; ++i) {
            byte[] b = Bytes.toBytes(longs[i]);
            TestBytes.assertEquals((long)longs[i], (long)Bytes.toLong(b));
            byte[] b2 = this.bytesWithOffset(b);
            TestBytes.assertEquals((long)longs[i], (long)Bytes.toLong(b2, 1));
            TestBytes.assertEquals((long)longs[i], (long)Bytes.toLong(b2, 1, 8));
        }
    }

    public void testToFloat() throws Exception {
        float[] floats = new float[]{-1.0f, 123.123f, Float.MAX_VALUE};
        for (int i = 0; i < floats.length; ++i) {
            byte[] b = Bytes.toBytes(floats[i]);
            TestBytes.assertEquals((Object)Float.valueOf(floats[i]), (Object)Float.valueOf(Bytes.toFloat(b)));
            byte[] b2 = this.bytesWithOffset(b);
            TestBytes.assertEquals((Object)Float.valueOf(floats[i]), (Object)Float.valueOf(Bytes.toFloat(b2, 1)));
        }
    }

    public void testToDouble() throws Exception {
        double[] doubles = new double[]{Double.MIN_VALUE, Double.MAX_VALUE};
        for (int i = 0; i < doubles.length; ++i) {
            byte[] b = Bytes.toBytes(doubles[i]);
            TestBytes.assertEquals((Object)doubles[i], (Object)Bytes.toDouble(b));
            byte[] b2 = this.bytesWithOffset(b);
            TestBytes.assertEquals((Object)doubles[i], (Object)Bytes.toDouble(b2, 1));
        }
    }

    public void testToBigDecimal() throws Exception {
        BigDecimal[] decimals = new BigDecimal[]{new BigDecimal("-1"), new BigDecimal("123.123"), new BigDecimal("123123123123")};
        for (int i = 0; i < decimals.length; ++i) {
            byte[] b = Bytes.toBytes(decimals[i]);
            TestBytes.assertEquals((Object)decimals[i], (Object)Bytes.toBigDecimal(b));
            byte[] b2 = this.bytesWithOffset(b);
            TestBytes.assertEquals((Object)decimals[i], (Object)Bytes.toBigDecimal(b2, 1, b.length));
        }
    }

    private byte[] bytesWithOffset(byte[] src) {
        byte[] result = new byte[src.length + 1];
        result[0] = -86;
        System.arraycopy(src, 0, result, 1, src.length);
        return result;
    }

    public void testToBytesForByteBuffer() {
        byte[] array = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        ByteBuffer target = ByteBuffer.wrap(array);
        target.position(2);
        target.limit(7);
        byte[] actual = Bytes.toBytes(target);
        byte[] expected = new byte[]{0, 1, 2, 3, 4, 5, 6};
        TestBytes.assertTrue((boolean)Arrays.equals(expected, actual));
        TestBytes.assertEquals((int)2, (int)target.position());
        TestBytes.assertEquals((int)7, (int)target.limit());
        ByteBuffer target2 = target.slice();
        TestBytes.assertEquals((int)0, (int)target2.position());
        TestBytes.assertEquals((int)5, (int)target2.limit());
        byte[] actual2 = Bytes.toBytes(target2);
        byte[] expected2 = new byte[]{2, 3, 4, 5, 6};
        TestBytes.assertTrue((boolean)Arrays.equals(expected2, actual2));
        TestBytes.assertEquals((int)0, (int)target2.position());
        TestBytes.assertEquals((int)5, (int)target2.limit());
    }

    public void testGetBytesForByteBuffer() {
        byte[] array = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        ByteBuffer target = ByteBuffer.wrap(array);
        target.position(2);
        target.limit(7);
        byte[] actual = Bytes.getBytes(target);
        byte[] expected = new byte[]{2, 3, 4, 5, 6};
        TestBytes.assertTrue((boolean)Arrays.equals(expected, actual));
        TestBytes.assertEquals((int)2, (int)target.position());
        TestBytes.assertEquals((int)7, (int)target.limit());
    }

    public void testToStringBinaryForBytes() {
        byte[] array = new byte[]{48, 57, 97, 122, 65, 90, 64, 1};
        String actual = Bytes.toStringBinary(array);
        String expected = "09azAZ@\\x01";
        TestBytes.assertEquals((String)expected, (String)actual);
        String actual2 = Bytes.toStringBinary(array, 2, 3);
        String expected2 = "azA";
        TestBytes.assertEquals((String)expected2, (String)actual2);
    }

    public void testToStringBinaryForArrayBasedByteBuffer() {
        byte[] array = new byte[]{48, 57, 97, 122, 65, 90, 64, 1};
        ByteBuffer target = ByteBuffer.wrap(array);
        String actual = Bytes.toStringBinary(target);
        String expected = "09azAZ@\\x01";
        TestBytes.assertEquals((String)expected, (String)actual);
    }

    public void testToStringBinaryForReadOnlyByteBuffer() {
        byte[] array = new byte[]{48, 57, 97, 122, 65, 90, 64, 1};
        ByteBuffer target = ByteBuffer.wrap(array).asReadOnlyBuffer();
        String actual = Bytes.toStringBinary(target);
        String expected = "09azAZ@\\x01";
        TestBytes.assertEquals((String)expected, (String)actual);
    }

    public void testBinarySearch() throws Exception {
        byte[][] arr = new byte[][]{{1}, {3}, {5}, {7}, {9}, {11}, {13}, {15}};
        byte[] key1 = new byte[]{3, 1};
        byte[] key2 = new byte[]{4, 9};
        byte[] key2_2 = new byte[]{4};
        byte[] key3 = new byte[]{5, 11};
        byte[] key4 = new byte[]{0};
        byte[] key5 = new byte[]{2};
        TestBytes.assertEquals((int)1, (int)Bytes.binarySearch(arr, key1, 0, 1, Bytes.BYTES_RAWCOMPARATOR));
        TestBytes.assertEquals((int)0, (int)Bytes.binarySearch(arr, key1, 1, 1, Bytes.BYTES_RAWCOMPARATOR));
        TestBytes.assertEquals((int)-3, (int)Arrays.binarySearch(arr, key2_2, Bytes.BYTES_COMPARATOR));
        TestBytes.assertEquals((int)-3, (int)Bytes.binarySearch(arr, key2, 0, 1, Bytes.BYTES_RAWCOMPARATOR));
        TestBytes.assertEquals((int)4, (int)Bytes.binarySearch(arr, key2, 1, 1, Bytes.BYTES_RAWCOMPARATOR));
        TestBytes.assertEquals((int)2, (int)Bytes.binarySearch(arr, key3, 0, 1, Bytes.BYTES_RAWCOMPARATOR));
        TestBytes.assertEquals((int)5, (int)Bytes.binarySearch(arr, key3, 1, 1, Bytes.BYTES_RAWCOMPARATOR));
        TestBytes.assertEquals((int)-1, (int)Bytes.binarySearch(arr, key4, 0, 1, Bytes.BYTES_RAWCOMPARATOR));
        TestBytes.assertEquals((int)-2, (int)Bytes.binarySearch(arr, key5, 0, 1, Bytes.BYTES_RAWCOMPARATOR));
        for (int i = 0; i < arr.length; ++i) {
            TestBytes.assertEquals((int)(-(i + 1)), (int)Bytes.binarySearch(arr, new byte[]{(byte)(arr[i][0] - 1)}, 0, 1, Bytes.BYTES_RAWCOMPARATOR));
            TestBytes.assertEquals((int)(-(i + 2)), (int)Bytes.binarySearch(arr, new byte[]{(byte)(arr[i][0] + 1)}, 0, 1, Bytes.BYTES_RAWCOMPARATOR));
        }
    }

    public void testToStringBytesBinaryReversible() {
        Random rand = new Random(System.currentTimeMillis());
        byte[] randomBytes = new byte[1000];
        for (int i = 0; i < 1000; ++i) {
            rand.nextBytes(randomBytes);
            this.verifyReversibleForBytes(randomBytes);
        }
        this.verifyReversibleForBytes(new byte[0]);
        this.verifyReversibleForBytes(new byte[]{92, 120, 65, 68});
        this.verifyReversibleForBytes(new byte[]{92, 120, 65, 68, 92});
    }

    private void verifyReversibleForBytes(byte[] originalBytes) {
        String convertedString = Bytes.toStringBinary(originalBytes);
        byte[] convertedBytes = Bytes.toBytesBinary(convertedString);
        if (Bytes.compareTo(originalBytes, convertedBytes) != 0) {
            TestBytes.fail((String)("Not reversible for\nbyte[]: " + Arrays.toString(originalBytes) + ",\nStringBinary: " + convertedString));
        }
    }

    public void testStartsWith() {
        TestBytes.assertTrue((boolean)Bytes.startsWith(Bytes.toBytes("hello"), Bytes.toBytes("h")));
        TestBytes.assertTrue((boolean)Bytes.startsWith(Bytes.toBytes("hello"), Bytes.toBytes("")));
        TestBytes.assertTrue((boolean)Bytes.startsWith(Bytes.toBytes("hello"), Bytes.toBytes("hello")));
        TestBytes.assertFalse((boolean)Bytes.startsWith(Bytes.toBytes("hello"), Bytes.toBytes("helloworld")));
        TestBytes.assertFalse((boolean)Bytes.startsWith(Bytes.toBytes(""), Bytes.toBytes("hello")));
    }

    public void testIncrementBytes() throws IOException {
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(10L, 1L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(12L, 123435445L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(124634654L, 1L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(10005460L, 5005645L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(1L, -1L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(10L, -1L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(10L, -5L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(1005435000L, -5L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(10L, -43657655L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(-1L, 1L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(-26L, 5034520L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(-10657200L, 5L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(-12343250L, 45376475L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(-10L, -5L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(-12343250L, -5L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(-12L, -34565445L));
        TestBytes.assertTrue((boolean)TestBytes.checkTestIncrementBytes(-1546543452L, -34565445L));
    }

    private static boolean checkTestIncrementBytes(long val, long amount) throws IOException {
        byte[] value = Bytes.toBytes(val);
        byte[] testValue = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1};
        if (value[0] > 0) {
            testValue = new byte[8];
        }
        System.arraycopy(value, 0, testValue, testValue.length - value.length, value.length);
        long incrementResult = Bytes.toLong(Bytes.incrementBytes(value, amount));
        return Bytes.toLong(testValue) + amount == incrementResult;
    }

    public void testFixedSizeString() throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        Bytes.writeStringFixedSize(dos, "Hello", 5);
        Bytes.writeStringFixedSize(dos, "World", 18);
        Bytes.writeStringFixedSize(dos, "", 9);
        try {
            Bytes.writeStringFixedSize(dos, "Too\u2013Long", 9);
            TestBytes.fail((String)"Exception expected");
        }
        catch (IOException ex) {
            TestBytes.assertEquals((String)"Trying to write 10 bytes (Too\\xE2\\x80\\x93Long) into a field of length 9", (String)ex.getMessage());
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        DataInputStream dis = new DataInputStream(bais);
        TestBytes.assertEquals((String)"Hello", (String)Bytes.readStringFixedSize(dis, 5));
        TestBytes.assertEquals((String)"World", (String)Bytes.readStringFixedSize(dis, 18));
        TestBytes.assertEquals((String)"", (String)Bytes.readStringFixedSize(dis, 9));
    }

    public void testCopy() throws Exception {
        byte[] copy;
        byte[] bytes = Bytes.toBytes("ABCDEFGHIJKLMNOPQRSTUVWXYZ");
        TestBytes.assertFalse((bytes == (copy = Bytes.copy(bytes)) ? 1 : 0) != 0);
        TestBytes.assertTrue((boolean)Bytes.equals(bytes, copy));
    }

    public void testToBytesBinaryTrailingBackslashes() throws Exception {
        try {
            Bytes.toBytesBinary("abc\\x00\\x01\\");
        }
        catch (StringIndexOutOfBoundsException ex) {
            TestBytes.fail((String)("Illegal string access: " + ex.getMessage()));
        }
    }

    public void testToStringBinary_toBytesBinary_Reversable() throws Exception {
        String bytes = Bytes.toStringBinary(Bytes.toBytes(2.17));
        TestBytes.assertEquals((double)2.17, (double)Bytes.toDouble(Bytes.toBytesBinary(bytes)), (double)0.0);
    }

    public void testUnsignedBinarySearch() {
        byte[] bytes = new byte[]{0, 5, 123, 127, -128, -100, -1};
        Assert.assertEquals((long)Bytes.unsignedBinarySearch(bytes, 0, bytes.length, (byte)5), (long)1L);
        Assert.assertEquals((long)Bytes.unsignedBinarySearch(bytes, 0, bytes.length, (byte)127), (long)3L);
        Assert.assertEquals((long)Bytes.unsignedBinarySearch(bytes, 0, bytes.length, (byte)-128), (long)4L);
        Assert.assertEquals((long)Bytes.unsignedBinarySearch(bytes, 0, bytes.length, (byte)-100), (long)5L);
        Assert.assertEquals((long)Bytes.unsignedBinarySearch(bytes, 0, bytes.length, (byte)-1), (long)6L);
        Assert.assertEquals((long)Bytes.unsignedBinarySearch(bytes, 0, bytes.length, (byte)2), (long)-2L);
        Assert.assertEquals((long)Bytes.unsignedBinarySearch(bytes, 0, bytes.length, (byte)-5), (long)-7L);
    }

    public void testUnsignedIncrement() {
        byte[] a = Bytes.toBytes(0);
        int a2 = Bytes.toInt(Bytes.unsignedCopyAndIncrement(a), 0);
        Assert.assertTrue((a2 == 1 ? 1 : 0) != 0);
        byte[] b = Bytes.toBytes(-1);
        byte[] actual = Bytes.unsignedCopyAndIncrement(b);
        Assert.assertNotSame((Object)b, (Object)actual);
        byte[] expected = new byte[]{1, 0, 0, 0, 0};
        Assert.assertArrayEquals((byte[])expected, (byte[])actual);
        byte[] c = Bytes.toBytes(255);
        int c2 = Bytes.toInt(Bytes.unsignedCopyAndIncrement(c), 0);
        Assert.assertTrue((c2 == 256 ? 1 : 0) != 0);
    }

    public void testIndexOf() {
        byte[] array = Bytes.toBytes("hello");
        TestBytes.assertEquals((int)1, (int)Bytes.indexOf(array, (byte)101));
        TestBytes.assertEquals((int)4, (int)Bytes.indexOf(array, (byte)111));
        TestBytes.assertEquals((int)-1, (int)Bytes.indexOf(array, (byte)97));
        TestBytes.assertEquals((int)0, (int)Bytes.indexOf(array, Bytes.toBytes("hel")));
        TestBytes.assertEquals((int)2, (int)Bytes.indexOf(array, Bytes.toBytes("ll")));
        TestBytes.assertEquals((int)-1, (int)Bytes.indexOf(array, Bytes.toBytes("hll")));
    }

    public void testContains() {
        byte[] array = Bytes.toBytes("hello world");
        TestBytes.assertTrue((boolean)Bytes.contains(array, (byte)101));
        TestBytes.assertTrue((boolean)Bytes.contains(array, (byte)100));
        TestBytes.assertFalse((boolean)Bytes.contains(array, (byte)97));
        TestBytes.assertTrue((boolean)Bytes.contains(array, Bytes.toBytes("world")));
        TestBytes.assertTrue((boolean)Bytes.contains(array, Bytes.toBytes("ello")));
        TestBytes.assertFalse((boolean)Bytes.contains(array, Bytes.toBytes("owo")));
    }

    public void testZero() {
        int i;
        byte[] array = Bytes.toBytes("hello");
        Bytes.zero(array);
        for (i = 0; i < array.length; ++i) {
            TestBytes.assertEquals((int)0, (int)array[i]);
        }
        array = Bytes.toBytes("hello world");
        Bytes.zero(array, 2, 7);
        TestBytes.assertFalse((array[0] == 0 ? 1 : 0) != 0);
        TestBytes.assertFalse((array[1] == 0 ? 1 : 0) != 0);
        for (i = 2; i < 9; ++i) {
            TestBytes.assertEquals((int)0, (int)array[i]);
        }
        for (i = 9; i < array.length; ++i) {
            TestBytes.assertFalse((array[i] == 0 ? 1 : 0) != 0);
        }
    }

    public void testPutBuffer() {
        byte i;
        byte[] b = new byte[100];
        for (i = 0; i < 100; i = (byte)((byte)(i + 1))) {
            Bytes.putByteBuffer(b, i, ByteBuffer.wrap(new byte[]{i}));
        }
        for (i = 0; i < 100; i = (byte)((byte)(i + 1))) {
            Assert.assertEquals((long)i, (long)b[i]);
        }
    }
}

