/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.util.CompressionTest;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.util.NativeCodeLoader;
import org.apache.hadoop.util.ReflectionUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestCompressionTest {
    static final Log LOG = LogFactory.getLog(TestCompressionTest.class);

    @Test
    public void testExceptionCaching() {
        try {
            CompressionTest.testCompression(Compression.Algorithm.LZO);
            Assert.fail();
        }
        catch (IOException e) {
            Assert.assertNotNull((Object)e.getCause());
        }
        try {
            CompressionTest.testCompression(Compression.Algorithm.LZO);
            Assert.fail();
        }
        catch (IOException e) {
            Assert.assertNull((Object)e.getCause());
        }
        Assert.assertFalse((boolean)CompressionTest.testCompression("LZO"));
    }

    @Test
    public void testTestCompression() {
        Assert.assertTrue((boolean)CompressionTest.testCompression("NONE"));
        Assert.assertTrue((boolean)CompressionTest.testCompression("GZ"));
        if (NativeCodeLoader.isNativeCodeLoaded()) {
            this.nativeCodecTest("LZO", "lzo2", "com.hadoop.compression.lzo.LzoCodec");
            this.nativeCodecTest("LZ4", null, "org.apache.hadoop.io.compress.Lz4Codec");
            this.nativeCodecTest("SNAPPY", "snappy", "org.apache.hadoop.io.compress.SnappyCodec");
        } else {
            LOG.debug("Native code not loaded");
            Assert.assertFalse((boolean)CompressionTest.testCompression("LZO"));
            Assert.assertFalse((boolean)CompressionTest.testCompression("LZ4"));
            Assert.assertFalse((boolean)CompressionTest.testCompression("SNAPPY"));
        }
    }

    private boolean isCompressionAvailable(String codecClassName) {
        try {
            Thread.currentThread().getContextClassLoader().loadClass(codecClassName);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private void nativeCodecTest(String codecName, String libName, String codecClassName) {
        if (this.isCompressionAvailable(codecClassName)) {
            try {
                if (libName != null) {
                    System.loadLibrary(libName);
                }
                try {
                    Configuration conf = new Configuration();
                    CompressionCodec codec = (CompressionCodec)ReflectionUtils.newInstance(conf.getClassByName(codecClassName), conf);
                    DataOutputBuffer compressedDataBuffer = new DataOutputBuffer();
                    CompressionOutputStream deflateFilter = codec.createOutputStream(compressedDataBuffer);
                    byte[] data = new byte[1024];
                    DataOutputStream deflateOut = new DataOutputStream(new BufferedOutputStream(deflateFilter));
                    deflateOut.write(data, 0, data.length);
                    deflateOut.flush();
                    deflateFilter.finish();
                    Assert.assertTrue((boolean)CompressionTest.testCompression(codecName));
                }
                catch (UnsatisfiedLinkError e) {
                    LOG.debug("No JNI for codec '" + codecName + "' " + e.getMessage());
                }
                catch (Exception e) {
                    LOG.error(codecName, e);
                }
            }
            catch (UnsatisfiedLinkError e) {
                LOG.debug("Native lib not available: " + codecName);
                Assert.assertFalse((boolean)CompressionTest.testCompression(codecName));
            }
        } else {
            LOG.debug("Codec class not available: " + codecName);
            Assert.assertFalse((boolean)CompressionTest.testCompression(codecName));
        }
    }
}

