/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.IsolationLevel;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.ScanInfo;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreScanner;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManagerTestHelper;
import org.apache.hadoop.hbase.util.ManualEnvironmentEdge;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@Category(value={MediumTests.class})
@RunWith(value=Parameterized.class)
public class TestCoprocessorScanPolicy {
    final Log LOG = LogFactory.getLog(this.getClass());
    protected static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final byte[] F = Bytes.toBytes("fam");
    private static final byte[] Q = Bytes.toBytes("qual");
    private static final byte[] R = Bytes.toBytes("row");

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setStrings("hbase.coprocessor.region.classes", ScanObserver.class.getName());
        TEST_UTIL.startMiniCluster();
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Parameterized.Parameters
    public static Collection<Object[]> parameters() {
        return HBaseTestingUtility.BOOLEAN_PARAMETERIZED;
    }

    public TestCoprocessorScanPolicy(boolean parallelSeekEnable) {
        TEST_UTIL.getMiniHBaseCluster().getConf().setBoolean("hbase.storescanner.parallel.seek.enable", parallelSeekEnable);
    }

    @Test
    public void testBaseCases() throws Exception {
        TableName tableName = TableName.valueOf("baseCases");
        if (TEST_UTIL.getHBaseAdmin().tableExists(tableName)) {
            TEST_UTIL.deleteTable(tableName);
        }
        HTable t = TEST_UTIL.createTable(tableName, F, 1);
        Put p = new Put(R);
        p.setAttribute("versions", new byte[0]);
        p.add(F, tableName.getName(), Bytes.toBytes(2));
        t.put(p);
        long now = EnvironmentEdgeManager.currentTimeMillis();
        p = new Put(R);
        p.add(F, Q, now, Q);
        t.put(p);
        p = new Put(R);
        p.add(F, Q, now + 1L, Q);
        t.put(p);
        Get g = new Get(R);
        g.setMaxVersions(10);
        Result r = t.get(g);
        Assert.assertEquals((long)2L, (long)r.size());
        TEST_UTIL.flush(tableName);
        TEST_UTIL.compact(tableName, true);
        g = new Get(R);
        g.setMaxVersions(10);
        r = t.get(g);
        Assert.assertEquals((long)2L, (long)r.size());
        p = new Put(R);
        p.add(F, Q, now + 2L, Q);
        t.put(p);
        g = new Get(R);
        g.setMaxVersions(10);
        r = t.get(g);
        Assert.assertEquals((long)2L, (long)r.size());
        t.close();
    }

    @Test
    public void testTTL() throws Exception {
        TableName tableName = TableName.valueOf("testTTL");
        if (TEST_UTIL.getHBaseAdmin().tableExists(tableName)) {
            TEST_UTIL.deleteTable(tableName);
        }
        HTableDescriptor desc = new HTableDescriptor(tableName);
        HColumnDescriptor hcd = new HColumnDescriptor(F).setMaxVersions(10).setTimeToLive(1);
        desc.addFamily(hcd);
        TEST_UTIL.getHBaseAdmin().createTable(desc);
        HTable t = new HTable(new Configuration(TEST_UTIL.getConfiguration()), tableName);
        long now = EnvironmentEdgeManager.currentTimeMillis();
        ManualEnvironmentEdge me = new ManualEnvironmentEdge();
        me.setValue(now);
        EnvironmentEdgeManagerTestHelper.injectEdge(me);
        long ts = now - 2000L;
        Put p = new Put(R);
        p.setAttribute("ttl", new byte[0]);
        p.add(F, tableName.getName(), Bytes.toBytes(3000L));
        t.put(p);
        p = new Put(R);
        p.add(F, Q, ts, Q);
        t.put(p);
        p = new Put(R);
        p.add(F, Q, ts + 1L, Q);
        t.put(p);
        Get g = new Get(R);
        g.setMaxVersions(10);
        Result r = t.get(g);
        Assert.assertEquals((long)2L, (long)r.size());
        TEST_UTIL.flush(tableName);
        TEST_UTIL.compact(tableName, true);
        g = new Get(R);
        g.setMaxVersions(10);
        r = t.get(g);
        Assert.assertEquals((long)2L, (long)r.size());
        me.setValue(now + 2000L);
        g = new Get(R);
        g.setMaxVersions(10);
        r = t.get(g);
        Assert.assertEquals((long)0L, (long)r.size());
        t.close();
    }

    public static class ScanObserver
    extends BaseRegionObserver {
        private Map<TableName, Long> ttls = new HashMap<TableName, Long>();
        private Map<TableName, Integer> versions = new HashMap<TableName, Integer>();

        @Override
        public void prePut(ObserverContext<RegionCoprocessorEnvironment> c, Put put, WALEdit edit, Durability durability) throws IOException {
            if (put.getAttribute("ttl") != null) {
                Cell cell = (Cell)((List)put.getFamilyCellMap().values().iterator().next()).get(0);
                KeyValue kv = KeyValueUtil.ensureKeyValue(cell);
                this.ttls.put(TableName.valueOf(kv.getQualifier()), Bytes.toLong(kv.getValue()));
                c.bypass();
            } else if (put.getAttribute("versions") != null) {
                Cell cell = (Cell)((List)put.getFamilyCellMap().values().iterator().next()).get(0);
                KeyValue kv = KeyValueUtil.ensureKeyValue(cell);
                this.versions.put(TableName.valueOf(kv.getQualifier()), Bytes.toInt(kv.getValue()));
                c.bypass();
            }
        }

        @Override
        public InternalScanner preFlushScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Store store, KeyValueScanner memstoreScanner, InternalScanner s) throws IOException {
            Long newTtl = this.ttls.get(store.getTableName());
            if (newTtl != null) {
                System.out.println("PreFlush:" + newTtl);
            }
            Integer newVersions = this.versions.get(store.getTableName());
            ScanInfo oldSI = store.getScanInfo();
            HColumnDescriptor family = store.getFamily();
            ScanInfo scanInfo = new ScanInfo(family.getName(), family.getMinVersions(), newVersions == null ? family.getMaxVersions() : newVersions.intValue(), newTtl == null ? oldSI.getTtl() : newTtl.longValue(), family.getKeepDeletedCells(), oldSI.getTimeToPurgeDeletes(), oldSI.getComparator());
            Scan scan = new Scan();
            scan.setMaxVersions(newVersions == null ? oldSI.getMaxVersions() : newVersions.intValue());
            return new StoreScanner(store, scanInfo, scan, Collections.singletonList(memstoreScanner), ScanType.COMPACT_RETAIN_DELETES, store.getSmallestReadPoint(), Long.MIN_VALUE);
        }

        @Override
        public InternalScanner preCompactScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Store store, List<? extends KeyValueScanner> scanners, ScanType scanType, long earliestPutTs, InternalScanner s) throws IOException {
            Long newTtl = this.ttls.get(store.getTableName());
            Integer newVersions = this.versions.get(store.getTableName());
            ScanInfo oldSI = store.getScanInfo();
            HColumnDescriptor family = store.getFamily();
            ScanInfo scanInfo = new ScanInfo(family.getName(), family.getMinVersions(), newVersions == null ? family.getMaxVersions() : newVersions.intValue(), newTtl == null ? oldSI.getTtl() : newTtl.longValue(), family.getKeepDeletedCells(), oldSI.getTimeToPurgeDeletes(), oldSI.getComparator());
            Scan scan = new Scan();
            scan.setMaxVersions(newVersions == null ? oldSI.getMaxVersions() : newVersions.intValue());
            return new StoreScanner(store, scanInfo, scan, scanners, scanType, store.getSmallestReadPoint(), earliestPutTs);
        }

        @Override
        public KeyValueScanner preStoreScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Store store, Scan scan, NavigableSet<byte[]> targetCols, KeyValueScanner s) throws IOException {
            Long newTtl = this.ttls.get(store.getTableName());
            Integer newVersions = this.versions.get(store.getTableName());
            ScanInfo oldSI = store.getScanInfo();
            HColumnDescriptor family = store.getFamily();
            ScanInfo scanInfo = new ScanInfo(family.getName(), family.getMinVersions(), newVersions == null ? family.getMaxVersions() : newVersions.intValue(), newTtl == null ? oldSI.getTtl() : newTtl.longValue(), family.getKeepDeletedCells(), oldSI.getTimeToPurgeDeletes(), oldSI.getComparator());
            return new StoreScanner(store, scanInfo, scan, targetCols, ((HStore)store).getHRegion().getReadpoint(IsolationLevel.READ_COMMITTED));
        }
    }
}

