/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HFileArchiveUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestHFileArchiveUtil {
    private Path rootDir = new Path("./");

    @Test
    public void testGetTableArchivePath() {
        Assert.assertNotNull((Object)HFileArchiveUtil.getTableArchivePath(this.rootDir, TableName.valueOf("table")));
    }

    @Test
    public void testGetArchivePath() throws Exception {
        Configuration conf = new Configuration();
        FSUtils.setRootDir(conf, new Path("root"));
        Assert.assertNotNull((Object)HFileArchiveUtil.getArchivePath(conf));
    }

    @Test
    public void testRegionArchiveDir() {
        Path regionDir = new Path("region");
        Assert.assertNotNull((Object)HFileArchiveUtil.getRegionArchiveDir(this.rootDir, TableName.valueOf("table"), regionDir));
    }

    @Test
    public void testGetStoreArchivePath() throws IOException {
        byte[] family = Bytes.toBytes("Family");
        Path tabledir = FSUtils.getTableDir(this.rootDir, TableName.valueOf("table"));
        HRegionInfo region = new HRegionInfo(TableName.valueOf("table"));
        Configuration conf = new Configuration();
        FSUtils.setRootDir(conf, new Path("root"));
        Assert.assertNotNull((Object)HFileArchiveUtil.getStoreArchivePath(conf, region, tabledir, family));
    }
}

