/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MediumTests;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.catalog.CatalogTracker;
import org.apache.hadoop.hbase.catalog.MetaReader;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.HMerge;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestMergeTable {
    private static final Log LOG = LogFactory.getLog(TestMergeTable.class);
    private final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static final byte[] COLUMN_NAME = Bytes.toBytes("contents");
    private static final byte[] VALUE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=300000L)
    public void testMergeTable() throws Exception {
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf(Bytes.toBytes("test")));
        desc.addFamily(new HColumnDescriptor(COLUMN_NAME));
        this.UTIL.getConfiguration().setLong("hbase.hregion.max.filesize", 0x4000000L);
        this.UTIL.getConfiguration().setInt("hbase.regionserver.regionSplitLimit", 0);
        this.UTIL.startMiniDFSCluster(1);
        Path rootdir = this.UTIL.createRootDir();
        FileSystem fs = FileSystem.get(this.UTIL.getConfiguration());
        if (fs.exists(rootdir) && fs.delete(rootdir, true)) {
            LOG.info("Cleaned up existing " + rootdir);
        }
        byte[] row_70001 = Bytes.toBytes("row_70001");
        byte[] row_80001 = Bytes.toBytes("row_80001");
        new FSTableDescriptors(fs, rootdir).createTableDescriptor(desc);
        HRegion[] regions = new HRegion[]{this.createRegion(desc, null, row_70001, 1, 70000, rootdir), this.createRegion(desc, row_70001, row_80001, 70001, 10000, rootdir), this.createRegion(desc, row_80001, null, 80001, 11000, rootdir)};
        this.setupMeta(rootdir, regions);
        try {
            LOG.info("Starting mini zk cluster");
            this.UTIL.startMiniZKCluster();
            LOG.info("Starting mini hbase cluster");
            this.UTIL.startMiniHBaseCluster(1, 1);
            Configuration c = new Configuration(this.UTIL.getConfiguration());
            CatalogTracker ct = new CatalogTracker(c);
            ct.start();
            List<HRegionInfo> originalTableRegions = MetaReader.getTableRegions(ct, desc.getTableName());
            LOG.info("originalTableRegions size=" + originalTableRegions.size() + "; " + originalTableRegions);
            HBaseAdmin admin = new HBaseAdmin(c);
            admin.disableTable(desc.getTableName());
            HMerge.merge(c, FileSystem.get(c), desc.getTableName());
            List<HRegionInfo> postMergeTableRegions = MetaReader.getTableRegions(ct, desc.getTableName());
            LOG.info("postMergeTableRegions size=" + postMergeTableRegions.size() + "; " + postMergeTableRegions);
            Assert.assertTrue((String)("originalTableRegions=" + originalTableRegions.size() + ", postMergeTableRegions=" + postMergeTableRegions.size()), (postMergeTableRegions.size() < originalTableRegions.size() ? 1 : 0) != 0);
            LOG.info("Done with merge");
        }
        finally {
            this.UTIL.shutdownMiniCluster();
            LOG.info("After cluster shutdown");
        }
    }

    private HRegion createRegion(HTableDescriptor desc, byte[] startKey, byte[] endKey, int firstRow, int nrows, Path rootdir) throws IOException {
        HRegionInfo hri = new HRegionInfo(desc.getTableName(), startKey, endKey);
        HRegion region = HRegion.createHRegion(hri, rootdir, this.UTIL.getConfiguration(), desc);
        LOG.info("Created region " + region.getRegionNameAsString());
        for (int i = firstRow; i < firstRow + nrows; ++i) {
            Put put = new Put(Bytes.toBytes("row_" + String.format("%1$05d", i)));
            put.setDurability(Durability.SKIP_WAL);
            put.add(COLUMN_NAME, null, VALUE);
            region.put(put);
            if (i % 10000 != 0) continue;
            LOG.info("Flushing write #" + i);
            region.flushcache();
        }
        HRegion.closeHRegion(region);
        return region;
    }

    protected void setupMeta(Path rootdir, HRegion[] regions) throws IOException {
        HRegion meta = HRegion.createHRegion(HRegionInfo.FIRST_META_REGIONINFO, rootdir, this.UTIL.getConfiguration(), HTableDescriptor.META_TABLEDESC);
        for (HRegion r : regions) {
            HRegion.addRegionToMETA(meta, r);
        }
        HRegion.closeHRegion(meta);
    }

    static {
        String partialValue = String.valueOf(System.currentTimeMillis());
        StringBuilder val = new StringBuilder();
        while (val.length() < 1024) {
            val.append(partialValue);
        }
        VALUE = Bytes.toBytes(val.toString());
    }
}

