/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.SmallTests;
import org.apache.hadoop.hbase.util.Threads;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestThreads {
    private static final Log LOG = LogFactory.getLog(TestThreads.class);
    private static final int SLEEP_TIME_MS = 3000;
    private static final int TOLERANCE_MS = 300;
    private final AtomicBoolean wasInterrupted = new AtomicBoolean(false);

    @Test(timeout=60000L)
    public void testSleepWithoutInterrupt() throws InterruptedException {
        Thread sleeper = new Thread(new Runnable(){

            @Override
            public void run() {
                LOG.debug("Sleeper thread: sleeping for 3000");
                Threads.sleepWithoutInterrupt(3000L);
                LOG.debug("Sleeper thread: finished sleeping");
                TestThreads.this.wasInterrupted.set(Thread.currentThread().isInterrupted());
            }
        });
        LOG.debug("Starting sleeper thread (3000 ms)");
        sleeper.start();
        long startTime = System.currentTimeMillis();
        LOG.debug("Main thread: sleeping for 200 ms");
        Threads.sleep(200L);
        LOG.debug("Interrupting the sleeper thread and sleeping for 500 ms");
        sleeper.interrupt();
        Threads.sleep(500L);
        LOG.debug("Interrupting the sleeper thread and sleeping for 800 ms");
        sleeper.interrupt();
        Threads.sleep(800L);
        LOG.debug("Interrupting the sleeper thread again");
        sleeper.interrupt();
        sleeper.join();
        Assert.assertTrue((String)"sleepWithoutInterrupt did not preserve the thread's interrupted status", (boolean)this.wasInterrupted.get());
        long timeElapsed = System.currentTimeMillis() - startTime;
        Assert.assertTrue((String)("Elapsed time " + timeElapsed + " ms is out of the expected " + " sleep time of " + 3000), (3000L - timeElapsed < 300L ? 1 : 0) != 0);
        LOG.debug("Target sleep time: 3000, time elapsed: " + timeElapsed);
    }
}

