/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class RecoveringRegionWatcher
extends ZooKeeperListener {
    private static final Log LOG = LogFactory.getLog(RecoveringRegionWatcher.class);
    private HRegionServer server;

    public RecoveringRegionWatcher(ZooKeeperWatcher watcher, HRegionServer server) {
        super(watcher);
        watcher.registerListener(this);
        this.server = server;
    }

    @Override
    public void nodeDeleted(String path) {
        if (this.server.isStopped() || this.server.isStopping()) {
            return;
        }
        String parentPath = path.substring(0, path.lastIndexOf(47));
        if (!this.watcher.recoveringRegionsZNode.equalsIgnoreCase(parentPath)) {
            return;
        }
        String regionName = path.substring(parentPath.length() + 1);
        HRegion region = this.server.getRecoveringRegions().remove(regionName);
        if (region != null) {
            region.setRecovering(false);
        }
        LOG.info(path + " znode deleted. Region: " + regionName + " completes recovery.");
    }

    @Override
    public void nodeDataChanged(String path) {
        this.registerWatcher(path);
    }

    @Override
    public void nodeChildrenChanged(String path) {
        this.registerWatcher(path);
    }

    private void registerWatcher(String path) {
        String parentPath = path.substring(0, path.lastIndexOf(47));
        if (!this.watcher.recoveringRegionsZNode.equalsIgnoreCase(parentPath)) {
            return;
        }
        try {
            ZKUtil.getDataAndWatch(this.watcher, path);
        }
        catch (KeeperException e) {
            LOG.warn("Can't register watcher on znode " + path, e);
        }
    }
}

