/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.RegionTransition;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.executor.EventType;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.AsyncCallback;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;

@InterfaceAudience.Private
public class ZKAssign {
    private static final Log LOG = LogFactory.getLog(ZKAssign.class);

    public static String getNodeName(ZooKeeperWatcher zkw, String regionName) {
        return ZKUtil.joinZNode(zkw.assignmentZNode, regionName);
    }

    public static String getRegionName(ZooKeeperWatcher zkw, String path) {
        return path.substring(zkw.assignmentZNode.length() + 1);
    }

    public static void createNodeOffline(ZooKeeperWatcher zkw, HRegionInfo region, ServerName serverName) throws KeeperException, KeeperException.NodeExistsException {
        ZKAssign.createNodeOffline(zkw, region, serverName, EventType.M_ZK_REGION_OFFLINE);
    }

    public static void createNodeOffline(ZooKeeperWatcher zkw, HRegionInfo region, ServerName serverName, EventType event) throws KeeperException, KeeperException.NodeExistsException {
        LOG.debug(zkw.prefix("Creating unassigned node " + region.getEncodedName() + " in OFFLINE state"));
        RegionTransition rt = RegionTransition.createRegionTransition(event, region.getRegionName(), serverName);
        String node = ZKAssign.getNodeName(zkw, region.getEncodedName());
        ZKUtil.createAndWatch(zkw, node, rt.toByteArray());
    }

    public static void asyncCreateNodeOffline(ZooKeeperWatcher zkw, HRegionInfo region, ServerName serverName, AsyncCallback.StringCallback cb, Object ctx) throws KeeperException {
        LOG.debug(zkw.prefix("Async create of unassigned node " + region.getEncodedName() + " with OFFLINE state"));
        RegionTransition rt = RegionTransition.createRegionTransition(EventType.M_ZK_REGION_OFFLINE, region.getRegionName(), serverName);
        String node = ZKAssign.getNodeName(zkw, region.getEncodedName());
        ZKUtil.asyncCreate(zkw, node, rt.toByteArray(), cb, ctx);
    }

    public static int createOrForceNodeOffline(ZooKeeperWatcher zkw, HRegionInfo region, ServerName serverName) throws KeeperException {
        LOG.debug(zkw.prefix("Creating (or updating) unassigned node " + region.getEncodedName() + " with OFFLINE state"));
        RegionTransition rt = RegionTransition.createRegionTransition(EventType.M_ZK_REGION_OFFLINE, region.getRegionName(), serverName, HConstants.EMPTY_BYTE_ARRAY);
        byte[] data = rt.toByteArray();
        String node = ZKAssign.getNodeName(zkw, region.getEncodedName());
        zkw.sync(node);
        int version = ZKUtil.checkExists(zkw, node);
        if (version == -1) {
            return ZKUtil.createAndWatch(zkw, node, data);
        }
        boolean setData = false;
        try {
            setData = ZKUtil.setData(zkw, node, data, version);
        }
        catch (KeeperException kpe) {
            LOG.info("Version mismatch while setting the node to OFFLINE state.");
            return -1;
        }
        if (!setData) {
            return -1;
        }
        byte[] bytes = ZKAssign.getData(zkw, region.getEncodedName());
        rt = ZKAssign.getRegionTransition(bytes);
        if (rt.getEventType() != EventType.M_ZK_REGION_OFFLINE) {
            return -1;
        }
        return version + 1;
    }

    public static boolean deleteOpenedNode(ZooKeeperWatcher zkw, String encodedRegionName, ServerName sn) throws KeeperException, KeeperException.NoNodeException {
        return ZKAssign.deleteNode(zkw, encodedRegionName, EventType.RS_ZK_REGION_OPENED, sn);
    }

    public static boolean deleteOfflineNode(ZooKeeperWatcher zkw, String encodedRegionName, ServerName sn) throws KeeperException, KeeperException.NoNodeException {
        return ZKAssign.deleteNode(zkw, encodedRegionName, EventType.M_ZK_REGION_OFFLINE, sn);
    }

    public static boolean deleteClosedNode(ZooKeeperWatcher zkw, String encodedRegionName, ServerName sn) throws KeeperException, KeeperException.NoNodeException {
        return ZKAssign.deleteNode(zkw, encodedRegionName, EventType.RS_ZK_REGION_CLOSED, sn);
    }

    public static boolean deleteClosingNode(ZooKeeperWatcher zkw, HRegionInfo region, ServerName sn) throws KeeperException, KeeperException.NoNodeException {
        String encodedRegionName = region.getEncodedName();
        return ZKAssign.deleteNode(zkw, encodedRegionName, EventType.M_ZK_REGION_CLOSING, sn);
    }

    public static boolean deleteNode(ZooKeeperWatcher zkw, String encodedRegionName, EventType expectedState, ServerName sn) throws KeeperException, KeeperException.NoNodeException {
        return ZKAssign.deleteNode(zkw, encodedRegionName, expectedState, sn, -1);
    }

    public static boolean deleteNode(ZooKeeperWatcher zkw, String encodedRegionName, EventType expectedState, int expectedVersion) throws KeeperException, KeeperException.NoNodeException {
        return ZKAssign.deleteNode(zkw, encodedRegionName, expectedState, null, expectedVersion);
    }

    public static boolean deleteNode(ZooKeeperWatcher zkw, String encodedRegionName, EventType expectedState, ServerName serverName, int expectedVersion) throws KeeperException, KeeperException.NoNodeException {
        if (LOG.isTraceEnabled()) {
            LOG.trace(zkw.prefix("Deleting existing unassigned node " + encodedRegionName + " in expected state " + (Object)((Object)expectedState)));
        }
        String node = ZKAssign.getNodeName(zkw, encodedRegionName);
        zkw.sync(node);
        Stat stat = new Stat();
        byte[] bytes = ZKUtil.getDataNoWatch(zkw, node, stat);
        if (bytes == null) {
            throw KeeperException.create(KeeperException.Code.NONODE);
        }
        RegionTransition rt = ZKAssign.getRegionTransition(bytes);
        EventType et = rt.getEventType();
        if (!et.equals((Object)expectedState)) {
            LOG.warn(zkw.prefix("Attempting to delete unassigned node " + encodedRegionName + " in " + (Object)((Object)expectedState) + " state but node is in " + (Object)((Object)et) + " state"));
            return false;
        }
        if (serverName != null && !rt.getServerName().equals(serverName)) {
            LOG.warn(zkw.prefix("Attempting to delete unassigned node " + encodedRegionName + " with target " + serverName + " but node has " + rt.getServerName()));
            return false;
        }
        if (expectedVersion != -1 && stat.getVersion() != expectedVersion) {
            LOG.warn("The node " + encodedRegionName + " we are trying to delete is not" + " the expected one. Got a version mismatch");
            return false;
        }
        if (!ZKUtil.deleteNode(zkw, node, stat.getVersion())) {
            LOG.warn(zkw.prefix("Attempting to delete unassigned node " + encodedRegionName + " in " + (Object)((Object)expectedState) + " state but after verifying state, we got a version mismatch"));
            return false;
        }
        LOG.debug(zkw.prefix("Deleted unassigned node " + encodedRegionName + " in expected state " + (Object)((Object)expectedState)));
        return true;
    }

    public static void deleteAllNodes(ZooKeeperWatcher zkw) throws KeeperException {
        LOG.debug(zkw.prefix("Deleting any existing unassigned nodes"));
        ZKUtil.deleteChildrenRecursively(zkw, zkw.assignmentZNode);
    }

    public static int createNodeClosing(ZooKeeperWatcher zkw, HRegionInfo region, ServerName serverName) throws KeeperException, KeeperException.NodeExistsException {
        LOG.debug(zkw.prefix("Creating unassigned node " + region.getEncodedName() + " in a CLOSING state"));
        RegionTransition rt = RegionTransition.createRegionTransition(EventType.M_ZK_REGION_CLOSING, region.getRegionName(), serverName, HConstants.EMPTY_BYTE_ARRAY);
        String node = ZKAssign.getNodeName(zkw, region.getEncodedName());
        return ZKUtil.createAndWatch(zkw, node, rt.toByteArray());
    }

    public static int transitionNodeClosed(ZooKeeperWatcher zkw, HRegionInfo region, ServerName serverName, int expectedVersion) throws KeeperException {
        return ZKAssign.transitionNode(zkw, region, serverName, EventType.M_ZK_REGION_CLOSING, EventType.RS_ZK_REGION_CLOSED, expectedVersion);
    }

    public static int transitionNodeOpening(ZooKeeperWatcher zkw, HRegionInfo region, ServerName serverName) throws KeeperException {
        return ZKAssign.transitionNodeOpening(zkw, region, serverName, EventType.M_ZK_REGION_OFFLINE);
    }

    public static int transitionNodeOpening(ZooKeeperWatcher zkw, HRegionInfo region, ServerName serverName, EventType beginState) throws KeeperException {
        return ZKAssign.transitionNode(zkw, region, serverName, beginState, EventType.RS_ZK_REGION_OPENING, -1);
    }

    public static int retransitionNodeOpening(ZooKeeperWatcher zkw, HRegionInfo region, ServerName serverName, int expectedVersion, boolean updateZNode) throws KeeperException {
        String encoded = region.getEncodedName();
        if (LOG.isDebugEnabled()) {
            LOG.debug(zkw.prefix("Attempting to retransition opening state of node " + HRegionInfo.prettyPrint(encoded)));
        }
        String node = ZKAssign.getNodeName(zkw, encoded);
        zkw.sync(node);
        Stat stat = new Stat();
        byte[] existingBytes = ZKUtil.getDataNoWatch(zkw, node, stat);
        if (existingBytes == null) {
            return -1;
        }
        RegionTransition rt = ZKAssign.getRegionTransition(existingBytes);
        if (expectedVersion != -1 && stat.getVersion() != expectedVersion) {
            LOG.warn(zkw.prefix("Attempt to retransition the opening state of the unassigned node for " + encoded + " failed, " + "the node existed but was version " + stat.getVersion() + " not the expected version " + expectedVersion));
            return -1;
        }
        EventType et = rt.getEventType();
        if (!et.equals((Object)EventType.RS_ZK_REGION_OPENING)) {
            String existingServer = rt.getServerName() == null ? "<unknown>" : rt.getServerName().toString();
            LOG.warn(zkw.prefix("Attempt to retransition the opening state of the unassigned node for " + encoded + " failed, the node existed but was in the state " + (Object)((Object)et) + " set by the server " + existingServer));
            return -1;
        }
        if (!updateZNode) {
            return expectedVersion;
        }
        try {
            rt = RegionTransition.createRegionTransition(EventType.RS_ZK_REGION_OPENING, region.getRegionName(), serverName, null);
            if (!ZKUtil.setData(zkw, node, rt.toByteArray(), stat.getVersion())) {
                LOG.warn(zkw.prefix("Attempt to retransition the opening state of the unassigned node for " + encoded + " failed, " + "the node existed and was in the expected state but then when " + "setting data we got a version mismatch"));
                return -1;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(zkw.prefix("Retransition opening state of node " + encoded));
            }
            return stat.getVersion() + 1;
        }
        catch (KeeperException.NoNodeException nne) {
            LOG.warn(zkw.prefix("Attempt to retransition the opening state of the unassigned node for " + encoded + " failed, " + "the node existed and was in the expected state but then when " + "setting data it no longer existed"));
            return -1;
        }
    }

    public static int transitionNodeOpened(ZooKeeperWatcher zkw, HRegionInfo region, ServerName serverName, int expectedVersion) throws KeeperException {
        return ZKAssign.transitionNode(zkw, region, serverName, EventType.RS_ZK_REGION_OPENING, EventType.RS_ZK_REGION_OPENED, expectedVersion);
    }

    public static boolean checkClosingState(ZooKeeperWatcher zkw, HRegionInfo region, int expectedVersion) throws KeeperException {
        String encoded = ZKAssign.getNodeName(zkw, region.getEncodedName());
        zkw.sync(encoded);
        Stat stat = new Stat();
        byte[] existingBytes = ZKUtil.getDataNoWatch(zkw, encoded, stat);
        if (existingBytes == null) {
            LOG.warn(zkw.prefix("Attempt to check the closing node for " + encoded + ". The node does not exist"));
            return false;
        }
        if (expectedVersion != -1 && stat.getVersion() != expectedVersion) {
            LOG.warn(zkw.prefix("Attempt to check the closing node for " + encoded + ". The node existed but was version " + stat.getVersion() + " not the expected version " + expectedVersion));
            return false;
        }
        RegionTransition rt = ZKAssign.getRegionTransition(existingBytes);
        if (!EventType.M_ZK_REGION_CLOSING.equals((Object)rt.getEventType())) {
            LOG.warn(zkw.prefix("Attempt to check the closing node for " + encoded + ". The node existed but was in an unexpected state: " + (Object)((Object)rt.getEventType())));
            return false;
        }
        return true;
    }

    public static int transitionNode(ZooKeeperWatcher zkw, HRegionInfo region, ServerName serverName, EventType beginState, EventType endState, int expectedVersion) throws KeeperException {
        return ZKAssign.transitionNode(zkw, region, serverName, beginState, endState, expectedVersion, null);
    }

    public static int transitionNode(ZooKeeperWatcher zkw, HRegionInfo region, ServerName serverName, EventType beginState, EventType endState, int expectedVersion, byte[] payload) throws KeeperException {
        String encoded = region.getEncodedName();
        if (LOG.isDebugEnabled()) {
            LOG.debug(zkw.prefix("Transitioning " + HRegionInfo.prettyPrint(encoded) + " from " + beginState.toString() + " to " + endState.toString()));
        }
        String node = ZKAssign.getNodeName(zkw, encoded);
        zkw.sync(node);
        Stat stat = new Stat();
        byte[] existingBytes = ZKUtil.getDataNoWatch(zkw, node, stat);
        if (existingBytes == null) {
            return -1;
        }
        if (expectedVersion != -1 && stat.getVersion() != expectedVersion) {
            LOG.warn(zkw.prefix("Attempt to transition the unassigned node for " + encoded + " from " + (Object)((Object)beginState) + " to " + (Object)((Object)endState) + " failed, " + "the node existed but was version " + stat.getVersion() + " not the expected version " + expectedVersion));
            return -1;
        }
        if (beginState.equals((Object)EventType.M_ZK_REGION_OFFLINE) && endState.equals((Object)EventType.RS_ZK_REGION_OPENING) && expectedVersion == -1 && stat.getVersion() != 0) {
            LOG.warn(zkw.prefix("Attempt to transition the unassigned node for " + encoded + " from " + (Object)((Object)beginState) + " to " + (Object)((Object)endState) + " failed, " + "the node existed but was version " + stat.getVersion() + " not the expected version " + expectedVersion));
            return -1;
        }
        RegionTransition rt = ZKAssign.getRegionTransition(existingBytes);
        if (!rt.getServerName().equals(serverName)) {
            LOG.warn(zkw.prefix("Attempt to transition the unassigned node for " + encoded + " from " + (Object)((Object)beginState) + " to " + (Object)((Object)endState) + " failed, " + "the server that tried to transition was " + serverName + " not the expected " + rt.getServerName()));
            return -1;
        }
        EventType et = rt.getEventType();
        if (!et.equals((Object)beginState)) {
            String existingServer = rt.getServerName() == null ? "<unknown>" : rt.getServerName().toString();
            LOG.warn(zkw.prefix("Attempt to transition the unassigned node for " + encoded + " from " + (Object)((Object)beginState) + " to " + (Object)((Object)endState) + " failed, the node existed but" + " was in the state " + (Object)((Object)et) + " set by the server " + existingServer));
            return -1;
        }
        try {
            rt = RegionTransition.createRegionTransition(endState, region.getRegionName(), serverName, payload);
            if (!ZKUtil.setData(zkw, node, rt.toByteArray(), stat.getVersion())) {
                LOG.warn(zkw.prefix("Attempt to transition the unassigned node for " + encoded + " from " + (Object)((Object)beginState) + " to " + (Object)((Object)endState) + " failed, " + "the node existed and was in the expected state but then when " + "setting data we got a version mismatch"));
                return -1;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(zkw.prefix("Transitioned node " + encoded + " from " + (Object)((Object)beginState) + " to " + (Object)((Object)endState)));
            }
            return stat.getVersion() + 1;
        }
        catch (KeeperException.NoNodeException nne) {
            LOG.warn(zkw.prefix("Attempt to transition the unassigned node for " + encoded + " from " + (Object)((Object)beginState) + " to " + (Object)((Object)endState) + " failed, " + "the node existed and was in the expected state but then when " + "setting data it no longer existed"));
            return -1;
        }
    }

    private static RegionTransition getRegionTransition(byte[] bytes) throws KeeperException {
        try {
            return RegionTransition.parseFrom(bytes);
        }
        catch (DeserializationException e) {
            throw ZKUtil.convert(e);
        }
    }

    public static byte[] getData(ZooKeeperWatcher zkw, String pathOrRegionName) throws KeeperException {
        String node = ZKAssign.getPath(zkw, pathOrRegionName);
        return ZKUtil.getDataAndWatch(zkw, node);
    }

    public static byte[] getDataAndWatch(ZooKeeperWatcher zkw, String pathOrRegionName, Stat stat) throws KeeperException {
        String node = ZKAssign.getPath(zkw, pathOrRegionName);
        return ZKUtil.getDataAndWatch(zkw, node, stat);
    }

    public static byte[] getDataNoWatch(ZooKeeperWatcher zkw, String pathOrRegionName, Stat stat) throws KeeperException {
        String node = ZKAssign.getPath(zkw, pathOrRegionName);
        return ZKUtil.getDataNoWatch(zkw, node, stat);
    }

    public static String getPath(ZooKeeperWatcher zkw, String pathOrRegionName) {
        return pathOrRegionName.startsWith("/") ? pathOrRegionName : ZKAssign.getNodeName(zkw, pathOrRegionName);
    }

    public static int getVersion(ZooKeeperWatcher zkw, HRegionInfo region) throws KeeperException {
        String znode = ZKAssign.getNodeName(zkw, region.getEncodedName());
        return ZKUtil.checkExists(zkw, znode);
    }

    public static void deleteNodeFailSilent(ZooKeeperWatcher watcher, HRegionInfo regionInfo) throws KeeperException {
        String node = ZKAssign.getNodeName(watcher, regionInfo.getEncodedName());
        ZKUtil.deleteNodeFailSilent(watcher, node);
    }

    public static void blockUntilNoRIT(ZooKeeperWatcher zkw) throws KeeperException, InterruptedException {
        while (ZKUtil.nodeHasChildren(zkw, zkw.assignmentZNode)) {
            List<String> znodes = ZKUtil.listChildrenAndWatchForNewChildren(zkw, zkw.assignmentZNode);
            if (znodes != null && !znodes.isEmpty()) {
                LOG.debug("Waiting on RIT: " + znodes);
            }
            Thread.sleep(100L);
        }
    }

    public static void blockUntilRIT(ZooKeeperWatcher zkw) throws KeeperException, InterruptedException {
        while (!ZKUtil.nodeHasChildren(zkw, zkw.assignmentZNode)) {
            List<String> znodes = ZKUtil.listChildrenAndWatchForNewChildren(zkw, zkw.assignmentZNode);
            if (znodes == null || znodes.isEmpty()) {
                LOG.debug("No RIT in ZK");
            }
            Thread.sleep(100L);
        }
    }

    static String toString(byte[] znodeBytes) {
        try {
            RegionTransition rt = RegionTransition.parseFrom(znodeBytes);
            return rt.toString();
        }
        catch (DeserializationException e) {
            return "";
        }
    }
}

