/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.PrivilegedExceptionAction;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TimeZone;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FSInputStream;
import org.apache.hadoop.fs.FileChecksum;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.MD5MD5CRC32FileChecksum;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.DFSUtil;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenIdentifier;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenRenewer;
import org.apache.hadoop.hdfs.security.token.delegation.DelegationTokenSelector;
import org.apache.hadoop.hdfs.server.namenode.JspHelper;
import org.apache.hadoop.hdfs.tools.DelegationTokenFetcher;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.apache.hadoop.security.token.TokenRenewer;
import org.apache.hadoop.security.token.delegation.AbstractDelegationTokenSelector;
import org.apache.hadoop.util.Progressable;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class HftpFileSystem
extends FileSystem
implements DelegationTokenRenewer.Renewable {
    private static final DelegationTokenRenewer<HftpFileSystem> dtRenewer = new DelegationTokenRenewer<HftpFileSystem>(HftpFileSystem.class);
    public static final Text TOKEN_KIND;
    protected UserGroupInformation ugi;
    private boolean remoteIsInsecure = false;
    private URI hftpURI;
    protected InetSocketAddress nnAddr;
    protected InetSocketAddress nnSecureAddr;
    public static final String HFTP_TIMEZONE = "UTC";
    public static final String HFTP_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ssZ";
    private Token<?> delegationToken;
    private Token<?> renewToken;
    private static final HftpDelegationTokenSelector hftpTokenSelector;
    protected static final ThreadLocal<SimpleDateFormat> df;

    public static final SimpleDateFormat getDateFormat() {
        SimpleDateFormat df = new SimpleDateFormat(HFTP_DATE_FORMAT);
        df.setTimeZone(TimeZone.getTimeZone(HFTP_TIMEZONE));
        return df;
    }

    @Override
    protected int getDefaultPort() {
        return this.getConf().getInt("dfs.http.port", 50070);
    }

    protected int getDefaultSecurePort() {
        return this.getConf().getInt("dfs.https.port", 50470);
    }

    protected InetSocketAddress getNamenodeAddr(URI uri) {
        return NetUtils.createSocketAddr(uri.getAuthority(), this.getDefaultPort());
    }

    protected InetSocketAddress getNamenodeSecureAddr(URI uri) {
        return NetUtils.makeSocketAddr(uri.getHost(), this.getDefaultSecurePort());
    }

    @Override
    public String getCanonicalServiceName() {
        return SecurityUtil.buildTokenService(this.nnSecureAddr).toString();
    }

    @Override
    public void initialize(URI name, Configuration conf) throws IOException {
        this.setConf(conf);
        super.initialize(name, conf);
        this.ugi = UserGroupInformation.getCurrentUser();
        this.nnAddr = this.getNamenodeAddr(name);
        this.nnSecureAddr = this.getNamenodeSecureAddr(name);
        this.hftpURI = DFSUtil.createUri(name.getScheme(), this.nnAddr);
    }

    protected void initDelegationToken() throws IOException {
        Token<DelegationTokenIdentifier> token = this.selectHftpDelegationToken();
        if (token == null) {
            token = this.selectHdfsDelegationToken();
        }
        boolean createdToken = false;
        if (token == null) {
            token = this.getDelegationToken(null);
            boolean bl = createdToken = token != null;
        }
        if (token != null) {
            this.setDelegationToken(token);
            if (createdToken) {
                dtRenewer.addRenewAction(this);
                LOG.debug("Created new DT for " + token.getService());
            } else {
                LOG.debug("Found existing DT for " + token.getService());
            }
        }
    }

    protected Token<DelegationTokenIdentifier> selectHftpDelegationToken() {
        Text serviceName = SecurityUtil.buildTokenService(this.nnSecureAddr);
        return hftpTokenSelector.selectToken(serviceName, this.ugi.getTokens());
    }

    protected Token<DelegationTokenIdentifier> selectHdfsDelegationToken() {
        return DelegationTokenSelector.selectHdfsDelegationToken(this.nnAddr, this.ugi, this.getConf());
    }

    @Override
    public Token<?> getRenewToken() {
        return this.renewToken;
    }

    @Override
    public <T extends TokenIdentifier> void setDelegationToken(Token<T> token) {
        this.renewToken = token;
        this.delegationToken = new Token<T>(token);
        this.delegationToken.setKind(DelegationTokenIdentifier.HDFS_DELEGATION_KIND);
    }

    @Override
    public synchronized Token<?> getDelegationToken(final String renewer) throws IOException {
        try {
            this.ugi.checkTGTAndReloginFromKeytab();
            return (Token)this.ugi.doAs(new PrivilegedExceptionAction<Token<?>>(){

                @Override
                public Token<?> run() throws IOException {
                    Credentials c;
                    String nnHttpUrl = DFSUtil.createUri("https", HftpFileSystem.this.nnSecureAddr).toString();
                    try {
                        c = DelegationTokenFetcher.getDTfromRemote(nnHttpUrl, renewer);
                    }
                    catch (Exception e) {
                        FileSystem.LOG.info("Couldn't get a delegation token from " + nnHttpUrl + " using https.");
                        FileSystem.LOG.debug("error was ", e);
                        HftpFileSystem.this.remoteIsInsecure = true;
                        return null;
                    }
                    Iterator<Token<? extends TokenIdentifier>> i$ = c.getAllTokens().iterator();
                    if (i$.hasNext()) {
                        Token<? extends TokenIdentifier> t = i$.next();
                        FileSystem.LOG.debug("Got dt for " + HftpFileSystem.this.getUri() + ";t.service=" + t.getService());
                        return t;
                    }
                    return null;
                }
            });
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public URI getUri() {
        return this.hftpURI;
    }

    private String getUgiParameter() {
        StringBuilder ugiParamenter = new StringBuilder(this.ugi.getShortUserName());
        for (String g : this.ugi.getGroupNames()) {
            ugiParamenter.append(",");
            ugiParamenter.append(g);
        }
        return ugiParamenter.toString();
    }

    static Void throwIOExceptionFromConnection(HttpURLConnection connection, IOException ioe) throws IOException {
        int code = connection.getResponseCode();
        String s = connection.getResponseMessage();
        throw s == null ? ioe : new IOException(s + " (error code=" + code + ")", ioe);
    }

    protected HttpURLConnection openConnection(String path, String query) throws IOException {
        try {
            query = this.updateQuery(query);
            URL url = new URI("http", null, this.nnAddr.getHostName(), this.nnAddr.getPort(), path, query, null).toURL();
            if (LOG.isTraceEnabled()) {
                LOG.trace("url=" + url);
            }
            return (HttpURLConnection)url.openConnection();
        }
        catch (URISyntaxException e) {
            throw (IOException)new IOException().initCause(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String updateQuery(String query) throws IOException {
        String tokenString = null;
        if (UserGroupInformation.isSecurityEnabled()) {
            HftpFileSystem hftpFileSystem = this;
            synchronized (hftpFileSystem) {
                if (this.delegationToken == null && !this.remoteIsInsecure) {
                    this.initDelegationToken();
                }
                if (this.delegationToken != null) {
                    tokenString = this.delegationToken.encodeToUrlString();
                    return query + JspHelper.getDelegationTokenUrlParam(tokenString);
                }
            }
        }
        return query;
    }

    @Override
    public FSDataInputStream open(Path f, int buffersize) throws IOException {
        long filelength;
        InputStream in;
        HttpURLConnection connection = this.openConnection("/data" + f.makeQualified(this).toUri().getPath(), "ugi=" + this.getUgiParameter());
        try {
            connection.setRequestMethod("GET");
            connection.connect();
            in = connection.getInputStream();
        }
        catch (IOException ioe) {
            int code = connection.getResponseCode();
            String s = connection.getResponseMessage();
            throw s == null ? ioe : new IOException(s + " (error code=" + code + ")", ioe);
        }
        String cl = connection.getHeaderField("Content-Length");
        long l = filelength = cl == null ? -1L : Long.parseLong(cl);
        if (LOG.isDebugEnabled()) {
            LOG.debug("filelength = " + filelength);
        }
        return new FSDataInputStream(new FSInputStream(){
            long currentPos = 0L;

            private void update(boolean isEOF, int n) throws IOException {
                if (!isEOF) {
                    this.currentPos += (long)n;
                } else if (this.currentPos < filelength) {
                    throw new IOException("Got EOF but byteread = " + this.currentPos + " < filelength = " + filelength);
                }
            }

            @Override
            public int read() throws IOException {
                int b = in.read();
                this.update(b == -1, 1);
                return b;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                int n = in.read(b, off, len);
                this.update(n == -1, n);
                return n;
            }

            @Override
            public void close() throws IOException {
                in.close();
            }

            @Override
            public void seek(long pos) throws IOException {
                throw new IOException("Can't seek!");
            }

            @Override
            public long getPos() throws IOException {
                throw new IOException("Position unknown!");
            }

            @Override
            public boolean seekToNewSource(long targetPos) throws IOException {
                return false;
            }
        });
    }

    @Override
    public FileStatus[] listStatus(Path f) throws IOException {
        LsParser lsparser = new LsParser();
        return lsparser.listStatus(f);
    }

    @Override
    public FileStatus getFileStatus(Path f) throws IOException {
        LsParser lsparser = new LsParser();
        return lsparser.getFileStatus(f);
    }

    @Override
    public FileChecksum getFileChecksum(Path f) throws IOException {
        String s = this.makeQualified(f).toUri().getPath();
        return new ChecksumParser().getFileChecksum(s);
    }

    @Override
    public Path getWorkingDirectory() {
        return new Path("/").makeQualified(this);
    }

    @Override
    public void setWorkingDirectory(Path f) {
    }

    @Override
    public FSDataOutputStream append(Path f, int bufferSize, Progressable progress) throws IOException {
        throw new IOException("Not supported");
    }

    @Override
    public FSDataOutputStream create(Path f, FsPermission permission, boolean overwrite, int bufferSize, short replication, long blockSize, Progressable progress) throws IOException {
        throw new IOException("Not supported");
    }

    @Override
    public boolean rename(Path src, Path dst) throws IOException {
        throw new IOException("Not supported");
    }

    @Override
    @Deprecated
    public boolean delete(Path f) throws IOException {
        throw new IOException("Not supported");
    }

    @Override
    public boolean delete(Path f, boolean recursive) throws IOException {
        throw new IOException("Not supported");
    }

    @Override
    public boolean mkdirs(Path f, FsPermission permission) throws IOException {
        throw new IOException("Not supported");
    }

    private static ContentSummary toContentSummary(Attributes attrs) throws SAXException {
        String length = attrs.getValue("length");
        String fileCount = attrs.getValue("fileCount");
        String directoryCount = attrs.getValue("directoryCount");
        String quota = attrs.getValue("quota");
        String spaceConsumed = attrs.getValue("spaceConsumed");
        String spaceQuota = attrs.getValue("spaceQuota");
        if (length == null || fileCount == null || directoryCount == null || quota == null || spaceConsumed == null || spaceQuota == null) {
            return null;
        }
        try {
            return new ContentSummary(Long.parseLong(length), Long.parseLong(fileCount), Long.parseLong(directoryCount), Long.parseLong(quota), Long.parseLong(spaceConsumed), Long.parseLong(spaceQuota));
        }
        catch (Exception e) {
            throw new SAXException("Invalid attributes: length=" + length + ", fileCount=" + fileCount + ", directoryCount=" + directoryCount + ", quota=" + quota + ", spaceConsumed=" + spaceConsumed + ", spaceQuota=" + spaceQuota, e);
        }
    }

    @Override
    public ContentSummary getContentSummary(Path f) throws IOException {
        String s = this.makeQualified(f).toUri().getPath();
        ContentSummary cs = new ContentSummaryParser().getContentSummary(s);
        return cs != null ? cs : super.getContentSummary(f);
    }

    static {
        HttpURLConnection.setFollowRedirects(true);
        TOKEN_KIND = new Text("HFTP delegation");
        hftpTokenSelector = new HftpDelegationTokenSelector();
        df = new ThreadLocal<SimpleDateFormat>(){

            @Override
            protected SimpleDateFormat initialValue() {
                return HftpFileSystem.getDateFormat();
            }
        };
    }

    private static class HftpDelegationTokenSelector
    extends AbstractDelegationTokenSelector<DelegationTokenIdentifier> {
        public HftpDelegationTokenSelector() {
            super(TOKEN_KIND);
        }
    }

    @InterfaceAudience.Private
    public static class TokenManager
    extends TokenRenewer {
        @Override
        public boolean handleKind(Text kind) {
            return kind.equals(TOKEN_KIND);
        }

        @Override
        public boolean isManaged(Token<?> token) throws IOException {
            return true;
        }

        @Override
        public long renew(Token<?> token, Configuration conf) throws IOException {
            UserGroupInformation.getLoginUser().checkTGTAndReloginFromKeytab();
            InetSocketAddress serviceAddr = SecurityUtil.getTokenServiceAddr(token);
            return DelegationTokenFetcher.renewDelegationToken(DFSUtil.createUri("https", serviceAddr).toString(), token);
        }

        @Override
        public void cancel(Token<?> token, Configuration conf) throws IOException {
            UserGroupInformation.getLoginUser().checkTGTAndReloginFromKeytab();
            InetSocketAddress serviceAddr = SecurityUtil.getTokenServiceAddr(token);
            DelegationTokenFetcher.cancelDelegationToken(DFSUtil.createUri("https", serviceAddr).toString(), token);
        }
    }

    private class ContentSummaryParser
    extends DefaultHandler {
        private ContentSummary contentsummary;

        private ContentSummaryParser() {
        }

        @Override
        public void startElement(String ns, String localname, String qname, Attributes attrs) throws SAXException {
            if (!ContentSummary.class.getName().equals(qname)) {
                if (RemoteException.class.getSimpleName().equals(qname)) {
                    throw new SAXException(RemoteException.valueOf(attrs));
                }
                throw new SAXException("Unrecognized entry: " + qname);
            }
            this.contentsummary = HftpFileSystem.toContentSummary(attrs);
        }

        private ContentSummary getContentSummary(String path) throws IOException {
            HttpURLConnection connection = HftpFileSystem.this.openConnection("/contentSummary" + path, "ugi=" + HftpFileSystem.this.getUgiParameter());
            InputStream in = null;
            try {
                in = connection.getInputStream();
                XMLReader xr = XMLReaderFactory.createXMLReader();
                xr.setContentHandler(this);
                xr.parse(new InputSource(in));
            }
            catch (FileNotFoundException fnfe) {
                ContentSummary contentSummary = null;
                return contentSummary;
            }
            catch (SAXException saxe) {
                Exception embedded = saxe.getException();
                if (embedded != null && embedded instanceof IOException) {
                    throw (IOException)embedded;
                }
                throw new IOException("Invalid xml format", saxe);
            }
            finally {
                if (in != null) {
                    in.close();
                }
                connection.disconnect();
            }
            return this.contentsummary;
        }
    }

    private class ChecksumParser
    extends DefaultHandler {
        private FileChecksum filechecksum;

        private ChecksumParser() {
        }

        @Override
        public void startElement(String ns, String localname, String qname, Attributes attrs) throws SAXException {
            if (!MD5MD5CRC32FileChecksum.class.getName().equals(qname)) {
                if (RemoteException.class.getSimpleName().equals(qname)) {
                    throw new SAXException(RemoteException.valueOf(attrs));
                }
                throw new SAXException("Unrecognized entry: " + qname);
            }
            this.filechecksum = MD5MD5CRC32FileChecksum.valueOf(attrs);
        }

        private FileChecksum getFileChecksum(String f) throws IOException {
            HttpURLConnection connection = HftpFileSystem.this.openConnection("/fileChecksum" + f, "ugi=" + HftpFileSystem.this.getUgiParameter());
            try {
                XMLReader xr = XMLReaderFactory.createXMLReader();
                xr.setContentHandler(this);
                connection.setRequestMethod("GET");
                connection.connect();
                xr.parse(new InputSource(connection.getInputStream()));
            }
            catch (SAXException e) {
                Exception embedded = e.getException();
                if (embedded != null && embedded instanceof IOException) {
                    throw (IOException)embedded;
                }
                throw new IOException("invalid xml directory content", e);
            }
            finally {
                connection.disconnect();
            }
            return this.filechecksum;
        }
    }

    class LsParser
    extends DefaultHandler {
        ArrayList<FileStatus> fslist = new ArrayList();

        LsParser() {
        }

        @Override
        public void startElement(String ns, String localname, String qname, Attributes attrs) throws SAXException {
            long modif;
            if ("listing".equals(qname)) {
                return;
            }
            if (!"file".equals(qname) && !"directory".equals(qname)) {
                if (RemoteException.class.getSimpleName().equals(qname)) {
                    throw new SAXException(RemoteException.valueOf(attrs));
                }
                throw new SAXException("Unrecognized entry: " + qname);
            }
            long atime = 0L;
            try {
                SimpleDateFormat ldf = df.get();
                modif = ldf.parse(attrs.getValue("modified")).getTime();
                String astr = attrs.getValue("accesstime");
                if (astr != null) {
                    atime = ldf.parse(astr).getTime();
                }
            }
            catch (ParseException e) {
                throw new SAXException(e);
            }
            FileStatus fs = "file".equals(qname) ? new FileStatus(Long.valueOf(attrs.getValue("size")), false, Short.valueOf(attrs.getValue("replication")).shortValue(), Long.valueOf(attrs.getValue("blocksize")), modif, atime, FsPermission.valueOf(attrs.getValue("permission")), attrs.getValue("owner"), attrs.getValue("group"), new Path(HftpFileSystem.this.getUri().toString(), attrs.getValue("path")).makeQualified(HftpFileSystem.this)) : new FileStatus(0L, true, 0, 0L, modif, atime, FsPermission.valueOf(attrs.getValue("permission")), attrs.getValue("owner"), attrs.getValue("group"), new Path(HftpFileSystem.this.getUri().toString(), attrs.getValue("path")).makeQualified(HftpFileSystem.this));
            this.fslist.add(fs);
        }

        private void fetchList(String path, boolean recur) throws IOException {
            try {
                XMLReader xr = XMLReaderFactory.createXMLReader();
                xr.setContentHandler(this);
                HttpURLConnection connection = HftpFileSystem.this.openConnection("/listPaths" + path, "ugi=" + HftpFileSystem.this.getUgiParameter() + (recur ? "&recursive=yes" : ""));
                connection.setRequestMethod("GET");
                connection.connect();
                InputStream resp = connection.getInputStream();
                xr.parse(new InputSource(resp));
            }
            catch (SAXException e) {
                Exception embedded = e.getException();
                if (embedded != null && embedded instanceof IOException) {
                    throw (IOException)embedded;
                }
                throw new IOException("invalid xml directory content", e);
            }
        }

        public FileStatus getFileStatus(Path f) throws IOException {
            this.fetchList(f.toUri().getPath(), false);
            if (this.fslist.size() == 0) {
                throw new FileNotFoundException("File does not exist: " + f);
            }
            return this.fslist.get(0);
        }

        public FileStatus[] listStatus(Path f, boolean recur) throws IOException {
            this.fetchList(f.toUri().getPath(), recur);
            if (this.fslist.size() > 0 && (this.fslist.size() != 1 || this.fslist.get(0).isDir())) {
                this.fslist.remove(0);
            }
            return this.fslist.toArray(new FileStatus[0]);
        }

        public FileStatus[] listStatus(Path f) throws IOException {
            return this.listStatus(f, false);
        }
    }
}

