/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.lib;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.metrics2.MetricsException;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsTag;
import org.apache.hadoop.metrics2.lib.MetricMutable;
import org.apache.hadoop.metrics2.lib.MetricMutableCounterInt;
import org.apache.hadoop.metrics2.lib.MetricMutableCounterLong;
import org.apache.hadoop.metrics2.lib.MetricMutableFactory;
import org.apache.hadoop.metrics2.lib.MetricMutableGaugeInt;
import org.apache.hadoop.metrics2.lib.MetricMutableGaugeLong;
import org.apache.hadoop.metrics2.lib.MetricMutableHistogram;
import org.apache.hadoop.metrics2.lib.MetricMutableQuantiles;
import org.apache.hadoop.metrics2.lib.MetricMutableStat;

public class DynamicMetricsRegistry {
    private final Log LOG = LogFactory.getLog(this.getClass());
    public static final String CONTEXT_KEY = "context";
    public static final String CONTEXT_DESC = "Metrics context";
    private final ConcurrentMap<String, MetricMutable> metricsMap = new ConcurrentHashMap<String, MetricMutable>();
    private final ConcurrentMap<String, MetricsTag> tagsMap = new ConcurrentHashMap<String, MetricsTag>();
    private final String name;
    private final MetricMutableFactory mf;

    public DynamicMetricsRegistry(String name) {
        this.name = name;
        this.mf = new MetricMutableFactory();
    }

    public DynamicMetricsRegistry(String name, MetricMutableFactory factory) {
        this.name = name;
        this.mf = factory;
    }

    public String name() {
        return this.name;
    }

    public MetricMutable get(String name) {
        return (MetricMutable)this.metricsMap.get(name);
    }

    public MetricMutableCounterInt newCounter(String name, String description, int initValue) {
        MetricMutableCounterInt ret = this.mf.newCounter(name, description, initValue);
        return this.addNewMetricIfAbsent(name, ret, MetricMutableCounterInt.class);
    }

    public MetricMutableCounterLong newCounter(String name, String description, long initValue) {
        MetricMutableCounterLong ret = this.mf.newCounter(name, description, initValue);
        return this.addNewMetricIfAbsent(name, ret, MetricMutableCounterLong.class);
    }

    public MetricMutableGaugeInt newGauge(String name, String description, int initValue) {
        MetricMutableGaugeInt ret = this.mf.newGauge(name, description, initValue);
        return this.addNewMetricIfAbsent(name, ret, MetricMutableGaugeInt.class);
    }

    public MetricMutableGaugeLong newGauge(String name, String description, long initValue) {
        MetricMutableGaugeLong ret = this.mf.newGauge(name, description, initValue);
        return this.addNewMetricIfAbsent(name, ret, MetricMutableGaugeLong.class);
    }

    public MetricMutableStat newStat(String name, String description, String sampleName, String valueName, boolean extended) {
        MetricMutableStat ret = this.mf.newStat(name, description, sampleName, valueName, extended);
        return this.addNewMetricIfAbsent(name, ret, MetricMutableStat.class);
    }

    public MetricMutableStat newStat(String name, String description, String sampleName, String valueName) {
        return this.newStat(name, description, sampleName, valueName, false);
    }

    public MetricMutableStat newStat(String name) {
        return this.newStat(name, "", "ops", "time", false);
    }

    public MetricMutableHistogram newHistogram(String name) {
        return this.newHistogram(name, "");
    }

    public MetricMutableHistogram newHistogram(String name, String desc) {
        MetricMutableHistogram histo = new MetricMutableHistogram(name, desc);
        return this.addNewMetricIfAbsent(name, histo, MetricMutableHistogram.class);
    }

    public MetricMutableQuantiles newQuantile(String name) {
        return this.newQuantile(name, "");
    }

    public MetricMutableQuantiles newQuantile(String name, String desc) {
        MetricMutableQuantiles histo = new MetricMutableQuantiles(name, desc);
        return this.addNewMetricIfAbsent(name, histo, MetricMutableQuantiles.class);
    }

    public DynamicMetricsRegistry setContext(String name) {
        return this.tag(CONTEXT_KEY, CONTEXT_DESC, name);
    }

    public DynamicMetricsRegistry tag(String name, String description, String value) {
        return this.tag(name, description, value, false);
    }

    public DynamicMetricsRegistry tag(String name, String description, String value, boolean override) {
        MetricsTag tag = new MetricsTag(name, description, value);
        if (!override) {
            MetricsTag existing = this.tagsMap.putIfAbsent(name, tag);
            if (existing != null) {
                throw new MetricsException("Tag " + name + " already exists!");
            }
            return this;
        }
        this.tagsMap.put(name, tag);
        return this;
    }

    public Set<Map.Entry<String, MetricsTag>> tags() {
        return this.tagsMap.entrySet();
    }

    public Set<Map.Entry<String, MetricMutable>> metrics() {
        return this.metricsMap.entrySet();
    }

    public void snapshot(MetricsRecordBuilder builder, boolean all) {
        for (Map.Entry<String, MetricsTag> entry : this.tags()) {
            builder.add(entry.getValue());
        }
        for (Map.Entry<String, Object> entry : this.metrics()) {
            ((MetricMutable)entry.getValue()).snapshot(builder, all);
        }
    }

    public void removeMetric(String name) {
        this.metricsMap.remove(name);
    }

    public MetricMutableGaugeLong getLongGauge(String gaugeName, long potentialStartingValue) {
        MetricMutableGaugeLong newGauge;
        MetricMutable metric = (MetricMutable)this.metricsMap.get(gaugeName);
        if (metric == null && (metric = this.metricsMap.putIfAbsent(gaugeName, newGauge = this.mf.newGauge(gaugeName, "", potentialStartingValue))) == null) {
            return newGauge;
        }
        if (!(metric instanceof MetricMutableGaugeLong)) {
            throw new MetricsException("Metric already exists in registry for metric name: " + this.name + " and not of type MetricMutableGaugeLong");
        }
        return (MetricMutableGaugeLong)metric;
    }

    public MetricMutableCounterLong getLongCounter(String counterName, long potentialStartingValue) {
        MetricMutableCounterLong newCounter;
        MetricMutable counter = (MetricMutable)this.metricsMap.get(counterName);
        if (counter == null && (counter = this.metricsMap.putIfAbsent(counterName, newCounter = this.mf.newCounter(counterName, "", potentialStartingValue))) == null) {
            return newCounter;
        }
        if (!(counter instanceof MetricMutableCounterLong)) {
            throw new MetricsException("Metric already exists in registry for metric name: " + this.name + "and not of type MetricMutableCounterLong");
        }
        return (MetricMutableCounterLong)counter;
    }

    public MetricMutableHistogram getHistogram(String histoName) {
        MetricMutableHistogram newHisto;
        MetricMutable histo = (MetricMutable)this.metricsMap.get(histoName);
        if (histo == null && (histo = this.metricsMap.putIfAbsent(histoName, newHisto = new MetricMutableHistogram(histoName, ""))) == null) {
            return newHisto;
        }
        if (!(histo instanceof MetricMutableHistogram)) {
            throw new MetricsException("Metric already exists in registry for metric name: " + this.name + "and not of type MetricMutableHistogram");
        }
        return (MetricMutableHistogram)histo;
    }

    public MetricMutableQuantiles getQuantile(String histoName) {
        MetricMutableQuantiles newHisto;
        MetricMutable histo = (MetricMutable)this.metricsMap.get(histoName);
        if (histo == null && (histo = this.metricsMap.putIfAbsent(histoName, newHisto = new MetricMutableQuantiles(histoName, ""))) == null) {
            return newHisto;
        }
        if (!(histo instanceof MetricMutableQuantiles)) {
            throw new MetricsException("Metric already exists in registry for metric name: " + this.name + "and not of type MetricMutableQuantiles");
        }
        return (MetricMutableQuantiles)histo;
    }

    private <T extends MetricMutable> T addNewMetricIfAbsent(String name, T ret, Class<T> metricClass) {
        MetricMutable metric = this.metricsMap.putIfAbsent(name, ret);
        if (metric == null) {
            return ret;
        }
        return (T)((MetricMutable)this.returnExistingWithCast(metric, metricClass, name));
    }

    private <T> T returnExistingWithCast(MetricMutable metric, Class<T> metricClass, String name) {
        if (!metricClass.isAssignableFrom(metric.getClass())) {
            throw new MetricsException("Metric already exists in registry for metric name: " + name + " and not of type " + metricClass);
        }
        return (T)metric;
    }

    public void clearMetrics() {
        this.metricsMap.clear();
    }
}

