/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.lib;

import com.yammer.metrics.stats.ExponentiallyDecayingSample;
import com.yammer.metrics.stats.Sample;
import com.yammer.metrics.stats.Snapshot;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.metrics2.MetricHistogram;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.MetricMutable;

public class MetricMutableHistogram
extends MetricMutable
implements MetricHistogram {
    private static final int DEFAULT_SAMPLE_SIZE = 2046;
    private static final double DEFAULT_ALPHA = 0.015;
    private final Sample sample = new ExponentiallyDecayingSample(2046, 0.015);
    private final AtomicLong min;
    private final AtomicLong max;
    private final AtomicLong sum;
    private final AtomicLong count = new AtomicLong();

    public MetricMutableHistogram(String name, String description) {
        super(name, description);
        this.min = new AtomicLong(Long.MAX_VALUE);
        this.max = new AtomicLong(Long.MIN_VALUE);
        this.sum = new AtomicLong();
    }

    @Override
    public void add(long val) {
        this.setChanged();
        this.count.incrementAndGet();
        this.sample.update(val);
        this.setMax(val);
        this.setMin(val);
        this.sum.getAndAdd(val);
    }

    private void setMax(long potentialMax) {
        boolean done = false;
        while (!done) {
            long currentMax = this.max.get();
            done = currentMax >= potentialMax || this.max.compareAndSet(currentMax, potentialMax);
        }
    }

    private void setMin(long potentialMin) {
        boolean done = false;
        while (!done) {
            long currentMin = this.min.get();
            done = currentMin <= potentialMin || this.min.compareAndSet(currentMin, potentialMin);
        }
    }

    public long getMax() {
        if (this.count.get() > 0L) {
            return this.max.get();
        }
        return 0L;
    }

    public long getMin() {
        if (this.count.get() > 0L) {
            return this.min.get();
        }
        return 0L;
    }

    public double getMean() {
        long cCount = this.count.get();
        if (cCount > 0L) {
            return (double)this.sum.get() / (double)cCount;
        }
        return 0.0;
    }

    @Override
    public void snapshot(MetricsRecordBuilder metricsRecordBuilder, boolean all) {
        if (all || this.changed()) {
            this.clearChanged();
            Snapshot s = this.sample.getSnapshot();
            metricsRecordBuilder.addCounter(this.name + "_num_ops", "", this.count.get());
            metricsRecordBuilder.addGauge(this.name + "_min", "", this.getMin());
            metricsRecordBuilder.addGauge(this.name + "_max", "", this.getMax());
            metricsRecordBuilder.addGauge(this.name + "_mean", "", this.getMean());
            metricsRecordBuilder.addGauge(this.name + "_median", "", s.getMedian());
            metricsRecordBuilder.addGauge(this.name + "_75th_percentile", "", s.get75thPercentile());
            metricsRecordBuilder.addGauge(this.name + "_95th_percentile", "", s.get95thPercentile());
            metricsRecordBuilder.addGauge(this.name + "_99th_percentile", "", s.get99thPercentile());
        }
    }
}

