/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.lib;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.metrics2.MetricHistogram;
import org.apache.hadoop.metrics2.MetricsExecutor;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.lib.MetricMutable;
import org.apache.hadoop.metrics2.lib.MetricsExecutorImpl;
import org.apache.hadoop.metrics2.util.MetricQuantile;
import org.apache.hadoop.metrics2.util.MetricSampleQuantiles;

@InterfaceAudience.Private
public class MetricMutableQuantiles
extends MetricMutable
implements MetricHistogram {
    static final MetricQuantile[] quantiles = new MetricQuantile[]{new MetricQuantile(0.5, 0.05), new MetricQuantile(0.75, 0.025), new MetricQuantile(0.9, 0.01), new MetricQuantile(0.95, 0.005), new MetricQuantile(0.99, 0.001)};
    static final String[] quantilesSuffix = new String[]{"_Median", "_75th_percentile", "_90th_percentile", "_95th_percentile", "_99th_percentile"};
    private final int interval;
    private MetricSampleQuantiles estimator = new MetricSampleQuantiles(quantiles);
    private long previousCount = 0L;
    private MetricsExecutor executor = new MetricsExecutorImpl();
    protected Map<MetricQuantile, Long> previousSnapshot = null;

    public MetricMutableQuantiles(String name, String description, String sampleName, String valueName, int interval) {
        super(name, description);
        this.interval = interval;
        this.executor.getExecutor().scheduleAtFixedRate(new RolloverSample(this), interval, interval, TimeUnit.SECONDS);
    }

    public MetricMutableQuantiles(String name, String description) {
        this(name, description, "Ops", "", 60);
    }

    @Override
    public synchronized void snapshot(MetricsRecordBuilder builder, boolean all) {
        if (all || this.changed()) {
            builder.addCounter(this.name + "NumOps", this.description, this.previousCount);
            for (int i = 0; i < quantiles.length; ++i) {
                long newValue = 0L;
                if (this.previousSnapshot != null) {
                    newValue = this.previousSnapshot.get(quantiles[i]);
                }
                builder.addGauge(this.name + quantilesSuffix[i], this.description, newValue);
            }
            if (this.changed()) {
                this.clearChanged();
            }
        }
    }

    @Override
    public synchronized void add(long value) {
        this.estimator.insert(value);
    }

    public int getInterval() {
        return this.interval;
    }

    private static class RolloverSample
    implements Runnable {
        MetricMutableQuantiles parent;

        public RolloverSample(MetricMutableQuantiles parent) {
            this.parent = parent;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            MetricMutableQuantiles metricMutableQuantiles = this.parent;
            synchronized (metricMutableQuantiles) {
                try {
                    this.parent.previousCount = this.parent.estimator.getCount();
                    this.parent.previousSnapshot = this.parent.estimator.snapshot();
                }
                catch (IOException e) {
                    this.parent.previousCount = 0L;
                    this.parent.previousSnapshot = null;
                }
                this.parent.estimator.clear();
            }
            this.parent.setChanged();
        }
    }
}

