/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.Weigher;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.cache.TenantCache;
import org.apache.phoenix.cache.TenantCacheImpl;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.memory.ChildMemoryManager;
import org.apache.phoenix.memory.GlobalMemoryManager;
import org.apache.phoenix.schema.PTable;

public class GlobalCache
extends TenantCacheImpl {
    private static GlobalCache INSTANCE;
    private final Configuration config;
    private final ConcurrentMap<ImmutableBytesWritable, TenantCache> perTenantCacheMap = new ConcurrentHashMap<ImmutableBytesWritable, TenantCache>();
    private Cache<ImmutableBytesPtr, PTable> metaDataCache;

    public void clearTenantCache() {
        this.perTenantCacheMap.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Cache<ImmutableBytesPtr, PTable> getMetaDataCache() {
        Cache<ImmutableBytesPtr, PTable> result = this.metaDataCache;
        if (result == null) {
            GlobalCache globalCache = this;
            synchronized (globalCache) {
                result = this.metaDataCache;
                if (result == null) {
                    long maxSize = this.config.getLong("phoenix.coprocessor.maxMetaDataCacheSize", 0x1400000L);
                    long maxTTL = this.config.getLong("phoenix.coprocessor.maxMetaDataCacheTimeToLiveMs", 1800000L);
                    this.metaDataCache = result = CacheBuilder.newBuilder().maximumWeight(maxSize).expireAfterAccess(maxTTL, TimeUnit.MILLISECONDS).weigher(new Weigher<ImmutableBytesPtr, PTable>(){

                        @Override
                        public int weigh(ImmutableBytesPtr key, PTable table) {
                            return 52 + key.getLength() + table.getEstimatedSize();
                        }
                    }).build();
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GlobalCache getInstance(RegionCoprocessorEnvironment env) {
        GlobalCache result = INSTANCE;
        if (result != null) return result;
        Class<GlobalCache> clazz = GlobalCache.class;
        synchronized (GlobalCache.class) {
            result = INSTANCE;
            if (result != null) return result;
            INSTANCE = result = new GlobalCache(env.getConfiguration());
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return result;
        }
    }

    public static TenantCache getTenantCache(RegionCoprocessorEnvironment env, ImmutableBytesWritable tenantId) {
        GlobalCache globalCache = GlobalCache.getInstance(env);
        GlobalCache tenantCache = tenantId == null ? globalCache : globalCache.getChildTenantCache(tenantId);
        return tenantCache;
    }

    private static long getMaxMemorySize(Configuration config) {
        long maxSize = Runtime.getRuntime().maxMemory() * (long)config.getInt("phoenix.query.maxGlobalMemoryPercentage", 15) / 100L;
        maxSize = Math.min(maxSize, config.getLong("phoenix.query.maxGlobalMemorySize", Long.MAX_VALUE));
        return maxSize;
    }

    private GlobalCache(Configuration config) {
        super(new GlobalMemoryManager(GlobalCache.getMaxMemorySize(config), config.getInt("phoenix.query.maxGlobalMemoryWaitMs", 10000)), config.getInt("phoenix.coprocessor.maxServerCacheTimeToLiveMs", 30000));
        this.config = config;
    }

    public Configuration getConfig() {
        return this.config;
    }

    public TenantCache getChildTenantCache(ImmutableBytesWritable tenantId) {
        TenantCache tenantCache = (TenantCache)this.perTenantCacheMap.get(tenantId);
        if (tenantCache == null) {
            int maxTenantMemoryPerc = this.config.getInt("phoenix.query.maxTenantMemoryPercentage", 100);
            int maxServerCacheTimeToLive = this.config.getInt("phoenix.coprocessor.maxServerCacheTimeToLiveMs", 30000);
            TenantCacheImpl newTenantCache = new TenantCacheImpl(new ChildMemoryManager(this.getMemoryManager(), maxTenantMemoryPerc), maxServerCacheTimeToLive);
            tenantCache = this.perTenantCacheMap.putIfAbsent(tenantId, newTenantCache);
            if (tenantCache == null) {
                tenantCache = newTenantCache;
            }
        }
        return tenantCache;
    }
}

