/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.cache.aggcache;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.hash.BloomFilter;
import com.google.common.hash.Funnels;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.MappedByteBuffer;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.phoenix.cache.aggcache.SpillFile;
import org.apache.phoenix.cache.aggcache.SpillManager;
import org.apache.phoenix.cache.aggcache.SpillableGroupByCache;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;

public class SpillMap
extends AbstractMap<ImmutableBytesPtr, byte[]>
implements Iterable<byte[]> {
    private final int thresholdBytes;
    private final int pageInserts;
    private int globalDepth;
    private int curMapBufferIndex;
    private SpillFile spillFile;
    private MappedByteBufferMap[] directory;
    private final SpillableGroupByCache.QueryCache cache;

    public SpillMap(SpillFile file, int thresholdBytes, int estValueSize, SpillableGroupByCache.QueryCache cache) throws IOException {
        this.thresholdBytes = thresholdBytes - 4;
        this.pageInserts = thresholdBytes / estValueSize;
        this.spillFile = file;
        this.cache = cache;
        this.globalDepth = 1;
        this.directory = new MappedByteBufferMap[1 << this.globalDepth];
        for (int i = 0; i < this.directory.length; ++i) {
            this.directory[i] = new MappedByteBufferMap(i, this.thresholdBytes, this.pageInserts, file);
            this.directory[i].flushBuffer();
        }
        this.directory[0].pageIn();
        this.curMapBufferIndex = 0;
    }

    private int getBucketIndex(ImmutableBytesPtr key) {
        int hashCode = key.hashCode();
        return hashCode & (1 << this.globalDepth) - 1;
    }

    private void redistribute(int index, ImmutableBytesPtr keyNew, byte[] valueNew) {
        MappedByteBufferMap byteMap = this.directory[index];
        int mappedIdx = byteMap.pageIndex;
        int localDepth = byteMap.localDepth;
        ArrayList<Integer> buckets = Lists.newArrayList();
        for (int i = 0; i < this.directory.length; ++i) {
            if (this.directory[i].pageIndex != mappedIdx) continue;
            buckets.add(i);
        }
        int tmpIndex = index ^ 1 << localDepth;
        int b1Index = Math.min(index, tmpIndex);
        int b2Index = Math.max(index, tmpIndex);
        MappedByteBufferMap b1 = new MappedByteBufferMap(b1Index, this.thresholdBytes, this.pageInserts, this.spillFile);
        MappedByteBufferMap b2 = new MappedByteBufferMap(b2Index, this.thresholdBytes, this.pageInserts, this.spillFile);
        for (Map.Entry<ImmutableBytesPtr, byte[]> element : byteMap.pageMap.entrySet()) {
            ImmutableBytesPtr key = element.getKey();
            byte[] value = element.getValue();
            if (this.cache.isKeyContained(key)) continue;
            if ((key.hashCode() & 1 << localDepth) != 0) {
                b2.addElement(null, key, value);
                continue;
            }
            b1.addElement(null, key, value);
        }
        byteMap.pageMap.clear();
        byteMap = null;
        b1.localDepth = localDepth + 1;
        b2.localDepth = localDepth + 1;
        boolean doubleDir = false;
        if (this.globalDepth < localDepth + 1) {
            doubleDir = true;
            b2Index = this.doubleDirectory(b2Index, keyNew);
        }
        if (!doubleDir) {
            for (int i = 0; i < buckets.size(); ++i) {
                this.directory[((Integer)buckets.get((int)i)).intValue()] = ((Integer)buckets.get(i) & 1 << localDepth) != 0 ? b2 : b1;
            }
        } else {
            this.directory[b1Index] = b1;
            this.directory[b2Index] = b2;
        }
    }

    private int doubleDirectory(int b2Index, ImmutableBytesPtr keyNew) {
        int newDirSize = 1 << this.globalDepth + 1;
        Preconditions.checkArgument(newDirSize < Integer.MAX_VALUE);
        MappedByteBufferMap[] newDirectory = new MappedByteBufferMap[newDirSize];
        for (int i = 0; i < this.directory.length; ++i) {
            newDirectory[i] = this.directory[i];
            newDirectory[i + this.directory.length] = this.directory[i];
        }
        this.directory = newDirectory;
        newDirectory = null;
        b2Index = keyNew.hashCode() & (1 << this.globalDepth) - 1 | 1 << this.globalDepth;
        ++this.globalDepth;
        return b2Index;
    }

    @Override
    public byte[] get(Object key) {
        if (!(key instanceof ImmutableBytesPtr)) {
            // empty if block
        }
        ImmutableBytesPtr ikey = (ImmutableBytesPtr)key;
        byte[] value = null;
        int bucketIndex = this.getBucketIndex(ikey);
        MappedByteBufferMap byteMap = this.directory[bucketIndex];
        if (this.directory[this.curMapBufferIndex].pageIndex != byteMap.pageIndex) {
            MappedByteBufferMap curByteMap = this.directory[this.curMapBufferIndex];
            if (byteMap.containsKey(ikey.copyBytesIfNecessary())) {
                curByteMap.flushBuffer();
                byteMap.pageIn();
                this.curMapBufferIndex = bucketIndex;
            }
        }
        value = byteMap.getPagedInElement(ikey);
        return value;
    }

    private byte[] getAlways(ImmutableBytesPtr key) {
        byte[] value = null;
        int bucketIndex = this.getBucketIndex(key);
        MappedByteBufferMap byteMap = this.directory[bucketIndex];
        if (this.directory[this.curMapBufferIndex].pageIndex != byteMap.pageIndex) {
            MappedByteBufferMap curByteMap = this.directory[this.curMapBufferIndex];
            curByteMap.flushBuffer();
            byteMap.pageIn();
            this.curMapBufferIndex = bucketIndex;
        }
        value = byteMap.getPagedInElement(key);
        return value;
    }

    @Override
    public byte[] put(ImmutableBytesPtr key, byte[] value) {
        boolean redistributed = false;
        byte[] spilledValue = this.getAlways(key);
        MappedByteBufferMap byteMap = this.directory[this.curMapBufferIndex];
        int index = this.curMapBufferIndex;
        while (!byteMap.canFit(spilledValue, value)) {
            this.redistribute(index, key, value);
            redistributed = true;
            index = this.getBucketIndex(key);
            byteMap = this.directory[index];
        }
        if (redistributed) {
            for (int i = 0; i < this.directory.length; ++i) {
                if (this.directory[i].pageIndex == byteMap.pageIndex) continue;
                this.directory[i].flushBuffer();
            }
            spilledValue = this.getAlways(key);
        }
        byteMap.addElement(spilledValue, key, value);
        return value;
    }

    public SpillFile getSpillFile() {
        return this.spillFile;
    }

    @Override
    public Iterator<byte[]> iterator() {
        this.directory[this.curMapBufferIndex].flushBuffer();
        return new Iterator<byte[]>(){
            int pageIndex = 0;
            Iterator<byte[]> entriesIter = SpillMap.access$600(SpillMap.this)[this.pageIndex].getPageMapEntries();
            HashSet<Integer> dups = new HashSet();

            @Override
            public boolean hasNext() {
                if (!this.entriesIter.hasNext()) {
                    boolean found = false;
                    while (!found) {
                        ++this.pageIndex;
                        if (this.pageIndex >= SpillMap.this.directory.length) {
                            return false;
                        }
                        ((SpillMap)SpillMap.this).directory[this.pageIndex - 1].pageMap.clear();
                        if (this.dups.contains(SpillMap.this.directory[this.pageIndex].pageIndex)) continue;
                        this.dups.add(SpillMap.this.directory[this.pageIndex].pageIndex);
                        this.entriesIter = SpillMap.this.directory[this.pageIndex].getPageMapEntries();
                        if (!this.entriesIter.hasNext()) continue;
                        found = true;
                    }
                }
                this.dups.add(SpillMap.this.directory[this.pageIndex].pageIndex);
                return true;
            }

            @Override
            public byte[] next() {
                return this.entriesIter.next();
            }

            @Override
            public void remove() {
                throw new IllegalAccessError("Iterator does not support removal operation");
            }
        };
    }

    @Override
    public Set<Map.Entry<ImmutableBytesPtr, byte[]>> entrySet() {
        throw new IllegalAccessError("entrySet is not supported for this type of cache");
    }

    private static class MappedByteBufferMap {
        private SpillFile spillFile;
        private int pageIndex;
        private final int thresholdBytes;
        private long totalResultSize;
        private boolean pagedIn;
        private int localDepth;
        private boolean dirtyPage;
        Map<ImmutableBytesPtr, byte[]> pageMap = Maps.newHashMap();
        BloomFilter<byte[]> bFilter;

        public MappedByteBufferMap(int id, int thresholdBytes, int pageInserts, SpillFile spillFile) {
            this.spillFile = spillFile;
            this.thresholdBytes = thresholdBytes;
            this.pageIndex = id;
            this.pageMap.clear();
            this.bFilter = BloomFilter.create(Funnels.byteArrayFunnel(), pageInserts);
            this.pagedIn = true;
            this.totalResultSize = 0L;
            this.localDepth = 1;
            this.dirtyPage = true;
        }

        private boolean containsKey(byte[] key) {
            return this.bFilter.mightContain(key);
        }

        private boolean canFit(byte[] curValue, byte[] newValue) {
            if (this.thresholdBytes < newValue.length) {
                throw new RuntimeException("page size too small to store a single KV element");
            }
            int resultSize = newValue.length + 4;
            if (curValue != null) {
                resultSize = Math.max(0, resultSize - (curValue.length + 4));
            }
            return (long)this.thresholdBytes - this.totalResultSize > (long)resultSize;
        }

        private void flushBuffer() throws BufferOverflowException {
            if (this.pagedIn) {
                MappedByteBuffer buffer;
                if (this.dirtyPage) {
                    Collection<byte[]> values = this.pageMap.values();
                    buffer = this.spillFile.getPage(this.pageIndex);
                    buffer.clear();
                    buffer.putInt(values.size());
                    for (byte[] value : values) {
                        buffer.putInt(value.length);
                        buffer.put(value, 0, value.length);
                    }
                }
                buffer = null;
                this.pageMap.clear();
                this.totalResultSize = 0L;
            }
            this.pagedIn = false;
            this.dirtyPage = false;
        }

        private void pageIn() throws IndexOutOfBoundsException {
            if (!this.pagedIn) {
                MappedByteBuffer buffer = this.spillFile.getPage(this.pageIndex);
                int numElements = buffer.getInt();
                for (int i = 0; i < numElements; ++i) {
                    int kvSize = buffer.getInt();
                    byte[] data = new byte[kvSize];
                    buffer.get(data, 0, kvSize);
                    try {
                        this.pageMap.put(SpillManager.getKey(data), data);
                        this.totalResultSize += (long)(data.length + 4);
                        continue;
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException(ioe);
                    }
                }
                this.pagedIn = true;
                this.dirtyPage = false;
            }
        }

        public byte[] getPagedInElement(ImmutableBytesPtr key) {
            return this.pageMap.get(key);
        }

        public void addElement(byte[] spilledValue, ImmutableBytesPtr key, byte[] value) {
            this.pageMap.put(key, value);
            this.bFilter.put(key.copyBytesIfNecessary());
            this.totalResultSize = spilledValue != null ? (this.totalResultSize += (long)Math.max(0, value.length - spilledValue.length)) : (this.totalResultSize += (long)(value.length + 4));
            this.dirtyPage = true;
        }

        public Iterator<byte[]> getPageMapEntries() {
            this.pageIn();
            return this.pageMap.values().iterator();
        }
    }
}

