/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.util.Collections;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.ExpressionCompiler;
import org.apache.phoenix.compile.MutationPlan;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.parse.BindParseNode;
import org.apache.phoenix.parse.CreateSequenceStatement;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.schema.MetaDataClient;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.SortOrder;

public class CreateSequenceCompiler {
    private final PhoenixStatement statement;
    private static final PDatum LONG_DATUM = new LongDatum();
    private static final PDatum INTEGER_DATUM = new IntegerDatum();

    public CreateSequenceCompiler(PhoenixStatement statement) {
        this.statement = statement;
    }

    public MutationPlan compile(final CreateSequenceStatement sequence) throws SQLException {
        ParseNode startsWithNode = sequence.getStartWith();
        ParseNode incrementByNode = sequence.getIncrementBy();
        if (!startsWithNode.isStateless()) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.STARTS_WITH_MUST_BE_CONSTANT).setSchemaName(sequence.getSequenceName().getSchemaName()).setTableName(sequence.getSequenceName().getTableName()).build().buildException();
        }
        if (!incrementByNode.isStateless()) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.INCREMENT_BY_MUST_BE_CONSTANT).setSchemaName(sequence.getSequenceName().getSchemaName()).setTableName(sequence.getSequenceName().getTableName()).build().buildException();
        }
        ParseNode cacheNode = sequence.getCacheSize();
        if (cacheNode != null && !cacheNode.isStateless()) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CACHE_MUST_BE_NON_NEGATIVE_CONSTANT).setSchemaName(sequence.getSequenceName().getSchemaName()).setTableName(sequence.getSequenceName().getTableName()).build().buildException();
        }
        final PhoenixConnection connection = this.statement.getConnection();
        final StatementContext context = new StatementContext(this.statement);
        if (startsWithNode instanceof BindParseNode) {
            context.getBindManager().addParamMetaData((BindParseNode)startsWithNode, LONG_DATUM);
        }
        if (incrementByNode instanceof BindParseNode) {
            context.getBindManager().addParamMetaData((BindParseNode)incrementByNode, LONG_DATUM);
        }
        if (cacheNode instanceof BindParseNode) {
            context.getBindManager().addParamMetaData((BindParseNode)cacheNode, INTEGER_DATUM);
        }
        ExpressionCompiler expressionCompiler = new ExpressionCompiler(context);
        Expression startsWithExpr = startsWithNode.accept(expressionCompiler);
        ImmutableBytesWritable ptr = context.getTempPtr();
        startsWithExpr.evaluate(null, ptr);
        if (ptr.getLength() == 0 || !startsWithExpr.getDataType().isCoercibleTo(PDataType.LONG)) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.STARTS_WITH_MUST_BE_CONSTANT).setSchemaName(sequence.getSequenceName().getSchemaName()).setTableName(sequence.getSequenceName().getTableName()).build().buildException();
        }
        final long startsWith = (Long)PDataType.LONG.toObject(ptr, startsWithExpr.getDataType());
        Expression incrementByExpr = incrementByNode.accept(expressionCompiler);
        incrementByExpr.evaluate(null, ptr);
        if (ptr.getLength() == 0 || !incrementByExpr.getDataType().isCoercibleTo(PDataType.LONG)) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.INCREMENT_BY_MUST_BE_CONSTANT).setSchemaName(sequence.getSequenceName().getSchemaName()).setTableName(sequence.getSequenceName().getTableName()).build().buildException();
        }
        final long incrementBy = (Long)PDataType.LONG.toObject(ptr, incrementByExpr.getDataType());
        long cacheSizeValue = connection.getQueryServices().getProps().getLong("phoenix.sequence.cacheSize", 100L);
        if (cacheNode != null) {
            Expression cacheSizeExpr = cacheNode.accept(expressionCompiler);
            cacheSizeExpr.evaluate(null, ptr);
            if (!(ptr.getLength() == 0 || cacheSizeExpr.getDataType().isCoercibleTo(PDataType.LONG) && (cacheSizeValue = ((Long)PDataType.LONG.toObject(ptr, cacheSizeExpr.getDataType())).longValue()) >= 0L)) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.CACHE_MUST_BE_NON_NEGATIVE_CONSTANT).setSchemaName(sequence.getSequenceName().getSchemaName()).setTableName(sequence.getSequenceName().getTableName()).build().buildException();
            }
        }
        final long cacheSize = Math.max(1L, cacheSizeValue);
        final MetaDataClient client = new MetaDataClient(connection);
        return new MutationPlan(){

            @Override
            public MutationState execute() throws SQLException {
                return client.createSequence(sequence, startsWith, incrementBy, cacheSize);
            }

            @Override
            public ExplainPlan getExplainPlan() throws SQLException {
                return new ExplainPlan(Collections.singletonList("CREATE SEQUENCE"));
            }

            @Override
            public PhoenixConnection getConnection() {
                return connection;
            }

            @Override
            public ParameterMetaData getParameterMetaData() {
                return context.getBindManager().getParameterMetaData();
            }

            @Override
            public StatementContext getContext() {
                return context;
            }
        };
    }

    private static class IntegerDatum
    implements PDatum {
        private IntegerDatum() {
        }

        @Override
        public boolean isNullable() {
            return false;
        }

        @Override
        public PDataType getDataType() {
            return PDataType.INTEGER;
        }

        @Override
        public Integer getMaxLength() {
            return null;
        }

        @Override
        public Integer getScale() {
            return null;
        }

        @Override
        public SortOrder getSortOrder() {
            return SortOrder.getDefault();
        }
    }

    private static class LongDatum
    implements PDatum {
        private LongDatum() {
        }

        @Override
        public boolean isNullable() {
            return false;
        }

        @Override
        public PDataType getDataType() {
            return PDataType.LONG;
        }

        @Override
        public Integer getMaxLength() {
            return null;
        }

        @Override
        public Integer getScale() {
            return null;
        }

        @Override
        public SortOrder getSortOrder() {
            return SortOrder.getDefault();
        }
    }
}

