/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.FilterList;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.cache.ServerCacheClient;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.FromCompiler;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.MutatingParallelIteratorFactory;
import org.apache.phoenix.compile.MutationPlan;
import org.apache.phoenix.compile.OrderByCompiler;
import org.apache.phoenix.compile.ProjectionCompiler;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.compile.StatementNormalizer;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.execute.AggregatePlan;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.index.IndexMetaDataCacheClient;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixResultSet;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.optimize.QueryOptimizer;
import org.apache.phoenix.parse.AliasedNode;
import org.apache.phoenix.parse.DeleteStatement;
import org.apache.phoenix.parse.FilterableStatement;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.ParseNodeFactory;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.PRow;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.ReadOnlyTableException;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.MetaDataUtil;

public class DeleteCompiler {
    private static ParseNodeFactory FACTORY = new ParseNodeFactory();
    private final PhoenixStatement statement;

    public DeleteCompiler(PhoenixStatement statement) {
        this.statement = statement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MutationState deleteRows(PhoenixStatement statement, TableRef tableRef, ResultIterator iterator, RowProjector projector) throws SQLException {
        PhoenixConnection connection = statement.getConnection();
        byte[] tenantId = connection.getTenantId() == null ? null : connection.getTenantId().getBytes();
        boolean isAutoCommit = connection.getAutoCommit();
        ConnectionQueryServices services = connection.getQueryServices();
        int maxSize = services.getProps().getInt("phoenix.mutate.maxSize", 500000);
        int batchSize = Math.min(connection.getMutateBatchSize(), maxSize);
        HashMap<ImmutableBytesPtr, Map<PColumn, byte[]>> mutations = Maps.newHashMapWithExpectedSize(batchSize);
        try {
            PTable table = tableRef.getTable();
            List<PColumn> pkColumns = table.getPKColumns();
            boolean isMultiTenant = table.isMultiTenant() && tenantId != null;
            boolean isSharedViewIndex = table.getViewIndexId() != null;
            int offset = table.getBucketNum() == null ? 0 : 1;
            byte[][] values = new byte[pkColumns.size()][];
            if (isMultiTenant) {
                values[offset++] = tenantId;
            }
            if (isSharedViewIndex) {
                values[offset++] = MetaDataUtil.getViewIndexIdDataType().toBytes(table.getViewIndexId());
            }
            PhoenixResultSet rs = new PhoenixResultSet(iterator, projector, statement);
            int rowCount = 0;
            while (rs.next()) {
                for (int i = offset; i < values.length; ++i) {
                    byte[] byteValue = rs.getBytes(i + 1 - offset);
                    if (pkColumns.get(i).getSortOrder() == SortOrder.DESC) {
                        byte[] tempByteValue = Arrays.copyOf(byteValue, byteValue.length);
                        byteValue = SortOrder.invert(byteValue, 0, tempByteValue, 0, byteValue.length);
                    }
                    values[i] = byteValue;
                }
                ImmutableBytesPtr ptr = new ImmutableBytesPtr();
                table.newKey(ptr, values);
                mutations.put(ptr, PRow.DELETE_MARKER);
                if (mutations.size() > maxSize) {
                    throw new IllegalArgumentException("MutationState size of " + mutations.size() + " is bigger than max allowed size of " + maxSize);
                }
                if (!isAutoCommit || ++rowCount % batchSize != 0) continue;
                MutationState state = new MutationState(tableRef, mutations, 0L, maxSize, connection);
                connection.getMutationState().join(state);
                connection.commit();
                mutations.clear();
            }
            MutationState mutationState = new MutationState(tableRef, mutations, rowCount / batchSize * batchSize, maxSize, connection);
            return mutationState;
        }
        finally {
            iterator.close();
        }
    }

    private boolean hasImmutableIndex(TableRef tableRef) {
        return tableRef.getTable().isImmutableRows() && !tableRef.getTable().getIndexes().isEmpty();
    }

    private boolean hasImmutableIndexWithKeyValueColumns(TableRef tableRef) {
        if (!this.hasImmutableIndex(tableRef)) {
            return false;
        }
        for (PTable index : tableRef.getTable().getIndexes()) {
            for (PColumn column : index.getPKColumns()) {
                if (IndexUtil.isDataPKColumn(column)) continue;
                return true;
            }
        }
        return false;
    }

    public MutationPlan compile(DeleteStatement delete) throws SQLException {
        final PhoenixConnection connection = this.statement.getConnection();
        boolean isAutoCommit = connection.getAutoCommit();
        ConnectionQueryServices services = connection.getQueryServices();
        ColumnResolver resolver = FromCompiler.getResolverForMutation(delete, connection);
        final TableRef tableRef = resolver.getTables().get(0);
        PTable table = tableRef.getTable();
        if (table.getType() == PTableType.VIEW && table.getViewType().isReadOnly()) {
            throw new ReadOnlyTableException(table.getSchemaName().getString(), table.getTableName().getString());
        }
        final boolean hasLimit = delete.getLimit() != null;
        boolean noQueryReqd = !hasLimit && !this.hasImmutableIndex(tableRef);
        boolean runOnServer = isAutoCommit && noQueryReqd;
        HintNode hint = delete.getHint();
        if (runOnServer && !delete.getHint().hasHint(HintNode.Hint.USE_INDEX_OVER_DATA_TABLE)) {
            hint = HintNode.create(hint, HintNode.Hint.USE_DATA_OVER_INDEX_TABLE);
        }
        ArrayList<AliasedNode> aliasedNodes = Lists.newArrayListWithExpectedSize(table.getPKColumns().size());
        boolean isSalted = table.getBucketNum() != null;
        boolean isMultiTenant = connection.getTenantId() != null && table.isMultiTenant();
        boolean isSharedViewIndex = table.getViewIndexId() != null;
        for (int i = (isSalted ? 1 : 0) + (isMultiTenant ? 1 : 0) + (isSharedViewIndex ? 1 : 0); i < table.getPKColumns().size(); ++i) {
            PColumn column = table.getPKColumns().get(i);
            aliasedNodes.add(FACTORY.aliasedNode(null, FACTORY.column(null, '\"' + column.getName().getString() + '\"', null)));
        }
        SelectStatement select = FACTORY.select(Collections.singletonList(delete.getTable()), hint, false, aliasedNodes, delete.getWhere(), Collections.<ParseNode>emptyList(), null, delete.getOrderBy(), delete.getLimit(), delete.getBindCount(), false);
        select = StatementNormalizer.normalize(select, resolver);
        DeletingParallelIteratorFactory parallelIteratorFactory = hasLimit ? null : new DeletingParallelIteratorFactory(connection, tableRef);
        final QueryPlan plan = new QueryOptimizer(services).optimize(this.statement, select, resolver, Collections.emptyList(), parallelIteratorFactory);
        if (!plan.getTableRef().equals(tableRef)) {
            runOnServer = false;
            noQueryReqd = false;
        }
        final int maxSize = services.getProps().getInt("phoenix.mutate.maxSize", 500000);
        if (this.hasImmutableIndexWithKeyValueColumns(tableRef)) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.NO_DELETE_IF_IMMUTABLE_INDEX).setSchemaName(tableRef.getTable().getSchemaName().getString()).setTableName(tableRef.getTable().getTableName().getString()).build().buildException();
        }
        final StatementContext context = plan.getContext();
        if (noQueryReqd && !(context.getScan().getFilter() instanceof FilterList) && context.getScanRanges().isPointLookup()) {
            return new MutationPlan(){

                @Override
                public ParameterMetaData getParameterMetaData() {
                    return context.getBindManager().getParameterMetaData();
                }

                @Override
                public MutationState execute() {
                    ScanRanges ranges = context.getScanRanges();
                    Iterator<KeyRange> iterator = ranges.getPointLookupKeyIterator();
                    HashMap<ImmutableBytesPtr, Map<PColumn, byte[]>> mutation = Maps.newHashMapWithExpectedSize(ranges.getPointLookupCount());
                    while (iterator.hasNext()) {
                        mutation.put(new ImmutableBytesPtr(iterator.next().getLowerRange()), PRow.DELETE_MARKER);
                    }
                    return new MutationState(tableRef, mutation, 0L, maxSize, connection);
                }

                @Override
                public ExplainPlan getExplainPlan() throws SQLException {
                    return new ExplainPlan(Collections.singletonList("DELETE SINGLE ROW"));
                }

                @Override
                public PhoenixConnection getConnection() {
                    return connection;
                }

                @Override
                public StatementContext getContext() {
                    return context;
                }
            };
        }
        if (runOnServer) {
            Scan scan = context.getScan();
            scan.setAttribute("_DeleteAgg", QueryConstants.TRUE);
            SelectStatement aggSelect = SelectStatement.create(SelectStatement.COUNT_ONE, delete.getHint());
            final RowProjector projector = ProjectionCompiler.compile(context, aggSelect, GroupByCompiler.GroupBy.EMPTY_GROUP_BY);
            final AggregatePlan aggPlan = new AggregatePlan(context, (FilterableStatement)select, tableRef, projector, null, OrderByCompiler.OrderBy.EMPTY_ORDER_BY, null, GroupByCompiler.GroupBy.EMPTY_GROUP_BY, null);
            return new MutationPlan(){

                @Override
                public PhoenixConnection getConnection() {
                    return connection;
                }

                @Override
                public ParameterMetaData getParameterMetaData() {
                    return context.getBindManager().getParameterMetaData();
                }

                @Override
                public StatementContext getContext() {
                    return context;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public MutationState execute() throws SQLException {
                    ImmutableBytesWritable ptr = context.getTempPtr();
                    tableRef.getTable().getIndexMaintainers(ptr);
                    ServerCacheClient.ServerCache cache = null;
                    try {
                        MutationState mutationState;
                        if (ptr.getLength() > 0) {
                            IndexMetaDataCacheClient client = new IndexMetaDataCacheClient(connection, tableRef);
                            cache = client.addIndexMetadataCache(context.getScanRanges(), ptr);
                            byte[] uuidValue = cache.getId();
                            context.getScan().setAttribute("IdxUUID", uuidValue);
                        }
                        ResultIterator iterator = aggPlan.iterator();
                        try {
                            Tuple row = iterator.next();
                            final long mutationCount = (Long)projector.getColumnProjector(0).getValue(row, PDataType.LONG, ptr);
                            mutationState = new MutationState(maxSize, connection){

                                @Override
                                public long getUpdateCount() {
                                    return mutationCount;
                                }
                            };
                        }
                        catch (Throwable throwable) {
                            iterator.close();
                            throw throwable;
                        }
                        iterator.close();
                        return mutationState;
                    }
                    finally {
                        if (cache != null) {
                            cache.close();
                        }
                    }
                }

                @Override
                public ExplainPlan getExplainPlan() throws SQLException {
                    List<String> queryPlanSteps = aggPlan.getExplainPlan().getPlanSteps();
                    ArrayList<String> planSteps = Lists.newArrayListWithExpectedSize(queryPlanSteps.size() + 1);
                    planSteps.add("DELETE ROWS");
                    planSteps.addAll(queryPlanSteps);
                    return new ExplainPlan(planSteps);
                }
            };
        }
        if (parallelIteratorFactory != null) {
            parallelIteratorFactory.setRowProjector(plan.getProjector());
        }
        return new MutationPlan(){

            @Override
            public PhoenixConnection getConnection() {
                return connection;
            }

            @Override
            public ParameterMetaData getParameterMetaData() {
                return context.getBindManager().getParameterMetaData();
            }

            @Override
            public StatementContext getContext() {
                return context;
            }

            @Override
            public MutationState execute() throws SQLException {
                ResultIterator iterator = plan.iterator();
                if (!hasLimit) {
                    Tuple tuple;
                    long totalRowCount = 0L;
                    while ((tuple = iterator.next()) != null) {
                        Cell kv = tuple.getValue(0);
                        totalRowCount += PDataType.LONG.getCodec().decodeLong(kv.getValueArray(), kv.getValueOffset(), SortOrder.getDefault());
                    }
                    return new MutationState(maxSize, connection, totalRowCount);
                }
                return DeleteCompiler.deleteRows(DeleteCompiler.this.statement, tableRef, iterator, plan.getProjector());
            }

            @Override
            public ExplainPlan getExplainPlan() throws SQLException {
                List<String> queryPlanSteps = plan.getExplainPlan().getPlanSteps();
                ArrayList<String> planSteps = Lists.newArrayListWithExpectedSize(queryPlanSteps.size() + 1);
                planSteps.add("DELETE ROWS");
                planSteps.addAll(queryPlanSteps);
                return new ExplainPlan(planSteps);
            }
        };
    }

    private static class DeletingParallelIteratorFactory
    extends MutatingParallelIteratorFactory {
        private RowProjector projector;

        private DeletingParallelIteratorFactory(PhoenixConnection connection, TableRef tableRef) {
            super(connection, tableRef);
        }

        @Override
        protected MutationState mutate(StatementContext context, ResultIterator iterator, PhoenixConnection connection) throws SQLException {
            PhoenixStatement statement = new PhoenixStatement(connection);
            return DeleteCompiler.deleteRows(statement, this.tableRef, iterator, this.projector);
        }

        public void setRowProjector(RowProjector projector) {
            this.projector = projector;
        }
    }
}

