/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.expression.AndExpression;
import org.apache.phoenix.expression.ArrayConstructorExpression;
import org.apache.phoenix.expression.BaseExpression;
import org.apache.phoenix.expression.CaseExpression;
import org.apache.phoenix.expression.CoerceExpression;
import org.apache.phoenix.expression.ColumnExpression;
import org.apache.phoenix.expression.ComparisonExpression;
import org.apache.phoenix.expression.DateAddExpression;
import org.apache.phoenix.expression.DateSubtractExpression;
import org.apache.phoenix.expression.DecimalAddExpression;
import org.apache.phoenix.expression.DecimalDivideExpression;
import org.apache.phoenix.expression.DecimalMultiplyExpression;
import org.apache.phoenix.expression.DecimalSubtractExpression;
import org.apache.phoenix.expression.DoubleAddExpression;
import org.apache.phoenix.expression.DoubleDivideExpression;
import org.apache.phoenix.expression.DoubleMultiplyExpression;
import org.apache.phoenix.expression.DoubleSubtractExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.InListExpression;
import org.apache.phoenix.expression.IsNullExpression;
import org.apache.phoenix.expression.LikeExpression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.LongAddExpression;
import org.apache.phoenix.expression.LongDivideExpression;
import org.apache.phoenix.expression.LongMultiplyExpression;
import org.apache.phoenix.expression.LongSubtractExpression;
import org.apache.phoenix.expression.NotExpression;
import org.apache.phoenix.expression.OrExpression;
import org.apache.phoenix.expression.RowKeyColumnExpression;
import org.apache.phoenix.expression.RowValueConstructorExpression;
import org.apache.phoenix.expression.StringConcatExpression;
import org.apache.phoenix.expression.TimestampAddExpression;
import org.apache.phoenix.expression.TimestampSubtractExpression;
import org.apache.phoenix.parse.AddParseNode;
import org.apache.phoenix.parse.AndParseNode;
import org.apache.phoenix.parse.ArithmeticParseNode;
import org.apache.phoenix.parse.ArrayConstructorNode;
import org.apache.phoenix.parse.BindParseNode;
import org.apache.phoenix.parse.CaseParseNode;
import org.apache.phoenix.parse.CastParseNode;
import org.apache.phoenix.parse.ColumnParseNode;
import org.apache.phoenix.parse.ComparisonParseNode;
import org.apache.phoenix.parse.DivideParseNode;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.parse.InListParseNode;
import org.apache.phoenix.parse.IsNullParseNode;
import org.apache.phoenix.parse.LikeParseNode;
import org.apache.phoenix.parse.LiteralParseNode;
import org.apache.phoenix.parse.MultiplyParseNode;
import org.apache.phoenix.parse.NotParseNode;
import org.apache.phoenix.parse.OrParseNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.RowValueConstructorParseNode;
import org.apache.phoenix.parse.SequenceValueParseNode;
import org.apache.phoenix.parse.StringConcatParseNode;
import org.apache.phoenix.parse.SubtractParseNode;
import org.apache.phoenix.parse.UnsupportedAllParseNodeVisitor;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.ColumnRef;
import org.apache.phoenix.schema.DelegateDatum;
import org.apache.phoenix.schema.PArrayDataType;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.PhoenixArray;
import org.apache.phoenix.schema.RowKeyValueAccessor;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.TypeMismatchException;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.SchemaUtil;

public class ExpressionCompiler
extends UnsupportedAllParseNodeVisitor<Expression> {
    private boolean isAggregate;
    protected ParseNode aggregateFunction;
    protected final StatementContext context;
    protected final GroupByCompiler.GroupBy groupBy;
    private int nodeCount;
    private final boolean resolveViewConstants;
    private static final PDatum DECIMAL_DATUM = new PDatum(){

        @Override
        public boolean isNullable() {
            return true;
        }

        @Override
        public PDataType getDataType() {
            return PDataType.DECIMAL;
        }

        @Override
        public Integer getMaxLength() {
            return null;
        }

        @Override
        public Integer getScale() {
            return null;
        }

        @Override
        public SortOrder getSortOrder() {
            return SortOrder.getDefault();
        }
    };

    ExpressionCompiler(StatementContext context) {
        this(context, GroupByCompiler.GroupBy.EMPTY_GROUP_BY, false);
    }

    ExpressionCompiler(StatementContext context, boolean resolveViewConstants) {
        this(context, GroupByCompiler.GroupBy.EMPTY_GROUP_BY, resolveViewConstants);
    }

    ExpressionCompiler(StatementContext context, GroupByCompiler.GroupBy groupBy) {
        this(context, groupBy, false);
    }

    ExpressionCompiler(StatementContext context, GroupByCompiler.GroupBy groupBy, boolean resolveViewConstants) {
        this.context = context;
        this.groupBy = groupBy;
        this.resolveViewConstants = resolveViewConstants;
    }

    public boolean isAggregate() {
        return this.isAggregate;
    }

    public boolean isTopLevel() {
        return this.nodeCount == 0;
    }

    public void reset() {
        this.isAggregate = false;
        this.nodeCount = 0;
    }

    @Override
    public boolean visitEnter(ComparisonParseNode node) {
        return true;
    }

    private void addBindParamMetaData(ParseNode lhsNode, ParseNode rhsNode, Expression lhsExpr, Expression rhsExpr) throws SQLException {
        if (lhsNode instanceof BindParseNode) {
            this.context.getBindManager().addParamMetaData((BindParseNode)lhsNode, rhsExpr);
        }
        if (rhsNode instanceof BindParseNode) {
            this.context.getBindManager().addParamMetaData((BindParseNode)rhsNode, lhsExpr);
        }
    }

    @Override
    public Expression visitLeave(ComparisonParseNode node, List<Expression> children) throws SQLException {
        ParseNode lhsNode = node.getChildren().get(0);
        ParseNode rhsNode = node.getChildren().get(1);
        Expression lhsExpr = children.get(0);
        Expression rhsExpr = children.get(1);
        CompareFilter.CompareOp op = node.getFilterOp();
        if (lhsNode instanceof RowValueConstructorParseNode && rhsNode instanceof RowValueConstructorParseNode) {
            int i;
            for (i = 0; i < Math.min(lhsExpr.getChildren().size(), rhsExpr.getChildren().size()); ++i) {
                this.addBindParamMetaData(lhsNode.getChildren().get(i), rhsNode.getChildren().get(i), lhsExpr.getChildren().get(i), rhsExpr.getChildren().get(i));
            }
            while (i < lhsExpr.getChildren().size()) {
                this.addBindParamMetaData(lhsNode.getChildren().get(i), null, lhsExpr.getChildren().get(i), null);
                ++i;
            }
            while (i < rhsExpr.getChildren().size()) {
                this.addBindParamMetaData(null, rhsNode.getChildren().get(i), null, rhsExpr.getChildren().get(i));
                ++i;
            }
        } else if (lhsExpr instanceof RowValueConstructorExpression) {
            this.addBindParamMetaData(lhsNode.getChildren().get(0), rhsNode, lhsExpr.getChildren().get(0), rhsExpr);
            for (int i = 1; i < lhsExpr.getChildren().size(); ++i) {
                this.addBindParamMetaData(lhsNode.getChildren().get(i), null, lhsExpr.getChildren().get(i), null);
            }
        } else if (rhsExpr instanceof RowValueConstructorExpression) {
            this.addBindParamMetaData(lhsNode, rhsNode.getChildren().get(0), lhsExpr, rhsExpr.getChildren().get(0));
            for (int i = 1; i < rhsExpr.getChildren().size(); ++i) {
                this.addBindParamMetaData(null, rhsNode.getChildren().get(i), null, rhsExpr.getChildren().get(i));
            }
        } else {
            this.addBindParamMetaData(lhsNode, rhsNode, lhsExpr, rhsExpr);
        }
        return this.wrapGroupByExpression(ComparisonExpression.create(op, children, this.context.getTempPtr()));
    }

    @Override
    public boolean visitEnter(AndParseNode node) throws SQLException {
        return true;
    }

    @Override
    public Expression visitLeave(AndParseNode node, List<Expression> children) throws SQLException {
        return this.wrapGroupByExpression(AndExpression.create(children));
    }

    @Override
    public boolean visitEnter(OrParseNode node) throws SQLException {
        return true;
    }

    private Expression orExpression(List<Expression> children) throws SQLException {
        Iterator<Expression> iterator = children.iterator();
        boolean isDeterministic = true;
        while (iterator.hasNext()) {
            Expression child = iterator.next();
            if (child.getDataType() != PDataType.BOOLEAN) {
                throw TypeMismatchException.newException(PDataType.BOOLEAN, child.getDataType(), child.toString());
            }
            if (LiteralExpression.isFalse(child)) {
                iterator.remove();
            }
            if (LiteralExpression.isTrue(child)) {
                return child;
            }
            isDeterministic &= child.isDeterministic();
        }
        if (children.size() == 0) {
            return LiteralExpression.newConstant((Object)true, isDeterministic);
        }
        if (children.size() == 1) {
            return children.get(0);
        }
        return new OrExpression(children);
    }

    @Override
    public Expression visitLeave(OrParseNode node, List<Expression> children) throws SQLException {
        return this.wrapGroupByExpression(this.orExpression(children));
    }

    @Override
    public boolean visitEnter(FunctionParseNode node) throws SQLException {
        if (node.isAggregate()) {
            if (this.aggregateFunction != null) {
                throw new SQLFeatureNotSupportedException("Nested aggregate functions are not supported");
            }
            this.aggregateFunction = node;
            this.isAggregate = true;
        }
        return true;
    }

    private Expression wrapGroupByExpression(Expression expression) {
        int index;
        if (this.aggregateFunction == null && (index = this.groupBy.getExpressions().indexOf(expression)) >= 0) {
            this.isAggregate = true;
            RowKeyValueAccessor accessor = new RowKeyValueAccessor(this.groupBy.getKeyExpressions(), index);
            expression = new RowKeyColumnExpression((PDatum)expression, accessor, this.groupBy.getKeyExpressions().get(index).getDataType());
        }
        return expression;
    }

    protected Expression addExpression(Expression expression) {
        return this.context.getExpressionManager().addIfAbsent(expression);
    }

    @Override
    public Expression visitLeave(FunctionParseNode node, List<Expression> children) throws SQLException {
        children = node.validate(children, this.context);
        Expression expression = node.create(children, this.context);
        ImmutableBytesWritable ptr = this.context.getTempPtr();
        if (node.isStateless()) {
            Object value = null;
            PDataType type = expression.getDataType();
            if (expression.evaluate(null, ptr)) {
                value = type.toObject(ptr);
            }
            return LiteralExpression.newConstant(value, type, expression.isDeterministic());
        }
        boolean isDeterministic = true;
        FunctionParseNode.BuiltInFunctionInfo info = node.getInfo();
        for (int i = 0; i < info.getRequiredArgCount(); ++i) {
            if (!node.evalToNullIfParamIsNull(this.context, i)) continue;
            Expression child = children.get(i);
            isDeterministic &= child.isDeterministic();
            if (!child.isStateless() || child.evaluate(null, ptr) && ptr.getLength() != 0) continue;
            return LiteralExpression.newConstant(null, expression.getDataType(), isDeterministic);
        }
        expression = this.addExpression(expression);
        expression = this.wrapGroupByExpression(expression);
        if (this.aggregateFunction == node) {
            this.aggregateFunction = null;
        }
        return expression;
    }

    protected ColumnRef resolveColumn(ColumnParseNode node) throws SQLException {
        boolean isSharedViewIndex;
        boolean isMultiTenant;
        boolean isSalted;
        int minPosition;
        ColumnRef ref = this.context.getResolver().resolveColumn(node.getSchemaName(), node.getTableName(), node.getName());
        PTable table = ref.getTable();
        int pkPosition = ref.getPKSlotPosition();
        if (pkPosition >= 0 && pkPosition < (minPosition = ((isSalted = table.getBucketNum() != null) ? 1 : 0) + ((isMultiTenant = this.context.getConnection().getTenantId() != null && table.isMultiTenant()) ? 1 : 0) + ((isSharedViewIndex = table.getViewIndexId() != null) ? 1 : 0))) {
            throw new ColumnNotFoundException(table.getSchemaName().getString(), table.getTableName().getString(), null, ref.getColumn().getName().getString());
        }
        return ref;
    }

    @Override
    public Expression visit(ColumnParseNode node) throws SQLException {
        ColumnRef ref = this.resolveColumn(node);
        TableRef tableRef = ref.getTableRef();
        ImmutableBytesWritable ptr = this.context.getTempPtr();
        PColumn column = ref.getColumn();
        if (!this.resolveViewConstants && IndexUtil.getViewConstantValue(column, ptr)) {
            return LiteralExpression.newConstant(column.getDataType().toObject(ptr), column.getDataType());
        }
        if (tableRef.equals(this.context.getCurrentTable()) && !SchemaUtil.isPKColumn(column)) {
            this.context.getScan().addColumn(column.getFamilyName().getBytes(), column.getName().getBytes());
        }
        ColumnExpression expression = ref.newColumnExpression();
        Expression wrappedExpression = this.wrapGroupByExpression(expression);
        if (this.isAggregate && this.aggregateFunction == null && wrappedExpression == expression) {
            ExpressionCompiler.throwNonAggExpressionInAggException(expression.toString());
        }
        return wrappedExpression;
    }

    @Override
    public Expression visit(BindParseNode node) throws SQLException {
        Object value = this.context.getBindManager().getBindValue(node);
        return LiteralExpression.newConstant(value, true);
    }

    @Override
    public Expression visit(LiteralParseNode node) throws SQLException {
        return LiteralExpression.newConstant(node.getValue(), node.getType(), true);
    }

    @Override
    public List<Expression> newElementList(int size) {
        this.nodeCount += size;
        return new ArrayList<Expression>(size);
    }

    @Override
    public void addElement(List<Expression> l, Expression element) {
        --this.nodeCount;
        l.add(element);
    }

    @Override
    public boolean visitEnter(CaseParseNode node) throws SQLException {
        return true;
    }

    private static boolean isDeterministic(List<Expression> l) {
        for (Expression e : l) {
            if (e.isDeterministic()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Expression visitLeave(CaseParseNode node, List<Expression> l) throws SQLException {
        CaseExpression caseExpression = new CaseExpression(l);
        for (int i = 0; i < node.getChildren().size(); i += 2) {
            ParseNode childNode = node.getChildren().get(i);
            if (!(childNode instanceof BindParseNode)) continue;
            this.context.getBindManager().addParamMetaData((BindParseNode)childNode, new DelegateDatum(caseExpression));
        }
        if (node.isStateless()) {
            ImmutableBytesWritable ptr = this.context.getTempPtr();
            int index = caseExpression.evaluateIndexOf(null, ptr);
            if (index < 0) {
                return LiteralExpression.newConstant(null, ExpressionCompiler.isDeterministic(l));
            }
            return caseExpression.getChildren().get(index);
        }
        return this.wrapGroupByExpression(caseExpression);
    }

    @Override
    public boolean visitEnter(LikeParseNode node) throws SQLException {
        return true;
    }

    @Override
    public Expression visitLeave(LikeParseNode node, List<Expression> children) throws SQLException {
        ParseNode lhsNode = node.getChildren().get(0);
        ParseNode rhsNode = node.getChildren().get(1);
        Expression lhs = children.get(0);
        Expression rhs = children.get(1);
        if (rhs.getDataType() != null && lhs.getDataType() != null && !lhs.getDataType().isCoercibleTo(rhs.getDataType()) && !rhs.getDataType().isCoercibleTo(lhs.getDataType())) {
            throw TypeMismatchException.newException(lhs.getDataType(), rhs.getDataType(), node.toString());
        }
        if (lhsNode instanceof BindParseNode) {
            this.context.getBindManager().addParamMetaData((BindParseNode)lhsNode, rhs);
        }
        if (rhsNode instanceof BindParseNode) {
            this.context.getBindManager().addParamMetaData((BindParseNode)rhsNode, lhs);
        }
        if (rhs instanceof LiteralExpression) {
            String pattern = (String)((LiteralExpression)rhs).getValue();
            if (pattern == null || pattern.length() == 0) {
                return LiteralExpression.newConstant(null, rhs.isDeterministic());
            }
            int index = LikeExpression.indexOfWildcard(pattern);
            Integer lhsMaxLength = lhs.getMaxLength();
            if (lhsMaxLength != null && lhsMaxLength < index) {
                return LiteralExpression.newConstant((Object)false, rhs.isDeterministic());
            }
            if (index == -1) {
                CompareFilter.CompareOp op;
                String rhsLiteral = LikeExpression.unescapeLike(pattern);
                if (lhsMaxLength != null && lhsMaxLength.intValue() != rhsLiteral.length()) {
                    return LiteralExpression.newConstant((Object)false, rhs.isDeterministic());
                }
                CompareFilter.CompareOp compareOp = op = node.isNegate() ? CompareFilter.CompareOp.NOT_EQUAL : CompareFilter.CompareOp.EQUAL;
                if (pattern.equals(rhsLiteral)) {
                    return new ComparisonExpression(op, children);
                }
                rhs = LiteralExpression.newConstant((Object)rhsLiteral, PDataType.CHAR, rhs.isDeterministic());
                return new ComparisonExpression(op, Arrays.asList(lhs, rhs));
            }
        }
        BaseExpression expression = new LikeExpression(children);
        if (node.isStateless()) {
            ImmutableBytesWritable ptr = this.context.getTempPtr();
            if (!expression.evaluate(null, ptr)) {
                return LiteralExpression.newConstant(null, expression.isDeterministic());
            }
            return LiteralExpression.newConstant((Object)(Boolean.TRUE.equals(PDataType.BOOLEAN.toObject(ptr)) ^ node.isNegate()), expression.isDeterministic());
        }
        if (node.isNegate()) {
            expression = new NotExpression(expression);
        }
        return this.wrapGroupByExpression(expression);
    }

    @Override
    public boolean visitEnter(NotParseNode node) throws SQLException {
        return true;
    }

    @Override
    public Expression visitLeave(NotParseNode node, List<Expression> children) throws SQLException {
        ParseNode childNode = node.getChildren().get(0);
        Expression child = children.get(0);
        if (!PDataType.BOOLEAN.isCoercibleTo(child.getDataType())) {
            throw TypeMismatchException.newException(PDataType.BOOLEAN, child.getDataType(), node.toString());
        }
        if (childNode instanceof BindParseNode) {
            this.context.getBindManager().addParamMetaData((BindParseNode)childNode, child);
        }
        return this.wrapGroupByExpression(NotExpression.create(child, this.context.getTempPtr()));
    }

    @Override
    public boolean visitEnter(CastParseNode node) throws SQLException {
        return true;
    }

    @Override
    public Expression visitLeave(CastParseNode node, List<Expression> children) throws SQLException {
        ParseNode childNode = node.getChildren().get(0);
        PDataType targetDataType = node.getDataType();
        Expression childExpr = children.get(0);
        PDataType fromDataType = childExpr.getDataType();
        if (childNode instanceof BindParseNode) {
            this.context.getBindManager().addParamMetaData((BindParseNode)childNode, childExpr);
        }
        Expression expr = childExpr;
        if (fromDataType != null && this.context.getResolver().getTables().get(0).getTable().getType() != PTableType.INDEX) {
            expr = CastParseNode.convertToRoundExpressionIfNeeded(fromDataType, targetDataType, children);
        }
        return CoerceExpression.create(expr, targetDataType, SortOrder.getDefault(), expr.getMaxLength());
    }

    @Override
    public boolean visitEnter(InListParseNode node) throws SQLException {
        return true;
    }

    @Override
    public Expression visitLeave(InListParseNode node, List<Expression> l) throws SQLException {
        List<Expression> inChildren = l;
        Expression firstChild = inChildren.get(0);
        ImmutableBytesWritable ptr = this.context.getTempPtr();
        PDataType firstChildType = firstChild.getDataType();
        ParseNode firstChildNode = node.getChildren().get(0);
        if (firstChildNode instanceof BindParseNode) {
            PDatum datum = firstChild;
            if (firstChildType == null) {
                datum = ExpressionCompiler.inferBindDatum(inChildren);
            }
            this.context.getBindManager().addParamMetaData((BindParseNode)firstChildNode, datum);
        }
        for (int i = 1; i < l.size(); ++i) {
            ParseNode childNode = node.getChildren().get(i);
            if (!(childNode instanceof BindParseNode)) continue;
            this.context.getBindManager().addParamMetaData((BindParseNode)childNode, firstChild);
        }
        return this.wrapGroupByExpression(InListExpression.create(inChildren, node.isNegate(), ptr));
    }

    private static PDatum inferBindDatum(List<Expression> children) {
        boolean isChildTypeUnknown = false;
        PDatum datum = children.get(1);
        for (int i = 2; i < children.size(); ++i) {
            Expression child = children.get(i);
            PDataType childType = child.getDataType();
            if (childType == null) {
                isChildTypeUnknown = true;
                continue;
            }
            if (datum.getDataType() == null) {
                datum = child;
                isChildTypeUnknown = true;
                continue;
            }
            if (datum.getDataType() == childType || childType.isCoercibleTo(datum.getDataType()) || !datum.getDataType().isCoercibleTo(childType)) continue;
            datum = child;
        }
        if (isChildTypeUnknown && datum.getDataType() != null && datum.getDataType().isCoercibleTo(PDataType.DECIMAL)) {
            return DECIMAL_DATUM;
        }
        return datum;
    }

    @Override
    public boolean visitEnter(IsNullParseNode node) throws SQLException {
        return true;
    }

    @Override
    public Expression visitLeave(IsNullParseNode node, List<Expression> children) throws SQLException {
        ParseNode childNode = node.getChildren().get(0);
        Expression child = children.get(0);
        if (childNode instanceof BindParseNode) {
            this.context.getBindManager().addParamMetaData((BindParseNode)childNode, child);
        }
        return this.wrapGroupByExpression(IsNullExpression.create(child, node.isNegate(), this.context.getTempPtr()));
    }

    private Expression visitLeave(ArithmeticParseNode node, List<Expression> children, ArithmeticExpressionBinder binder, ArithmeticExpressionFactory factory) throws SQLException {
        boolean isNull = false;
        for (Expression child : children) {
            boolean isChildLiteral = child instanceof LiteralExpression;
            isNull |= isChildLiteral && ((LiteralExpression)child).getValue() == null;
        }
        Expression expression = factory.create(node, children);
        for (int i = 0; i < node.getChildren().size(); ++i) {
            ParseNode childNode = node.getChildren().get(i);
            if (!(childNode instanceof BindParseNode)) continue;
            this.context.getBindManager().addParamMetaData((BindParseNode)childNode, binder == null ? expression : binder.getBindMetaData(i, children, expression));
        }
        ImmutableBytesWritable ptr = this.context.getTempPtr();
        if (expression.isStateless()) {
            if (!expression.evaluate(null, ptr) || ptr.getLength() == 0) {
                return LiteralExpression.newConstant(null, expression.getDataType(), expression.isDeterministic());
            }
            return LiteralExpression.newConstant(expression.getDataType().toObject(ptr), expression.getDataType(), expression.isDeterministic());
        }
        if (isNull) {
            return LiteralExpression.newConstant(null, expression.getDataType(), expression.isDeterministic());
        }
        return this.wrapGroupByExpression(expression);
    }

    @Override
    public boolean visitEnter(SubtractParseNode node) throws SQLException {
        return true;
    }

    @Override
    public Expression visitLeave(SubtractParseNode node, List<Expression> children) throws SQLException {
        return this.visitLeave(node, children, new ArithmeticExpressionBinder(){

            @Override
            public PDatum getBindMetaData(int i, List<Expression> children, final Expression expression) {
                PDataType type;
                if (i == 0 && (type = children.get(1).getDataType()) != null && type.isCoercibleTo(PDataType.DATE)) {
                    return new PDatum(){

                        @Override
                        public boolean isNullable() {
                            return expression.isNullable();
                        }

                        @Override
                        public PDataType getDataType() {
                            return type;
                        }

                        @Override
                        public Integer getMaxLength() {
                            return expression.getMaxLength();
                        }

                        @Override
                        public Integer getScale() {
                            return expression.getScale();
                        }

                        @Override
                        public SortOrder getSortOrder() {
                            return expression.getSortOrder();
                        }
                    };
                }
                if (expression.getDataType() != null && expression.getDataType().isCoercibleTo(PDataType.DATE)) {
                    return new PDatum(){

                        @Override
                        public boolean isNullable() {
                            return expression.isNullable();
                        }

                        @Override
                        public PDataType getDataType() {
                            return PDataType.DECIMAL;
                        }

                        @Override
                        public Integer getMaxLength() {
                            return expression.getMaxLength();
                        }

                        @Override
                        public Integer getScale() {
                            return expression.getScale();
                        }

                        @Override
                        public SortOrder getSortOrder() {
                            return expression.getSortOrder();
                        }
                    };
                }
                return expression;
            }
        }, new ArithmeticExpressionFactory(){

            @Override
            public Expression create(ArithmeticParseNode node, List<Expression> children) throws SQLException {
                boolean isType2Date;
                int i = 0;
                PDataType theType = null;
                Expression e1 = children.get(0);
                Expression e2 = children.get(1);
                boolean isDeterministic = e1.isDeterministic() && e2.isDeterministic();
                PDataType type1 = e1.getDataType();
                PDataType type2 = e2.getDataType();
                boolean isType1Date = type1 != null && type1 != PDataType.TIMESTAMP && type1 != PDataType.UNSIGNED_TIMESTAMP && type1.isCoercibleTo(PDataType.DATE);
                boolean bl = isType2Date = type2 != null && type2 != PDataType.TIMESTAMP && type2 != PDataType.UNSIGNED_TIMESTAMP && type2.isCoercibleTo(PDataType.DATE);
                if (isType1Date || isType2Date) {
                    if (isType1Date && isType2Date) {
                        i = 2;
                        theType = PDataType.LONG;
                    } else if (isType1Date && type2 != null && type2.isCoercibleTo(PDataType.DECIMAL)) {
                        i = 2;
                        theType = PDataType.DATE;
                    } else if (type1 == null || type2 == null) {
                        i = 2;
                        theType = null;
                    }
                } else if (type1 == PDataType.TIMESTAMP || type2 == PDataType.TIMESTAMP) {
                    i = 2;
                    theType = PDataType.TIMESTAMP;
                } else if (type1 == PDataType.UNSIGNED_TIMESTAMP || type2 == PDataType.UNSIGNED_TIMESTAMP) {
                    i = 2;
                    theType = PDataType.UNSIGNED_TIMESTAMP;
                }
                while (i < children.size()) {
                    Expression e = children.get(i);
                    isDeterministic &= e.isDeterministic();
                    PDataType type = e.getDataType();
                    if (type != null) {
                        if (type.isCoercibleTo(PDataType.LONG)) {
                            if (theType == null) {
                                theType = PDataType.LONG;
                            }
                        } else if (type == PDataType.DECIMAL) {
                            if (theType == null || !theType.isCoercibleTo(PDataType.DATE)) {
                                theType = PDataType.DECIMAL;
                            }
                        } else if (type.isCoercibleTo(PDataType.DOUBLE)) {
                            if (theType == null || theType != PDataType.DECIMAL && !theType.isCoercibleTo(PDataType.DATE)) {
                                theType = PDataType.DOUBLE;
                            }
                        } else {
                            throw TypeMismatchException.newException(type, node.toString());
                        }
                    }
                    ++i;
                }
                if (theType == PDataType.DECIMAL) {
                    return new DecimalSubtractExpression(children);
                }
                if (theType == PDataType.LONG) {
                    return new LongSubtractExpression(children);
                }
                if (theType == PDataType.DOUBLE) {
                    return new DoubleSubtractExpression(children);
                }
                if (theType == null) {
                    return LiteralExpression.newConstant(null, theType, isDeterministic);
                }
                if (theType == PDataType.TIMESTAMP || theType == PDataType.UNSIGNED_TIMESTAMP) {
                    return new TimestampSubtractExpression(children);
                }
                if (theType.isCoercibleTo(PDataType.DATE)) {
                    return new DateSubtractExpression(children);
                }
                throw TypeMismatchException.newException(theType, node.toString());
            }
        });
    }

    @Override
    public boolean visitEnter(AddParseNode node) throws SQLException {
        return true;
    }

    @Override
    public Expression visitLeave(AddParseNode node, List<Expression> children) throws SQLException {
        return this.visitLeave(node, children, new ArithmeticExpressionBinder(){

            @Override
            public PDatum getBindMetaData(int i, List<Expression> children, final Expression expression) {
                PDataType type = expression.getDataType();
                if (type != null && type.isCoercibleTo(PDataType.DATE)) {
                    return new PDatum(){

                        @Override
                        public boolean isNullable() {
                            return expression.isNullable();
                        }

                        @Override
                        public PDataType getDataType() {
                            return PDataType.DECIMAL;
                        }

                        @Override
                        public Integer getMaxLength() {
                            return expression.getMaxLength();
                        }

                        @Override
                        public Integer getScale() {
                            return expression.getScale();
                        }

                        @Override
                        public SortOrder getSortOrder() {
                            return expression.getSortOrder();
                        }
                    };
                }
                return expression;
            }
        }, new ArithmeticExpressionFactory(){

            @Override
            public Expression create(ArithmeticParseNode node, List<Expression> children) throws SQLException {
                boolean foundDate = false;
                boolean isDeterministic = true;
                PDataType theType = null;
                for (int i = 0; i < children.size(); ++i) {
                    Expression e = children.get(i);
                    isDeterministic &= e.isDeterministic();
                    PDataType type = e.getDataType();
                    if (type == null) continue;
                    if (type.isCoercibleTo(PDataType.TIMESTAMP)) {
                        if (foundDate) {
                            throw TypeMismatchException.newException(type, node.toString());
                        }
                        if (theType == null || theType != PDataType.TIMESTAMP && theType != PDataType.UNSIGNED_TIMESTAMP) {
                            theType = type;
                        }
                        foundDate = true;
                        continue;
                    }
                    if (type == PDataType.DECIMAL) {
                        if (theType != null && theType.isCoercibleTo(PDataType.TIMESTAMP)) continue;
                        theType = PDataType.DECIMAL;
                        continue;
                    }
                    if (type.isCoercibleTo(PDataType.LONG)) {
                        if (theType != null) continue;
                        theType = PDataType.LONG;
                        continue;
                    }
                    if (type.isCoercibleTo(PDataType.DOUBLE)) {
                        if (theType != null) continue;
                        theType = PDataType.DOUBLE;
                        continue;
                    }
                    throw TypeMismatchException.newException(type, node.toString());
                }
                if (theType == PDataType.DECIMAL) {
                    return new DecimalAddExpression(children);
                }
                if (theType == PDataType.LONG) {
                    return new LongAddExpression(children);
                }
                if (theType == PDataType.DOUBLE) {
                    return new DoubleAddExpression(children);
                }
                if (theType == null) {
                    return LiteralExpression.newConstant(null, theType, isDeterministic);
                }
                if (theType == PDataType.TIMESTAMP || theType == PDataType.UNSIGNED_TIMESTAMP) {
                    return new TimestampAddExpression(children);
                }
                if (theType.isCoercibleTo(PDataType.DATE)) {
                    return new DateAddExpression(children);
                }
                throw TypeMismatchException.newException(theType, node.toString());
            }
        });
    }

    @Override
    public boolean visitEnter(MultiplyParseNode node) throws SQLException {
        return true;
    }

    @Override
    public Expression visitLeave(MultiplyParseNode node, List<Expression> children) throws SQLException {
        return this.visitLeave(node, children, null, new ArithmeticExpressionFactory(){

            @Override
            public Expression create(ArithmeticParseNode node, List<Expression> children) throws SQLException {
                Enum theType = null;
                boolean isDeterministic = true;
                for (int i = 0; i < children.size(); ++i) {
                    Expression e = children.get(i);
                    isDeterministic &= e.isDeterministic();
                    PDataType type = e.getDataType();
                    if (type == null) continue;
                    if (type == PDataType.DECIMAL) {
                        theType = PDataType.DECIMAL;
                        continue;
                    }
                    if (type.isCoercibleTo(PDataType.LONG)) {
                        if (theType != null) continue;
                        theType = PDataType.LONG;
                        continue;
                    }
                    if (type.isCoercibleTo(PDataType.DOUBLE)) {
                        if (theType != null) continue;
                        theType = PDataType.DOUBLE;
                        continue;
                    }
                    throw TypeMismatchException.newException(type, node.toString());
                }
                switch (9.$SwitchMap$org$apache$phoenix$schema$PDataType[theType.ordinal()]) {
                    case 1: {
                        return new DecimalMultiplyExpression(children);
                    }
                    case 2: {
                        return new LongMultiplyExpression(children);
                    }
                    case 3: {
                        return new DoubleMultiplyExpression(children);
                    }
                }
                return LiteralExpression.newConstant(null, (PDataType)theType, isDeterministic);
            }
        });
    }

    @Override
    public boolean visitEnter(DivideParseNode node) throws SQLException {
        return true;
    }

    @Override
    public Expression visitLeave(DivideParseNode node, List<Expression> children) throws SQLException {
        for (int i = 1; i < children.size(); ++i) {
            LiteralExpression literal;
            Expression child = children.get(i);
            if (child.getDataType() == null || !(child instanceof LiteralExpression) || !((literal = (LiteralExpression)child).getDataType() == PDataType.DECIMAL ? PDataType.DECIMAL.compareTo(literal.getValue(), BigDecimal.ZERO) == 0 : literal.getDataType().compareTo(literal.getValue(), 0L, PDataType.LONG) == 0)) continue;
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.DIVIDE_BY_ZERO).build().buildException();
        }
        return this.visitLeave(node, children, null, new ArithmeticExpressionFactory(){

            @Override
            public Expression create(ArithmeticParseNode node, List<Expression> children) throws SQLException {
                Enum theType = null;
                boolean isDeterministic = true;
                for (int i = 0; i < children.size(); ++i) {
                    Expression e = children.get(i);
                    isDeterministic &= e.isDeterministic();
                    PDataType type = e.getDataType();
                    if (type == null) continue;
                    if (type == PDataType.DECIMAL) {
                        theType = PDataType.DECIMAL;
                        continue;
                    }
                    if (type.isCoercibleTo(PDataType.LONG)) {
                        if (theType != null) continue;
                        theType = PDataType.LONG;
                        continue;
                    }
                    if (type.isCoercibleTo(PDataType.DOUBLE)) {
                        if (theType != null) continue;
                        theType = PDataType.DOUBLE;
                        continue;
                    }
                    throw TypeMismatchException.newException(type, node.toString());
                }
                switch (9.$SwitchMap$org$apache$phoenix$schema$PDataType[theType.ordinal()]) {
                    case 1: {
                        return new DecimalDivideExpression(children);
                    }
                    case 2: {
                        return new LongDivideExpression(children);
                    }
                    case 3: {
                        return new DoubleDivideExpression(children);
                    }
                }
                return LiteralExpression.newConstant(null, (PDataType)theType, isDeterministic);
            }
        });
    }

    public static void throwNonAggExpressionInAggException(String nonAggregateExpression) throws SQLException {
        throw new SQLExceptionInfo.Builder(SQLExceptionCode.AGGREGATE_WITH_NOT_GROUP_BY_COLUMN).setMessage(nonAggregateExpression).build().buildException();
    }

    @Override
    public Expression visitLeave(StringConcatParseNode node, List<Expression> children) throws SQLException {
        StringConcatExpression expression = new StringConcatExpression(children);
        for (int i = 0; i < children.size(); ++i) {
            PDataType type;
            ParseNode childNode = node.getChildren().get(i);
            if (childNode instanceof BindParseNode) {
                this.context.getBindManager().addParamMetaData((BindParseNode)childNode, expression);
            }
            if ((type = children.get(i).getDataType()) != PDataType.VARBINARY) continue;
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.TYPE_NOT_SUPPORTED_FOR_OPERATOR).setMessage("Concatenation does not support " + (Object)((Object)type) + " in expression" + node).build().buildException();
        }
        ImmutableBytesWritable ptr = this.context.getTempPtr();
        if (expression.isStateless()) {
            if (!expression.evaluate(null, ptr) || ptr.getLength() == 0) {
                return LiteralExpression.newConstant(null, expression.getDataType(), expression.isDeterministic());
            }
            return LiteralExpression.newConstant(expression.getDataType().toObject(ptr), expression.getDataType(), expression.isDeterministic());
        }
        return this.wrapGroupByExpression(expression);
    }

    @Override
    public boolean visitEnter(StringConcatParseNode node) throws SQLException {
        return true;
    }

    @Override
    public boolean visitEnter(RowValueConstructorParseNode node) throws SQLException {
        return true;
    }

    @Override
    public Expression visitLeave(RowValueConstructorParseNode node, List<Expression> l) throws SQLException {
        return this.wrapGroupByExpression(new RowValueConstructorExpression(l, node.isStateless()));
    }

    @Override
    public Expression visit(SequenceValueParseNode node) throws SQLException {
        throw new SQLExceptionInfo.Builder(SQLExceptionCode.INVALID_USE_OF_NEXT_VALUE_FOR).setSchemaName(node.getTableName().getSchemaName()).setTableName(node.getTableName().getTableName()).build().buildException();
    }

    @Override
    public Expression visitLeave(ArrayConstructorNode node, List<Expression> children) throws SQLException {
        boolean isChildTypeUnknown = false;
        Expression arrayElemChild = null;
        PDataType arrayElemDataType = children.get(0).getDataType();
        for (int i = 0; i < children.size(); ++i) {
            Expression child = children.get(i);
            PDataType childType = child.getDataType();
            if (childType == null) {
                isChildTypeUnknown = true;
                continue;
            }
            if (arrayElemDataType == null) {
                arrayElemDataType = childType;
                isChildTypeUnknown = true;
                arrayElemChild = child;
                continue;
            }
            if (arrayElemDataType == childType || childType.isCoercibleTo(arrayElemDataType)) continue;
            if (arrayElemDataType.isCoercibleTo(childType)) {
                arrayElemChild = child;
                arrayElemDataType = childType;
                continue;
            }
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_CONVERT_TYPE).setMessage("Case expressions must have common type: " + (Object)((Object)arrayElemDataType) + " cannot be coerced to " + (Object)((Object)childType)).build().buildException();
        }
        if (isChildTypeUnknown && arrayElemDataType != null && arrayElemDataType.isCoercibleTo(PDataType.DECIMAL)) {
            arrayElemDataType = PDataType.DECIMAL;
        }
        final PDataType theArrayElemDataType = arrayElemDataType;
        for (int i = 0; i < node.getChildren().size(); ++i) {
            ParseNode childNode = node.getChildren().get(i);
            if (!(childNode instanceof BindParseNode)) continue;
            this.context.getBindManager().addParamMetaData((BindParseNode)childNode, arrayElemDataType == arrayElemChild.getDataType() ? arrayElemChild : new DelegateDatum(arrayElemChild){

                @Override
                public PDataType getDataType() {
                    return theArrayElemDataType;
                }
            });
        }
        ImmutableBytesWritable ptr = this.context.getTempPtr();
        Object[] elements = new Object[children.size()];
        if (node.isStateless()) {
            boolean isDeterministic = true;
            for (int i = 0; i < children.size(); ++i) {
                Expression child = children.get(i);
                isDeterministic &= child.isDeterministic();
                child.evaluate(null, ptr);
                Object value = arrayElemDataType.toObject(ptr, child.getDataType(), child.getSortOrder());
                elements[i] = LiteralExpression.newConstant(value, child.getDataType(), child.isDeterministic()).getValue();
            }
            PhoenixArray value = PArrayDataType.instantiatePhoenixArray(arrayElemDataType, elements);
            return LiteralExpression.newConstant((Object)value, PDataType.fromTypeId(arrayElemDataType.getSqlType() + 3000), isDeterministic);
        }
        ArrayConstructorExpression arrayExpression = new ArrayConstructorExpression(children, arrayElemDataType);
        return this.wrapGroupByExpression(arrayExpression);
    }

    @Override
    public boolean visitEnter(ArrayConstructorNode node) throws SQLException {
        return true;
    }

    static class 9 {
        static final /* synthetic */ int[] $SwitchMap$org$apache$phoenix$schema$PDataType;

        static {
            $SwitchMap$org$apache$phoenix$schema$PDataType = new int[PDataType.values().length];
            try {
                9.$SwitchMap$org$apache$phoenix$schema$PDataType[PDataType.DECIMAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                9.$SwitchMap$org$apache$phoenix$schema$PDataType[PDataType.LONG.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                9.$SwitchMap$org$apache$phoenix$schema$PDataType[PDataType.DOUBLE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    private static interface ArithmeticExpressionBinder {
        public PDatum getBindMetaData(int var1, List<Expression> var2, Expression var3);
    }

    private static interface ArithmeticExpressionFactory {
        public Expression create(ArithmeticParseNode var1, List<Expression> var2) throws SQLException;
    }
}

