/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.coprocessor.MetaDataProtocol;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.parse.BindTableNode;
import org.apache.phoenix.parse.ColumnDef;
import org.apache.phoenix.parse.CreateTableStatement;
import org.apache.phoenix.parse.DerivedTableNode;
import org.apache.phoenix.parse.JoinTableNode;
import org.apache.phoenix.parse.NamedTableNode;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.parse.SingleTableStatement;
import org.apache.phoenix.parse.TableName;
import org.apache.phoenix.parse.TableNode;
import org.apache.phoenix.parse.TableNodeVisitor;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.schema.AmbiguousColumnException;
import org.apache.phoenix.schema.AmbiguousTableException;
import org.apache.phoenix.schema.ColumnFamilyNotFoundException;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.ColumnRef;
import org.apache.phoenix.schema.MetaDataClient;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnFamily;
import org.apache.phoenix.schema.PColumnFamilyImpl;
import org.apache.phoenix.schema.PColumnImpl;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableImpl;
import org.apache.phoenix.schema.PTableKey;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.TableNotFoundException;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.util.SchemaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FromCompiler {
    private static final Logger logger = LoggerFactory.getLogger(FromCompiler.class);
    public static final ColumnResolver EMPTY_TABLE_RESOLVER = new ColumnResolver(){

        @Override
        public List<TableRef> getTables() {
            return Collections.emptyList();
        }

        @Override
        public TableRef resolveTable(String schemaName, String tableName) throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public ColumnRef resolveColumn(String schemaName, String tableName, String colName) throws SQLException {
            throw new UnsupportedOperationException();
        }
    };

    public static ColumnResolver getResolverForCreation(CreateTableStatement statement, PhoenixConnection connection) throws SQLException {
        TableName baseTable = statement.getBaseTableName();
        if (baseTable == null) {
            return EMPTY_TABLE_RESOLVER;
        }
        NamedTableNode tableNode = NamedTableNode.create(null, baseTable, Collections.<ColumnDef>emptyList());
        try {
            SingleTableColumnResolver visitor = new SingleTableColumnResolver(connection, tableNode, true);
            return visitor;
        }
        catch (TableNotFoundException e) {
            if (connection.getTenantId() == null && statement.getTableType() == PTableType.VIEW) {
                ConnectionQueryServices services = connection.getQueryServices();
                byte[] fullTableName = SchemaUtil.getTableNameAsBytes(baseTable.getSchemaName(), baseTable.getTableName());
                HTableInterface htable = null;
                try {
                    htable = services.getTable(fullTableName);
                }
                catch (UnsupportedOperationException ignore) {
                    throw e;
                }
                finally {
                    if (htable != null) {
                        Closeables.closeQuietly(htable);
                    }
                }
                tableNode = NamedTableNode.create(null, baseTable, statement.getColumnDefs());
                return new SingleTableColumnResolver(connection, tableNode, e.getTimeStamp());
            }
            throw e;
        }
    }

    public static ColumnResolver getResolverForQuery(SelectStatement statement, PhoenixConnection connection) throws SQLException {
        List<TableNode> fromNodes = statement.getFrom();
        if (fromNodes.size() == 1) {
            return new SingleTableColumnResolver(connection, (NamedTableNode)fromNodes.get(0), true);
        }
        MultiTableColumnResolver visitor = new MultiTableColumnResolver(connection);
        for (TableNode node : fromNodes) {
            node.accept(visitor);
        }
        return visitor;
    }

    public static ColumnResolver getResolver(NamedTableNode tableNode, PhoenixConnection connection) throws SQLException {
        SingleTableColumnResolver visitor = new SingleTableColumnResolver(connection, tableNode, true);
        return visitor;
    }

    public static ColumnResolver getResolverForMutation(SingleTableStatement statement, PhoenixConnection connection) throws SQLException {
        SingleTableColumnResolver visitor = new SingleTableColumnResolver(connection, statement.getTable(), false);
        return visitor;
    }

    public static class MultiTableColumnResolver
    extends BaseColumnResolver
    implements TableNodeVisitor {
        private final ListMultimap<String, TableRef> tableMap = ArrayListMultimap.create();
        private final List<TableRef> tables = Lists.newArrayList();

        private MultiTableColumnResolver(PhoenixConnection connection) {
            super(connection);
        }

        @Override
        public List<TableRef> getTables() {
            return this.tables;
        }

        @Override
        public void visit(BindTableNode boundTableNode) throws SQLException {
            throw new SQLFeatureNotSupportedException();
        }

        @Override
        public void visit(JoinTableNode joinNode) throws SQLException {
            joinNode.getTable().accept(this);
        }

        @Override
        public void visit(NamedTableNode tableNode) throws SQLException {
            String alias = tableNode.getAlias();
            TableRef tableRef = this.createTableRef(tableNode, true);
            PTable theTable = tableRef.getTable();
            if (alias != null) {
                this.tableMap.put(alias, tableRef);
            }
            String name = theTable.getName().getString();
            if (alias == null || !alias.equals(name)) {
                this.tableMap.put(name, tableRef);
            }
            this.tables.add(tableRef);
        }

        @Override
        public void visit(DerivedTableNode subselectNode) throws SQLException {
            throw new SQLFeatureNotSupportedException();
        }

        @Override
        public TableRef resolveTable(String schemaName, String tableName) throws SQLException {
            String fullTableName = SchemaUtil.getTableName(schemaName, tableName);
            List<TableRef> tableRefs = this.tableMap.get(fullTableName);
            if (tableRefs.size() == 0) {
                throw new TableNotFoundException(fullTableName);
            }
            if (tableRefs.size() > 1) {
                throw new AmbiguousTableException(tableName);
            }
            return tableRefs.get(0);
        }

        private ColumnFamilyRef resolveColumnFamily(String tableName, String cfName) throws SQLException {
            if (tableName == null) {
                ColumnFamilyRef theColumnFamilyRef = null;
                for (TableRef tableRef : this.tables) {
                    try {
                        PColumnFamily columnFamily = tableRef.getTable().getColumnFamily(cfName);
                        if (theColumnFamilyRef != null) {
                            throw new TableNotFoundException(cfName);
                        }
                        theColumnFamilyRef = new ColumnFamilyRef(tableRef, columnFamily);
                    }
                    catch (ColumnFamilyNotFoundException e) {}
                }
                if (theColumnFamilyRef != null) {
                    return theColumnFamilyRef;
                }
                throw new TableNotFoundException(cfName);
            }
            TableRef tableRef = this.resolveTable(null, tableName);
            PColumnFamily columnFamily = tableRef.getTable().getColumnFamily(cfName);
            return new ColumnFamilyRef(tableRef, columnFamily);
        }

        @Override
        public ColumnRef resolveColumn(String schemaName, String tableName, String colName) throws SQLException {
            if (tableName == null) {
                int theColumnPosition = -1;
                TableRef theTableRef = null;
                for (TableRef tableRef : this.tables) {
                    try {
                        PColumn column = tableRef.getTable().getColumn(colName);
                        if (theTableRef != null) {
                            throw new AmbiguousColumnException(colName);
                        }
                        theTableRef = tableRef;
                        theColumnPosition = column.getPosition();
                    }
                    catch (ColumnNotFoundException e) {}
                }
                if (theTableRef != null) {
                    return new ColumnRef(theTableRef, theColumnPosition);
                }
                throw new ColumnNotFoundException(colName);
            }
            try {
                TableRef tableRef = this.resolveTable(schemaName, tableName);
                PColumn column = tableRef.getTable().getColumn(colName);
                return new ColumnRef(tableRef, column.getPosition());
            }
            catch (TableNotFoundException e) {
                ColumnFamilyRef cfRef = this.resolveColumnFamily(schemaName, tableName);
                PColumn column = cfRef.getFamily().getColumn(colName);
                return new ColumnRef(cfRef.getTableRef(), column.getPosition());
            }
        }

        private static class ColumnFamilyRef {
            private final TableRef tableRef;
            private final PColumnFamily family;

            ColumnFamilyRef(TableRef tableRef, PColumnFamily family) {
                this.tableRef = tableRef;
                this.family = family;
            }

            public TableRef getTableRef() {
                return this.tableRef;
            }

            public PColumnFamily getFamily() {
                return this.family;
            }
        }
    }

    private static abstract class BaseColumnResolver
    implements ColumnResolver {
        protected final PhoenixConnection connection;
        protected final MetaDataClient client;

        private BaseColumnResolver(PhoenixConnection connection) {
            this.connection = connection;
            this.client = new MetaDataClient(connection);
        }

        protected TableRef createTableRef(NamedTableNode tableNode, boolean updateCacheImmediately) throws SQLException {
            MetaDataProtocol.MetaDataMutationResult result;
            String tableName = tableNode.getName().getTableName();
            String schemaName = tableNode.getName().getSchemaName();
            long timeStamp = -1L;
            String fullTableName = SchemaUtil.getTableName(schemaName, tableName);
            PName tenantId = this.connection.getTenantId();
            PTable theTable = null;
            if (updateCacheImmediately || this.connection.getAutoCommit()) {
                result = this.client.updateCache(schemaName, tableName);
                timeStamp = result.getMutationTime();
                theTable = result.getTable();
                if (theTable == null) {
                    throw new TableNotFoundException(schemaName, tableName, timeStamp);
                }
            } else {
                block10: {
                    try {
                        theTable = this.connection.getMetaDataCache().getTable(new PTableKey(tenantId, fullTableName));
                    }
                    catch (TableNotFoundException e1) {
                        if (tenantId == null) break block10;
                        try {
                            theTable = this.connection.getMetaDataCache().getTable(new PTableKey(null, fullTableName));
                        }
                        catch (TableNotFoundException e2) {
                            // empty catch block
                        }
                    }
                }
                if (theTable == null && (result = this.client.updateCache(schemaName, tableName)).wasUpdated()) {
                    timeStamp = result.getMutationTime();
                    theTable = result.getTable();
                }
                if (theTable == null) {
                    throw new TableNotFoundException(schemaName, tableName, timeStamp);
                }
            }
            List<ColumnDef> dynamicColumns = tableNode.getDynamicColumns();
            theTable = this.addDynamicColumns(dynamicColumns, theTable);
            TableRef tableRef = new TableRef(tableNode.getAlias(), theTable, timeStamp, !dynamicColumns.isEmpty());
            if (logger.isDebugEnabled() && timeStamp != -1L) {
                logger.debug("Re-resolved stale table " + fullTableName + " with seqNum " + tableRef.getTable().getSequenceNumber() + " at timestamp " + tableRef.getTable().getTimeStamp() + " with " + tableRef.getTable().getColumns().size() + " columns: " + tableRef.getTable().getColumns());
            }
            return tableRef;
        }

        protected PTable addDynamicColumns(List<ColumnDef> dynColumns, PTable theTable) throws SQLException {
            if (!dynColumns.isEmpty()) {
                ArrayList<PColumn> allcolumns = new ArrayList<PColumn>();
                List<PColumn> existingColumns = theTable.getColumns();
                allcolumns.addAll(theTable.getBucketNum() == null ? existingColumns : existingColumns.subList(1, existingColumns.size()));
                int position = existingColumns.size();
                PName defaultFamilyName = PNameFactory.newName(SchemaUtil.getEmptyColumnFamily(theTable));
                for (ColumnDef dynColumn : dynColumns) {
                    PName familyName = defaultFamilyName;
                    PName name = PNameFactory.newName(dynColumn.getColumnDefName().getColumnName());
                    String family = dynColumn.getColumnDefName().getFamilyName();
                    if (family != null) {
                        theTable.getColumnFamily(family);
                        familyName = PNameFactory.newName(family);
                    }
                    allcolumns.add(new PColumnImpl(name, familyName, dynColumn.getDataType(), dynColumn.getMaxLength(), dynColumn.getScale(), dynColumn.isNull(), position, dynColumn.getSortOrder(), dynColumn.getArraySize(), null, false));
                    ++position;
                }
                theTable = PTableImpl.makePTable(theTable, allcolumns);
            }
            return theTable;
        }
    }

    private static class SingleTableColumnResolver
    extends BaseColumnResolver {
        private final List<TableRef> tableRefs;
        private final String alias;

        public SingleTableColumnResolver(PhoenixConnection connection, NamedTableNode table, long timeStamp) throws SQLException {
            super(connection);
            ArrayList<PColumnFamily> families = Lists.newArrayListWithExpectedSize(table.getDynamicColumns().size());
            for (ColumnDef def : table.getDynamicColumns()) {
                if (def.getColumnDefName().getFamilyName() == null) continue;
                families.add(new PColumnFamilyImpl(PNameFactory.newName(def.getColumnDefName().getFamilyName()), Collections.<PColumn>emptyList()));
            }
            Long scn = connection.getSCN();
            PTable theTable = new PTableImpl(connection.getTenantId(), table.getName().getSchemaName(), table.getName().getTableName(), scn == null ? Long.MAX_VALUE : scn, families);
            theTable = this.addDynamicColumns(table.getDynamicColumns(), theTable);
            this.alias = null;
            this.tableRefs = ImmutableList.of(new TableRef(this.alias, theTable, timeStamp, !table.getDynamicColumns().isEmpty()));
        }

        public SingleTableColumnResolver(PhoenixConnection connection, NamedTableNode tableNode, boolean updateCacheImmediately) throws SQLException {
            super(connection);
            this.alias = tableNode.getAlias();
            TableRef tableRef = this.createTableRef(tableNode, updateCacheImmediately);
            this.tableRefs = ImmutableList.of(tableRef);
        }

        @Override
        public List<TableRef> getTables() {
            return this.tableRefs;
        }

        @Override
        public TableRef resolveTable(String schemaName, String tableName) throws SQLException {
            TableRef tableRef = this.tableRefs.get(0);
            if (schemaName != null || tableName != null) {
                String resolvedTableName = tableRef.getTable().getTableName().getString();
                String resolvedSchemaName = tableRef.getTable().getSchemaName().getString();
                if (!(schemaName == null || tableName == null || schemaName.equals(resolvedSchemaName) && tableName.equals(resolvedTableName) || schemaName.equals(this.alias))) {
                    throw new TableNotFoundException(schemaName, tableName);
                }
            }
            return tableRef;
        }

        @Override
        public ColumnRef resolveColumn(String schemaName, String tableName, String colName) throws SQLException {
            TableRef tableRef = this.tableRefs.get(0);
            boolean resolveCF = false;
            if (schemaName != null || tableName != null) {
                String resolvedTableName = tableRef.getTable().getTableName().getString();
                String resolvedSchemaName = tableRef.getTable().getSchemaName().getString();
                if (schemaName != null && tableName != null) {
                    if (!(schemaName.equals(resolvedSchemaName) && tableName.equals(resolvedTableName) || (resolveCF = schemaName.equals(this.alias)))) {
                        throw new ColumnNotFoundException(schemaName, tableName, null, colName);
                    }
                } else if (!(tableName == null || tableName.equals(this.alias) || tableName.equals(resolvedTableName) && resolvedSchemaName.equals(""))) {
                    resolveCF = true;
                }
            }
            PColumn column = resolveCF ? tableRef.getTable().getColumnFamily(tableName).getColumn(colName) : tableRef.getTable().getColumn(colName);
            return new ColumnRef(tableRef, column.getPosition());
        }
    }
}

