/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.http.annotation.Immutable;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.compile.TrackOrderPreservingExpressionCompiler;
import org.apache.phoenix.coprocessor.GroupedAggregateRegionObserver;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.expression.CoerceExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.parse.AliasedNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.schema.PDataType;

public class GroupByCompiler {
    public static GroupBy compile(StatementContext context, SelectStatement statement) throws SQLException {
        String groupExprAttribName;
        ArrayList<Expression> expressions;
        List<ParseNode> groupByNodes = statement.getGroupBy();
        if (groupByNodes.isEmpty()) {
            if (statement.isAggregate()) {
                return new GroupBy.GroupByBuilder().setScanAttribName("_UngroupedAgg").build();
            }
            if (!statement.isDistinct()) {
                return GroupBy.EMPTY_GROUP_BY;
            }
            groupByNodes = Lists.newArrayListWithExpectedSize(statement.getSelect().size());
            for (AliasedNode aliasedNode : statement.getSelect()) {
                groupByNodes.add(aliasedNode.getNode());
            }
        }
        TrackOrderPreservingExpressionCompiler groupByVisitor = new TrackOrderPreservingExpressionCompiler(context, GroupBy.EMPTY_GROUP_BY, groupByNodes.size(), TrackOrderPreservingExpressionCompiler.Ordering.UNORDERED);
        for (ParseNode node : groupByNodes) {
            Expression expression = node.accept(groupByVisitor);
            if (groupByVisitor.isAggregate()) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.AGGREGATE_IN_GROUP_BY).setMessage(expression.toString()).build().buildException();
            }
            if (!expression.isStateless()) {
                groupByVisitor.addEntry(expression);
            }
            groupByVisitor.reset();
        }
        List<TrackOrderPreservingExpressionCompiler.Entry> groupByEntries = groupByVisitor.getEntries();
        if (groupByEntries.isEmpty()) {
            return GroupBy.EMPTY_GROUP_BY;
        }
        boolean isRowKeyOrderedGrouping = groupByVisitor.isOrderPreserving();
        ArrayList<Expression> keyExpressions = expressions = Lists.newArrayListWithCapacity(groupByEntries.size());
        if (isRowKeyOrderedGrouping) {
            groupExprAttribName = "_OrderedGroupByExpressions";
            for (TrackOrderPreservingExpressionCompiler.Entry groupByEntry : groupByEntries) {
                expressions.add(groupByEntry.getExpression());
            }
        } else {
            groupExprAttribName = "_UnorderedGroupByExpressions";
            Collections.sort(groupByEntries, new Comparator<TrackOrderPreservingExpressionCompiler.Entry>(){

                @Override
                public int compare(TrackOrderPreservingExpressionCompiler.Entry o1, TrackOrderPreservingExpressionCompiler.Entry o2) {
                    boolean isFixedNullable2;
                    Expression e1 = o1.getExpression();
                    Expression e2 = o2.getExpression();
                    boolean isFixed1 = e1.getDataType().isFixedWidth();
                    boolean isFixed2 = e2.getDataType().isFixedWidth();
                    boolean isFixedNullable1 = e1.isNullable() && isFixed1;
                    boolean bl = isFixedNullable2 = e2.isNullable() && isFixed2;
                    if (isFixedNullable1 == isFixedNullable2) {
                        if (isFixed1 == isFixed2) {
                            return o1.getColumnPosition() - o2.getColumnPosition();
                        }
                        if (isFixed1) {
                            return -1;
                        }
                        return 1;
                    }
                    if (isFixedNullable1) {
                        return 1;
                    }
                    return -1;
                }
            });
            for (TrackOrderPreservingExpressionCompiler.Entry groupByEntry : groupByEntries) {
                expressions.add(groupByEntry.getExpression());
            }
            for (int i = expressions.size() - 2; i >= 0; --i) {
                Expression expression = (Expression)expressions.get(i);
                PDataType keyType = GroupByCompiler.getKeyType(expression);
                if (keyType == expression.getDataType()) continue;
                if (keyExpressions == expressions) {
                    keyExpressions = new ArrayList<Expression>(expressions);
                }
                keyExpressions.set(i, CoerceExpression.create(expression, keyType));
            }
        }
        GroupedAggregateRegionObserver.serializeIntoScan(context.getScan(), groupExprAttribName, keyExpressions);
        GroupBy groupBy = new GroupBy.GroupByBuilder().setScanAttribName(groupExprAttribName).setExpressions(expressions).setKeyExpressions(keyExpressions).build();
        return groupBy;
    }

    private static PDataType getKeyType(Expression expression) {
        PDataType type = expression.getDataType();
        if (!expression.isNullable() || !type.isFixedWidth()) {
            return type;
        }
        if (type.isCastableTo(PDataType.DECIMAL)) {
            return PDataType.DECIMAL;
        }
        if (type.isCastableTo(PDataType.VARCHAR)) {
            return PDataType.VARCHAR;
        }
        throw new IllegalStateException("Multiple occurrences of type " + (Object)((Object)type) + " may not occur in a GROUP BY clause");
    }

    private GroupByCompiler() {
    }

    @Immutable
    public static class GroupBy {
        private final List<Expression> expressions;
        private final List<Expression> keyExpressions;
        private final String scanAttribName;
        public static final GroupBy EMPTY_GROUP_BY = new GroupBy(new GroupByBuilder());

        private GroupBy(GroupByBuilder builder) {
            this.expressions = ImmutableList.copyOf(builder.expressions);
            this.keyExpressions = ImmutableList.copyOf(builder.keyExpressions);
            this.scanAttribName = builder.scanAttribName;
            assert (this.expressions.size() == this.keyExpressions.size());
        }

        public List<Expression> getExpressions() {
            return this.expressions;
        }

        public List<Expression> getKeyExpressions() {
            return this.keyExpressions;
        }

        public String getScanAttribName() {
            return this.scanAttribName;
        }

        public boolean isEmpty() {
            return this.expressions.isEmpty();
        }

        public boolean isOrderPreserving() {
            return !"_UnorderedGroupByExpressions".equals(this.scanAttribName);
        }

        public void explain(List<String> planSteps, Integer limit) {
            if (this.scanAttribName != null) {
                if ("_UngroupedAgg".equals(this.scanAttribName)) {
                    planSteps.add("    SERVER AGGREGATE INTO SINGLE ROW");
                } else if ("_UnorderedGroupByExpressions".equals(this.scanAttribName)) {
                    planSteps.add("    SERVER AGGREGATE INTO DISTINCT ROWS BY " + this.getExpressions() + (limit == null ? "" : " LIMIT " + limit + " GROUP" + (limit == 1 ? "" : "S")));
                } else {
                    planSteps.add("    SERVER AGGREGATE INTO ORDERED DISTINCT ROWS BY " + this.getExpressions() + (limit == null ? "" : " LIMIT " + limit + " GROUP" + (limit == 1 ? "" : "S")));
                }
            }
        }

        public static class GroupByBuilder {
            private String scanAttribName;
            private List<Expression> expressions = Collections.emptyList();
            private List<Expression> keyExpressions = Collections.emptyList();

            public GroupByBuilder setScanAttribName(String scanAttribName) {
                this.scanAttribName = scanAttribName;
                return this;
            }

            public GroupByBuilder setExpressions(List<Expression> expressions) {
                this.expressions = expressions;
                return this;
            }

            public GroupByBuilder setKeyExpressions(List<Expression> keyExpressions) {
                this.keyExpressions = keyExpressions;
                return this;
            }

            public GroupBy build() {
                return new GroupBy(this);
            }
        }
    }
}

