/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.sql.SQLException;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.phoenix.compile.ExpressionCompiler;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.parse.AddParseNode;
import org.apache.phoenix.parse.AndParseNode;
import org.apache.phoenix.parse.BetweenParseNode;
import org.apache.phoenix.parse.CaseParseNode;
import org.apache.phoenix.parse.ColumnParseNode;
import org.apache.phoenix.parse.ComparisonParseNode;
import org.apache.phoenix.parse.DivideParseNode;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.parse.IsNullParseNode;
import org.apache.phoenix.parse.MultiplyParseNode;
import org.apache.phoenix.parse.OrParseNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.parse.SelectStatementRewriter;
import org.apache.phoenix.parse.SubtractParseNode;
import org.apache.phoenix.parse.TraverseNoParseNodeVisitor;
import org.apache.phoenix.schema.ColumnRef;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.TypeMismatchException;

public class HavingCompiler {
    private HavingCompiler() {
    }

    public static Expression compile(StatementContext context, SelectStatement statement, GroupByCompiler.GroupBy groupBy) throws SQLException {
        ParseNode having = statement.getHaving();
        if (having == null) {
            return null;
        }
        ExpressionCompiler expressionBuilder = new ExpressionCompiler(context, groupBy);
        Expression expression = having.accept(expressionBuilder);
        if (expression.getDataType() != PDataType.BOOLEAN) {
            throw TypeMismatchException.newException(PDataType.BOOLEAN, expression.getDataType(), expression.toString());
        }
        if (LiteralExpression.isFalse(expression)) {
            context.setScanRanges(ScanRanges.NOTHING);
            return null;
        }
        if (LiteralExpression.isTrue(expression)) {
            return null;
        }
        if (!expressionBuilder.isAggregate()) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.ONLY_AGGREGATE_IN_HAVING_CLAUSE).build().buildException();
        }
        return expression;
    }

    public static SelectStatement rewrite(StatementContext context, SelectStatement statement, GroupByCompiler.GroupBy groupBy) throws SQLException {
        ParseNode having = statement.getHaving();
        if (having == null) {
            return statement;
        }
        HavingClauseVisitor visitor = new HavingClauseVisitor(context, groupBy);
        having.accept(visitor);
        statement = SelectStatementRewriter.moveFromHavingToWhereClause(statement, visitor.getMoveToWhereClauseExpressions());
        return statement;
    }

    private static class HavingClauseVisitor
    extends TraverseNoParseNodeVisitor<Void> {
        private ParseNode topNode = null;
        private boolean hasNoAggregateFunctions = true;
        private Boolean hasOnlyAggregateColumns;
        private final StatementContext context;
        private final GroupByCompiler.GroupBy groupBy;
        private final Set<ParseNode> moveToWhereClause = new LinkedHashSet<ParseNode>();

        HavingClauseVisitor(StatementContext context, GroupByCompiler.GroupBy groupBy) {
            this.context = context;
            this.groupBy = groupBy;
        }

        public Set<ParseNode> getMoveToWhereClauseExpressions() {
            return this.moveToWhereClause;
        }

        @Override
        public boolean visitEnter(AndParseNode node) throws SQLException {
            return true;
        }

        @Override
        public boolean visitEnter(OrParseNode node) throws SQLException {
            this.enterBooleanNode(node);
            return true;
        }

        @Override
        public boolean visitEnter(ComparisonParseNode node) throws SQLException {
            this.enterBooleanNode(node);
            return true;
        }

        @Override
        public boolean visitEnter(IsNullParseNode node) throws SQLException {
            this.enterBooleanNode(node);
            return true;
        }

        private void enterBooleanNode(ParseNode node) {
            if (this.topNode == null) {
                this.topNode = node;
            }
        }

        private void leaveBooleanNode(ParseNode node) {
            if (this.topNode == node) {
                if (this.hasNoAggregateFunctions && !Boolean.FALSE.equals(this.hasOnlyAggregateColumns)) {
                    this.moveToWhereClause.add(node);
                }
                this.hasNoAggregateFunctions = true;
                this.hasOnlyAggregateColumns = null;
                this.topNode = null;
            }
        }

        @Override
        public Void visitLeave(OrParseNode node, List<Void> l) throws SQLException {
            this.leaveBooleanNode(node);
            return null;
        }

        @Override
        public Void visitLeave(ComparisonParseNode node, List<Void> l) throws SQLException {
            this.leaveBooleanNode(node);
            return null;
        }

        @Override
        public Void visitLeave(IsNullParseNode node, List<Void> l) throws SQLException {
            this.leaveBooleanNode(node);
            return null;
        }

        @Override
        public boolean visitEnter(FunctionParseNode node) throws SQLException {
            boolean isAggregate = node.isAggregate();
            this.hasNoAggregateFunctions = this.hasNoAggregateFunctions && !isAggregate;
            return !isAggregate;
        }

        @Override
        public boolean visitEnter(CaseParseNode node) throws SQLException {
            return true;
        }

        @Override
        public Void visit(ColumnParseNode node) throws SQLException {
            ColumnRef ref = this.context.getResolver().resolveColumn(node.getSchemaName(), node.getTableName(), node.getName());
            boolean isAggregateColumn = this.groupBy.getExpressions().indexOf(ref.newColumnExpression()) >= 0;
            this.hasOnlyAggregateColumns = this.hasOnlyAggregateColumns == null ? Boolean.valueOf(isAggregateColumn) : Boolean.valueOf(this.hasOnlyAggregateColumns & isAggregateColumn);
            return null;
        }

        @Override
        public boolean visitEnter(SubtractParseNode node) throws SQLException {
            return true;
        }

        @Override
        public boolean visitEnter(AddParseNode node) throws SQLException {
            return true;
        }

        @Override
        public boolean visitEnter(MultiplyParseNode node) throws SQLException {
            return true;
        }

        @Override
        public boolean visitEnter(DivideParseNode node) throws SQLException {
            return true;
        }

        @Override
        public boolean visitEnter(BetweenParseNode node) throws SQLException {
            return true;
        }
    }
}

