/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.compile.ExpressionCompiler;
import org.apache.phoenix.compile.IndexStatementRewriter;
import org.apache.phoenix.compile.QueryCompiler;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.expression.AndExpression;
import org.apache.phoenix.expression.CoerceExpression;
import org.apache.phoenix.expression.ColumnExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.join.ScanProjector;
import org.apache.phoenix.parse.AliasedNode;
import org.apache.phoenix.parse.AndParseNode;
import org.apache.phoenix.parse.BetweenParseNode;
import org.apache.phoenix.parse.BindTableNode;
import org.apache.phoenix.parse.CaseParseNode;
import org.apache.phoenix.parse.CastParseNode;
import org.apache.phoenix.parse.ColumnDef;
import org.apache.phoenix.parse.ColumnParseNode;
import org.apache.phoenix.parse.ComparisonParseNode;
import org.apache.phoenix.parse.ConcreteTableNode;
import org.apache.phoenix.parse.DerivedTableNode;
import org.apache.phoenix.parse.EqualParseNode;
import org.apache.phoenix.parse.FunctionParseNode;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.parse.InListParseNode;
import org.apache.phoenix.parse.IsNullParseNode;
import org.apache.phoenix.parse.JoinTableNode;
import org.apache.phoenix.parse.LikeParseNode;
import org.apache.phoenix.parse.NamedTableNode;
import org.apache.phoenix.parse.NotParseNode;
import org.apache.phoenix.parse.OrParseNode;
import org.apache.phoenix.parse.OrderByNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.ParseNodeFactory;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.parse.StatelessTraverseAllParseNodeVisitor;
import org.apache.phoenix.parse.TableName;
import org.apache.phoenix.parse.TableNode;
import org.apache.phoenix.parse.TableNodeVisitor;
import org.apache.phoenix.parse.TableWildcardParseNode;
import org.apache.phoenix.parse.TraverseNoParseNodeVisitor;
import org.apache.phoenix.parse.WildcardParseNode;
import org.apache.phoenix.schema.AmbiguousColumnException;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.ColumnRef;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnImpl;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableImpl;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.SaltingUtil;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.util.SchemaUtil;

public class JoinCompiler {
    private static String PROJECTED_TABLE_SCHEMA = ".";
    private static ParseNodeFactory NODE_FACTORY = new ParseNodeFactory();

    public static JoinSpec getSubJoinSpecWithoutPostFilters(JoinSpec join) {
        return new JoinSpec(join.origResolver, join.mainTableNode, join.dynamicColumns, join.mainTable, join.select, join.preFilters, new ArrayList(), join.joinTables.subList(0, join.joinTables.size() - 1), join.useStarJoin, join.tableRefToJoinTableMap, join.columnRefs);
    }

    private static List<AliasedNode> extractFromSelect(List<AliasedNode> select, TableRef table, ColumnResolver resolver) throws SQLException {
        ArrayList<AliasedNode> ret = new ArrayList<AliasedNode>();
        ColumnParseNodeVisitor visitor = new ColumnParseNodeVisitor(resolver);
        for (AliasedNode aliasedNode : select) {
            ParseNode node = aliasedNode.getNode();
            if (node instanceof TableWildcardParseNode) {
                TableName tableName = ((TableWildcardParseNode)node).getTableName();
                if (!table.equals(resolver.resolveTable(tableName.getSchemaName(), tableName.getTableName()))) continue;
                ret.clear();
                ret.add(aliasedNode);
                return ret;
            }
            node.accept(visitor);
            ColumnParseNodeVisitor.ContentType type = visitor.getContentType(table);
            if (type == ColumnParseNodeVisitor.ContentType.SELF_ONLY) {
                ret.add(aliasedNode);
            } else if (type == ColumnParseNodeVisitor.ContentType.COMPLEX) {
                for (Map.Entry<ColumnRef, ColumnParseNode> entry : visitor.getColumnRefMap().entrySet()) {
                    if (!entry.getKey().getTableRef().equals(table)) continue;
                    ret.add(NODE_FACTORY.aliasedNode(null, entry.getValue()));
                }
            }
            visitor.reset();
        }
        return ret;
    }

    public static JoinSpec getJoinSpec(StatementContext context, SelectStatement statement) throws SQLException {
        return new JoinSpec(statement, context.getResolver());
    }

    public static SelectStatement optimize(StatementContext context, SelectStatement select, PhoenixStatement statement) throws SQLException {
        class TableNodeRewriter
        implements TableNodeVisitor {
            private TableRef table;
            private TableNode replaced;

            TableNodeRewriter(TableRef table) {
                this.table = table;
            }

            public TableNode getReplacedTableNode() {
                return this.replaced;
            }

            @Override
            public void visit(BindTableNode boundTableNode) throws SQLException {
                String alias = boundTableNode.getAlias();
                this.replaced = NODE_FACTORY.bindTable(alias == null ? null : '\"' + alias + '\"', this.getReplacedTableName());
            }

            @Override
            public void visit(JoinTableNode joinNode) throws SQLException {
                joinNode.getTable().accept(this);
                this.replaced = NODE_FACTORY.join(joinNode.getType(), joinNode.getOnNode(), this.replaced);
            }

            @Override
            public void visit(NamedTableNode namedTableNode) throws SQLException {
                String alias = namedTableNode.getAlias();
                this.replaced = NODE_FACTORY.namedTable(alias == null ? null : '\"' + alias + '\"', this.getReplacedTableName(), namedTableNode.getDynamicColumns());
            }

            @Override
            public void visit(DerivedTableNode subselectNode) throws SQLException {
                throw new SQLFeatureNotSupportedException();
            }

            private TableName getReplacedTableName() {
                String schemaName = this.table.getTable().getSchemaName().getString();
                return TableName.create(schemaName.length() == 0 ? null : schemaName, this.table.getTable().getTableName().getString());
            }
        }
        Set<TableRef> set;
        ColumnResolver resolver = context.getResolver();
        TableRef groupByTableRef = null;
        TableRef orderByTableRef = null;
        if (select.getGroupBy() != null && !select.getGroupBy().isEmpty()) {
            ColumnParseNodeVisitor groupByVisitor = new ColumnParseNodeVisitor(resolver);
            for (ParseNode parseNode : select.getGroupBy()) {
                parseNode.accept(groupByVisitor);
            }
            set = groupByVisitor.getTableRefSet();
            if (set.size() == 1) {
                groupByTableRef = set.iterator().next();
            }
        } else if (select.getOrderBy() != null && !select.getOrderBy().isEmpty()) {
            ColumnParseNodeVisitor orderByVisitor = new ColumnParseNodeVisitor(resolver);
            for (OrderByNode orderByNode : select.getOrderBy()) {
                orderByNode.getNode().accept(orderByVisitor);
            }
            set = orderByVisitor.getTableRefSet();
            if (set.size() == 1) {
                orderByTableRef = set.iterator().next();
            }
        }
        JoinSpec join = JoinCompiler.getJoinSpec(context, select);
        if (groupByTableRef != null || orderByTableRef != null) {
            QueryCompiler compiler = new QueryCompiler(statement, select, resolver);
            List<Object> list = statement.getParameters();
            StatementContext ctx = new StatementContext(statement, resolver, new Scan());
            QueryPlan plan = compiler.compileJoinQuery(ctx, select, list, join, false);
            TableRef table = plan.getTableRef();
            if (groupByTableRef != null && !groupByTableRef.equals(table)) {
                groupByTableRef = null;
            }
            if (orderByTableRef != null && !orderByTableRef.equals(table)) {
                orderByTableRef = null;
            }
        }
        HashMap<TableRef, TableRef> replacement = new HashMap<TableRef, TableRef>();
        List<TableNode> list = select.getFrom();
        ArrayList<TableNode> newFrom = Lists.newArrayListWithExpectedSize(list.size());
        for (int i = 1; i < list.size(); ++i) {
            TableNode jNode = list.get(i);
            assert (jNode instanceof JoinTableNode);
            TableNode tNode = ((JoinTableNode)jNode).getTable();
            for (JoinTable jTable : join.getJoinTables()) {
                if (jTable.getTableNode() != tNode) continue;
                TableRef table = jTable.getTable();
                List<ParseNode> groupBy = table.equals(groupByTableRef) ? select.getGroupBy() : null;
                List<OrderByNode> orderBy = table.equals(orderByTableRef) ? select.getOrderBy() : null;
                SelectStatement stmt = JoinCompiler.getSubqueryForOptimizedPlan(select.getHint(), ((JoinTable)join.tableRefToJoinTableMap.get(table)).getDynamicColumns(), table, join.columnRefs, jTable.getPreFiltersCombined(), groupBy, orderBy, join.isWildCardSelect(table));
                QueryPlan plan = context.getConnection().getQueryServices().getOptimizer().optimize(statement, stmt);
                if (!plan.getTableRef().equals(table)) {
                    TableNodeRewriter rewriter = new TableNodeRewriter(plan.getTableRef());
                    jNode.accept(rewriter);
                    newFrom.add(rewriter.getReplacedTableNode());
                    replacement.put(table, plan.getTableRef());
                    continue;
                }
                newFrom.add(jNode);
            }
        }
        TableRef table = join.getMainTable();
        List<ParseNode> groupBy = table.equals(groupByTableRef) ? select.getGroupBy() : null;
        List<OrderByNode> orderBy = table.equals(orderByTableRef) ? select.getOrderBy() : null;
        SelectStatement stmt = JoinCompiler.getSubqueryForOptimizedPlan(select.getHint(), join.dynamicColumns, table, join.columnRefs, join.getPreFiltersCombined(), groupBy, orderBy, join.isWildCardSelect(table));
        QueryPlan plan = context.getConnection().getQueryServices().getOptimizer().optimize(statement, stmt);
        if (!plan.getTableRef().equals(table)) {
            TableNodeRewriter rewriter = new TableNodeRewriter(plan.getTableRef());
            list.get(0).accept(rewriter);
            newFrom.add(0, rewriter.getReplacedTableNode());
            replacement.put(table, plan.getTableRef());
        } else {
            newFrom.add(0, list.get(0));
        }
        if (replacement.isEmpty()) {
            return select;
        }
        return IndexStatementRewriter.translate(NODE_FACTORY.select(select, newFrom), resolver, replacement);
    }

    private static SelectStatement getSubqueryForOptimizedPlan(HintNode hintNode, List<ColumnDef> dynamicCols, TableRef tableRef, Map<ColumnRef, ColumnRefType> columnRefs, ParseNode where, List<ParseNode> groupBy, List<OrderByNode> orderBy, boolean isWildCardSelect) {
        String schemaName = tableRef.getTable().getSchemaName().getString();
        TableName tName = TableName.create(schemaName.length() == 0 ? null : schemaName, tableRef.getTable().getTableName().getString());
        ArrayList<AliasedNode> selectList = new ArrayList<AliasedNode>();
        if (isWildCardSelect) {
            selectList.add(NODE_FACTORY.aliasedNode(null, WildcardParseNode.INSTANCE));
        } else {
            for (ColumnRef colRef : columnRefs.keySet()) {
                if (!colRef.getTableRef().equals(tableRef)) continue;
                ParseNode node = NODE_FACTORY.column(tName, '\"' + colRef.getColumn().getName().getString() + '\"', null);
                if (groupBy != null) {
                    node = NODE_FACTORY.function("COUNT", Collections.singletonList(node));
                }
                selectList.add(NODE_FACTORY.aliasedNode(null, node));
            }
        }
        String tableAlias = tableRef.getTableAlias();
        List<NamedTableNode> from = Collections.singletonList(NODE_FACTORY.namedTable(tableAlias == null ? null : '\"' + tableAlias + '\"', tName, dynamicCols));
        return NODE_FACTORY.select(from, hintNode, false, selectList, where, groupBy, null, orderBy, null, 0, false);
    }

    public static SelectStatement getSubqueryWithoutJoin(SelectStatement statement, JoinSpec join) {
        return NODE_FACTORY.select(statement.getFrom().subList(0, 1), statement.getHint(), statement.isDistinct(), statement.getSelect(), join.getPreFiltersCombined(), statement.getGroupBy(), statement.getHaving(), statement.getOrderBy(), statement.getLimit(), statement.getBindCount(), statement.isAggregate());
    }

    public static SelectStatement getSubqueryForLastJoinTable(SelectStatement statement, JoinSpec join) throws SQLException {
        List<JoinTable> joinTables = join.getJoinTables();
        int count = joinTables.size();
        assert (count > 0);
        JoinTable lastJoinTable = joinTables.get(count - 1);
        if (lastJoinTable.getSubquery() != null) {
            throw new SQLFeatureNotSupportedException("Subqueries not supported.");
        }
        ArrayList<TableNode> from = new ArrayList<TableNode>(1);
        from.add(lastJoinTable.getTableNode());
        return NODE_FACTORY.select(from, statement.getHint(), statement.isDistinct(), statement.getSelect(), lastJoinTable.getPreFiltersCombined(), statement.getGroupBy(), statement.getHaving(), statement.getOrderBy(), statement.getLimit(), statement.getBindCount(), statement.isAggregate());
    }

    public static SelectStatement getSubQueryWithoutLastJoin(SelectStatement statement, JoinSpec join) {
        List<TableNode> from = statement.getFrom();
        assert (from.size() > 1);
        List<JoinTable> joinTables = join.getJoinTables();
        int count = joinTables.size();
        assert (count > 0);
        ArrayList<AliasedNode> select = new ArrayList<AliasedNode>();
        select.addAll(join.getSelect());
        for (int i = 0; i < count - 1; ++i) {
            select.addAll(joinTables.get(i).getSelect());
        }
        return NODE_FACTORY.select(from.subList(0, from.size() - 1), statement.getHint(), false, select, join.getPreFiltersCombined(), null, null, null, null, statement.getBindCount(), false);
    }

    public static PTableWrapper mergeProjectedTables(PTableWrapper lWrapper, PTableWrapper rWrapper, boolean innerJoin) throws SQLException {
        PTable left = lWrapper.getTable();
        PTable right = rWrapper.getTable();
        ArrayList<PColumn> merged = new ArrayList<PColumn>();
        merged.addAll(left.getColumns());
        int position = merged.size();
        for (PColumn c : right.getColumns()) {
            if (SchemaUtil.isPKColumn(c)) continue;
            PColumnImpl column = new PColumnImpl(c.getName(), PNameFactory.newName(ScanProjector.VALUE_COLUMN_FAMILY), c.getDataType(), c.getMaxLength(), c.getScale(), innerJoin ? c.isNullable() : true, position++, c.getSortOrder(), c.getArraySize(), c.getViewConstant(), c.isViewReferenced());
            merged.add(column);
        }
        if (left.getBucketNum() != null) {
            merged.remove(0);
        }
        PTableImpl t = PTableImpl.makePTable(left.getTenantId(), left.getSchemaName(), PNameFactory.newName(SchemaUtil.getTableName(left.getName().getString(), right.getName().getString())), left.getType(), left.getIndexState(), left.getTimeStamp(), left.getSequenceNumber(), left.getPKName(), left.getBucketNum(), merged, left.getParentTableName(), left.getIndexes(), left.isImmutableRows(), Collections.<PName>emptyList(), null, null, false, left.isMultiTenant(), left.getViewType(), left.getViewIndexId());
        ArrayListMultimap<String, String> mergedMap = ArrayListMultimap.create();
        mergedMap.putAll(lWrapper.getColumnNameMap());
        mergedMap.putAll(rWrapper.getColumnNameMap());
        return new PTableWrapper(t, mergedMap);
    }

    public static ScanProjector getScanProjector(ProjectedPTableWrapper table) {
        return new ScanProjector(table);
    }

    private static String getProjectedColumnName(String schemaName, String tableName, String colName) {
        return SchemaUtil.getColumnName(SchemaUtil.getTableName(schemaName, tableName), colName);
    }

    private static class DynamicColumnsVisitor
    implements TableNodeVisitor {
        private List<ColumnDef> dynamicCols;

        public List<ColumnDef> getDynamicColumns() {
            return this.dynamicCols == null ? Collections.emptyList() : this.dynamicCols;
        }

        @Override
        public void visit(BindTableNode boundTableNode) throws SQLException {
        }

        @Override
        public void visit(JoinTableNode joinNode) throws SQLException {
            assert (false);
        }

        @Override
        public void visit(NamedTableNode namedTableNode) throws SQLException {
            this.dynamicCols = namedTableNode.getDynamicColumns();
        }

        @Override
        public void visit(DerivedTableNode subselectNode) throws SQLException {
            throw new SQLFeatureNotSupportedException();
        }
    }

    public static class JoinedTableColumnResolver
    implements ColumnResolver {
        private PTableWrapper table;
        private ColumnResolver tableResolver;
        private TableRef tableRef;

        private JoinedTableColumnResolver(PTableWrapper table, ColumnResolver tableResolver) {
            this.table = table;
            this.tableResolver = tableResolver;
            this.tableRef = new TableRef(null, table.getTable(), 0L, false);
        }

        public PTableWrapper getPTableWrapper() {
            return this.table;
        }

        @Override
        public List<TableRef> getTables() {
            return this.tableResolver.getTables();
        }

        @Override
        public TableRef resolveTable(String schemaName, String tableName) throws SQLException {
            return this.tableResolver.resolveTable(schemaName, tableName);
        }

        @Override
        public ColumnRef resolveColumn(String schemaName, String tableName, String colName) throws SQLException {
            String name = JoinCompiler.getProjectedColumnName(schemaName, tableName, colName);
            try {
                PColumn column = this.tableRef.getTable().getColumn(name);
                return new ColumnRef(this.tableRef, column.getPosition());
            }
            catch (ColumnNotFoundException e) {
                List<String> names = this.table.getMappedColumnName(name);
                if (names.size() == 1) {
                    PColumn column = this.tableRef.getTable().getColumn(names.get(0));
                    return new ColumnRef(this.tableRef, column.getPosition());
                }
                if (names.size() > 1) {
                    throw new AmbiguousColumnException(name);
                }
                throw e;
            }
        }
    }

    public static class ProjectedPTableWrapper
    extends PTableWrapper {
        private List<Expression> sourceExpressions;

        protected ProjectedPTableWrapper(PTable table, ListMultimap<String, String> columnNameMap, List<Expression> sourceExpressions) {
            super(table, columnNameMap);
            this.sourceExpressions = sourceExpressions;
        }

        public Expression getSourceExpression(PColumn column) {
            return this.sourceExpressions.get(column.getPosition() - (this.table.getBucketNum() == null ? 0 : 1));
        }
    }

    public static class PTableWrapper {
        protected PTable table;
        protected ListMultimap<String, String> columnNameMap;

        protected PTableWrapper(PTable table, ListMultimap<String, String> columnNameMap) {
            this.table = table;
            this.columnNameMap = columnNameMap;
        }

        public PTable getTable() {
            return this.table;
        }

        public ListMultimap<String, String> getColumnNameMap() {
            return this.columnNameMap;
        }

        public List<String> getMappedColumnName(String name) {
            return this.columnNameMap.get(name);
        }
    }

    private static class ColumnParseNodeVisitor
    extends StatelessTraverseAllParseNodeVisitor {
        private ColumnResolver resolver;
        private final Set<TableRef> tableRefSet;
        private final Map<ColumnRef, ColumnParseNode> columnRefMap;

        public ColumnParseNodeVisitor(ColumnResolver resolver) {
            this.resolver = resolver;
            this.tableRefSet = new HashSet<TableRef>();
            this.columnRefMap = new HashMap<ColumnRef, ColumnParseNode>();
        }

        public void reset() {
            this.tableRefSet.clear();
            this.columnRefMap.clear();
        }

        @Override
        public Void visit(ColumnParseNode node) throws SQLException {
            ColumnRef columnRef = this.resolver.resolveColumn(node.getSchemaName(), node.getTableName(), node.getName());
            this.columnRefMap.put(columnRef, node);
            this.tableRefSet.add(columnRef.getTableRef());
            return null;
        }

        public Set<TableRef> getTableRefSet() {
            return this.tableRefSet;
        }

        public Map<ColumnRef, ColumnParseNode> getColumnRefMap() {
            return this.columnRefMap;
        }

        public ContentType getContentType(TableRef selfTable) {
            if (this.tableRefSet.isEmpty()) {
                return ContentType.NONE;
            }
            if (this.tableRefSet.size() > 1) {
                return ContentType.COMPLEX;
            }
            if (this.tableRefSet.contains(selfTable)) {
                return ContentType.SELF_ONLY;
            }
            return ContentType.FOREIGN_ONLY;
        }

        public static enum ContentType {
            NONE,
            SELF_ONLY,
            FOREIGN_ONLY,
            COMPLEX;

        }
    }

    public static class JoinTable {
        private JoinTableNode.JoinType type;
        private TableNode tableNode;
        private List<ColumnDef> dynamicColumns;
        private TableRef table;
        private List<AliasedNode> select;
        private HintNode hint;
        private List<ParseNode> preFilters;
        private List<ParseNode> conditions;
        private SelectStatement subquery;
        private Set<TableRef> leftTableRefs;

        public JoinTable(JoinTableNode node, TableRef tableRef, SelectStatement statement, ColumnResolver resolver) throws SQLException {
            if (!(node.getTable() instanceof ConcreteTableNode)) {
                throw new SQLFeatureNotSupportedException("Subqueries not supported.");
            }
            this.type = node.getType();
            this.tableNode = node.getTable();
            DynamicColumnsVisitor v = new DynamicColumnsVisitor();
            this.tableNode.accept(v);
            this.dynamicColumns = v.getDynamicColumns();
            this.table = tableRef;
            this.select = JoinCompiler.extractFromSelect(statement.getSelect(), tableRef, resolver);
            this.hint = statement.getHint();
            this.preFilters = new ArrayList<ParseNode>();
            this.conditions = new ArrayList<ParseNode>();
            this.leftTableRefs = new HashSet<TableRef>();
            node.getOnNode().accept(new OnNodeVisitor(resolver));
        }

        public JoinTableNode.JoinType getType() {
            return this.type;
        }

        public TableNode getTableNode() {
            return this.tableNode;
        }

        public List<ColumnDef> getDynamicColumns() {
            return this.dynamicColumns;
        }

        public TableRef getTable() {
            return this.table;
        }

        public List<AliasedNode> getSelect() {
            return this.select;
        }

        public List<ParseNode> getPreFilters() {
            return this.preFilters;
        }

        public List<ParseNode> getJoinConditions() {
            return this.conditions;
        }

        public SelectStatement getSubquery() {
            return this.subquery;
        }

        public Set<TableRef> getLeftTableRefs() {
            return this.leftTableRefs;
        }

        public ParseNode getPreFiltersCombined() {
            if (this.preFilters == null || this.preFilters.isEmpty()) {
                return null;
            }
            if (this.preFilters.size() == 1) {
                return this.preFilters.get(0);
            }
            return NODE_FACTORY.and(this.preFilters);
        }

        public SelectStatement getAsSubquery() {
            if (this.subquery != null) {
                return this.subquery;
            }
            ArrayList<TableNode> from = new ArrayList<TableNode>(1);
            from.add(this.tableNode);
            return NODE_FACTORY.select(from, this.hint, false, this.select, this.getPreFiltersCombined(), null, null, null, null, 0, false);
        }

        public Pair<List<Expression>, List<Expression>> compileJoinConditions(StatementContext context, ColumnResolver leftResolver, ColumnResolver rightResolver) throws SQLException {
            ColumnResolver resolver = context.getResolver();
            ArrayList<Pair<Expression, Object>> compiled = new ArrayList<Pair<Expression, Object>>(this.conditions.size());
            context.setResolver(leftResolver);
            ExpressionCompiler expressionCompiler = new ExpressionCompiler(context);
            for (ParseNode condition : this.conditions) {
                assert (condition instanceof EqualParseNode);
                EqualParseNode equalNode = (EqualParseNode)condition;
                expressionCompiler.reset();
                Expression left = equalNode.getLHS().accept(expressionCompiler);
                compiled.add(new Pair<Expression, Object>(left, null));
            }
            context.setResolver(rightResolver);
            expressionCompiler = new ExpressionCompiler(context);
            Iterator iter = compiled.iterator();
            for (ParseNode condition : this.conditions) {
                Pair p = (Pair)iter.next();
                EqualParseNode equalParseNode = (EqualParseNode)condition;
                expressionCompiler.reset();
                Expression right = equalParseNode.getRHS().accept(expressionCompiler);
                Expression left = (Expression)p.getFirst();
                PDataType toType = this.getCommonType(left.getDataType(), right.getDataType());
                if (left.getDataType() != toType) {
                    left = CoerceExpression.create(left, toType);
                    p.setFirst(left);
                }
                if (right.getDataType() != toType) {
                    right = CoerceExpression.create(right, toType);
                }
                p.setSecond(right);
            }
            context.setResolver(resolver);
            Collections.sort(compiled, new Comparator<Pair<Expression, Expression>>(){

                @Override
                public int compare(Pair<Expression, Expression> o1, Pair<Expression, Expression> o2) {
                    boolean isFixedNullable2;
                    Expression e1 = o1.getFirst();
                    Expression e2 = o2.getFirst();
                    boolean isFixed1 = e1.getDataType().isFixedWidth();
                    boolean isFixed2 = e2.getDataType().isFixedWidth();
                    boolean isFixedNullable1 = e1.isNullable() && isFixed1;
                    boolean bl = isFixedNullable2 = e2.isNullable() && isFixed2;
                    if (isFixedNullable1 == isFixedNullable2) {
                        if (isFixed1 == isFixed2) {
                            return 0;
                        }
                        if (isFixed1) {
                            return -1;
                        }
                        return 1;
                    }
                    if (isFixedNullable1) {
                        return 1;
                    }
                    return -1;
                }
            });
            ArrayList lConditions = new ArrayList(compiled.size());
            ArrayList rConditions = new ArrayList(compiled.size());
            for (Pair pair : compiled) {
                lConditions.add(pair.getFirst());
                rConditions.add(pair.getSecond());
            }
            return new Pair<List<Expression>, List<Expression>>(lConditions, rConditions);
        }

        private PDataType getCommonType(PDataType lType, PDataType rType) throws SQLException {
            if (lType == rType) {
                return lType;
            }
            if (!lType.isComparableTo(rType)) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_CONVERT_TYPE).setMessage("On-clause LHS expression and RHS expression must be comparable. LHS type: " + (Object)((Object)lType) + ", RHS type: " + (Object)((Object)rType)).build().buildException();
            }
            if ((lType == null || lType.isCoercibleTo(PDataType.TINYINT)) && (rType == null || rType.isCoercibleTo(PDataType.TINYINT))) {
                return lType == null ? rType : lType;
            }
            if ((lType == null || lType.isCoercibleTo(PDataType.SMALLINT)) && (rType == null || rType.isCoercibleTo(PDataType.SMALLINT))) {
                return lType == null ? rType : lType;
            }
            if ((lType == null || lType.isCoercibleTo(PDataType.INTEGER)) && (rType == null || rType.isCoercibleTo(PDataType.INTEGER))) {
                return lType == null ? rType : lType;
            }
            if ((lType == null || lType.isCoercibleTo(PDataType.LONG)) && (rType == null || rType.isCoercibleTo(PDataType.LONG))) {
                return lType == null ? rType : lType;
            }
            if ((lType == null || lType.isCoercibleTo(PDataType.DOUBLE)) && (rType == null || rType.isCoercibleTo(PDataType.DOUBLE))) {
                return lType == null ? rType : lType;
            }
            if ((lType == null || lType.isCoercibleTo(PDataType.DECIMAL)) && (rType == null || rType.isCoercibleTo(PDataType.DECIMAL))) {
                return PDataType.DECIMAL;
            }
            if ((lType == null || lType.isCoercibleTo(PDataType.DATE)) && (rType == null || rType.isCoercibleTo(PDataType.DATE))) {
                return lType == null ? rType : lType;
            }
            if ((lType == null || lType.isCoercibleTo(PDataType.TIMESTAMP)) && (rType == null || rType.isCoercibleTo(PDataType.TIMESTAMP))) {
                return lType == null ? rType : lType;
            }
            if ((lType == null || lType.isCoercibleTo(PDataType.VARCHAR)) && (rType == null || rType.isCoercibleTo(PDataType.VARCHAR))) {
                return PDataType.VARCHAR;
            }
            if ((lType == null || lType.isCoercibleTo(PDataType.BOOLEAN)) && (rType == null || rType.isCoercibleTo(PDataType.BOOLEAN))) {
                return PDataType.BOOLEAN;
            }
            return PDataType.VARBINARY;
        }

        private class OnNodeVisitor
        extends TraverseNoParseNodeVisitor<Void> {
            private ColumnResolver resolver;

            public OnNodeVisitor(ColumnResolver resolver) {
                this.resolver = resolver;
            }

            private Void leaveNonEqBooleanNode(ParseNode node, List<Void> l) throws SQLException {
                ColumnParseNodeVisitor visitor = new ColumnParseNodeVisitor(this.resolver);
                node.accept(visitor);
                ColumnParseNodeVisitor.ContentType type = visitor.getContentType(JoinTable.this.table);
                if (type == ColumnParseNodeVisitor.ContentType.NONE || type == ColumnParseNodeVisitor.ContentType.SELF_ONLY) {
                    JoinTable.this.preFilters.add(node);
                } else {
                    this.throwUnsupportedJoinConditionException();
                }
                return null;
            }

            @Override
            public Void visitLeave(LikeParseNode node, List<Void> l) throws SQLException {
                return this.leaveNonEqBooleanNode(node, l);
            }

            @Override
            public boolean visitEnter(AndParseNode node) {
                return true;
            }

            @Override
            public Void visitLeave(OrParseNode node, List<Void> l) throws SQLException {
                return this.leaveNonEqBooleanNode(node, l);
            }

            @Override
            public Void visitLeave(ComparisonParseNode node, List<Void> l) throws SQLException {
                if (!(node instanceof EqualParseNode)) {
                    return this.leaveNonEqBooleanNode(node, l);
                }
                ColumnParseNodeVisitor lhsVisitor = new ColumnParseNodeVisitor(this.resolver);
                ColumnParseNodeVisitor rhsVisitor = new ColumnParseNodeVisitor(this.resolver);
                node.getLHS().accept(lhsVisitor);
                node.getRHS().accept(rhsVisitor);
                ColumnParseNodeVisitor.ContentType lhsType = lhsVisitor.getContentType(JoinTable.this.table);
                ColumnParseNodeVisitor.ContentType rhsType = rhsVisitor.getContentType(JoinTable.this.table);
                if (!(lhsType != ColumnParseNodeVisitor.ContentType.SELF_ONLY && lhsType != ColumnParseNodeVisitor.ContentType.NONE || rhsType != ColumnParseNodeVisitor.ContentType.SELF_ONLY && rhsType != ColumnParseNodeVisitor.ContentType.NONE)) {
                    JoinTable.this.preFilters.add(node);
                } else if (lhsType == ColumnParseNodeVisitor.ContentType.FOREIGN_ONLY && rhsType == ColumnParseNodeVisitor.ContentType.SELF_ONLY) {
                    JoinTable.this.conditions.add(node);
                    JoinTable.this.leftTableRefs.addAll(lhsVisitor.getTableRefSet());
                } else if (rhsType == ColumnParseNodeVisitor.ContentType.FOREIGN_ONLY && lhsType == ColumnParseNodeVisitor.ContentType.SELF_ONLY) {
                    JoinTable.this.conditions.add(NODE_FACTORY.equal(node.getRHS(), node.getLHS()));
                    JoinTable.this.leftTableRefs.addAll(rhsVisitor.getTableRefSet());
                } else {
                    this.throwUnsupportedJoinConditionException();
                }
                return null;
            }

            @Override
            public Void visitLeave(NotParseNode node, List<Void> l) throws SQLException {
                return this.leaveNonEqBooleanNode(node, l);
            }

            @Override
            public Void visitLeave(InListParseNode node, List<Void> l) throws SQLException {
                return this.leaveNonEqBooleanNode(node, l);
            }

            @Override
            public Void visitLeave(IsNullParseNode node, List<Void> l) throws SQLException {
                return this.leaveNonEqBooleanNode(node, l);
            }

            @Override
            public Void visitLeave(FunctionParseNode node, List<Void> l) throws SQLException {
                return this.leaveNonEqBooleanNode(node, l);
            }

            @Override
            public Void visitLeave(BetweenParseNode node, List<Void> l) throws SQLException {
                return this.leaveNonEqBooleanNode(node, l);
            }

            @Override
            public Void visitLeave(CaseParseNode node, List<Void> l) throws SQLException {
                return this.leaveNonEqBooleanNode(node, l);
            }

            @Override
            public Void visitLeave(CastParseNode node, List<Void> l) throws SQLException {
                return this.leaveNonEqBooleanNode(node, l);
            }

            private void throwUnsupportedJoinConditionException() throws SQLFeatureNotSupportedException {
                throw new SQLFeatureNotSupportedException("Does not support non-standard or non-equi join conditions.");
            }
        }
    }

    public static class JoinSpec {
        private ColumnResolver origResolver;
        private TableNode mainTableNode;
        private List<ColumnDef> dynamicColumns;
        private TableRef mainTable;
        private List<AliasedNode> select;
        private List<ParseNode> preFilters;
        private List<ParseNode> postFilters;
        private List<JoinTable> joinTables;
        private boolean useStarJoin;
        private Map<TableRef, JoinTable> tableRefToJoinTableMap;
        private Map<ColumnRef, ColumnRefType> columnRefs;

        private JoinSpec(SelectStatement statement, ColumnResolver resolver) throws SQLException {
            JoinTable joinTable;
            this.origResolver = resolver;
            List<AliasedNode> selectList = statement.getSelect();
            List<TableNode> tableNodes = statement.getFrom();
            assert (tableNodes.size() > 1);
            Iterator<TableNode> iter = tableNodes.iterator();
            Iterator<TableRef> tableRefIter = resolver.getTables().iterator();
            this.mainTableNode = iter.next();
            DynamicColumnsVisitor v = new DynamicColumnsVisitor();
            this.mainTableNode.accept(v);
            this.dynamicColumns = v.getDynamicColumns();
            this.mainTable = tableRefIter.next();
            this.select = JoinCompiler.extractFromSelect(selectList, this.mainTable, resolver);
            this.joinTables = new ArrayList<JoinTable>(tableNodes.size() - 1);
            this.preFilters = new ArrayList<ParseNode>();
            this.postFilters = new ArrayList<ParseNode>();
            this.useStarJoin = !statement.getHint().hasHint(HintNode.Hint.NO_STAR_JOIN);
            this.tableRefToJoinTableMap = new HashMap<TableRef, JoinTable>();
            ColumnParseNodeVisitor generalRefVisitor = new ColumnParseNodeVisitor(resolver);
            ColumnParseNodeVisitor joinLocalRefVisitor = new ColumnParseNodeVisitor(resolver);
            ColumnParseNodeVisitor prefilterRefVisitor = new ColumnParseNodeVisitor(resolver);
            int lastRightJoinIndex = -1;
            TableNode tableNode = null;
            int i = 0;
            while (iter.hasNext()) {
                tableNode = iter.next();
                if (!(tableNode instanceof JoinTableNode)) {
                    throw new SQLFeatureNotSupportedException("Implicit joins not supported.");
                }
                JoinTableNode joinTableNode = (JoinTableNode)tableNode;
                joinTable = new JoinTable(joinTableNode, tableRefIter.next(), statement, resolver);
                for (ParseNode condition : joinTable.conditions) {
                    ComparisonParseNode comparisonNode = (ComparisonParseNode)condition;
                    comparisonNode.getLHS().accept(generalRefVisitor);
                    comparisonNode.getRHS().accept(joinLocalRefVisitor);
                }
                if (joinTable.getType() == JoinTableNode.JoinType.Right) {
                    lastRightJoinIndex = i;
                }
                this.joinTables.add(joinTable);
                this.tableRefToJoinTableMap.put(joinTable.getTable(), joinTable);
                ++i;
            }
            ArrayList<TableRef> prefilterAcceptedTables = new ArrayList<TableRef>();
            int n = i = lastRightJoinIndex == -1 ? 0 : lastRightJoinIndex;
            while (i < this.joinTables.size()) {
                joinTable = this.joinTables.get(i);
                if (joinTable.getType() != JoinTableNode.JoinType.Left) {
                    prefilterAcceptedTables.add(joinTable.getTable());
                }
                ++i;
            }
            if (statement.getWhere() != null) {
                if (lastRightJoinIndex > -1 && prefilterAcceptedTables.isEmpty()) {
                    this.postFilters.add(statement.getWhere());
                } else {
                    statement.getWhere().accept(new WhereNodeVisitor(resolver, lastRightJoinIndex > -1, prefilterAcceptedTables));
                    for (ParseNode parseNode : this.preFilters) {
                        parseNode.accept(prefilterRefVisitor);
                    }
                }
                for (ParseNode parseNode : this.postFilters) {
                    parseNode.accept(generalRefVisitor);
                }
            }
            for (JoinTable joinTable2 : this.joinTables) {
                for (ParseNode prefilter : joinTable2.preFilters) {
                    prefilter.accept(prefilterRefVisitor);
                }
            }
            for (AliasedNode aliasedNode : selectList) {
                aliasedNode.getNode().accept(generalRefVisitor);
            }
            if (statement.getGroupBy() != null) {
                for (ParseNode parseNode : statement.getGroupBy()) {
                    parseNode.accept(generalRefVisitor);
                }
            }
            if (statement.getHaving() != null) {
                statement.getHaving().accept(generalRefVisitor);
            }
            if (statement.getOrderBy() != null) {
                for (OrderByNode orderByNode : statement.getOrderBy()) {
                    orderByNode.getNode().accept(generalRefVisitor);
                }
            }
            this.columnRefs = new HashMap<ColumnRef, ColumnRefType>();
            for (ColumnRef columnRef : generalRefVisitor.getColumnRefMap().keySet()) {
                this.columnRefs.put(columnRef, ColumnRefType.GENERAL);
            }
            for (ColumnRef columnRef : joinLocalRefVisitor.getColumnRefMap().keySet()) {
                if (this.columnRefs.containsKey(columnRef)) continue;
                this.columnRefs.put(columnRef, ColumnRefType.JOINLOCAL);
            }
            for (ColumnRef columnRef : prefilterRefVisitor.getColumnRefMap().keySet()) {
                if (this.columnRefs.containsKey(columnRef)) continue;
                this.columnRefs.put(columnRef, ColumnRefType.PREFILTER);
            }
        }

        private JoinSpec(ColumnResolver resolver, TableNode tableNode, List<ColumnDef> dynamicColumns, TableRef table, List<AliasedNode> select, List<ParseNode> preFilters, List<ParseNode> postFilters, List<JoinTable> joinTables, boolean useStarJoin, Map<TableRef, JoinTable> tableRefToJoinTableMap, Map<ColumnRef, ColumnRefType> columnRefs) {
            this.origResolver = resolver;
            this.mainTableNode = tableNode;
            this.dynamicColumns = dynamicColumns;
            this.mainTable = table;
            this.select = select;
            this.preFilters = preFilters;
            this.postFilters = postFilters;
            this.joinTables = joinTables;
            this.useStarJoin = useStarJoin;
            this.tableRefToJoinTableMap = tableRefToJoinTableMap;
            this.columnRefs = columnRefs;
        }

        public ColumnResolver getOriginalResolver() {
            return this.origResolver;
        }

        public TableNode getMainTableNode() {
            return this.mainTableNode;
        }

        public List<ColumnDef> getDynamicColumns() {
            return this.dynamicColumns;
        }

        public TableRef getMainTable() {
            return this.mainTable;
        }

        public List<AliasedNode> getSelect() {
            return this.select;
        }

        public List<ParseNode> getPreFilters() {
            return this.preFilters;
        }

        public List<ParseNode> getPostFilters() {
            return this.postFilters;
        }

        public List<JoinTable> getJoinTables() {
            return this.joinTables;
        }

        public ParseNode getPreFiltersCombined() {
            if (this.preFilters == null || this.preFilters.isEmpty()) {
                return null;
            }
            if (this.preFilters.size() == 1) {
                return this.preFilters.get(0);
            }
            return NODE_FACTORY.and(this.preFilters);
        }

        public Expression compilePostFilterExpression(StatementContext context) throws SQLException {
            if (this.postFilters == null || this.postFilters.isEmpty()) {
                return null;
            }
            ExpressionCompiler expressionCompiler = new ExpressionCompiler(context);
            ArrayList<Expression> expressions = new ArrayList<Expression>(this.postFilters.size());
            for (ParseNode postFilter : this.postFilters) {
                expressionCompiler.reset();
                Expression expression = postFilter.accept(expressionCompiler);
                expressions.add(expression);
            }
            if (expressions.size() == 1) {
                return (Expression)expressions.get(0);
            }
            return AndExpression.create(expressions);
        }

        public boolean[] getStarJoinVector() {
            assert (!this.joinTables.isEmpty());
            int count = this.joinTables.size();
            if (!this.useStarJoin && count > 1 && this.joinTables.get(count - 1).getType() != JoinTableNode.JoinType.Left) {
                return null;
            }
            boolean[] vector = new boolean[count];
            for (int i = 0; i < count; ++i) {
                JoinTable joinTable = this.joinTables.get(i);
                if (joinTable.getType() != JoinTableNode.JoinType.Left && joinTable.getType() != JoinTableNode.JoinType.Inner) {
                    return null;
                }
                vector[i] = true;
                Iterator<TableRef> iter = joinTable.getLeftTableRefs().iterator();
                while (vector[i] && iter.hasNext()) {
                    TableRef tableRef = iter.next();
                    if (tableRef.equals(this.mainTable)) continue;
                    vector[i] = false;
                }
            }
            return vector;
        }

        protected boolean isWildCardSelect(TableRef table) {
            List<AliasedNode> selectList = table.equals(this.mainTable) ? this.select : this.tableRefToJoinTableMap.get(table).getSelect();
            return selectList.size() == 1 && selectList.get(0).getNode() instanceof TableWildcardParseNode;
        }

        public void projectColumns(Scan scan, TableRef table) {
            if (this.isWildCardSelect(table)) {
                scan.getFamilyMap().clear();
                return;
            }
            for (ColumnRef columnRef : this.columnRefs.keySet()) {
                if (!columnRef.getTableRef().equals(table) || SchemaUtil.isPKColumn(columnRef.getColumn())) continue;
                scan.addColumn(columnRef.getColumn().getFamilyName().getBytes(), columnRef.getColumn().getName().getBytes());
            }
        }

        public ProjectedPTableWrapper createProjectedTable(TableRef tableRef, boolean retainPKColumns) throws SQLException {
            boolean hasSaltingColumn;
            ArrayList<PColumn> projectedColumns = new ArrayList<PColumn>();
            ArrayList<Expression> sourceExpressions = new ArrayList<Expression>();
            ArrayListMultimap<String, String> columnNameMap = ArrayListMultimap.create();
            PTable table = tableRef.getTable();
            boolean bl = hasSaltingColumn = retainPKColumns && table.getBucketNum() != null;
            if (retainPKColumns) {
                for (PColumn pColumn : table.getPKColumns()) {
                    JoinSpec.addProjectedColumn(projectedColumns, sourceExpressions, columnNameMap, pColumn, tableRef, pColumn.getFamilyName(), hasSaltingColumn);
                }
            }
            if (this.isWildCardSelect(tableRef)) {
                for (PColumn pColumn : table.getColumns()) {
                    if (retainPKColumns && SchemaUtil.isPKColumn(pColumn)) continue;
                    JoinSpec.addProjectedColumn(projectedColumns, sourceExpressions, columnNameMap, pColumn, tableRef, PNameFactory.newName(ScanProjector.VALUE_COLUMN_FAMILY), hasSaltingColumn);
                }
            } else {
                for (Map.Entry entry : this.columnRefs.entrySet()) {
                    ColumnRef columnRef = (ColumnRef)entry.getKey();
                    if (entry.getValue() == ColumnRefType.PREFILTER || !columnRef.getTableRef().equals(tableRef) || retainPKColumns && SchemaUtil.isPKColumn(columnRef.getColumn())) continue;
                    PColumn column = columnRef.getColumn();
                    JoinSpec.addProjectedColumn(projectedColumns, sourceExpressions, columnNameMap, column, tableRef, PNameFactory.newName(ScanProjector.VALUE_COLUMN_FAMILY), hasSaltingColumn);
                }
            }
            PTableImpl t = PTableImpl.makePTable(table.getTenantId(), PNameFactory.newName(PROJECTED_TABLE_SCHEMA), table.getName(), PTableType.JOIN, table.getIndexState(), table.getTimeStamp(), table.getSequenceNumber(), table.getPKName(), retainPKColumns ? table.getBucketNum() : null, projectedColumns, table.getParentTableName(), table.getIndexes(), table.isImmutableRows(), Collections.<PName>emptyList(), null, null, table.isWALDisabled(), table.isMultiTenant(), table.getViewType(), table.getViewIndexId());
            return new ProjectedPTableWrapper(t, columnNameMap, sourceExpressions);
        }

        private static void addProjectedColumn(List<PColumn> projectedColumns, List<Expression> sourceExpressions, ListMultimap<String, String> columnNameMap, PColumn sourceColumn, TableRef sourceTable, PName familyName, boolean hasSaltingColumn) throws SQLException {
            if (sourceColumn == SaltingUtil.SALTING_COLUMN) {
                return;
            }
            int position = projectedColumns.size() + (hasSaltingColumn ? 1 : 0);
            PTable table = sourceTable.getTable();
            String schemaName = table.getSchemaName().getString();
            String tableName = table.getTableName().getString();
            String colName = sourceColumn.getName().getString();
            String fullName = JoinCompiler.getProjectedColumnName(schemaName, tableName, colName);
            String aliasedName = sourceTable.getTableAlias() == null ? fullName : JoinCompiler.getProjectedColumnName(null, sourceTable.getTableAlias(), colName);
            columnNameMap.put(colName, aliasedName);
            if (!fullName.equals(aliasedName)) {
                columnNameMap.put(fullName, aliasedName);
            }
            PName name = PNameFactory.newName(aliasedName);
            PColumnImpl column = new PColumnImpl(name, familyName, sourceColumn.getDataType(), sourceColumn.getMaxLength(), sourceColumn.getScale(), sourceColumn.isNullable(), position, sourceColumn.getSortOrder(), sourceColumn.getArraySize(), sourceColumn.getViewConstant(), sourceColumn.isViewReferenced());
            ColumnExpression sourceExpression = new ColumnRef(sourceTable, sourceColumn.getPosition()).newColumnExpression();
            projectedColumns.add(column);
            sourceExpressions.add(sourceExpression);
        }

        public ColumnResolver getColumnResolver(PTableWrapper table) {
            return new JoinedTableColumnResolver(table, this.origResolver);
        }

        public boolean hasPostReference(TableRef table) {
            if (this.isWildCardSelect(table)) {
                return true;
            }
            for (Map.Entry<ColumnRef, ColumnRefType> e : this.columnRefs.entrySet()) {
                if (e.getValue() != ColumnRefType.GENERAL || !e.getKey().getTableRef().equals(table)) continue;
                return true;
            }
            return false;
        }

        private class WhereNodeVisitor
        extends TraverseNoParseNodeVisitor<Void> {
            private ColumnResolver resolver;
            private boolean hasRightJoin;
            private List<TableRef> prefilterAcceptedTables;

            public WhereNodeVisitor(ColumnResolver resolver, boolean hasRightJoin, List<TableRef> prefilterAcceptedTables) {
                this.resolver = resolver;
                this.hasRightJoin = hasRightJoin;
                this.prefilterAcceptedTables = prefilterAcceptedTables;
            }

            private Void leaveBooleanNode(ParseNode node, List<Void> l) throws SQLException {
                ColumnParseNodeVisitor visitor = new ColumnParseNodeVisitor(this.resolver);
                node.accept(visitor);
                ColumnParseNodeVisitor.ContentType type = visitor.getContentType(JoinSpec.this.mainTable);
                switch (type) {
                    case NONE: 
                    case SELF_ONLY: {
                        if (!this.hasRightJoin) {
                            JoinSpec.this.preFilters.add(node);
                            break;
                        }
                        JoinSpec.this.postFilters.add(node);
                        break;
                    }
                    case FOREIGN_ONLY: {
                        TableRef matched = null;
                        for (TableRef table : this.prefilterAcceptedTables) {
                            if (visitor.getContentType(table) != ColumnParseNodeVisitor.ContentType.SELF_ONLY) continue;
                            matched = table;
                            break;
                        }
                        if (matched != null) {
                            ((JoinTable)JoinSpec.this.tableRefToJoinTableMap.get(matched)).preFilters.add(node);
                            break;
                        }
                        JoinSpec.this.postFilters.add(node);
                        break;
                    }
                    default: {
                        JoinSpec.this.postFilters.add(node);
                    }
                }
                return null;
            }

            @Override
            public Void visitLeave(LikeParseNode node, List<Void> l) throws SQLException {
                return this.leaveBooleanNode(node, l);
            }

            @Override
            public boolean visitEnter(AndParseNode node) {
                return true;
            }

            @Override
            public Void visitLeave(OrParseNode node, List<Void> l) throws SQLException {
                return this.leaveBooleanNode(node, l);
            }

            @Override
            public Void visitLeave(ComparisonParseNode node, List<Void> l) throws SQLException {
                return this.leaveBooleanNode(node, l);
            }

            @Override
            public Void visitLeave(NotParseNode node, List<Void> l) throws SQLException {
                return this.leaveBooleanNode(node, l);
            }

            @Override
            public Void visitLeave(InListParseNode node, List<Void> l) throws SQLException {
                return this.leaveBooleanNode(node, l);
            }

            @Override
            public Void visitLeave(IsNullParseNode node, List<Void> l) throws SQLException {
                return this.leaveBooleanNode(node, l);
            }

            @Override
            public Void visitLeave(FunctionParseNode node, List<Void> l) throws SQLException {
                return this.leaveBooleanNode(node, l);
            }

            @Override
            public Void visitLeave(BetweenParseNode node, List<Void> l) throws SQLException {
                return this.leaveBooleanNode(node, l);
            }

            @Override
            public Void visitLeave(CaseParseNode node, List<Void> l) throws SQLException {
                return this.leaveBooleanNode(node, l);
            }

            @Override
            public Void visitLeave(CastParseNode node, List<Void> l) throws SQLException {
                return this.leaveBooleanNode(node, l);
            }
        }
    }

    public static enum ColumnRefType {
        PREFILTER,
        JOINLOCAL,
        GENERAL;

    }
}

