/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.phoenix.compile.ExpressionCompiler;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.compile.TrackOrderPreservingExpressionCompiler;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.OrderByExpression;
import org.apache.phoenix.parse.FilterableStatement;
import org.apache.phoenix.parse.OrderByNode;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.schema.SortOrder;

public class OrderByCompiler {
    public static OrderBy compile(StatementContext context, FilterableStatement statement, GroupByCompiler.GroupBy groupBy, Integer limit) throws SQLException {
        List<OrderByNode> orderByNodes = statement.getOrderBy();
        if (orderByNodes.isEmpty()) {
            return OrderBy.EMPTY_ORDER_BY;
        }
        TrackOrderPreservingExpressionCompiler visitor = new TrackOrderPreservingExpressionCompiler(context, groupBy, orderByNodes.size(), TrackOrderPreservingExpressionCompiler.Ordering.ORDERED);
        LinkedHashSet<OrderByExpression> orderByExpressions = Sets.newLinkedHashSetWithExpectedSize(orderByNodes.size());
        for (OrderByNode node : orderByNodes) {
            boolean isAscending = node.isAscending();
            Expression expression = node.getNode().accept(visitor);
            if (!expression.isStateless() && visitor.addEntry(expression, isAscending ? SortOrder.ASC : SortOrder.DESC)) {
                if (!visitor.isAggregate() && (statement.isAggregate() || statement.isDistinct())) {
                    if (statement.isDistinct()) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.ORDER_BY_NOT_IN_SELECT_DISTINCT).setMessage(expression.toString()).build().buildException();
                    }
                    ExpressionCompiler.throwNonAggExpressionInAggException(expression.toString());
                }
                if (expression.getSortOrder() == SortOrder.DESC) {
                    isAscending = !isAscending;
                }
                OrderByExpression orderByExpression = new OrderByExpression(expression, node.isNullsLast(), isAscending);
                orderByExpressions.add(orderByExpression);
            }
            visitor.reset();
        }
        if (orderByExpressions.isEmpty()) {
            return OrderBy.EMPTY_ORDER_BY;
        }
        if (visitor.isOrderPreserving()) {
            if (visitor.isReverse().booleanValue()) {
                if (context.getConnection().getQueryServices().supportsFeature(ConnectionQueryServices.Feature.REVERSE_SCAN)) {
                    return OrderBy.REV_ROW_KEY_ORDER_BY;
                }
            } else {
                return OrderBy.FWD_ROW_KEY_ORDER_BY;
            }
        }
        return new OrderBy(Lists.newArrayList(orderByExpressions.iterator()));
    }

    private OrderByCompiler() {
    }

    public static class OrderBy {
        public static final OrderBy EMPTY_ORDER_BY = new OrderBy(Collections.<OrderByExpression>emptyList());
        public static final OrderBy FWD_ROW_KEY_ORDER_BY = new OrderBy(Collections.<OrderByExpression>emptyList());
        public static final OrderBy REV_ROW_KEY_ORDER_BY = new OrderBy(Collections.<OrderByExpression>emptyList());
        private final List<OrderByExpression> orderByExpressions;

        private OrderBy(List<OrderByExpression> orderByExpressions) {
            this.orderByExpressions = ImmutableList.copyOf(orderByExpressions);
        }

        public List<OrderByExpression> getOrderByExpressions() {
            return this.orderByExpressions;
        }
    }
}

