/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.sql.SQLException;
import java.util.List;
import org.apache.phoenix.compile.MutationPlan;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.util.IndexUtil;

public class PostIndexDDLCompiler {
    private final PhoenixConnection connection;
    private final TableRef dataTableRef;

    public PostIndexDDLCompiler(PhoenixConnection connection, TableRef dataTableRef) {
        this.connection = connection;
        this.dataTableRef = dataTableRef;
    }

    public MutationPlan compile(PTable indexTable) throws SQLException {
        int posOffset;
        StringBuilder indexColumns = new StringBuilder();
        StringBuilder dataColumns = new StringBuilder();
        List<PColumn> dataTableColumns = this.dataTableRef.getTable().getColumns();
        PTable dataTable = this.dataTableRef.getTable();
        int nColumns = dataTable.getColumns().size();
        boolean isSalted = dataTable.getBucketNum() != null;
        boolean isMultiTenant = this.connection.getTenantId() != null && dataTable.isMultiTenant();
        boolean isSharedViewIndex = dataTable.getViewIndexId() != null;
        for (int i = posOffset = (isSalted ? 1 : 0) + (isMultiTenant ? 1 : 0) + (isSharedViewIndex ? 1 : 0); i < nColumns; ++i) {
            PColumn col = dataTableColumns.get(i);
            String indexColName = IndexUtil.getIndexColumnName(col);
            try {
                indexTable.getColumn(indexColName);
                if (col.getFamilyName() != null) {
                    dataColumns.append('\"').append(col.getFamilyName()).append("\".");
                }
                dataColumns.append('\"').append(col.getName()).append("\",");
                indexColumns.append('\"').append(indexColName).append("\",");
                continue;
            }
            catch (ColumnNotFoundException e) {
                // empty catch block
            }
        }
        dataColumns.setLength(dataColumns.length() - 1);
        indexColumns.setLength(indexColumns.length() - 1);
        String schemaName = this.dataTableRef.getTable().getSchemaName().getString();
        String tableName = indexTable.getTableName().getString();
        StringBuilder updateStmtStr = new StringBuilder();
        updateStmtStr.append("UPSERT /*+ NO_INDEX */ INTO ").append(schemaName.length() == 0 ? "" : '\"' + schemaName + "\".").append('\"').append(tableName).append("\"(").append((CharSequence)indexColumns).append(") SELECT ").append((CharSequence)dataColumns).append(" FROM ").append(schemaName.length() == 0 ? "" : '\"' + schemaName + "\".").append('\"').append(this.dataTableRef.getTable().getTableName().getString()).append('\"');
        PhoenixStatement statement = new PhoenixStatement(this.connection);
        return statement.compileMutation(updateStmtStr.toString());
    }
}

