/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.compile.FromCompiler;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.HavingCompiler;
import org.apache.phoenix.compile.JoinCompiler;
import org.apache.phoenix.compile.LimitCompiler;
import org.apache.phoenix.compile.OrderByCompiler;
import org.apache.phoenix.compile.ProjectionCompiler;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.compile.WhereCompiler;
import org.apache.phoenix.execute.AggregatePlan;
import org.apache.phoenix.execute.BasicQueryPlan;
import org.apache.phoenix.execute.HashJoinPlan;
import org.apache.phoenix.execute.ScanPlan;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.iterate.ParallelIterators;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.join.HashJoinInfo;
import org.apache.phoenix.join.ScanProjector;
import org.apache.phoenix.parse.FilterableStatement;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.parse.JoinTableNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.SQLParser;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.util.ScanUtil;

public class QueryCompiler {
    private static final String LOAD_COLUMN_FAMILIES_ON_DEMAND_ATTR = "_ondemand_";
    private final PhoenixStatement statement;
    private final Scan scan;
    private final Scan originalScan;
    private final ColumnResolver resolver;
    private final SelectStatement select;
    private final List<? extends PDatum> targetColumns;
    private final ParallelIterators.ParallelIteratorFactory parallelIteratorFactory;

    public QueryCompiler(PhoenixStatement statement, SelectStatement select, ColumnResolver resolver) throws SQLException {
        this(statement, select, resolver, Collections.emptyList(), null);
    }

    public QueryCompiler(PhoenixStatement statement, SelectStatement select, ColumnResolver resolver, List<? extends PDatum> targetColumns, ParallelIterators.ParallelIteratorFactory parallelIteratorFactory) throws SQLException {
        this.statement = statement;
        this.select = select;
        this.resolver = resolver;
        this.scan = new Scan();
        this.targetColumns = targetColumns;
        this.parallelIteratorFactory = parallelIteratorFactory;
        if (statement.getConnection().getQueryServices().getLowestClusterHBaseVersion() >= PhoenixDatabaseMetaData.ESSENTIAL_FAMILY_VERSION_THRESHOLD) {
            this.scan.setAttribute(LOAD_COLUMN_FAMILIES_ON_DEMAND_ATTR, QueryConstants.TRUE);
        }
        if (select.getHint().hasHint(HintNode.Hint.NO_CACHE)) {
            this.scan.setCacheBlocks(false);
        }
        this.originalScan = ScanUtil.newScan(this.scan);
    }

    public QueryPlan compile() throws SQLException {
        SelectStatement select = this.select;
        List<Object> binds = this.statement.getParameters();
        StatementContext context = new StatementContext(this.statement, this.resolver, this.scan);
        if (select.getFrom().size() > 1) {
            if (this.select != (select = JoinCompiler.optimize(context, select, this.statement))) {
                ColumnResolver resolver = FromCompiler.getResolverForQuery(select, this.statement.getConnection());
                context = new StatementContext(this.statement, resolver, this.scan);
            }
            JoinCompiler.JoinSpec join = JoinCompiler.getJoinSpec(context, select);
            return this.compileJoinQuery(context, select, binds, join, false);
        }
        return this.compileSingleQuery(context, select, binds, this.parallelIteratorFactory);
    }

    protected QueryPlan compileJoinQuery(StatementContext context, SelectStatement select, List<Object> binds, JoinCompiler.JoinSpec join, boolean asSubquery) throws SQLException {
        byte[] emptyByteArray = new byte[]{};
        List<JoinCompiler.JoinTable> joinTables = join.getJoinTables();
        if (joinTables.isEmpty()) {
            JoinCompiler.ProjectedPTableWrapper projectedTable = join.createProjectedTable(join.getMainTable(), !asSubquery);
            ScanProjector.serializeProjectorIntoScan(context.getScan(), JoinCompiler.getScanProjector(projectedTable));
            context.setCurrentTable(join.getMainTable());
            context.setResolver(join.getColumnResolver(projectedTable));
            join.projectColumns(context.getScan(), join.getMainTable());
            return this.compileSingleQuery(context, select, binds, null);
        }
        boolean[] starJoinVector = join.getStarJoinVector();
        if (starJoinVector != null) {
            JoinCompiler.ProjectedPTableWrapper initialProjectedTable;
            JoinCompiler.PTableWrapper projectedTable = initialProjectedTable = join.createProjectedTable(join.getMainTable(), !asSubquery);
            int count = joinTables.size();
            ImmutableBytesPtr[] joinIds = new ImmutableBytesPtr[count];
            List[] joinExpressions = new List[count];
            List[] hashExpressions = new List[count];
            JoinTableNode.JoinType[] joinTypes = new JoinTableNode.JoinType[count];
            PTable[] tables = new PTable[count];
            int[] fieldPositions = new int[count];
            QueryPlan[] joinPlans = new QueryPlan[count];
            fieldPositions[0] = projectedTable.getTable().getColumns().size() - projectedTable.getTable().getPKColumns().size();
            boolean needsProject = asSubquery;
            for (int i = 0; i < count; ++i) {
                JoinCompiler.JoinTable joinTable = joinTables.get(i);
                SelectStatement subStatement = joinTable.getAsSubquery();
                if (subStatement.getFrom().size() > 1) {
                    throw new SQLFeatureNotSupportedException("Sub queries not supported.");
                }
                JoinCompiler.ProjectedPTableWrapper subProjTable = join.createProjectedTable(joinTable.getTable(), false);
                ColumnResolver resolver = join.getColumnResolver(subProjTable);
                Scan subScan = ScanUtil.newScan(this.originalScan);
                ScanProjector.serializeProjectorIntoScan(subScan, JoinCompiler.getScanProjector(subProjTable));
                StatementContext subContext = new StatementContext(this.statement, resolver, subScan);
                subContext.setCurrentTable(joinTable.getTable());
                join.projectColumns(subScan, joinTable.getTable());
                joinPlans[i] = this.compileSingleQuery(subContext, subStatement, binds, null);
                boolean hasPostReference = join.hasPostReference(joinTable.getTable());
                if (hasPostReference) {
                    tables[i] = subProjTable.getTable();
                    projectedTable = JoinCompiler.mergeProjectedTables(projectedTable, subProjTable, joinTable.getType() == JoinTableNode.JoinType.Inner);
                    needsProject = true;
                } else {
                    tables[i] = null;
                }
                if (!starJoinVector[i]) {
                    needsProject = true;
                }
                ColumnResolver leftResolver = starJoinVector[i] ? join.getOriginalResolver() : join.getColumnResolver(projectedTable);
                joinIds[i] = new ImmutableBytesPtr(emptyByteArray);
                Pair<List<Expression>, List<Expression>> joinConditions = joinTable.compileJoinConditions(context, leftResolver, resolver);
                joinExpressions[i] = joinConditions.getFirst();
                hashExpressions[i] = joinConditions.getSecond();
                joinTypes[i] = joinTable.getType();
                if (i >= count - 1) continue;
                fieldPositions[i + 1] = fieldPositions[i] + (tables[i] == null ? 0 : tables[i].getColumns().size() - tables[i].getPKColumns().size());
            }
            if (needsProject) {
                ScanProjector.serializeProjectorIntoScan(context.getScan(), JoinCompiler.getScanProjector(initialProjectedTable));
            }
            context.setCurrentTable(join.getMainTable());
            context.setResolver(needsProject ? join.getColumnResolver(projectedTable) : join.getOriginalResolver());
            join.projectColumns(context.getScan(), join.getMainTable());
            BasicQueryPlan plan = this.compileSingleQuery(context, JoinCompiler.getSubqueryWithoutJoin(select, join), binds, this.parallelIteratorFactory);
            Expression postJoinFilterExpression = join.compilePostFilterExpression(context);
            HashJoinInfo joinInfo = new HashJoinInfo(projectedTable.getTable(), joinIds, joinExpressions, joinTypes, starJoinVector, tables, fieldPositions, postJoinFilterExpression);
            return new HashJoinPlan(plan, joinInfo, hashExpressions, joinPlans);
        }
        JoinCompiler.JoinTable lastJoinTable = joinTables.get(joinTables.size() - 1);
        JoinTableNode.JoinType type = lastJoinTable.getType();
        if (type == JoinTableNode.JoinType.Full) {
            throw new SQLFeatureNotSupportedException("Full joins not supported.");
        }
        if (type == JoinTableNode.JoinType.Right || type == JoinTableNode.JoinType.Inner) {
            SelectStatement lhs = JoinCompiler.getSubQueryWithoutLastJoin(select, join);
            SelectStatement rhs = JoinCompiler.getSubqueryForLastJoinTable(select, join);
            JoinCompiler.JoinSpec lhsJoin = JoinCompiler.getSubJoinSpecWithoutPostFilters(join);
            Scan subScan = ScanUtil.newScan(this.originalScan);
            StatementContext lhsCtx = new StatementContext(this.statement, context.getResolver(), subScan);
            QueryPlan lhsPlan = this.compileJoinQuery(lhsCtx, lhs, binds, lhsJoin, true);
            ColumnResolver lhsResolver = lhsCtx.getResolver();
            JoinCompiler.PTableWrapper lhsProjTable = ((JoinCompiler.JoinedTableColumnResolver)lhsResolver).getPTableWrapper();
            JoinCompiler.ProjectedPTableWrapper rhsProjTable = join.createProjectedTable(lastJoinTable.getTable(), !asSubquery);
            ColumnResolver rhsResolver = join.getOriginalResolver();
            ImmutableBytesPtr[] joinIds = new ImmutableBytesPtr[]{new ImmutableBytesPtr(emptyByteArray)};
            Pair<List<Expression>, List<Expression>> joinConditions = lastJoinTable.compileJoinConditions(context, lhsResolver, rhsResolver);
            List<Expression> joinExpressions = joinConditions.getSecond();
            List<Expression> hashExpressions = joinConditions.getFirst();
            int fieldPosition = rhsProjTable.getTable().getColumns().size() - rhsProjTable.getTable().getPKColumns().size();
            JoinCompiler.PTableWrapper projectedTable = JoinCompiler.mergeProjectedTables(rhsProjTable, lhsProjTable, type == JoinTableNode.JoinType.Inner);
            ScanProjector.serializeProjectorIntoScan(context.getScan(), JoinCompiler.getScanProjector(rhsProjTable));
            context.setCurrentTable(lastJoinTable.getTable());
            context.setResolver(join.getColumnResolver(projectedTable));
            join.projectColumns(context.getScan(), lastJoinTable.getTable());
            BasicQueryPlan rhsPlan = this.compileSingleQuery(context, rhs, binds, this.parallelIteratorFactory);
            Expression postJoinFilterExpression = join.compilePostFilterExpression(context);
            HashJoinInfo joinInfo = new HashJoinInfo(projectedTable.getTable(), joinIds, new List[]{joinExpressions}, new JoinTableNode.JoinType[]{type == JoinTableNode.JoinType.Inner ? type : JoinTableNode.JoinType.Left}, new boolean[]{true}, new PTable[]{lhsProjTable.getTable()}, new int[]{fieldPosition}, postJoinFilterExpression);
            return new HashJoinPlan(rhsPlan, joinInfo, new List[]{hashExpressions}, new QueryPlan[]{lhsPlan});
        }
        throw new SQLFeatureNotSupportedException("Joins with pattern 'A right join B left join C' not supported.");
    }

    protected BasicQueryPlan compileSingleQuery(StatementContext context, SelectStatement select, List<Object> binds, ParallelIterators.ParallelIteratorFactory parallelIteratorFactory) throws SQLException {
        PhoenixConnection connection = this.statement.getConnection();
        ColumnResolver resolver = context.getResolver();
        TableRef tableRef = context.getCurrentTable();
        PTable table = tableRef.getTable();
        ParseNode viewWhere = null;
        if (table.getViewStatement() != null) {
            viewWhere = new SQLParser(table.getViewStatement()).parseQuery().getWhere();
        }
        Integer limit = LimitCompiler.compile(context, select);
        GroupByCompiler.GroupBy groupBy = GroupByCompiler.compile(context, select);
        select = HavingCompiler.rewrite(context, select, groupBy);
        Expression having = HavingCompiler.compile(context, select, groupBy);
        context.setResolver(FromCompiler.getResolverForQuery(select, connection));
        WhereCompiler.compile(context, select, viewWhere);
        context.setResolver(resolver);
        OrderByCompiler.OrderBy orderBy = OrderByCompiler.compile(context, select, groupBy, limit);
        RowProjector projector = ProjectionCompiler.compile(context, select, groupBy, this.targetColumns);
        int maxRows = this.statement.getMaxRows();
        if (maxRows > 0) {
            limit = limit != null ? Integer.valueOf(Math.min(limit, maxRows)) : Integer.valueOf(maxRows);
        }
        if (select.isAggregate() || select.isDistinct()) {
            return new AggregatePlan(context, (FilterableStatement)select, tableRef, projector, limit, orderBy, parallelIteratorFactory, groupBy, having);
        }
        return new ScanPlan(context, select, tableRef, projector, limit, orderBy, parallelIteratorFactory);
    }
}

