/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import com.google.common.collect.Maps;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.phoenix.compile.ColumnProjector;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.util.SchemaUtil;

public class RowProjector {
    public static final RowProjector EMPTY_PROJECTOR = new RowProjector(Collections.emptyList(), 0, true);
    private final List<? extends ColumnProjector> columnProjectors;
    private final Map<String, Integer> reverseIndex;
    private final boolean allCaseSensitive;
    private final boolean someCaseSensitive;
    private final int estimatedSize;
    private final boolean isProjectEmptyKeyValue;

    public RowProjector(RowProjector projector, boolean isProjectEmptyKeyValue) {
        this(projector.getColumnProjectors(), projector.getEstimatedRowByteSize(), isProjectEmptyKeyValue);
    }

    public RowProjector(List<? extends ColumnProjector> columnProjectors, int estimatedRowSize, boolean isProjectEmptyKeyValue) {
        this.columnProjectors = Collections.unmodifiableList(columnProjectors);
        int position = columnProjectors.size();
        this.reverseIndex = Maps.newHashMapWithExpectedSize(position);
        boolean allCaseSensitive = true;
        boolean someCaseSensitive = false;
        --position;
        while (position >= 0) {
            ColumnProjector colProjector = columnProjectors.get(position);
            allCaseSensitive &= colProjector.isCaseSensitive();
            someCaseSensitive |= colProjector.isCaseSensitive();
            this.reverseIndex.put(colProjector.getName(), position);
            --position;
        }
        this.allCaseSensitive = allCaseSensitive;
        this.someCaseSensitive = someCaseSensitive;
        this.estimatedSize = estimatedRowSize;
        this.isProjectEmptyKeyValue = isProjectEmptyKeyValue;
    }

    public boolean isProjectEmptyKeyValue() {
        return this.isProjectEmptyKeyValue;
    }

    public List<? extends ColumnProjector> getColumnProjectors() {
        return this.columnProjectors;
    }

    public int getColumnIndex(String name) throws SQLException {
        Integer index;
        if (!this.someCaseSensitive) {
            name = SchemaUtil.normalizeIdentifier(name);
        }
        if ((index = this.reverseIndex.get(name)) == null) {
            if (!this.allCaseSensitive && this.someCaseSensitive) {
                name = SchemaUtil.normalizeIdentifier(name);
                index = this.reverseIndex.get(name);
            }
            if (index == null) {
                throw new ColumnNotFoundException(name);
            }
        }
        return index;
    }

    public ColumnProjector getColumnProjector(int index) {
        return this.columnProjectors.get(index);
    }

    public int getColumnCount() {
        return this.columnProjectors.size();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[");
        for (ColumnProjector columnProjector : this.columnProjectors) {
            buf.append(columnProjector.getExpression());
            buf.append(',');
        }
        if (buf.length() > 1) {
            buf.setLength(buf.length() - 1);
        }
        buf.append(']');
        return buf.toString();
    }

    public int getEstimatedRowByteSize() {
        return this.estimatedSize;
    }
}

