/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.filter.SkipScanFilter;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.RowKeySchema;
import org.apache.phoenix.schema.SaltingUtil;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.SchemaUtil;

public class ScanRanges {
    private static final List<List<KeyRange>> EVERYTHING_RANGES = Collections.emptyList();
    private static final List<List<KeyRange>> NOTHING_RANGES = Collections.singletonList(Collections.singletonList(KeyRange.EMPTY_RANGE));
    public static final ScanRanges EVERYTHING = new ScanRanges(EVERYTHING_RANGES, null, false, false);
    public static final ScanRanges NOTHING = new ScanRanges(NOTHING_RANGES, null, false, false);
    private SkipScanFilter filter;
    private final List<List<KeyRange>> ranges;
    private final RowKeySchema schema;
    private final boolean forceRangeScan;
    private final boolean isPointLookup;
    public static final ImmutableBytesWritable UNBOUND = new ImmutableBytesWritable(KeyRange.UNBOUND);

    public static ScanRanges create(List<List<KeyRange>> ranges, RowKeySchema schema) {
        return ScanRanges.create(ranges, schema, false, null);
    }

    public static ScanRanges create(List<List<KeyRange>> ranges, RowKeySchema schema, boolean forceRangeScan, Integer nBuckets) {
        boolean isPointLookup;
        int offset;
        int n = offset = nBuckets == null ? 0 : 1;
        if (ranges.size() == offset) {
            return EVERYTHING;
        }
        if (ranges.size() == 1 + offset && ranges.get(offset).size() == 1 && ranges.get(offset).get(0) == KeyRange.EMPTY_RANGE) {
            return NOTHING;
        }
        boolean bl = isPointLookup = !forceRangeScan && ScanRanges.isPointLookup(schema, ranges);
        if (isPointLookup) {
            List<byte[]> keys = ScanRanges.getPointKeys(ranges, schema, nBuckets);
            ArrayList<KeyRange> keyRanges = Lists.newArrayListWithExpectedSize(keys.size());
            for (byte[] key : keys) {
                keyRanges.add(KeyRange.getKeyRange(key));
            }
            ranges = Collections.singletonList(keyRanges);
            schema = SchemaUtil.VAR_BINARY_SCHEMA;
        } else if (nBuckets != null) {
            ArrayList<List<KeyRange>> saltedRanges = Lists.newArrayListWithExpectedSize(ranges.size());
            saltedRanges.add(SaltingUtil.generateAllSaltingRanges(nBuckets));
            saltedRanges.addAll(ranges.subList(1, ranges.size()));
            ranges = saltedRanges;
        }
        return new ScanRanges(ranges, schema, forceRangeScan, isPointLookup);
    }

    private ScanRanges(List<List<KeyRange>> ranges, RowKeySchema schema, boolean forceRangeScan, boolean isPointLookup) {
        this.isPointLookup = isPointLookup;
        ArrayList sortedRanges = Lists.newArrayListWithExpectedSize(ranges.size());
        for (int i = 0; i < ranges.size(); ++i) {
            ArrayList sorted = Lists.newArrayList((Iterable)ranges.get(i));
            Collections.sort(sorted, KeyRange.COMPARATOR);
            sortedRanges.add(ImmutableList.copyOf(sorted));
        }
        this.ranges = ImmutableList.copyOf(sortedRanges);
        this.schema = schema;
        if (schema != null && !ranges.isEmpty()) {
            this.filter = new SkipScanFilter(this.ranges, schema);
        }
        this.forceRangeScan = forceRangeScan;
    }

    public SkipScanFilter getSkipScanFilter() {
        return this.filter;
    }

    public List<List<KeyRange>> getRanges() {
        return this.ranges;
    }

    public RowKeySchema getSchema() {
        return this.schema;
    }

    public boolean isEverything() {
        return this == EVERYTHING;
    }

    public boolean isDegenerate() {
        return this == NOTHING;
    }

    public boolean useSkipScanFilter() {
        if (this.forceRangeScan) {
            return false;
        }
        if (this.isPointLookup) {
            return this.getPointLookupCount() > 1;
        }
        boolean hasRangeKey = false;
        boolean useSkipScan = false;
        for (List<KeyRange> orRanges : this.ranges) {
            if (useSkipScan |= orRanges.size() > 1 | hasRangeKey) {
                return true;
            }
            for (KeyRange range : orRanges) {
                hasRangeKey |= !range.isSingleKey();
            }
        }
        return false;
    }

    private static boolean isPointLookup(RowKeySchema schema, List<List<KeyRange>> ranges) {
        if (ranges.size() < schema.getMaxFields()) {
            return false;
        }
        for (List<KeyRange> orRanges : ranges) {
            for (KeyRange keyRange : orRanges) {
                if (keyRange.isSingleKey()) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean incrementKey(List<List<KeyRange>> slots, int[] position) {
        int idx;
        for (idx = slots.size() - 1; idx >= 0 && (position[idx] = (position[idx] + 1) % slots.get(idx).size()) == 0; --idx) {
        }
        return idx >= 0;
    }

    private static List<byte[]> getPointKeys(List<List<KeyRange>> ranges, RowKeySchema schema, Integer bucketNum) {
        int offset;
        if (ranges == null || ranges.isEmpty()) {
            return Collections.emptyList();
        }
        boolean isSalted = bucketNum != null;
        int count = 1;
        for (int i = offset = isSalted ? 1 : 0; i < ranges.size(); ++i) {
            count *= ranges.get(i).size();
        }
        ArrayList<byte[]> keys = Lists.newArrayListWithExpectedSize(count);
        int[] position = new int[ranges.size()];
        int maxKeyLength = SchemaUtil.getMaxKeyLength(schema, ranges);
        byte[] key = new byte[maxKeyLength];
        do {
            int length = ScanUtil.setKey(schema, ranges, position, KeyRange.Bound.LOWER, key, offset, offset, ranges.size(), offset);
            if (isSalted) {
                key[0] = SaltingUtil.getSaltingByte(key, offset, length, bucketNum);
            }
            keys.add(Arrays.copyOf(key, length + offset));
        } while (ScanRanges.incrementKey(ranges, position));
        return keys;
    }

    public boolean isPointLookup() {
        return this.isPointLookup;
    }

    public int getPointLookupCount() {
        return this.isPointLookup ? this.ranges.get(0).size() : 0;
    }

    public Iterator<KeyRange> getPointLookupKeyIterator() {
        return this.isPointLookup ? this.ranges.get(0).iterator() : Iterators.emptyIterator();
    }

    public void setScanStartStopRow(Scan scan) {
        if (this.isEverything()) {
            return;
        }
        if (this.isDegenerate()) {
            scan.setStartRow(KeyRange.EMPTY_RANGE.getLowerRange());
            scan.setStopRow(KeyRange.EMPTY_RANGE.getUpperRange());
            return;
        }
        byte[] expectedKey = ScanUtil.getMinKey(this.schema, this.ranges);
        if (expectedKey != null) {
            scan.setStartRow(expectedKey);
        }
        if ((expectedKey = ScanUtil.getMaxKey(this.schema, this.ranges)) != null) {
            scan.setStopRow(expectedKey);
        }
    }

    public boolean intersect(byte[] lowerInclusiveKey, byte[] upperExclusiveKey) {
        if (this.isEverything()) {
            return true;
        }
        if (this.isDegenerate()) {
            return false;
        }
        return this.filter.hasIntersect(lowerInclusiveKey, upperExclusiveKey);
    }

    public String toString() {
        return "ScanRanges[" + this.ranges.toString() + "]";
    }
}

