/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import java.sql.SQLException;
import java.text.Format;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.compile.AggregationManager;
import org.apache.phoenix.compile.BindManager;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.compile.ExpressionManager;
import org.apache.phoenix.compile.FromCompiler;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.compile.SequenceManager;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.schema.MetaDataClient;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.util.DateUtil;
import org.apache.phoenix.util.ScanUtil;

public class StatementContext {
    private ColumnResolver resolver;
    private final BindManager binds;
    private final Scan scan;
    private final ExpressionManager expressions;
    private final AggregationManager aggregates;
    private final String dateFormat;
    private final Format dateFormatter;
    private final Format dateParser;
    private final String numberFormat;
    private final ImmutableBytesWritable tempPtr;
    private final PhoenixStatement statement;
    private long currentTime = -1L;
    private ScanRanges scanRanges = ScanRanges.EVERYTHING;
    private KeyRange minMaxRange = null;
    private final SequenceManager sequences;
    private TableRef currentTable;
    private List<Pair<byte[], byte[]>> whereConditionColumns;

    public StatementContext(PhoenixStatement statement) {
        this(statement, FromCompiler.EMPTY_TABLE_RESOLVER, new Scan());
    }

    public StatementContext(PhoenixStatement statement, ColumnResolver resolver, Scan scan) {
        this.statement = statement;
        this.resolver = resolver;
        this.scan = scan;
        this.binds = new BindManager(statement.getParameters());
        this.aggregates = new AggregationManager();
        this.expressions = new ExpressionManager();
        PhoenixConnection connection = statement.getConnection();
        this.dateFormat = connection.getQueryServices().getProps().get("phoenix.query.dateFormat", "yyyy-MM-dd HH:mm:ss");
        this.dateFormatter = DateUtil.getDateFormatter(this.dateFormat);
        this.dateParser = DateUtil.getDateParser(this.dateFormat);
        this.numberFormat = connection.getQueryServices().getProps().get("phoenix.query.numberFormat", "#,##0.###");
        this.tempPtr = new ImmutableBytesWritable();
        this.currentTable = resolver != null && !resolver.getTables().isEmpty() ? resolver.getTables().get(0) : null;
        this.sequences = new SequenceManager(statement);
        this.whereConditionColumns = new ArrayList<Pair<byte[], byte[]>>();
    }

    public String getDateFormat() {
        return this.dateFormat;
    }

    public Format getDateFormatter() {
        return this.dateFormatter;
    }

    public Format getDateParser() {
        return this.dateParser;
    }

    public String getNumberFormat() {
        return this.numberFormat;
    }

    public Scan getScan() {
        return this.scan;
    }

    public BindManager getBindManager() {
        return this.binds;
    }

    public TableRef getCurrentTable() {
        return this.currentTable;
    }

    public void setCurrentTable(TableRef table) {
        this.currentTable = table;
    }

    public AggregationManager getAggregationManager() {
        return this.aggregates;
    }

    public ColumnResolver getResolver() {
        return this.resolver;
    }

    public void setResolver(ColumnResolver resolver) {
        this.resolver = resolver;
    }

    public ExpressionManager getExpressionManager() {
        return this.expressions;
    }

    public ImmutableBytesWritable getTempPtr() {
        return this.tempPtr;
    }

    public ScanRanges getScanRanges() {
        return this.scanRanges;
    }

    public void setScanRanges(ScanRanges scanRanges) {
        this.setScanRanges(scanRanges, null);
    }

    public void setScanRanges(ScanRanges scanRanges, KeyRange minMaxRange) {
        this.scanRanges = scanRanges;
        this.scanRanges.setScanStartStopRow(this.scan);
        PTable table = this.getCurrentTable().getTable();
        if (minMaxRange != null) {
            byte[] lowerRange = minMaxRange.getLowerRange();
            if (!minMaxRange.lowerUnbound() && !minMaxRange.isLowerInclusive()) {
                lowerRange = ScanUtil.nextKey(lowerRange, table, this.tempPtr);
            }
            byte[] upperRange = minMaxRange.getUpperRange();
            if (!minMaxRange.upperUnbound() && minMaxRange.isUpperInclusive()) {
                upperRange = ScanUtil.nextKey(upperRange, table, this.tempPtr);
            }
            if (minMaxRange.getLowerRange() != lowerRange || minMaxRange.getUpperRange() != upperRange) {
                minMaxRange = KeyRange.getKeyRange(lowerRange, true, upperRange, false);
            }
            if (table.getBucketNum() == null) {
                minMaxRange = minMaxRange.intersect(KeyRange.getKeyRange(this.scan.getStartRow(), this.scan.getStopRow()));
                this.scan.setStartRow(minMaxRange.getLowerRange());
                this.scan.setStopRow(minMaxRange.getUpperRange());
            }
            this.minMaxRange = minMaxRange;
        }
    }

    public PhoenixConnection getConnection() {
        return this.statement.getConnection();
    }

    public PhoenixStatement getStatement() {
        return this.statement;
    }

    public long getCurrentTime() throws SQLException {
        long ts = this.getCurrentTable().getTimeStamp();
        if (ts != -1L) {
            return ts;
        }
        if (this.currentTime != -1L) {
            return this.currentTime;
        }
        PTable table = this.getCurrentTable().getTable();
        PhoenixConnection connection = this.getConnection();
        MetaDataClient client = new MetaDataClient(connection);
        this.currentTime = client.getCurrentTime(table.getSchemaName().getString(), table.getTableName().getString());
        return this.currentTime;
    }

    public KeyRange getMinMaxRange() {
        return this.minMaxRange;
    }

    public SequenceManager getSequenceManager() {
        return this.sequences;
    }

    public void addWhereCoditionColumn(byte[] cf, byte[] q) {
        this.whereConditionColumns.add(new Pair<byte[], byte[]>(cf, q));
    }

    public List<Pair<byte[], byte[]>> getWhereCoditionColumns() {
        return this.whereConditionColumns;
    }
}

