/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import com.google.common.collect.Lists;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.phoenix.compile.ExpressionCompiler;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.function.FunctionExpression;
import org.apache.phoenix.parse.CaseParseNode;
import org.apache.phoenix.parse.ColumnParseNode;
import org.apache.phoenix.parse.DivideParseNode;
import org.apache.phoenix.parse.MultiplyParseNode;
import org.apache.phoenix.parse.SubtractParseNode;
import org.apache.phoenix.schema.ColumnRef;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.util.SchemaUtil;

public class TrackOrderPreservingExpressionCompiler
extends ExpressionCompiler {
    private final List<Entry> entries;
    private final Ordering ordering;
    private final int positionOffset;
    private FunctionExpression.OrderPreserving orderPreserving = FunctionExpression.OrderPreserving.YES;
    private ColumnRef columnRef;
    private boolean isOrderPreserving = true;
    private Boolean isReverse;

    TrackOrderPreservingExpressionCompiler(StatementContext context, GroupByCompiler.GroupBy groupBy, int expectedEntrySize, Ordering ordering) {
        super(context, groupBy);
        PTable table = context.getResolver().getTables().get(0).getTable();
        boolean isSalted = table.getBucketNum() != null;
        boolean isMultiTenant = context.getConnection().getTenantId() != null && table.isMultiTenant();
        boolean isSharedViewIndex = table.getViewIndexId() != null;
        this.positionOffset = (isSalted ? 1 : 0) + (isMultiTenant ? 1 : 0) + (isSharedViewIndex ? 1 : 0);
        this.entries = Lists.newArrayListWithExpectedSize(expectedEntrySize);
        this.ordering = ordering;
    }

    public Boolean isReverse() {
        return this.isReverse;
    }

    public boolean isOrderPreserving() {
        if (!this.isOrderPreserving) {
            return false;
        }
        if (this.ordering == Ordering.UNORDERED) {
            Collections.sort(this.entries, new Comparator<Entry>(){

                @Override
                public int compare(Entry o1, Entry o2) {
                    return o1.getPkPosition() - o2.getPkPosition();
                }
            });
        }
        int prevPos = this.positionOffset - 1;
        FunctionExpression.OrderPreserving prevOrderPreserving = FunctionExpression.OrderPreserving.YES;
        for (int i = 0; i < this.entries.size() && this.isOrderPreserving; ++i) {
            Entry entry = this.entries.get(i);
            int pos = entry.getPkPosition();
            this.isOrderPreserving &= entry.getOrderPreserving() != FunctionExpression.OrderPreserving.NO && (pos == prevPos || pos - 1 == prevPos && prevOrderPreserving == FunctionExpression.OrderPreserving.YES);
            prevPos = pos;
            prevOrderPreserving = this.entries.get(i).getOrderPreserving();
        }
        return this.isOrderPreserving;
    }

    @Override
    protected Expression addExpression(Expression expression) {
        if (expression instanceof FunctionExpression) {
            this.orderPreserving = FunctionExpression.OrderPreserving.values()[Math.min(this.orderPreserving.ordinal(), ((FunctionExpression)expression).preservesOrder().ordinal())];
        }
        return super.addExpression(expression);
    }

    @Override
    public boolean visitEnter(CaseParseNode node) throws SQLException {
        this.orderPreserving = FunctionExpression.OrderPreserving.NO;
        return super.visitEnter(node);
    }

    @Override
    public boolean visitEnter(DivideParseNode node) throws SQLException {
        this.orderPreserving = FunctionExpression.OrderPreserving.NO;
        return super.visitEnter(node);
    }

    @Override
    public boolean visitEnter(SubtractParseNode node) throws SQLException {
        this.orderPreserving = FunctionExpression.OrderPreserving.NO;
        return super.visitEnter(node);
    }

    @Override
    public boolean visitEnter(MultiplyParseNode node) throws SQLException {
        this.orderPreserving = FunctionExpression.OrderPreserving.NO;
        return super.visitEnter(node);
    }

    @Override
    public void reset() {
        super.reset();
        this.columnRef = null;
        this.orderPreserving = FunctionExpression.OrderPreserving.YES;
    }

    @Override
    protected ColumnRef resolveColumn(ColumnParseNode node) throws SQLException {
        ColumnRef ref = super.resolveColumn(node);
        if (!SchemaUtil.isPKColumn(ref.getColumn())) {
            this.orderPreserving = FunctionExpression.OrderPreserving.NO;
        }
        if (this.columnRef == null) {
            this.columnRef = ref;
        } else if (!this.columnRef.equals(ref)) {
            this.orderPreserving = FunctionExpression.OrderPreserving.NO;
        }
        return ref;
    }

    public boolean addEntry(Expression expression) {
        if (expression instanceof LiteralExpression) {
            return false;
        }
        this.isOrderPreserving &= this.orderPreserving != FunctionExpression.OrderPreserving.NO;
        this.entries.add(new Entry(expression, this.columnRef, this.orderPreserving));
        return true;
    }

    public boolean addEntry(Expression expression, SortOrder sortOrder) {
        if (expression.getSortOrder() != sortOrder) {
            if (this.isReverse == null) {
                this.isReverse = true;
            } else if (!this.isReverse.booleanValue()) {
                this.orderPreserving = FunctionExpression.OrderPreserving.NO;
            }
        } else if (this.isReverse == null) {
            this.isReverse = false;
        } else if (this.isReverse.booleanValue()) {
            this.orderPreserving = FunctionExpression.OrderPreserving.NO;
        }
        return this.addEntry(expression);
    }

    public List<Entry> getEntries() {
        return this.entries;
    }

    public static class Entry {
        private final Expression expression;
        private final ColumnRef columnRef;
        private final FunctionExpression.OrderPreserving orderPreserving;

        private Entry(Expression expression, ColumnRef columnRef, FunctionExpression.OrderPreserving orderPreserving) {
            this.expression = expression;
            this.columnRef = columnRef;
            this.orderPreserving = orderPreserving;
        }

        public Expression getExpression() {
            return this.expression;
        }

        public int getPkPosition() {
            return this.columnRef.getPKSlotPosition();
        }

        public int getColumnPosition() {
            return this.columnRef.getColumnPosition();
        }

        public FunctionExpression.OrderPreserving getOrderPreserving() {
            return this.orderPreserving;
        }
    }

    public static enum Ordering {
        ORDERED,
        UNORDERED;

    }
}

