/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.sql.ParameterMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.cache.ServerCacheClient;
import org.apache.phoenix.compile.ColumnResolver;
import org.apache.phoenix.compile.ExplainPlan;
import org.apache.phoenix.compile.ExpressionCompiler;
import org.apache.phoenix.compile.FromCompiler;
import org.apache.phoenix.compile.GroupByCompiler;
import org.apache.phoenix.compile.MutatingParallelIteratorFactory;
import org.apache.phoenix.compile.MutationPlan;
import org.apache.phoenix.compile.OrderByCompiler;
import org.apache.phoenix.compile.ProjectionCompiler;
import org.apache.phoenix.compile.QueryPlan;
import org.apache.phoenix.compile.RowProjector;
import org.apache.phoenix.compile.SequenceManager;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.compile.StatementNormalizer;
import org.apache.phoenix.coprocessor.UngroupedAggregateRegionObserver;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.execute.AggregatePlan;
import org.apache.phoenix.execute.MutationState;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.index.IndexMetaDataCacheClient;
import org.apache.phoenix.iterate.ResultIterator;
import org.apache.phoenix.iterate.SequenceResultIterator;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixResultSet;
import org.apache.phoenix.jdbc.PhoenixStatement;
import org.apache.phoenix.optimize.QueryOptimizer;
import org.apache.phoenix.parse.AliasedNode;
import org.apache.phoenix.parse.BindParseNode;
import org.apache.phoenix.parse.ColumnName;
import org.apache.phoenix.parse.FilterableStatement;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.parse.LiteralParseNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.SelectStatement;
import org.apache.phoenix.parse.SequenceValueParseNode;
import org.apache.phoenix.parse.UpsertStatement;
import org.apache.phoenix.query.ConnectionQueryServices;
import org.apache.phoenix.schema.ColumnRef;
import org.apache.phoenix.schema.ConstraintViolationException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnImpl;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableImpl;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.ReadOnlyTableException;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.TypeMismatchException;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.SchemaUtil;

public class UpsertCompiler {
    private final PhoenixStatement statement;

    private static void setValues(byte[][] values, int[] pkSlotIndex, int[] columnIndexes, PTable table, Map<ImmutableBytesPtr, Map<PColumn, byte[]>> mutation) {
        HashMap<PColumn, byte[]> columnValues = Maps.newHashMapWithExpectedSize(columnIndexes.length);
        byte[][] pkValues = new byte[table.getPKColumns().size()][];
        if (table.getBucketNum() != null) {
            pkValues[0] = new byte[]{0};
        }
        for (int i = 0; i < values.length; ++i) {
            byte[] value = values[i];
            PColumn column = table.getColumns().get(columnIndexes[i]);
            if (SchemaUtil.isPKColumn(column)) {
                pkValues[pkSlotIndex[i]] = value;
                continue;
            }
            columnValues.put(column, value);
        }
        ImmutableBytesPtr ptr = new ImmutableBytesPtr();
        table.newKey(ptr, pkValues);
        mutation.put(ptr, columnValues);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MutationState upsertSelect(PhoenixStatement statement, TableRef tableRef, RowProjector projector, ResultIterator iterator, int[] columnIndexes, int[] pkSlotIndexes) throws SQLException {
        try {
            PhoenixConnection connection = statement.getConnection();
            ConnectionQueryServices services = connection.getQueryServices();
            int maxSize = services.getProps().getInt("phoenix.mutate.maxSize", 500000);
            int batchSize = Math.min(connection.getMutateBatchSize(), maxSize);
            boolean isAutoCommit = connection.getAutoCommit();
            byte[][] values = new byte[columnIndexes.length][];
            int rowCount = 0;
            HashMap<ImmutableBytesPtr, Map<PColumn, byte[]>> mutation = Maps.newHashMapWithExpectedSize(batchSize);
            PTable table = tableRef.getTable();
            PhoenixResultSet rs = new PhoenixResultSet(iterator, projector, statement);
            ImmutableBytesWritable ptr = new ImmutableBytesWritable();
            while (rs.next()) {
                for (int i = 0; i < values.length; ++i) {
                    Integer scale;
                    PColumn column = table.getColumns().get(columnIndexes[i]);
                    byte[] bytes = rs.getBytes(i + 1);
                    ptr.set(bytes == null ? ByteUtil.EMPTY_BYTE_ARRAY : bytes);
                    Object value = rs.getObject(i + 1);
                    int rsPrecision = rs.getMetaData().getPrecision(i + 1);
                    Integer precision = rsPrecision == 0 ? null : Integer.valueOf(rsPrecision);
                    int rsScale = rs.getMetaData().getScale(i + 1);
                    Integer n = scale = rsScale == 0 ? null : Integer.valueOf(rsScale);
                    if (!column.getDataType().isSizeCompatible(ptr, value, column.getDataType(), precision, scale, column.getMaxLength(), column.getScale())) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.DATA_EXCEEDS_MAX_CAPACITY).setColumnName(column.getName().getString()).setMessage("value=" + column.getDataType().toStringLiteral(ptr, null)).build().buildException();
                    }
                    column.getDataType().coerceBytes(ptr, value, column.getDataType(), precision, scale, SortOrder.getDefault(), column.getMaxLength(), column.getScale(), column.getSortOrder());
                    values[i] = ByteUtil.copyKeyBytesIfNecessary(ptr);
                }
                UpsertCompiler.setValues(values, pkSlotIndexes, columnIndexes, table, mutation);
                if (!isAutoCommit || ++rowCount % batchSize != 0) continue;
                MutationState state = new MutationState(tableRef, mutation, 0L, maxSize, connection);
                connection.getMutationState().join(state);
                connection.commit();
                mutation.clear();
            }
            MutationState mutationState = new MutationState(tableRef, mutation, rowCount / batchSize * batchSize, maxSize, connection);
            return mutationState;
        }
        finally {
            iterator.close();
        }
    }

    public UpsertCompiler(PhoenixStatement statement) {
        this.statement = statement;
    }

    public MutationPlan compile(UpsertStatement upsert) throws SQLException {
        int nValuesToSet;
        ArrayList<PColumn> targetColumns;
        int[] pkSlotIndexesToBe;
        int[] columnIndexesToBe;
        final PhoenixConnection connection = this.statement.getConnection();
        ConnectionQueryServices services = connection.getQueryServices();
        final int maxSize = services.getProps().getInt("phoenix.mutate.maxSize", 500000);
        ColumnResolver resolver = FromCompiler.getResolverForMutation(upsert, connection);
        final TableRef tableRef = resolver.getTables().get(0);
        PTable table = tableRef.getTable();
        if (table.getType() == PTableType.VIEW && table.getViewType().isReadOnly()) {
            throw new ReadOnlyTableException(table.getSchemaName().getString(), table.getTableName().getString());
        }
        boolean isSalted = table.getBucketNum() != null;
        boolean isTenantSpecific = table.isMultiTenant() && connection.getTenantId() != null;
        boolean isSharedViewIndex = table.getViewIndexId() != null;
        String tenantId = isTenantSpecific ? connection.getTenantId().getString() : null;
        int posOffset = isSalted ? 1 : 0;
        List<ColumnName> columnNodes = upsert.getColumns();
        final List<PColumn> allColumns = table.getColumns();
        Set<PColumn> addViewColumnsToBe = Collections.emptySet();
        Set<PColumn> overlapViewColumnsToBe = Collections.emptySet();
        int nColumnsToSet = 0;
        if (table.getViewType() == PTable.ViewType.UPDATABLE) {
            addViewColumnsToBe = Sets.newLinkedHashSetWithExpectedSize(allColumns.size());
            for (PColumn column : allColumns) {
                if (column.getViewConstant() == null) continue;
                addViewColumnsToBe.add(column);
            }
        }
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        if (columnNodes.isEmpty() || columnNodes.size() == upsert.getTable().getDynamicColumns().size()) {
            nColumnsToSet = allColumns.size() - posOffset;
            columnIndexesToBe = new int[nColumnsToSet];
            pkSlotIndexesToBe = new int[columnIndexesToBe.length];
            targetColumns = Lists.newArrayListWithExpectedSize(columnIndexesToBe.length);
            targetColumns.addAll(Collections.nCopies(columnIndexesToBe.length, null));
            int minPKPos = 0;
            if (isTenantSpecific) {
                PColumn tenantColumn = table.getPKColumns().get(minPKPos);
                columnIndexesToBe[minPKPos] = tenantColumn.getPosition();
                targetColumns.set(minPKPos, tenantColumn);
                ++minPKPos;
            }
            if (isSharedViewIndex) {
                PColumn indexIdColumn = table.getPKColumns().get(minPKPos);
                columnIndexesToBe[minPKPos] = indexIdColumn.getPosition();
                targetColumns.set(minPKPos, indexIdColumn);
                ++minPKPos;
            }
            int j = 0;
            for (int i = posOffset; i < allColumns.size(); ++i) {
                PColumn column = allColumns.get(i);
                if (SchemaUtil.isPKColumn(column)) {
                    pkSlotIndexesToBe[i - posOffset] = j + posOffset;
                    if (j++ < minPKPos) continue;
                    minPKPos = 0;
                }
                columnIndexesToBe[i - posOffset + minPKPos] = i;
                targetColumns.set(i - posOffset + minPKPos, column);
            }
            if (!addViewColumnsToBe.isEmpty()) {
                overlapViewColumnsToBe = addViewColumnsToBe;
                addViewColumnsToBe = Collections.emptySet();
            }
        } else {
            int numColsInUpsert = columnNodes.size();
            nColumnsToSet = numColsInUpsert + addViewColumnsToBe.size() + (isTenantSpecific ? 1 : 0) + (isSharedViewIndex ? 1 : 0);
            columnIndexesToBe = new int[nColumnsToSet];
            pkSlotIndexesToBe = new int[columnIndexesToBe.length];
            targetColumns = Lists.newArrayListWithExpectedSize(columnIndexesToBe.length);
            targetColumns.addAll(Collections.nCopies(columnIndexesToBe.length, null));
            Arrays.fill(columnIndexesToBe, -1);
            Arrays.fill(pkSlotIndexesToBe, -1);
            BitSet pkColumnsSet = new BitSet(table.getPKColumns().size());
            int i = 0;
            if (isTenantSpecific) {
                PColumn tenantColumn = table.getPKColumns().get(i + posOffset);
                columnIndexesToBe[i] = tenantColumn.getPosition();
                pkSlotIndexesToBe[i] = i + posOffset;
                pkColumnsSet.set(pkSlotIndexesToBe[i]);
                targetColumns.set(i, tenantColumn);
                ++i;
            }
            if (isSharedViewIndex) {
                PColumn indexIdColumn = table.getPKColumns().get(i + posOffset);
                columnIndexesToBe[i] = indexIdColumn.getPosition();
                pkSlotIndexesToBe[i] = i + posOffset;
                pkColumnsSet.set(pkSlotIndexesToBe[i]);
                targetColumns.set(i, indexIdColumn);
                ++i;
            }
            for (ColumnName colName : columnNodes) {
                ColumnRef ref = resolver.resolveColumn(null, colName.getFamilyName(), colName.getColumnName());
                PColumn column = ref.getColumn();
                if (IndexUtil.getViewConstantValue(column, ptr)) {
                    if (overlapViewColumnsToBe.isEmpty()) {
                        overlapViewColumnsToBe = Sets.newHashSetWithExpectedSize(addViewColumnsToBe.size());
                    }
                    --nColumnsToSet;
                    overlapViewColumnsToBe.add(column);
                    addViewColumnsToBe.remove(column);
                }
                columnIndexesToBe[i] = ref.getColumnPosition();
                targetColumns.set(i, column);
                if (SchemaUtil.isPKColumn(column)) {
                    pkSlotIndexesToBe[i] = ref.getPKSlotPosition();
                    pkColumnsSet.set(pkSlotIndexesToBe[i]);
                }
                ++i;
            }
            for (PColumn column : addViewColumnsToBe) {
                columnIndexesToBe[i] = column.getPosition();
                targetColumns.set(i, column);
                if (SchemaUtil.isPKColumn(column)) {
                    pkSlotIndexesToBe[i] = SchemaUtil.getPKPosition(table, column);
                    pkColumnsSet.set(pkSlotIndexesToBe[i]);
                }
                ++i;
            }
            for (i = posOffset; i < table.getPKColumns().size(); ++i) {
                PColumn pkCol = table.getPKColumns().get(i);
                if (pkColumnsSet.get(i) || pkCol.isNullable()) continue;
                throw new ConstraintViolationException(table.getName().getString() + "." + pkCol.getName().getString() + " may not be null");
            }
        }
        List<ParseNode> valueNodes = upsert.getValues();
        QueryPlan plan = null;
        RowProjector rowProjectorToBe = null;
        boolean sameTable = false;
        boolean runOnServer = false;
        UpsertingParallelIteratorFactory upsertParallelIteratorFactoryToBe = null;
        boolean isAutoCommit = connection.getAutoCommit();
        if (valueNodes == null) {
            SelectStatement select = upsert.getSelect();
            assert (select != null);
            ColumnResolver selectResolver = FromCompiler.getResolverForQuery(select, connection);
            select = StatementNormalizer.normalize(select, selectResolver);
            sameTable = (select = UpsertCompiler.prependTenantAndViewConstants(table, select, tenantId, addViewColumnsToBe)).getFrom().size() == 1 && tableRef.equals(selectResolver.getTables().get(0));
            runOnServer = sameTable && isAutoCommit && !table.isImmutableRows() && !select.isAggregate() && !select.isDistinct() && select.getLimit() == null && table.getBucketNum() == null;
            UpsertingParallelIteratorFactory parallelIteratorFactory = select.isAggregate() || select.isDistinct() || select.getLimit() != null ? null : (upsertParallelIteratorFactoryToBe = new UpsertingParallelIteratorFactory(connection, tableRef));
            HintNode hint = upsert.getHint();
            if (!upsert.getHint().hasHint(HintNode.Hint.USE_INDEX_OVER_DATA_TABLE)) {
                hint = HintNode.create(hint, HintNode.Hint.USE_DATA_OVER_INDEX_TABLE);
            }
            select = SelectStatement.create(select, hint);
            plan = new QueryOptimizer(services).optimize(this.statement, select, selectResolver, targetColumns, parallelIteratorFactory);
            runOnServer &= plan.getTableRef().equals(tableRef);
            rowProjectorToBe = plan.getProjector();
            nValuesToSet = rowProjectorToBe.getColumnCount();
        } else {
            nValuesToSet = valueNodes.size() + addViewColumnsToBe.size() + (isTenantSpecific ? 1 : 0) + (isSharedViewIndex ? 1 : 0);
        }
        final RowProjector projector = rowProjectorToBe;
        final UpsertingParallelIteratorFactory upsertParallelIteratorFactory = upsertParallelIteratorFactoryToBe;
        final QueryPlan queryPlan = plan;
        if (columnNodes.isEmpty() && columnIndexesToBe.length >= nValuesToSet) {
            nColumnsToSet = nValuesToSet;
            columnIndexesToBe = Arrays.copyOf(columnIndexesToBe, nValuesToSet);
            pkSlotIndexesToBe = Arrays.copyOf(pkSlotIndexesToBe, nValuesToSet);
        }
        if (nValuesToSet != nColumnsToSet) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.UPSERT_COLUMN_NUMBERS_MISMATCH).setMessage("Numbers of columns: " + nColumnsToSet + ". Number of values: " + nValuesToSet).build().buildException();
        }
        final int[] columnIndexes = columnIndexesToBe;
        final int[] pkSlotIndexes = pkSlotIndexesToBe;
        final Set<PColumn> addViewColumns = addViewColumnsToBe;
        final Set<PColumn> overlapViewColumns = overlapViewColumnsToBe;
        if (valueNodes == null) {
            UpsertCompiler.throwIfNotUpdatable(tableRef, overlapViewColumnsToBe, targetColumns, projector, sameTable);
            if (runOnServer) {
                PColumn column;
                int i;
                int[] allColumnsIndexes = Arrays.copyOf(columnIndexes, columnIndexes.length + nValuesToSet);
                int[] reverseColumnIndexes = new int[table.getColumns().size()];
                ArrayList<Expression> projectedExpressions = Lists.newArrayListWithExpectedSize(reverseColumnIndexes.length);
                Arrays.fill(reverseColumnIndexes, -1);
                for (int i2 = 0; i2 < nValuesToSet; ++i2) {
                    projectedExpressions.add(projector.getColumnProjector(i2).getExpression());
                    reverseColumnIndexes[columnIndexes[i2]] = i2;
                }
                int offset = table.getBucketNum() == null ? 0 : 1;
                for (i = 0; i < table.getPKColumns().size() - offset; ++i) {
                    column = table.getPKColumns().get(i + offset);
                    int pos = reverseColumnIndexes[column.getPosition()];
                    if (pos == -1) {
                        if (column.getDataType().isFixedWidth()) continue;
                        pos = projectedExpressions.size();
                        LiteralExpression literalNull = LiteralExpression.newConstant(null, column.getDataType(), true);
                        projectedExpressions.add(literalNull);
                        allColumnsIndexes[pos] = column.getPosition();
                    }
                    Collections.swap(projectedExpressions, i, pos);
                    int tempPos = allColumnsIndexes[i];
                    allColumnsIndexes[i] = allColumnsIndexes[pos];
                    allColumnsIndexes[pos] = tempPos;
                    reverseColumnIndexes[tempPos] = reverseColumnIndexes[i];
                    reverseColumnIndexes[i] = i;
                }
                for (i = 0; i < table.getPKColumns().size(); ++i) {
                    column = table.getPKColumns().get(i);
                    Expression source = (Expression)projectedExpressions.get(i);
                    if (source != null && source.equals(new ColumnRef(tableRef, column.getPosition()).newColumnExpression())) continue;
                    runOnServer = false;
                    break;
                }
                if (runOnServer) {
                    ArrayList<PColumn> projectedColumns = Lists.newArrayListWithExpectedSize(projectedExpressions.size());
                    for (int i3 = 0; i3 < projectedExpressions.size(); ++i3) {
                        PColumn column2 = allColumns.get(allColumnsIndexes[i3]);
                        projectedColumns.add(column2.getPosition() == i3 ? column2 : new PColumnImpl(column2, i3));
                    }
                    PTableImpl projectedTable = PTableImpl.makePTable(table, projectedColumns);
                    SelectStatement select = SelectStatement.create(SelectStatement.COUNT_ONE, upsert.getHint());
                    final RowProjector aggProjector = ProjectionCompiler.compile(queryPlan.getContext(), select, GroupByCompiler.GroupBy.EMPTY_GROUP_BY);
                    final StatementContext context = queryPlan.getContext();
                    final Scan scan = context.getScan();
                    scan.setAttribute("_UpsertSelectTable", UngroupedAggregateRegionObserver.serialize(projectedTable));
                    scan.setAttribute("_UpsertSelectExprs", UngroupedAggregateRegionObserver.serialize(projectedExpressions));
                    final AggregatePlan aggPlan = new AggregatePlan(context, (FilterableStatement)select, tableRef, aggProjector, null, OrderByCompiler.OrderBy.EMPTY_ORDER_BY, null, GroupByCompiler.GroupBy.EMPTY_GROUP_BY, null);
                    return new MutationPlan(){

                        @Override
                        public PhoenixConnection getConnection() {
                            return connection;
                        }

                        @Override
                        public ParameterMetaData getParameterMetaData() {
                            return queryPlan.getContext().getBindManager().getParameterMetaData();
                        }

                        @Override
                        public StatementContext getContext() {
                            return queryPlan.getContext();
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public MutationState execute() throws SQLException {
                            ImmutableBytesWritable ptr = context.getTempPtr();
                            tableRef.getTable().getIndexMaintainers(ptr);
                            ServerCacheClient.ServerCache cache = null;
                            try {
                                MutationState mutationState;
                                if (ptr.getLength() > 0) {
                                    IndexMetaDataCacheClient client = new IndexMetaDataCacheClient(connection, tableRef);
                                    cache = client.addIndexMetadataCache(context.getScanRanges(), ptr);
                                    byte[] uuidValue = cache.getId();
                                    scan.setAttribute("IdxUUID", uuidValue);
                                }
                                ResultIterator iterator = aggPlan.iterator();
                                try {
                                    Tuple row = iterator.next();
                                    final long mutationCount = (Long)aggProjector.getColumnProjector(0).getValue(row, PDataType.LONG, ptr);
                                    mutationState = new MutationState(maxSize, connection){

                                        @Override
                                        public long getUpdateCount() {
                                            return mutationCount;
                                        }
                                    };
                                }
                                catch (Throwable throwable) {
                                    iterator.close();
                                    throw throwable;
                                }
                                iterator.close();
                                return mutationState;
                            }
                            finally {
                                if (cache != null) {
                                    cache.close();
                                }
                            }
                        }

                        @Override
                        public ExplainPlan getExplainPlan() throws SQLException {
                            List<String> queryPlanSteps = aggPlan.getExplainPlan().getPlanSteps();
                            ArrayList<String> planSteps = Lists.newArrayListWithExpectedSize(queryPlanSteps.size() + 1);
                            planSteps.add("UPSERT ROWS");
                            planSteps.addAll(queryPlanSteps);
                            return new ExplainPlan(planSteps);
                        }
                    };
                }
            }
            return new MutationPlan(){

                @Override
                public PhoenixConnection getConnection() {
                    return connection;
                }

                @Override
                public ParameterMetaData getParameterMetaData() {
                    return queryPlan.getContext().getBindManager().getParameterMetaData();
                }

                @Override
                public StatementContext getContext() {
                    return queryPlan.getContext();
                }

                @Override
                public MutationState execute() throws SQLException {
                    Tuple tuple;
                    ResultIterator iterator = queryPlan.iterator();
                    if (upsertParallelIteratorFactory == null) {
                        return UpsertCompiler.upsertSelect(UpsertCompiler.this.statement, tableRef, projector, iterator, columnIndexes, pkSlotIndexes);
                    }
                    upsertParallelIteratorFactory.setRowProjector(projector);
                    upsertParallelIteratorFactory.setColumnIndexes(columnIndexes);
                    upsertParallelIteratorFactory.setPkSlotIndexes(pkSlotIndexes);
                    long totalRowCount = 0L;
                    while ((tuple = iterator.next()) != null) {
                        Cell kv = tuple.getValue(0);
                        totalRowCount += PDataType.LONG.getCodec().decodeLong(kv.getValueArray(), kv.getValueOffset(), SortOrder.getDefault());
                    }
                    return new MutationState(maxSize, UpsertCompiler.this.statement.getConnection(), totalRowCount);
                }

                @Override
                public ExplainPlan getExplainPlan() throws SQLException {
                    List<String> queryPlanSteps = queryPlan.getExplainPlan().getPlanSteps();
                    ArrayList<String> planSteps = Lists.newArrayListWithExpectedSize(queryPlanSteps.size() + 1);
                    planSteps.add("UPSERT SELECT");
                    planSteps.addAll(queryPlanSteps);
                    return new ExplainPlan(planSteps);
                }
            };
        }
        int nodeIndex = 0;
        final byte[][] values = new byte[nValuesToSet][];
        if (isTenantSpecific) {
            values[nodeIndex++] = connection.getTenantId().getBytes();
        }
        if (isSharedViewIndex) {
            values[nodeIndex++] = MetaDataUtil.getViewIndexIdDataType().toBytes(table.getViewIndexId());
        }
        final int nodeIndexOffset = nodeIndex;
        final StatementContext context = new StatementContext(this.statement, resolver, new Scan());
        UpsertValuesCompiler expressionBuilder = new UpsertValuesCompiler(context);
        final ArrayList<Expression> constantExpressions = Lists.newArrayListWithExpectedSize(valueNodes.size());
        for (ParseNode valueNode : valueNodes) {
            if (!valueNode.isStateless()) {
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.VALUE_IN_UPSERT_NOT_CONSTANT).build().buildException();
            }
            PColumn column = allColumns.get(columnIndexes[nodeIndex]);
            expressionBuilder.setColumn(column);
            Expression expression = valueNode.accept(expressionBuilder);
            if (expression.getDataType() != null && !expression.getDataType().isCastableTo(column.getDataType())) {
                throw TypeMismatchException.newException(expression.getDataType(), column.getDataType(), "expression: " + expression.toString() + " in column " + column);
            }
            constantExpressions.add(expression);
            ++nodeIndex;
        }
        return new MutationPlan(){

            @Override
            public PhoenixConnection getConnection() {
                return connection;
            }

            @Override
            public ParameterMetaData getParameterMetaData() {
                return context.getBindManager().getParameterMetaData();
            }

            @Override
            public StatementContext getContext() {
                return context;
            }

            @Override
            public MutationState execute() throws SQLException {
                ImmutableBytesWritable ptr = context.getTempPtr();
                SequenceManager sequenceManager = context.getSequenceManager();
                int nodeIndex = nodeIndexOffset;
                Tuple tuple = sequenceManager.getSequenceCount() == 0 ? null : sequenceManager.newSequenceTuple(null);
                for (Expression constantExpression : constantExpressions) {
                    PColumn column = (PColumn)allColumns.get(columnIndexes[nodeIndex]);
                    constantExpression.evaluate(tuple, ptr);
                    Object value = null;
                    if (constantExpression.getDataType() != null) {
                        value = constantExpression.getDataType().toObject(ptr, constantExpression.getSortOrder(), constantExpression.getMaxLength(), constantExpression.getScale());
                        if (!constantExpression.getDataType().isCoercibleTo(column.getDataType(), value)) {
                            throw TypeMismatchException.newException(constantExpression.getDataType(), column.getDataType(), "expression: " + constantExpression.toString() + " in column " + column);
                        }
                        if (!column.getDataType().isSizeCompatible(ptr, value, constantExpression.getDataType(), constantExpression.getMaxLength(), constantExpression.getScale(), column.getMaxLength(), column.getScale())) {
                            throw new SQLExceptionInfo.Builder(SQLExceptionCode.DATA_EXCEEDS_MAX_CAPACITY).setColumnName(column.getName().getString()).setMessage("value=" + constantExpression.toString()).build().buildException();
                        }
                    }
                    column.getDataType().coerceBytes(ptr, value, constantExpression.getDataType(), constantExpression.getMaxLength(), constantExpression.getScale(), constantExpression.getSortOrder(), column.getMaxLength(), column.getScale(), column.getSortOrder());
                    if (overlapViewColumns.contains(column) && Bytes.compareTo(ptr.get(), ptr.getOffset(), ptr.getLength(), column.getViewConstant(), 0, column.getViewConstant().length - 1) != 0) {
                        throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_UPDATE_VIEW_COLUMN).setColumnName(column.getName().getString()).setMessage("value=" + constantExpression.toString()).build().buildException();
                    }
                    values[nodeIndex] = ByteUtil.copyKeyBytesIfNecessary(ptr);
                    ++nodeIndex;
                }
                for (PColumn column : addViewColumns) {
                    if (IndexUtil.getViewConstantValue(column, ptr)) {
                        values[nodeIndex++] = ByteUtil.copyKeyBytesIfNecessary(ptr);
                        continue;
                    }
                    throw new IllegalStateException();
                }
                HashMap<ImmutableBytesPtr, Map<PColumn, byte[]>> mutation = Maps.newHashMapWithExpectedSize(1);
                UpsertCompiler.setValues(values, pkSlotIndexes, columnIndexes, tableRef.getTable(), mutation);
                return new MutationState(tableRef, mutation, 0L, maxSize, connection);
            }

            @Override
            public ExplainPlan getExplainPlan() throws SQLException {
                ArrayList<String> planSteps = Lists.newArrayListWithExpectedSize(2);
                if (context.getSequenceManager().getSequenceCount() > 0) {
                    planSteps.add("CLIENT RESERVE " + context.getSequenceManager().getSequenceCount() + " SEQUENCES");
                }
                planSteps.add("PUT SINGLE ROW");
                return new ExplainPlan(planSteps);
            }
        };
    }

    private static SelectStatement prependTenantAndViewConstants(PTable table, SelectStatement select, String tenantId, Set<PColumn> addViewColumns) {
        if ((!table.isMultiTenant() || tenantId == null) && table.getViewIndexId() == null && addViewColumns.isEmpty()) {
            return select;
        }
        ArrayList<AliasedNode> selectNodes = Lists.newArrayListWithCapacity(select.getSelect().size() + 1 + addViewColumns.size());
        if (table.isMultiTenant() && tenantId != null) {
            selectNodes.add(new AliasedNode(null, new LiteralParseNode(tenantId)));
        }
        if (table.getViewIndexId() != null) {
            selectNodes.add(new AliasedNode(null, new LiteralParseNode(table.getViewIndexId())));
        }
        selectNodes.addAll(select.getSelect());
        for (PColumn column : addViewColumns) {
            byte[] byteValue = column.getViewConstant();
            Object value = column.getDataType().toObject(byteValue, 0, byteValue.length - 1);
            selectNodes.add(new AliasedNode(null, new LiteralParseNode(value)));
        }
        return SelectStatement.create(select, selectNodes);
    }

    private static void throwIfNotUpdatable(TableRef tableRef, Set<PColumn> overlapViewColumns, List<PColumn> targetColumns, RowProjector projector, boolean sameTable) throws SQLException {
        PTable table = tableRef.getTable();
        if (table.getViewType() == PTable.ViewType.UPDATABLE && !overlapViewColumns.isEmpty()) {
            ImmutableBytesWritable ptr = new ImmutableBytesWritable();
            for (int i = 0; i < targetColumns.size(); ++i) {
                PColumn targetColumn = targetColumns.get(i);
                if (!overlapViewColumns.contains(targetColumn)) continue;
                Expression source = projector.getColumnProjector(i).getExpression();
                if (source.isStateless()) {
                    source.evaluate(null, ptr);
                    if (Bytes.compareTo(ptr.get(), ptr.getOffset(), ptr.getLength(), targetColumn.getViewConstant(), 0, targetColumn.getViewConstant().length - 1) == 0) continue;
                }
                throw new SQLExceptionInfo.Builder(SQLExceptionCode.CANNOT_UPDATE_VIEW_COLUMN).setColumnName(targetColumn.getName().getString()).build().buildException();
            }
        }
    }

    private static final class UpsertValuesCompiler
    extends ExpressionCompiler {
        private PColumn column;

        private UpsertValuesCompiler(StatementContext context) {
            super(context);
        }

        public void setColumn(PColumn column) {
            this.column = column;
        }

        @Override
        public Expression visit(BindParseNode node) throws SQLException {
            if (this.isTopLevel()) {
                this.context.getBindManager().addParamMetaData(node, this.column);
                Object value = this.context.getBindManager().getBindValue(node);
                return LiteralExpression.newConstant(value, this.column.getDataType(), this.column.getSortOrder(), true);
            }
            return super.visit(node);
        }

        @Override
        public Expression visit(LiteralParseNode node) throws SQLException {
            if (this.isTopLevel()) {
                return LiteralExpression.newConstant(node.getValue(), this.column.getDataType(), this.column.getSortOrder(), true);
            }
            return super.visit(node);
        }

        @Override
        public Expression visit(SequenceValueParseNode node) throws SQLException {
            return this.context.getSequenceManager().newSequenceReference(node);
        }
    }

    private static class UpsertingParallelIteratorFactory
    extends MutatingParallelIteratorFactory {
        private RowProjector projector;
        private int[] columnIndexes;
        private int[] pkSlotIndexes;

        private UpsertingParallelIteratorFactory(PhoenixConnection connection, TableRef tableRef) {
            super(connection, tableRef);
        }

        @Override
        protected MutationState mutate(StatementContext context, ResultIterator iterator, PhoenixConnection connection) throws SQLException {
            PhoenixStatement statement = new PhoenixStatement(connection);
            if (context.getSequenceManager().getSequenceCount() > 0) {
                iterator = new SequenceResultIterator(iterator, context.getSequenceManager());
            }
            return UpsertCompiler.upsertSelect(statement, this.tableRef, this.projector, iterator, this.columnIndexes, this.pkSlotIndexes);
        }

        public void setRowProjector(RowProjector projector) {
            this.projector = projector;
        }

        public void setColumnIndexes(int[] columnIndexes) {
            this.columnIndexes = columnIndexes;
        }

        public void setPkSlotIndexes(int[] pkSlotIndexes) {
            this.pkSlotIndexes = pkSlotIndexes;
        }
    }
}

