/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.phoenix.compile.ExpressionCompiler;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.compile.WhereOptimizer;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.expression.AndExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.KeyValueColumnExpression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.visitor.KeyValueExpressionVisitor;
import org.apache.phoenix.filter.BooleanExpressionFilter;
import org.apache.phoenix.filter.MultiCFCQKeyValueComparisonFilter;
import org.apache.phoenix.filter.MultiCQKeyValueComparisonFilter;
import org.apache.phoenix.filter.RowKeyComparisonFilter;
import org.apache.phoenix.filter.SingleCFCQKeyValueComparisonFilter;
import org.apache.phoenix.filter.SingleCQKeyValueComparisonFilter;
import org.apache.phoenix.parse.ColumnParseNode;
import org.apache.phoenix.parse.FilterableStatement;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.parse.ParseNode;
import org.apache.phoenix.parse.ParseNodeFactory;
import org.apache.phoenix.schema.AmbiguousColumnException;
import org.apache.phoenix.schema.ColumnRef;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableType;
import org.apache.phoenix.schema.TableRef;
import org.apache.phoenix.schema.TypeMismatchException;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.SchemaUtil;

public class WhereCompiler {
    protected static final ParseNodeFactory NODE_FACTORY = new ParseNodeFactory();

    private WhereCompiler() {
    }

    public static Expression compile(StatementContext context, FilterableStatement statement) throws SQLException {
        return WhereCompiler.compile(context, statement, null);
    }

    public static Expression compile(StatementContext context, FilterableStatement statement, ParseNode viewWhere) throws SQLException {
        Expression expression;
        HashSet<Expression> extractedNodes = Sets.newHashSet();
        WhereExpressionCompiler whereCompiler = new WhereExpressionCompiler(context);
        ParseNode where = statement.getWhere();
        Expression expression2 = expression = where == null ? LiteralExpression.newConstant((Object)true, PDataType.BOOLEAN, true) : where.accept(whereCompiler);
        if (whereCompiler.isAggregate()) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.AGGREGATE_IN_WHERE).build().buildException();
        }
        if (expression.getDataType() != PDataType.BOOLEAN) {
            throw TypeMismatchException.newException(PDataType.BOOLEAN, expression.getDataType(), expression.toString());
        }
        if (viewWhere != null) {
            WhereExpressionCompiler viewWhereCompiler = new WhereExpressionCompiler(context, true);
            Expression viewExpression = viewWhere.accept(viewWhereCompiler);
            expression = AndExpression.create(Lists.newArrayList(expression, viewExpression));
        }
        expression = WhereOptimizer.pushKeyExpressionsToScan(context, statement, expression, extractedNodes);
        WhereCompiler.setScanFilter(context, statement, expression, whereCompiler.disambiguateWithFamily);
        return expression;
    }

    private static void setScanFilter(StatementContext context, FilterableStatement statement, Expression whereClause, boolean disambiguateWithFamily) {
        BooleanExpressionFilter filter = null;
        Scan scan = context.getScan();
        assert (scan.getFilter() == null);
        if (LiteralExpression.isFalse(whereClause)) {
            context.setScanRanges(ScanRanges.NOTHING);
        } else if (whereClause != null && !LiteralExpression.isTrue(whereClause)) {
            final Counter counter = new Counter();
            whereClause.accept(new KeyValueExpressionVisitor(){

                @Override
                public Iterator<Expression> defaultIterator(Expression node) {
                    if (counter.getCount() == Counter.Count.MULTIPLE) {
                        return Iterators.emptyIterator();
                    }
                    return super.defaultIterator(node);
                }

                @Override
                public Void visit(KeyValueColumnExpression expression) {
                    counter.increment(expression);
                    return null;
                }
            });
            switch (counter.getCount()) {
                case NONE: {
                    PTable table = context.getResolver().getTables().get(0).getTable();
                    byte[] essentialCF = table.getType() == PTableType.VIEW ? ByteUtil.EMPTY_BYTE_ARRAY : SchemaUtil.getEmptyColumnFamily(table);
                    filter = new RowKeyComparisonFilter(whereClause, essentialCF);
                    break;
                }
                case SINGLE: {
                    filter = disambiguateWithFamily ? new SingleCFCQKeyValueComparisonFilter(whereClause) : new SingleCQKeyValueComparisonFilter(whereClause);
                    break;
                }
                case MULTIPLE: {
                    filter = disambiguateWithFamily ? new MultiCFCQKeyValueComparisonFilter(whereClause) : new MultiCQKeyValueComparisonFilter(whereClause);
                }
            }
        }
        scan.setFilter(filter);
        ScanRanges scanRanges = context.getScanRanges();
        boolean forcedSkipScan = statement.getHint().hasHint(HintNode.Hint.SKIP_SCAN);
        boolean forcedRangeScan = statement.getHint().hasHint(HintNode.Hint.RANGE_SCAN);
        if (forcedSkipScan || scanRanges.useSkipScanFilter() && !forcedRangeScan) {
            ScanUtil.andFilterAtBeginning(scan, scanRanges.getSkipScanFilter());
        }
    }

    private static final class Counter {
        private Count count = Count.NONE;
        private KeyValueColumnExpression column;

        private Counter() {
        }

        public void increment(KeyValueColumnExpression column) {
            switch (this.count) {
                case NONE: {
                    this.count = Count.SINGLE;
                    this.column = column;
                    break;
                }
                case SINGLE: {
                    this.count = column.equals(this.column) ? Count.SINGLE : Count.MULTIPLE;
                    break;
                }
            }
        }

        public Count getCount() {
            return this.count;
        }

        public static enum Count {
            NONE,
            SINGLE,
            MULTIPLE;

        }
    }

    private static class WhereExpressionCompiler
    extends ExpressionCompiler {
        private boolean disambiguateWithFamily;

        WhereExpressionCompiler(StatementContext context) {
            super(context, true);
        }

        WhereExpressionCompiler(StatementContext context, boolean resolveViewConstants) {
            super(context, resolveViewConstants);
        }

        @Override
        public Expression visit(ColumnParseNode node) throws SQLException {
            ColumnRef ref = this.resolveColumn(node);
            TableRef tableRef = ref.getTableRef();
            if (tableRef.equals(this.context.getCurrentTable()) && !SchemaUtil.isPKColumn(ref.getColumn())) {
                this.context.addWhereCoditionColumn(ref.getColumn().getFamilyName().getBytes(), ref.getColumn().getName().getBytes());
            }
            return ref.newColumnExpression();
        }

        @Override
        protected ColumnRef resolveColumn(ColumnParseNode node) throws SQLException {
            ColumnRef ref = super.resolveColumn(node);
            PTable table = ref.getTable();
            try {
                if (!SchemaUtil.isPKColumn(ref.getColumn())) {
                    table.getColumn(ref.getColumn().getName().getString());
                }
            }
            catch (AmbiguousColumnException e) {
                this.disambiguateWithFamily = true;
            }
            return ref;
        }
    }
}

