/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.compile;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.compile.KeyPart;
import org.apache.phoenix.compile.ScanRanges;
import org.apache.phoenix.compile.StatementContext;
import org.apache.phoenix.expression.AndExpression;
import org.apache.phoenix.expression.BaseExpression;
import org.apache.phoenix.expression.BaseTerminalExpression;
import org.apache.phoenix.expression.CoerceExpression;
import org.apache.phoenix.expression.ComparisonExpression;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.InListExpression;
import org.apache.phoenix.expression.IsNullExpression;
import org.apache.phoenix.expression.LikeExpression;
import org.apache.phoenix.expression.LiteralExpression;
import org.apache.phoenix.expression.OrExpression;
import org.apache.phoenix.expression.RowKeyColumnExpression;
import org.apache.phoenix.expression.RowValueConstructorExpression;
import org.apache.phoenix.expression.function.FunctionExpression;
import org.apache.phoenix.expression.function.ScalarFunction;
import org.apache.phoenix.expression.visitor.TraverseNoExpressionVisitor;
import org.apache.phoenix.parse.FilterableStatement;
import org.apache.phoenix.parse.HintNode;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.RowKeySchema;
import org.apache.phoenix.schema.SaltingUtil;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.SchemaUtil;

public class WhereOptimizer {
    private static final List<KeyRange> EVERYTHING_RANGES = Collections.singletonList(KeyRange.EVERYTHING_RANGE);
    private static final List<KeyRange> SALT_PLACEHOLDER = Collections.singletonList(PDataType.CHAR.getKeyRange(QueryConstants.SEPARATOR_BYTE_ARRAY));

    private WhereOptimizer() {
    }

    public static Expression pushKeyExpressionsToScan(StatementContext context, FilterableStatement statement, Expression whereClause) {
        return WhereOptimizer.pushKeyExpressionsToScan(context, statement, whereClause, null);
    }

    public static Expression pushKeyExpressionsToScan(StatementContext context, FilterableStatement statement, Expression whereClause, Set<Expression> extractNodes) {
        PName tenantId = context.getConnection().getTenantId();
        PTable table = context.getResolver().getTables().get(0).getTable();
        if (!(whereClause != null || tenantId != null && table.isMultiTenant())) {
            context.setScanRanges(ScanRanges.EVERYTHING);
            return whereClause;
        }
        if (LiteralExpression.isFalse(whereClause)) {
            context.setScanRanges(ScanRanges.NOTHING);
            return null;
        }
        KeyExpressionVisitor visitor = new KeyExpressionVisitor(context, table);
        KeyExpressionVisitor.KeySlots keySlots = null;
        if (whereClause != null) {
            keySlots = whereClause.accept(visitor);
            if (!(keySlots != null || tenantId != null && table.isMultiTenant())) {
                context.setScanRanges(ScanRanges.EVERYTHING);
                return whereClause;
            }
            if (keySlots == KeyExpressionVisitor.DEGENERATE_KEY_PARTS) {
                context.setScanRanges(ScanRanges.NOTHING);
                return null;
            }
        }
        if (keySlots == null) {
            keySlots = KeyExpressionVisitor.DEGENERATE_KEY_PARTS;
        }
        if (extractNodes == null) {
            extractNodes = new HashSet<Expression>(table.getPKColumns().size());
        }
        int pkPos = -1;
        Integer nBuckets = table.getBucketNum();
        int fullyQualifiedColumnCount = table.getPKColumns().size() - (nBuckets == null ? 0 : 1);
        RowKeySchema schema = table.getRowKeySchema();
        ArrayList<List<KeyRange>> cnf = Lists.newArrayListWithExpectedSize(schema.getMaxFields());
        boolean forcedSkipScan = statement.getHint().hasHint(HintNode.Hint.SKIP_SCAN);
        boolean forcedRangeScan = statement.getHint().hasHint(HintNode.Hint.RANGE_SCAN);
        boolean hasUnboundedRange = false;
        boolean hasAnyRange = false;
        Iterator<KeyExpressionVisitor.KeySlot> iterator = keySlots.iterator();
        if (nBuckets != null) {
            cnf.add(SALT_PLACEHOLDER);
            ++pkPos;
        }
        if (tenantId != null && table.isMultiTenant()) {
            KeyRange tenantIdKeyRange = KeyRange.getKeyRange(tenantId.getBytes());
            cnf.add(Collections.singletonList(tenantIdKeyRange));
            ++pkPos;
        }
        if (table.getViewIndexId() != null) {
            KeyRange indexIdKeyRange = KeyRange.getKeyRange(MetaDataUtil.getViewIndexIdDataType().toBytes(table.getViewIndexId()));
            cnf.add(Collections.singletonList(indexIdKeyRange));
            ++pkPos;
        }
        while (iterator.hasNext()) {
            KeyExpressionVisitor.KeySlot slot = iterator.next();
            if (slot == null || slot.getKeyRanges().isEmpty()) {
                if (forcedSkipScan) continue;
                break;
            }
            if (slot.getPKPosition() != pkPos + 1) {
                if (!forcedSkipScan) break;
                for (int i = pkPos + 1; i < slot.getPKPosition(); ++i) {
                    cnf.add(Collections.singletonList(KeyRange.EVERYTHING_RANGE));
                }
            }
            if (fullyQualifiedColumnCount > 1 && slot.getPKSpan() == fullyQualifiedColumnCount && !((Object)EVERYTHING_RANGES).equals(slot.getKeyRanges())) {
                schema = nBuckets == null ? SchemaUtil.VAR_BINARY_SCHEMA : SaltingUtil.VAR_BINARY_SALTED_SCHEMA;
            }
            KeyPart keyPart = slot.getKeyPart();
            pkPos = slot.getPKPosition();
            List<KeyRange> keyRanges = slot.getKeyRanges();
            cnf.add(keyRanges);
            for (KeyRange range : keyRanges) {
                if (!range.isUnbound()) continue;
                hasUnboundedRange = true;
                break;
            }
            if (!forcedRangeScan || !hasAnyRange) {
                List<Expression> nodesToExtract = keyPart.getExtractNodes();
                extractNodes.addAll(nodesToExtract);
            }
            if (hasUnboundedRange && !forcedSkipScan) break;
            hasAnyRange |= keyRanges.size() > 1 || keyRanges.size() == 1 && !keyRanges.get(0).isSingleKey();
        }
        context.setScanRanges(ScanRanges.create(cnf, schema, statement.getHint().hasHint(HintNode.Hint.RANGE_SCAN), nBuckets), keySlots.getMinMaxRange());
        if (whereClause == null) {
            return null;
        }
        return whereClause.accept(new RemoveExtractedNodesVisitor(extractNodes));
    }

    public static class KeyExpressionVisitor
    extends TraverseNoExpressionVisitor<KeySlots> {
        private static final KeySlots DEGENERATE_KEY_PARTS = new KeySlots(){

            @Override
            public Iterator<KeySlot> iterator() {
                return Iterators.emptyIterator();
            }

            @Override
            public KeyRange getMinMaxRange() {
                return null;
            }
        };
        private final PTable table;
        private final StatementContext context;

        private static boolean isDegenerate(List<KeyRange> keyRanges) {
            return keyRanges == null || keyRanges.isEmpty() || keyRanges.size() == 1 && keyRanges.get(0) == KeyRange.EMPTY_RANGE;
        }

        private static KeySlots newKeyParts(KeySlot slot, Expression extractNode, KeyRange keyRange) {
            if (keyRange == null) {
                return DEGENERATE_KEY_PARTS;
            }
            List<KeyRange> keyRanges = slot.getPKSpan() == 1 ? Collections.singletonList(keyRange) : EVERYTHING_RANGES;
            KeyRange minMaxRange = slot.getPKSpan() == 1 ? null : keyRange;
            return KeyExpressionVisitor.newKeyParts(slot, extractNode, keyRanges, minMaxRange);
        }

        private static KeySlots newKeyParts(KeySlot slot, Expression extractNode, List<KeyRange> keyRanges, KeyRange minMaxRange) {
            if (KeyExpressionVisitor.isDegenerate(keyRanges)) {
                return DEGENERATE_KEY_PARTS;
            }
            List extractNodes = extractNode == null || slot.getKeyPart().getExtractNodes().isEmpty() ? Collections.emptyList() : Collections.singletonList(extractNode);
            return new SingleKeySlot(new BaseKeyPart(slot.getKeyPart().getColumn(), extractNodes), slot.getPKPosition(), slot.getPKSpan(), keyRanges, minMaxRange, slot.getOrderPreserving());
        }

        private static KeySlots newKeyParts(KeySlot slot, List<Expression> extractNodes, List<KeyRange> keyRanges, KeyRange minMaxRange) {
            if (KeyExpressionVisitor.isDegenerate(keyRanges)) {
                return DEGENERATE_KEY_PARTS;
            }
            return new SingleKeySlot(new BaseKeyPart(slot.getKeyPart().getColumn(), extractNodes), slot.getPKPosition(), slot.getPKSpan(), keyRanges, minMaxRange, slot.getOrderPreserving());
        }

        private KeySlots newRowValueConstructorKeyParts(RowValueConstructorExpression rvc, List<KeySlots> childSlots) {
            KeySlots slots;
            KeySlot keySlot;
            List<Expression> childExtractNodes;
            if (childSlots.isEmpty() || rvc.isStateless()) {
                return null;
            }
            int positionOffset = (this.table.getBucketNum() == null ? 0 : 1) + (this.context.getConnection().getTenantId() != null && this.table.isMultiTenant() ? 1 : 0) + (this.table.getViewIndexId() == null ? 0 : 1);
            int position = 0;
            Iterator<KeySlots> i$ = childSlots.iterator();
            while (i$.hasNext() && (childExtractNodes = (keySlot = (slots = i$.next()).iterator().next()).getKeyPart().getExtractNodes()).size() == 1 && childExtractNodes.get(0) == rvc.getChildren().get(position) && keySlot.getPKPosition() == position + positionOffset) {
                ++position;
                assert (keySlot.getOrderPreserving() != FunctionExpression.OrderPreserving.NO);
                if (keySlot.getOrderPreserving() != FunctionExpression.OrderPreserving.YES_IF_LAST) continue;
                break;
            }
            if (position > 0) {
                int span = position;
                return new SingleKeySlot((KeyPart)new RowValueConstructorKeyPart(this.table.getPKColumns().get(positionOffset), rvc, span, childSlots), positionOffset, span, EVERYTHING_RANGES);
            }
            return null;
        }

        private static KeySlots newScalarFunctionKeyPart(KeySlot slot, ScalarFunction node) {
            if (KeyExpressionVisitor.isDegenerate(slot.getKeyRanges())) {
                return DEGENERATE_KEY_PARTS;
            }
            KeyPart part = node.newKeyPart(slot.getKeyPart());
            if (part == null) {
                return null;
            }
            return new SingleKeySlot(part, slot.getPKPosition(), slot.getKeyRanges(), node.preservesOrder());
        }

        private KeySlots newCoerceKeyPart(KeySlot slot, final CoerceExpression node) {
            if (KeyExpressionVisitor.isDegenerate(slot.getKeyRanges())) {
                return DEGENERATE_KEY_PARTS;
            }
            final KeyPart childPart = slot.getKeyPart();
            final ImmutableBytesWritable ptr = this.context.getTempPtr();
            return new SingleKeySlot(new KeyPart(){

                @Override
                public KeyRange getKeyRange(CompareFilter.CompareOp op, Expression rhs) {
                    KeyRange range = childPart.getKeyRange(op, rhs);
                    byte[] lower = range.getLowerRange();
                    if (!range.lowerUnbound()) {
                        ptr.set(lower);
                        node.getChild().getDataType().coerceBytes(ptr, node.getDataType(), rhs.getSortOrder(), node.getChild().getSortOrder());
                        lower = ByteUtil.copyKeyBytesIfNecessary(ptr);
                    }
                    byte[] upper = range.getUpperRange();
                    if (!range.upperUnbound()) {
                        ptr.set(upper);
                        node.getChild().getDataType().coerceBytes(ptr, node.getDataType(), rhs.getSortOrder(), node.getChild().getSortOrder());
                        upper = ByteUtil.copyKeyBytesIfNecessary(ptr);
                    }
                    return KeyRange.getKeyRange(lower, range.isLowerInclusive(), upper, range.isUpperInclusive());
                }

                @Override
                public List<Expression> getExtractNodes() {
                    return childPart.getExtractNodes();
                }

                @Override
                public PColumn getColumn() {
                    return childPart.getColumn();
                }
            }, slot.getPKPosition(), (List)slot.getKeyRanges());
        }

        private KeySlots andKeySlots(AndExpression andExpression, List<KeySlots> childSlots) {
            int nColumns = this.table.getPKColumns().size();
            KeySlot[] keySlot = new KeySlot[nColumns];
            KeyRange minMaxRange = KeyRange.EVERYTHING_RANGE;
            ArrayList<Expression> minMaxExtractNodes = Lists.newArrayList();
            int initPosition = (this.table.getBucketNum() == null ? 0 : 1) + (this.context.getConnection().getTenantId() != null && this.table.isMultiTenant() ? 1 : 0) + (this.table.getViewIndexId() == null ? 0 : 1);
            for (KeySlots childSlot : childSlots) {
                if (childSlot == DEGENERATE_KEY_PARTS) {
                    return DEGENERATE_KEY_PARTS;
                }
                if (childSlot.getMinMaxRange() != null) {
                    minMaxRange = minMaxRange.intersect(childSlot.getMinMaxRange());
                    for (KeySlot slot : childSlot) {
                        minMaxExtractNodes.addAll(slot.getKeyPart().getExtractNodes());
                    }
                    continue;
                }
                for (KeySlot slot : childSlot) {
                    if (slot == null) continue;
                    int position = slot.getPKPosition();
                    KeySlot existing = keySlot[position];
                    if (existing == null) {
                        keySlot[position] = slot;
                        continue;
                    }
                    keySlot[position] = existing.intersect(slot);
                    if (keySlot[position] != null) continue;
                    return DEGENERATE_KEY_PARTS;
                }
            }
            if (!minMaxExtractNodes.isEmpty()) {
                keySlot[initPosition] = keySlot[initPosition] == null ? new KeySlot(new BaseKeyPart(this.table.getPKColumns().get(initPosition), minMaxExtractNodes), initPosition, 1, EVERYTHING_RANGES, null) : keySlot[initPosition].concatExtractNodes(minMaxExtractNodes);
            }
            List<KeySlot> keySlots = Arrays.asList(keySlot);
            keySlots = keySlots.subList(initPosition, keySlots.size());
            return new MultiKeySlot(keySlots, minMaxRange == KeyRange.EVERYTHING_RANGE ? null : minMaxRange);
        }

        private KeySlots orKeySlots(OrExpression orExpression, List<KeySlots> childSlots) {
            if (orExpression.getChildren().size() != childSlots.size()) {
                return null;
            }
            int initialPos = (this.table.getBucketNum() == null ? 0 : 1) + (this.context.getConnection().getTenantId() != null && this.table.isMultiTenant() ? 1 : 0) + (this.table.getViewIndexId() == null ? 0 : 1);
            KeySlot theSlot = null;
            List<Expression> slotExtractNodes = Lists.newArrayList();
            int thePosition = -1;
            boolean extractAll = true;
            List<KeyRange> slotRanges = Lists.newArrayList();
            KeyRange minMaxRange = KeyRange.EMPTY_RANGE;
            for (KeySlots childSlot : childSlots) {
                List<Expression> extractNodes;
                if (childSlot == DEGENERATE_KEY_PARTS) continue;
                if (childSlot.getMinMaxRange() != null) {
                    if (!slotRanges.isEmpty() && thePosition != initialPos) {
                        return null;
                    }
                    minMaxRange = minMaxRange.union(childSlot.getMinMaxRange());
                    thePosition = initialPos;
                    for (KeySlot slot : childSlot) {
                        extractNodes = slot.getKeyPart().getExtractNodes();
                        extractAll &= !extractNodes.isEmpty();
                        slotExtractNodes.addAll(extractNodes);
                    }
                    continue;
                }
                for (KeySlot slot : childSlot) {
                    if (slot == null) continue;
                    if (thePosition == -1) {
                        theSlot = slot;
                        thePosition = slot.getPKPosition();
                    } else if (thePosition != slot.getPKPosition()) {
                        return null;
                    }
                    extractNodes = slot.getKeyPart().getExtractNodes();
                    extractAll &= !extractNodes.isEmpty();
                    slotExtractNodes.addAll(extractNodes);
                    slotRanges.addAll(slot.getKeyRanges());
                }
            }
            if (thePosition == -1) {
                return null;
            }
            if (!slotRanges.isEmpty() && minMaxRange != KeyRange.EMPTY_RANGE) {
                boolean clearExtracts = false;
                for (KeyRange range : slotRanges) {
                    KeyRange intersection;
                    if (!(clearExtracts || (intersection = minMaxRange.intersect(range)) != KeyRange.EMPTY_RANGE && range.equals(intersection.union(range)) && minMaxRange.equals(intersection.union(minMaxRange)))) {
                        clearExtracts = true;
                    }
                    minMaxRange = minMaxRange.union(range);
                }
                if (clearExtracts) {
                    extractAll = false;
                    slotExtractNodes = Collections.emptyList();
                }
                slotRanges = Collections.emptyList();
            }
            if (theSlot == null) {
                theSlot = new KeySlot(new BaseKeyPart(this.table.getPKColumns().get(initialPos), slotExtractNodes), initialPos, 1, EVERYTHING_RANGES, null);
            } else if (minMaxRange != KeyRange.EMPTY_RANGE && !slotExtractNodes.isEmpty()) {
                theSlot = theSlot.concatExtractNodes(slotExtractNodes);
            }
            return KeyExpressionVisitor.newKeyParts(theSlot, extractAll ? Collections.singletonList(orExpression) : slotExtractNodes, slotRanges.isEmpty() ? EVERYTHING_RANGES : KeyRange.coalesce(slotRanges), minMaxRange == KeyRange.EMPTY_RANGE ? null : minMaxRange);
        }

        public KeyExpressionVisitor(StatementContext context, PTable table) {
            this.context = context;
            this.table = table;
        }

        private boolean isFullyQualified(int pkSpan) {
            int nPKColumns = this.table.getPKColumns().size();
            return this.table.getBucketNum() == null ? pkSpan == nPKColumns : pkSpan == nPKColumns - 1;
        }

        @Override
        public KeySlots defaultReturn(Expression node, List<KeySlots> l) {
            return l.size() == 1 ? l.get(0) : null;
        }

        @Override
        public Iterator<Expression> visitEnter(CoerceExpression node) {
            return node.getChildren().iterator();
        }

        @Override
        public KeySlots visitLeave(CoerceExpression node, List<KeySlots> childParts) {
            if (childParts.isEmpty()) {
                return null;
            }
            return this.newCoerceKeyPart(childParts.get(0).iterator().next(), node);
        }

        @Override
        public Iterator<Expression> visitEnter(AndExpression node) {
            return node.getChildren().iterator();
        }

        @Override
        public KeySlots visitLeave(AndExpression node, List<KeySlots> l) {
            KeySlots keyExpr = this.andKeySlots(node, l);
            return keyExpr;
        }

        @Override
        public Iterator<Expression> visitEnter(OrExpression node) {
            return node.getChildren().iterator();
        }

        @Override
        public KeySlots visitLeave(OrExpression node, List<KeySlots> l) {
            KeySlots keySlots = this.orKeySlots(node, l);
            if (keySlots == null) {
                l.clear();
                return null;
            }
            return keySlots;
        }

        @Override
        public Iterator<Expression> visitEnter(RowValueConstructorExpression node) {
            return node.getChildren().iterator();
        }

        @Override
        public KeySlots visitLeave(RowValueConstructorExpression node, List<KeySlots> childSlots) {
            return this.newRowValueConstructorKeyParts(node, childSlots);
        }

        @Override
        public KeySlots visit(RowKeyColumnExpression node) {
            PColumn column = this.table.getPKColumns().get(node.getPosition());
            return new SingleKeySlot((KeyPart)new BaseKeyPart(column, Collections.singletonList(node)), node.getPosition(), 1, EVERYTHING_RANGES);
        }

        @Override
        public Iterator<Expression> visitEnter(ComparisonExpression node) {
            Expression rhs = node.getChildren().get(1);
            if (!rhs.isStateless() || node.getFilterOp() == CompareFilter.CompareOp.NOT_EQUAL) {
                return Iterators.emptyIterator();
            }
            return Iterators.singletonIterator(node.getChildren().get(0));
        }

        @Override
        public KeySlots visitLeave(ComparisonExpression node, List<KeySlots> childParts) {
            if (childParts.isEmpty()) {
                return null;
            }
            Expression rhs = node.getChildren().get(1);
            KeySlots childSlots = childParts.get(0);
            KeySlot childSlot = childSlots.iterator().next();
            KeyPart childPart = childSlot.getKeyPart();
            SortOrder sortOrder = childPart.getColumn().getSortOrder();
            CompareFilter.CompareOp op = sortOrder.transform(node.getFilterOp());
            KeyRange keyRange = childPart.getKeyRange(op, rhs);
            return KeyExpressionVisitor.newKeyParts(childSlot, node, keyRange);
        }

        @Override
        public Iterator<Expression> visitEnter(ScalarFunction node) {
            int index = node.getKeyFormationTraversalIndex();
            if (index < 0) {
                return Iterators.emptyIterator();
            }
            return Iterators.singletonIterator(node.getChildren().get(index));
        }

        @Override
        public KeySlots visitLeave(ScalarFunction node, List<KeySlots> childParts) {
            if (childParts.isEmpty()) {
                return null;
            }
            return KeyExpressionVisitor.newScalarFunctionKeyPart(childParts.get(0).iterator().next(), node);
        }

        @Override
        public Iterator<Expression> visitEnter(LikeExpression node) {
            if (!(node.getChildren().get(1) instanceof LiteralExpression) || node.startsWithWildcard()) {
                return Iterators.emptyIterator();
            }
            return Iterators.singletonIterator(node.getChildren().get(0));
        }

        @Override
        public KeySlots visitLeave(LikeExpression node, List<KeySlots> childParts) {
            if (childParts.isEmpty()) {
                return null;
            }
            KeySlots childSlots = childParts.get(0);
            KeySlot childSlot = childSlots.iterator().next();
            String startsWith = node.getLiteralPrefix();
            byte[] key = PDataType.CHAR.toBytes(startsWith, node.getChildren().get(0).getSortOrder());
            Integer childNodeFixedLength = node.getChildren().get(0).getMaxLength();
            if (childNodeFixedLength != null && key.length > childNodeFixedLength) {
                return DEGENERATE_KEY_PARTS;
            }
            PColumn column = childSlot.getKeyPart().getColumn();
            PDataType type = column.getDataType();
            KeyRange keyRange = type.getKeyRange(key, true, ByteUtil.nextKey(key), false);
            Integer columnFixedLength = column.getMaxLength();
            if (columnFixedLength != null) {
                keyRange = keyRange.fill(columnFixedLength);
            }
            return KeyExpressionVisitor.newKeyParts(childSlot, node.endsWithOnlyWildcard() ? node : null, keyRange);
        }

        @Override
        public Iterator<Expression> visitEnter(InListExpression node) {
            return Iterators.singletonIterator(node.getChildren().get(0));
        }

        @Override
        public KeySlots visitLeave(InListExpression node, List<KeySlots> childParts) {
            if (childParts.isEmpty()) {
                return null;
            }
            List<Expression> keyExpressions = node.getKeyExpressions();
            ArrayList<KeyRange> ranges = Lists.newArrayListWithExpectedSize(keyExpressions.size());
            KeySlot childSlot = childParts.get(0).iterator().next();
            KeyPart childPart = childSlot.getKeyPart();
            if (childSlot.getPKSpan() > 1 && !this.isFullyQualified(childSlot.getPKSpan())) {
                return KeyExpressionVisitor.newKeyParts(childSlot, (Expression)null, Collections.singletonList(KeyRange.getKeyRange(ByteUtil.copyKeyBytesIfNecessary(node.getMinKey()), true, ByteUtil.copyKeyBytesIfNecessary(node.getMaxKey()), true)), null);
            }
            for (Expression key : keyExpressions) {
                KeyRange range = childPart.getKeyRange(CompareFilter.CompareOp.EQUAL, key);
                if (range == KeyRange.EMPTY_RANGE) continue;
                ranges.add(range);
            }
            return KeyExpressionVisitor.newKeyParts(childSlot, node, ranges, null);
        }

        @Override
        public Iterator<Expression> visitEnter(IsNullExpression node) {
            return Iterators.singletonIterator(node.getChildren().get(0));
        }

        @Override
        public KeySlots visitLeave(IsNullExpression node, List<KeySlots> childParts) {
            if (childParts.isEmpty()) {
                return null;
            }
            KeySlots childSlots = childParts.get(0);
            KeySlot childSlot = childSlots.iterator().next();
            PColumn column = childSlot.getKeyPart().getColumn();
            PDataType type = column.getDataType();
            boolean isFixedWidth = type.isFixedWidth();
            if (isFixedWidth) {
                return node.isNegate() ? null : KeyExpressionVisitor.newKeyParts(childSlot, node, type.getKeyRange(new byte[SchemaUtil.getFixedByteSize(column)], true, KeyRange.UNBOUND, true));
            }
            KeyRange keyRange = node.isNegate() ? KeyRange.IS_NOT_NULL_RANGE : KeyRange.IS_NULL_RANGE;
            return KeyExpressionVisitor.newKeyParts(childSlot, node, keyRange);
        }

        private class RowValueConstructorKeyPart
        implements KeyPart {
            private final RowValueConstructorExpression rvc;
            private final PColumn column;
            private final List<Expression> nodes;
            private final List<KeySlots> childSlots;

            private RowValueConstructorKeyPart(PColumn column, RowValueConstructorExpression rvc, int span, List<KeySlots> childSlots) {
                this.column = column;
                if (span == rvc.getChildren().size()) {
                    this.rvc = rvc;
                    this.nodes = Collections.singletonList(rvc);
                    this.childSlots = childSlots;
                } else {
                    this.rvc = new RowValueConstructorExpression(rvc.getChildren().subList(0, span), rvc.isStateless());
                    this.nodes = Collections.emptyList();
                    this.childSlots = childSlots.subList(0, span);
                }
            }

            @Override
            public List<Expression> getExtractNodes() {
                return this.nodes;
            }

            @Override
            public PColumn getColumn() {
                return this.column;
            }

            @Override
            public KeyRange getKeyRange(CompareFilter.CompareOp op, Expression rhs) {
                CompareFilter.CompareOp rvcElementOp;
                CompareFilter.CompareOp compareOp = op == CompareFilter.CompareOp.LESS_OR_EQUAL ? CompareFilter.CompareOp.LESS : (rvcElementOp = op == CompareFilter.CompareOp.GREATER ? CompareFilter.CompareOp.GREATER_OR_EQUAL : op);
                if (op != CompareFilter.CompareOp.EQUAL) {
                    boolean usedAllOfLHS;
                    boolean bl = usedAllOfLHS = !this.nodes.isEmpty();
                    if (usedAllOfLHS && this.rvc.getChildren().size() < rhs.getChildren().size()) {
                        if (op == CompareFilter.CompareOp.LESS) {
                            op = CompareFilter.CompareOp.LESS_OR_EQUAL;
                        } else if (op == CompareFilter.CompareOp.GREATER_OR_EQUAL) {
                            op = CompareFilter.CompareOp.GREATER;
                        }
                    }
                    if (!usedAllOfLHS || this.rvc.getChildren().size() != rhs.getChildren().size()) {
                        rhs = new RowValueConstructorExpression(rhs.getChildren().subList(0, Math.min(this.rvc.getChildren().size(), rhs.getChildren().size())), rhs.isStateless());
                    }
                }
                final Iterator<KeySlots> keySlotsIterator = this.childSlots.iterator();
                try {
                    rhs = BaseExpression.coerce((Expression)this.rvc, rhs, new BaseExpression.ExpressionComparabilityWrapper(){

                        @Override
                        public Expression wrap(final Expression lhs, final Expression rhs) throws SQLException {
                            final KeyPart childPart = ((KeySlots)keySlotsIterator.next()).iterator().next().getKeyPart();
                            return new BaseTerminalExpression(){

                                @Override
                                public boolean evaluate(Tuple tuple, ImmutableBytesWritable ptr) {
                                    byte[] key;
                                    if (childPart == null) {
                                        return rhs.evaluate(tuple, ptr);
                                    }
                                    if (!rhs.evaluate(tuple, ptr)) {
                                        return false;
                                    }
                                    if (ptr.getLength() == 0) {
                                        ptr.set(ByteUtil.EMPTY_BYTE_ARRAY);
                                        return true;
                                    }
                                    KeyRange range = childPart.getKeyRange(rvcElementOp, rhs);
                                    if (range == KeyRange.EMPTY_RANGE) {
                                        return false;
                                    }
                                    byte[] byArray = key = range.isLowerInclusive() ? range.getLowerRange() : range.getUpperRange();
                                    if (lhs.getDataType().isFixedWidth() && lhs.getMaxLength() != null && key.length != lhs.getMaxLength()) {
                                        key = Arrays.copyOf(key, (int)lhs.getMaxLength());
                                    }
                                    ptr.set(key);
                                    return true;
                                }

                                @Override
                                public PDataType getDataType() {
                                    return childPart.getColumn().getDataType();
                                }

                                @Override
                                public boolean isNullable() {
                                    return childPart.getColumn().isNullable();
                                }

                                @Override
                                public Integer getMaxLength() {
                                    return lhs.getMaxLength();
                                }

                                @Override
                                public Integer getScale() {
                                    return childPart.getColumn().getScale();
                                }

                                @Override
                                public SortOrder getSortOrder() {
                                    return childPart.getColumn().getSortOrder();
                                }
                            };
                        }
                    });
                }
                catch (SQLException e) {
                    return null;
                }
                ImmutableBytesWritable ptr = KeyExpressionVisitor.this.context.getTempPtr();
                if (!rhs.evaluate(null, ptr) || ptr.getLength() == 0) {
                    return null;
                }
                byte[] key = ByteUtil.copyKeyBytesIfNecessary(ptr);
                return ByteUtil.getKeyRange(key, op, PDataType.VARBINARY);
            }
        }

        private static class BaseKeyPart
        implements KeyPart {
            private final PColumn column;
            private final List<Expression> nodes;

            @Override
            public KeyRange getKeyRange(CompareFilter.CompareOp op, Expression rhs) {
                Integer length;
                ImmutableBytesWritable ptr = new ImmutableBytesWritable();
                rhs.evaluate(null, ptr);
                byte[] key = ByteUtil.copyKeyBytesIfNecessary(ptr);
                PDataType type = this.getColumn().getDataType();
                if (type.isFixedWidth() && (length = this.getColumn().getMaxLength()) != null) {
                    key = ByteUtil.fillKey(key, length);
                }
                return ByteUtil.getKeyRange(key, op, type);
            }

            private BaseKeyPart(PColumn column, List<Expression> nodes) {
                this.column = column;
                this.nodes = nodes;
            }

            @Override
            public List<Expression> getExtractNodes() {
                return this.nodes;
            }

            @Override
            public PColumn getColumn() {
                return this.column;
            }
        }

        private static class SingleKeySlot
        implements KeySlots {
            private final KeySlot slot;
            private final KeyRange minMaxRange;

            private SingleKeySlot(KeyPart part, int pkPosition, List<KeyRange> ranges) {
                this(part, pkPosition, 1, ranges);
            }

            private SingleKeySlot(KeyPart part, int pkPosition, List<KeyRange> ranges, FunctionExpression.OrderPreserving orderPreserving) {
                this(part, pkPosition, 1, ranges, orderPreserving);
            }

            private SingleKeySlot(KeyPart part, int pkPosition, int pkSpan, List<KeyRange> ranges) {
                this(part, pkPosition, pkSpan, ranges, null, null);
            }

            private SingleKeySlot(KeyPart part, int pkPosition, int pkSpan, List<KeyRange> ranges, FunctionExpression.OrderPreserving orderPreserving) {
                this(part, pkPosition, pkSpan, ranges, null, orderPreserving);
            }

            private SingleKeySlot(KeyPart part, int pkPosition, int pkSpan, List<KeyRange> ranges, KeyRange minMaxRange, FunctionExpression.OrderPreserving orderPreserving) {
                this.slot = new KeySlot(part, pkPosition, pkSpan, ranges, orderPreserving);
                this.minMaxRange = minMaxRange;
            }

            @Override
            public Iterator<KeySlot> iterator() {
                return Iterators.singletonIterator(this.slot);
            }

            @Override
            public KeyRange getMinMaxRange() {
                return this.minMaxRange;
            }
        }

        private static class MultiKeySlot
        implements KeySlots {
            private final List<KeySlot> childSlots;
            private final KeyRange minMaxRange;

            private MultiKeySlot(List<KeySlot> childSlots, KeyRange minMaxRange) {
                this.childSlots = childSlots;
                this.minMaxRange = minMaxRange;
            }

            @Override
            public Iterator<KeySlot> iterator() {
                return this.childSlots.iterator();
            }

            @Override
            public KeyRange getMinMaxRange() {
                return this.minMaxRange;
            }
        }

        private static final class KeySlot {
            private final int pkPosition;
            private final int pkSpan;
            private final KeyPart keyPart;
            private final List<KeyRange> keyRanges;
            private final FunctionExpression.OrderPreserving orderPreserving;

            private KeySlot(KeyPart keyPart, int pkPosition, int pkSpan, List<KeyRange> keyRanges) {
                this(keyPart, pkPosition, pkSpan, keyRanges, FunctionExpression.OrderPreserving.YES);
            }

            private KeySlot(KeyPart keyPart, int pkPosition, int pkSpan, List<KeyRange> keyRanges, FunctionExpression.OrderPreserving orderPreserving) {
                this.pkPosition = pkPosition;
                this.pkSpan = pkSpan;
                this.keyPart = keyPart;
                this.keyRanges = keyRanges;
                this.orderPreserving = orderPreserving;
            }

            public KeyPart getKeyPart() {
                return this.keyPart;
            }

            public int getPKPosition() {
                return this.pkPosition;
            }

            public int getPKSpan() {
                return this.pkSpan;
            }

            public List<KeyRange> getKeyRanges() {
                return this.keyRanges;
            }

            public final KeySlot concatExtractNodes(List<Expression> extractNodes) {
                return new KeySlot(new BaseKeyPart(this.getKeyPart().getColumn(), SchemaUtil.concat(this.getKeyPart().getExtractNodes(), extractNodes)), this.getPKPosition(), this.getPKSpan(), this.getKeyRanges(), this.getOrderPreserving());
            }

            public final KeySlot intersect(KeySlot that) {
                if (this.getPKPosition() != that.getPKPosition()) {
                    throw new IllegalArgumentException("Position must be equal for intersect");
                }
                Preconditions.checkArgument(!this.keyRanges.isEmpty());
                Preconditions.checkArgument(!that.keyRanges.isEmpty());
                List<KeyRange> keyRanges = KeyRange.intersect(this.getKeyRanges(), that.getKeyRanges());
                if (KeyExpressionVisitor.isDegenerate(keyRanges)) {
                    return null;
                }
                return new KeySlot(new BaseKeyPart(this.getKeyPart().getColumn(), SchemaUtil.concat(this.getKeyPart().getExtractNodes(), that.getKeyPart().getExtractNodes())), this.getPKPosition(), this.getPKSpan(), keyRanges, this.getOrderPreserving());
            }

            public FunctionExpression.OrderPreserving getOrderPreserving() {
                return this.orderPreserving;
            }
        }

        private static interface KeySlots
        extends Iterable<KeySlot> {
            @Override
            public Iterator<KeySlot> iterator();

            public KeyRange getMinMaxRange();
        }
    }

    private static class RemoveExtractedNodesVisitor
    extends TraverseNoExpressionVisitor<Expression> {
        private final Set<Expression> nodesToRemove;

        private RemoveExtractedNodesVisitor(Set<Expression> nodesToRemove) {
            this.nodesToRemove = nodesToRemove;
        }

        @Override
        public Expression defaultReturn(Expression node, List<Expression> e) {
            return this.nodesToRemove.contains(node) ? null : node;
        }

        @Override
        public Iterator<Expression> visitEnter(OrExpression node) {
            return node.getChildren().iterator();
        }

        @Override
        public Iterator<Expression> visitEnter(AndExpression node) {
            return node.getChildren().iterator();
        }

        @Override
        public Expression visitLeave(AndExpression node, List<Expression> l) {
            if (l.size() != node.getChildren().size()) {
                if (l.isEmpty()) {
                    return LiteralExpression.newConstant((Object)true, true);
                }
                if (l.size() == 1) {
                    return l.get(0);
                }
                return new AndExpression(l);
            }
            return node;
        }
    }
}

