/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.cache.GlobalCache;
import org.apache.phoenix.cache.HashCache;
import org.apache.phoenix.cache.TenantCache;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.join.HashJoinInfo;
import org.apache.phoenix.join.ScanProjector;
import org.apache.phoenix.parse.JoinTableNode;
import org.apache.phoenix.schema.IllegalDataException;
import org.apache.phoenix.schema.KeyValueSchema;
import org.apache.phoenix.schema.ValueBitSet;
import org.apache.phoenix.schema.tuple.ResultTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.TupleUtil;

public class HashJoinRegionScanner
implements RegionScanner {
    private final RegionScanner scanner;
    private final ScanProjector projector;
    private final HashJoinInfo joinInfo;
    private Queue<Tuple> resultQueue;
    private boolean hasMore;
    private HashCache[] hashCaches;
    private List<Tuple>[] tempTuples;
    private ValueBitSet tempDestBitSet;
    private ValueBitSet[] tempSrcBitSet;

    public HashJoinRegionScanner(RegionScanner scanner, ScanProjector projector, HashJoinInfo joinInfo, ImmutableBytesWritable tenantId, RegionCoprocessorEnvironment env) throws IOException {
        this.scanner = scanner;
        this.projector = projector;
        this.joinInfo = joinInfo;
        this.resultQueue = new LinkedList<Tuple>();
        this.hasMore = true;
        if (joinInfo != null) {
            for (JoinTableNode.JoinType type : joinInfo.getJoinTypes()) {
                if (type == JoinTableNode.JoinType.Inner || type == JoinTableNode.JoinType.Left) continue;
                throw new DoNotRetryIOException("Got join type '" + (Object)((Object)type) + "'. Expect only INNER or LEFT with hash-joins.");
            }
            int count = joinInfo.getJoinIds().length;
            this.tempTuples = new List[count];
            this.hashCaches = new HashCache[count];
            this.tempSrcBitSet = new ValueBitSet[count];
            TenantCache cache = GlobalCache.getTenantCache(env, tenantId);
            for (int i = 0; i < count; ++i) {
                ImmutableBytesPtr joinId = joinInfo.getJoinIds()[i];
                HashCache hashCache = (HashCache)cache.getServerCache(joinId);
                if (hashCache == null) {
                    throw new DoNotRetryIOException("Could not find hash cache for joinId: " + Bytes.toString(joinId.get(), joinId.getOffset(), joinId.getLength()) + ". The cache might have expired and have been removed.");
                }
                this.hashCaches[i] = hashCache;
                this.tempSrcBitSet[i] = ValueBitSet.newInstance(joinInfo.getSchemas()[i]);
            }
            if (this.projector != null) {
                this.tempDestBitSet = ValueBitSet.newInstance(joinInfo.getJoinedSchema());
                this.projector.setValueBitSet(this.tempDestBitSet);
            }
        }
    }

    private void processResults(List<Cell> result, boolean hasLimit) throws IOException {
        if (result.isEmpty()) {
            return;
        }
        ResultTuple tuple = new ResultTuple(Result.create(result));
        if (this.joinInfo == null) {
            this.resultQueue.offer(this.projector.projectResults(tuple));
            return;
        }
        if (hasLimit) {
            throw new UnsupportedOperationException("Cannot support join operations in scans with limit");
        }
        int count = this.joinInfo.getJoinIds().length;
        boolean cont = true;
        for (int i = 0; i < count; ++i) {
            if (!this.joinInfo.earlyEvaluation()[i]) continue;
            ImmutableBytesPtr key = TupleUtil.getConcatenatedValue(tuple, this.joinInfo.getJoinExpressions()[i]);
            this.tempTuples[i] = this.hashCaches[i].get(key);
            JoinTableNode.JoinType type = this.joinInfo.getJoinTypes()[i];
            if (type != JoinTableNode.JoinType.Inner || this.tempTuples[i] != null) continue;
            cont = false;
            break;
        }
        if (cont) {
            Expression postFilter;
            int i;
            if (this.projector == null) {
                int dup = 1;
                for (i = 0; i < count; ++i) {
                    dup *= this.tempTuples[i] == null ? 1 : this.tempTuples[i].size();
                }
                for (i = 0; i < dup; ++i) {
                    this.resultQueue.offer(tuple);
                }
            } else {
                KeyValueSchema schema = this.joinInfo.getJoinedSchema();
                this.resultQueue.offer(this.projector.projectResults(tuple));
                for (i = 0; i < count; ++i) {
                    boolean earlyEvaluation = this.joinInfo.earlyEvaluation()[i];
                    if (earlyEvaluation && this.tempTuples[i] == null) continue;
                    int j = this.resultQueue.size();
                    while (j-- > 0) {
                        Tuple lhs = this.resultQueue.poll();
                        if (!earlyEvaluation) {
                            ImmutableBytesPtr key = TupleUtil.getConcatenatedValue(lhs, this.joinInfo.getJoinExpressions()[i]);
                            this.tempTuples[i] = this.hashCaches[i].get(key);
                            if (this.tempTuples[i] == null) {
                                if (this.joinInfo.getJoinTypes()[i] == JoinTableNode.JoinType.Inner) continue;
                                this.resultQueue.offer(lhs);
                                continue;
                            }
                        }
                        for (Tuple t : this.tempTuples[i]) {
                            Tuple joined = this.tempSrcBitSet[i] == ValueBitSet.EMPTY_VALUE_BITSET ? lhs : ScanProjector.mergeProjectedValue((ScanProjector.ProjectedValueTuple)lhs, schema, this.tempDestBitSet, t, this.joinInfo.getSchemas()[i], this.tempSrcBitSet[i], this.joinInfo.getFieldPositions()[i]);
                            this.resultQueue.offer(joined);
                        }
                    }
                }
            }
            if ((postFilter = this.joinInfo.getPostJoinFilterExpression()) != null) {
                Iterator iter = this.resultQueue.iterator();
                while (iter.hasNext()) {
                    ImmutableBytesWritable tempPtr;
                    block19: {
                        Tuple t = (Tuple)iter.next();
                        tempPtr = new ImmutableBytesWritable();
                        try {
                            if (!postFilter.evaluate(t, tempPtr)) {
                                iter.remove();
                            }
                            break block19;
                        }
                        catch (IllegalDataException e) {
                            iter.remove();
                        }
                        continue;
                    }
                    Boolean b = (Boolean)postFilter.getDataType().toObject(tempPtr);
                    if (b.booleanValue()) continue;
                    iter.remove();
                }
            }
        }
    }

    private boolean shouldAdvance() {
        if (!this.resultQueue.isEmpty()) {
            return false;
        }
        return this.hasMore;
    }

    private boolean nextInQueue(List<Cell> results) {
        if (this.resultQueue.isEmpty()) {
            return false;
        }
        Tuple tuple = this.resultQueue.poll();
        for (int i = 0; i < tuple.size(); ++i) {
            results.add(tuple.getValue(i));
        }
        return this.resultQueue.isEmpty() ? this.hasMore : true;
    }

    @Override
    public long getMvccReadPoint() {
        return this.scanner.getMvccReadPoint();
    }

    @Override
    public HRegionInfo getRegionInfo() {
        return this.scanner.getRegionInfo();
    }

    @Override
    public boolean isFilterDone() throws IOException {
        return this.scanner.isFilterDone() && this.resultQueue.isEmpty();
    }

    @Override
    public boolean nextRaw(List<Cell> result) throws IOException {
        while (this.shouldAdvance()) {
            this.hasMore = this.scanner.nextRaw(result);
            this.processResults(result, false);
            result.clear();
        }
        return this.nextInQueue(result);
    }

    @Override
    public boolean nextRaw(List<Cell> result, int limit) throws IOException {
        while (this.shouldAdvance()) {
            this.hasMore = this.scanner.nextRaw(result, limit);
            this.processResults(result, true);
            result.clear();
        }
        return this.nextInQueue(result);
    }

    @Override
    public boolean reseek(byte[] row) throws IOException {
        return this.scanner.reseek(row);
    }

    @Override
    public void close() throws IOException {
        this.scanner.close();
    }

    @Override
    public boolean next(List<Cell> result) throws IOException {
        while (this.shouldAdvance()) {
            this.hasMore = this.scanner.next(result);
            this.processResults(result, false);
            result.clear();
        }
        return this.nextInQueue(result);
    }

    @Override
    public boolean next(List<Cell> result, int limit) throws IOException {
        while (this.shouldAdvance()) {
            this.hasMore = this.scanner.next(result, limit);
            this.processResults(result, true);
            result.clear();
        }
        return this.nextInQueue(result);
    }

    @Override
    public long getMaxResultSize() {
        return this.scanner.getMaxResultSize();
    }
}

