/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import com.google.common.collect.Lists;
import com.google.protobuf.ByteString;
import com.google.protobuf.HBaseZeroCopyByteString;
import java.util.Collections;
import java.util.List;
import org.apache.phoenix.coprocessor.generated.MetaDataProtos;
import org.apache.phoenix.hbase.index.util.VersionUtil;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableImpl;
import org.apache.phoenix.util.ByteUtil;

public abstract class MetaDataProtocol
extends MetaDataProtos.MetaDataService {
    public static final int PHOENIX_MAJOR_VERSION = 4;
    public static final int PHOENIX_MINOR_VERSION = 0;
    public static final int PHOENIX_PATCH_NUMBER = 0;
    public static final int PHOENIX_VERSION = VersionUtil.encodeVersion(4, 0, 0);
    public static final long MIN_TABLE_TIMESTAMP = 0L;
    public static final long MIN_SYSTEM_TABLE_TIMESTAMP = 1L;
    public static final int DEFAULT_MAX_META_DATA_VERSIONS = 1000;

    public static class MetaDataMutationResult {
        private MutationCode returnCode;
        private long mutationTime;
        private PTable table;
        private List<byte[]> tableNamesToDelete;
        private byte[] columnName;
        private byte[] familyName;
        private boolean wasUpdated;

        public MetaDataMutationResult() {
        }

        public MetaDataMutationResult(MutationCode returnCode, long currentTime, PTable table, PColumn column) {
            this(returnCode, currentTime, table);
            if (column != null) {
                this.columnName = column.getName().getBytes();
                this.familyName = column.getFamilyName().getBytes();
            }
        }

        public MetaDataMutationResult(MutationCode returnCode, long currentTime, PTable table) {
            this(returnCode, currentTime, table, Collections.emptyList());
        }

        public MetaDataMutationResult(MutationCode returnCode, long currentTime, PTable table, boolean wasUpdated) {
            this(returnCode, currentTime, table, Collections.emptyList());
            this.wasUpdated = wasUpdated;
        }

        public MetaDataMutationResult(MutationCode returnCode, long currentTime, PTable table, List<byte[]> tableNamesToDelete) {
            this.returnCode = returnCode;
            this.mutationTime = currentTime;
            this.table = table;
            this.tableNamesToDelete = tableNamesToDelete;
        }

        public MutationCode getMutationCode() {
            return this.returnCode;
        }

        public long getMutationTime() {
            return this.mutationTime;
        }

        public boolean wasUpdated() {
            return this.wasUpdated;
        }

        public PTable getTable() {
            return this.table;
        }

        public void setTable(PTable table) {
            this.table = table;
        }

        public List<byte[]> getTableNamesToDelete() {
            return this.tableNamesToDelete;
        }

        public byte[] getColumnName() {
            return this.columnName;
        }

        public byte[] getFamilyName() {
            return this.familyName;
        }

        public static MetaDataMutationResult constructFromProto(MetaDataProtos.MetaDataResponse proto) {
            MetaDataMutationResult result = new MetaDataMutationResult();
            result.returnCode = MutationCode.values()[proto.getReturnCode().ordinal()];
            result.mutationTime = proto.getMutationTime();
            if (proto.hasTable()) {
                result.wasUpdated = true;
                result.table = PTableImpl.createFromProto(proto.getTable());
            }
            if (proto.getTablesToDeleteCount() > 0) {
                result.tableNamesToDelete = Lists.newArrayListWithExpectedSize(proto.getTablesToDeleteCount());
                for (ByteString tableName : proto.getTablesToDeleteList()) {
                    result.tableNamesToDelete.add(tableName.toByteArray());
                }
            }
            result.columnName = ByteUtil.EMPTY_BYTE_ARRAY;
            if (proto.hasColumnName()) {
                result.columnName = proto.getColumnName().toByteArray();
            }
            if (proto.hasFamilyName()) {
                result.familyName = proto.getFamilyName().toByteArray();
            }
            return result;
        }

        public static MetaDataProtos.MetaDataResponse toProto(MetaDataMutationResult result) {
            MetaDataProtos.MetaDataResponse.Builder builder = MetaDataProtos.MetaDataResponse.newBuilder();
            if (result != null) {
                builder.setReturnCode(MetaDataProtos.MutationCode.values()[result.getMutationCode().ordinal()]);
                builder.setMutationTime(result.getMutationTime());
                if (result.table != null) {
                    builder.setTable(PTableImpl.toProto(result.table));
                }
                if (result.getTableNamesToDelete() != null) {
                    for (byte[] tableName : result.tableNamesToDelete) {
                        builder.addTablesToDelete(HBaseZeroCopyByteString.wrap(tableName));
                    }
                }
                if (result.getColumnName() != null) {
                    builder.setColumnName(HBaseZeroCopyByteString.wrap(result.getColumnName()));
                }
                if (result.getFamilyName() != null) {
                    builder.setFamilyName(HBaseZeroCopyByteString.wrap(result.getFamilyName()));
                }
            }
            return builder.build();
        }
    }

    public static enum MutationCode {
        TABLE_ALREADY_EXISTS,
        TABLE_NOT_FOUND,
        COLUMN_NOT_FOUND,
        COLUMN_ALREADY_EXISTS,
        CONCURRENT_TABLE_MUTATION,
        TABLE_NOT_IN_REGION,
        NEWER_TABLE_FOUND,
        UNALLOWED_TABLE_MUTATION,
        NO_PK_COLUMNS,
        PARENT_TABLE_NOT_FOUND;

    }
}

