/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.cache.GlobalCache;
import org.apache.phoenix.cache.TenantCache;
import org.apache.phoenix.coprocessor.BaseRegionScanner;
import org.apache.phoenix.coprocessor.BaseScannerRegionObserver;
import org.apache.phoenix.coprocessor.HashJoinRegionScanner;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.KeyValueColumnExpression;
import org.apache.phoenix.expression.OrderByExpression;
import org.apache.phoenix.expression.function.ArrayIndexFunction;
import org.apache.phoenix.iterate.OrderedResultIterator;
import org.apache.phoenix.iterate.RegionScannerResultIterator;
import org.apache.phoenix.join.HashJoinInfo;
import org.apache.phoenix.join.ScanProjector;
import org.apache.phoenix.memory.MemoryManager;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.KeyValueSchema;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.ValueBitSet;
import org.apache.phoenix.schema.tuple.MultiKeyValueTuple;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.ServerUtil;

public class ScanRegionObserver
extends BaseScannerRegionObserver {
    private ImmutableBytesWritable ptr = new ImmutableBytesWritable();
    private KeyValueSchema kvSchema = null;
    private ValueBitSet kvSchemaBitSet;

    public static void serializeIntoScan(Scan scan, int thresholdBytes, int limit, List<OrderByExpression> orderByExpressions, int estimatedRowSize) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            DataOutputStream output = new DataOutputStream(stream);
            WritableUtils.writeVInt(output, thresholdBytes);
            WritableUtils.writeVInt(output, limit);
            WritableUtils.writeVInt(output, estimatedRowSize);
            WritableUtils.writeVInt(output, orderByExpressions.size());
            for (OrderByExpression orderingCol : orderByExpressions) {
                orderingCol.write(output);
            }
            scan.setAttribute("_TopN", stream.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static OrderedResultIterator deserializeFromScan(Scan scan, RegionScanner s) {
        byte[] topN = scan.getAttribute("_TopN");
        if (topN == null) {
            return null;
        }
        ByteArrayInputStream stream = new ByteArrayInputStream(topN);
        try {
            DataInputStream input = new DataInputStream(stream);
            int thresholdBytes = WritableUtils.readVInt(input);
            int limit = WritableUtils.readVInt(input);
            int estimatedRowSize = WritableUtils.readVInt(input);
            int size = WritableUtils.readVInt(input);
            ArrayList<OrderByExpression> orderByExpressions = Lists.newArrayListWithExpectedSize(size);
            for (int i = 0; i < size; ++i) {
                OrderByExpression orderByExpression = new OrderByExpression();
                orderByExpression.readFields(input);
                orderByExpressions.add(orderByExpression);
            }
            RegionScannerResultIterator inner = new RegionScannerResultIterator(s);
            OrderedResultIterator orderedResultIterator = new OrderedResultIterator(inner, orderByExpressions, thresholdBytes, limit >= 0 ? Integer.valueOf(limit) : null, estimatedRowSize);
            return orderedResultIterator;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Expression[] deserializeArrayPostionalExpressionInfoFromScan(Scan scan, RegionScanner s, List<KeyValueColumnExpression> arrayKVRefs) {
        byte[] specificArrayIdx = scan.getAttribute("_SpecificArrayIndex");
        if (specificArrayIdx == null) {
            return null;
        }
        KeyValueSchema.KeyValueSchemaBuilder builder = new KeyValueSchema.KeyValueSchemaBuilder(0);
        ByteArrayInputStream stream = new ByteArrayInputStream(specificArrayIdx);
        try {
            DataInputStream input = new DataInputStream(stream);
            int arrayKVRefSize = WritableUtils.readVInt(input);
            for (int i = 0; i < arrayKVRefSize; ++i) {
                KeyValueColumnExpression kvExp = new KeyValueColumnExpression();
                kvExp.readFields(input);
                arrayKVRefs.add(kvExp);
            }
            int arrayKVFuncSize = WritableUtils.readVInt(input);
            Expression[] arrayFuncRefs = new Expression[arrayKVFuncSize];
            for (int i = 0; i < arrayKVFuncSize; ++i) {
                ArrayIndexFunction arrayIdxFunc = new ArrayIndexFunction();
                arrayIdxFunc.readFields(input);
                arrayFuncRefs[i] = arrayIdxFunc;
                builder.addField(arrayIdxFunc);
            }
            this.kvSchema = builder.build();
            this.kvSchemaBitSet = ValueBitSet.newInstance(this.kvSchema);
            Expression[] expressionArray = arrayFuncRefs;
            return expressionArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    protected RegionScanner doPostScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, Scan scan, RegionScanner s) throws Throwable {
        byte[] isScanQuery = scan.getAttribute("_NonAggregateQuery");
        if (isScanQuery == null || Bytes.compareTo(PDataType.FALSE_BYTES, isScanQuery) == 0) {
            return s;
        }
        ScanProjector p = ScanProjector.deserializeProjectorFromScan(scan);
        HashJoinInfo j = HashJoinInfo.deserializeHashJoinFromScan(scan);
        ImmutableBytesWritable tenantId = ScanUtil.getTenantId(scan);
        RegionScanner innerScanner = s;
        if (p != null || j != null) {
            innerScanner = new HashJoinRegionScanner(s, p, j, tenantId, c.getEnvironment());
        }
        OrderedResultIterator iterator = ScanRegionObserver.deserializeFromScan(scan, innerScanner);
        ArrayList<KeyValueColumnExpression> arrayKVRefs = new ArrayList<KeyValueColumnExpression>();
        Expression[] arrayFuncRefs = this.deserializeArrayPostionalExpressionInfoFromScan(scan, innerScanner, arrayKVRefs);
        innerScanner = this.getWrappedScanner(c, innerScanner, arrayKVRefs, arrayFuncRefs);
        if (iterator == null) {
            return innerScanner;
        }
        return this.getTopNScanner(c, innerScanner, iterator, tenantId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegionScanner getTopNScanner(ObserverContext<RegionCoprocessorEnvironment> c, final RegionScanner s, final OrderedResultIterator iterator, ImmutableBytesWritable tenantId) throws Throwable {
        Tuple firstTuple;
        TenantCache tenantCache = GlobalCache.getTenantCache(c.getEnvironment(), tenantId);
        long estSize = iterator.getEstimatedByteSize();
        final MemoryManager.MemoryChunk chunk = tenantCache.getMemoryManager().allocate(estSize);
        final HRegion region = c.getEnvironment().getRegion();
        region.startRegionOperation();
        try {
            firstTuple = iterator.next();
            long actualSize = iterator.getByteSize();
            chunk.resize(actualSize);
        }
        catch (Throwable t) {
            ServerUtil.throwIOException(region.getRegionNameAsString(), t);
            RegionScanner regionScanner = null;
            return regionScanner;
        }
        finally {
            region.closeRegionOperation();
        }
        return new BaseRegionScanner(){
            private Tuple tuple;
            {
                this.tuple = firstTuple;
            }

            @Override
            public boolean isFilterDone() {
                return this.tuple == null;
            }

            @Override
            public HRegionInfo getRegionInfo() {
                return s.getRegionInfo();
            }

            @Override
            public boolean next(List<Cell> results) throws IOException {
                try {
                    if (this.isFilterDone()) {
                        return false;
                    }
                    for (int i = 0; i < this.tuple.size(); ++i) {
                        results.add(this.tuple.getValue(i));
                    }
                    this.tuple = iterator.next();
                    return !this.isFilterDone();
                }
                catch (Throwable t) {
                    ServerUtil.throwIOException(region.getRegionNameAsString(), t);
                    return false;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void close() throws IOException {
                try {
                    s.close();
                }
                finally {
                    chunk.close();
                }
            }

            @Override
            public long getMaxResultSize() {
                return s.getMaxResultSize();
            }
        };
    }

    private RegionScanner getWrappedScanner(final ObserverContext<RegionCoprocessorEnvironment> c, final RegionScanner s, final List<KeyValueColumnExpression> arrayKVRefs, final Expression[] arrayFuncRefs) {
        return new RegionScanner(){

            @Override
            public boolean next(List<Cell> results) throws IOException {
                try {
                    return s.next(results);
                }
                catch (Throwable t) {
                    ServerUtil.throwIOException(((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion().getRegionNameAsString(), t);
                    return false;
                }
            }

            @Override
            public boolean next(List<Cell> result, int limit) throws IOException {
                try {
                    return s.next(result, limit);
                }
                catch (Throwable t) {
                    ServerUtil.throwIOException(((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion().getRegionNameAsString(), t);
                    return false;
                }
            }

            @Override
            public void close() throws IOException {
                s.close();
            }

            @Override
            public HRegionInfo getRegionInfo() {
                return s.getRegionInfo();
            }

            @Override
            public boolean isFilterDone() throws IOException {
                return s.isFilterDone();
            }

            @Override
            public boolean reseek(byte[] row) throws IOException {
                return s.reseek(row);
            }

            @Override
            public long getMvccReadPoint() {
                return s.getMvccReadPoint();
            }

            @Override
            public boolean nextRaw(List<Cell> result) throws IOException {
                try {
                    boolean next = s.nextRaw(result);
                    if (result.size() == 0) {
                        return next;
                    }
                    if (arrayFuncRefs != null && arrayFuncRefs.length == 0 || arrayKVRefs.size() == 0) {
                        return next;
                    }
                    this.replaceArrayIndexElement(arrayKVRefs, arrayFuncRefs, result);
                    return next;
                }
                catch (Throwable t) {
                    ServerUtil.throwIOException(((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion().getRegionNameAsString(), t);
                    return false;
                }
            }

            @Override
            public boolean nextRaw(List<Cell> result, int limit) throws IOException {
                try {
                    boolean next = s.nextRaw(result, limit);
                    if (result.size() == 0) {
                        return next;
                    }
                    if (arrayFuncRefs != null && arrayFuncRefs.length == 0 || arrayKVRefs.size() == 0) {
                        return next;
                    }
                    this.replaceArrayIndexElement(arrayKVRefs, arrayFuncRefs, result);
                    return next;
                }
                catch (Throwable t) {
                    ServerUtil.throwIOException(((RegionCoprocessorEnvironment)c.getEnvironment()).getRegion().getRegionNameAsString(), t);
                    return false;
                }
            }

            private void replaceArrayIndexElement(List<KeyValueColumnExpression> arrayKVRefs2, Expression[] arrayFuncRefs2, List<Cell> result) {
                MultiKeyValueTuple tuple = new MultiKeyValueTuple(result);
                Cell rowKv = result.get(0);
                block0: for (int i = 0; i < arrayKVRefs2.size(); ++i) {
                    KeyValueColumnExpression kvExp = arrayKVRefs2.get(i);
                    if (!kvExp.evaluate(tuple, ScanRegionObserver.this.ptr)) continue;
                    for (int idx = tuple.size() - 1; idx >= 0; --idx) {
                        Cell kv = tuple.getValue(idx);
                        if (!Bytes.equals(kvExp.getColumnFamily(), 0, kvExp.getColumnFamily().length, kv.getFamilyArray(), kv.getFamilyOffset(), kv.getFamilyLength()) || !Bytes.equals(kvExp.getColumnName(), 0, kvExp.getColumnName().length, kv.getQualifierArray(), kv.getQualifierOffset(), kv.getQualifierLength())) continue;
                        result.remove(idx);
                        continue block0;
                    }
                }
                byte[] value = ScanRegionObserver.this.kvSchema.toBytes(tuple, arrayFuncRefs2, ScanRegionObserver.this.kvSchemaBitSet, ScanRegionObserver.this.ptr);
                result.add(new KeyValue(rowKv.getRowArray(), rowKv.getRowOffset(), rowKv.getRowLength(), QueryConstants.ARRAY_VALUE_COLUMN_FAMILY, 0, QueryConstants.ARRAY_VALUE_COLUMN_FAMILY.length, QueryConstants.ARRAY_VALUE_COLUMN_QUALIFIER, 0, QueryConstants.ARRAY_VALUE_COLUMN_QUALIFIER.length, Long.MAX_VALUE, KeyValue.Type.codeToType(rowKv.getTypeByte()), value, 0, value.length));
            }

            @Override
            public long getMaxResultSize() {
                return s.getMaxResultSize();
            }
        };
    }
}

