/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.Sequence;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.util.KeyValueUtil;
import org.apache.phoenix.util.ServerUtil;

public class SequenceRegionObserver
extends BaseRegionObserver {
    public static final String OPERATION_ATTRIB = "SEQUENCE_OPERATION";
    public static final String MAX_TIMERANGE_ATTRIB = "MAX_TIMERANGE";
    public static final String CURRENT_VALUE_ATTRIB = "CURRENT_VALUE";
    private static final byte[] SUCCESS_VALUE = PDataType.INTEGER.toBytes(0);

    private static Result getErrorResult(byte[] row, long timestamp, int errorCode) {
        byte[] errorCodeBuf = new byte[PDataType.INTEGER.getByteSize().intValue()];
        PDataType.INTEGER.getCodec().encodeInt(errorCode, errorCodeBuf, 0);
        return Result.create(Collections.singletonList(KeyValueUtil.newKeyValue(row, PhoenixDatabaseMetaData.SEQUENCE_FAMILY_BYTES, QueryConstants.EMPTY_COLUMN_BYTES, timestamp, errorCodeBuf)));
    }

    private static void acquireLock(HRegion region, byte[] key, List<HRegion.RowLock> locks) throws IOException {
        HRegion.RowLock rowLock = region.getRowLock(key);
        if (rowLock == null) {
            throw new IOException("Failed to acquire lock on " + Bytes.toStringBinary(key));
        }
        locks.add(rowLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result preIncrement(ObserverContext<RegionCoprocessorEnvironment> e, Increment increment) throws IOException {
        RegionCoprocessorEnvironment env = e.getEnvironment();
        e.bypass();
        e.complete();
        HRegion region = env.getRegion();
        byte[] row = increment.getRow();
        ArrayList<HRegion.RowLock> locks = Lists.newArrayList();
        TimeRange tr = increment.getTimeRange();
        region.startRegionOperation();
        try {
            Result result;
            block16: {
                boolean validateOnly;
                block15: {
                    SequenceRegionObserver.acquireLock(region, row, locks);
                    try {
                        long maxTimestamp = tr.getMax();
                        if (maxTimestamp == Long.MAX_VALUE) {
                            maxTimestamp = EnvironmentEdgeManager.currentTimeMillis();
                            tr = new TimeRange(tr.getMin(), maxTimestamp);
                        }
                        validateOnly = true;
                        Get get = new Get(row);
                        get.setTimeRange(tr.getMin(), tr.getMax());
                        for (Map.Entry entry : increment.getFamilyCellMap().entrySet()) {
                            byte[] cf = (byte[])entry.getKey();
                            for (Cell cq : (List)entry.getValue()) {
                                long value = PDataType.LONG.getCodec().decodeLong(cq.getValueArray(), cq.getValueOffset(), SortOrder.getDefault());
                                get.addColumn(cf, CellUtil.cloneQualifier(cq));
                                validateOnly &= (long)Sequence.Action.VALIDATE.ordinal() == value;
                            }
                        }
                        result = region.get(get);
                        if (!result.isEmpty()) break block15;
                        Result result2 = SequenceRegionObserver.getErrorResult(row, maxTimestamp, SQLExceptionCode.SEQUENCE_UNDEFINED.getErrorCode());
                        region.releaseRowLocks(locks);
                        return result2;
                    }
                    catch (Throwable throwable) {
                        try {
                            region.releaseRowLocks(locks);
                            throw throwable;
                        }
                        catch (Throwable t) {
                            ServerUtil.throwIOException("Increment of sequence " + Bytes.toStringBinary(row), t);
                            Result result3 = null;
                            return result3;
                        }
                    }
                }
                if (!validateOnly) break block16;
                Result result4 = result;
                region.releaseRowLocks(locks);
                return result4;
            }
            KeyValue keyValue = Sequence.getCurrentValueKV(result);
            KeyValue incrementByKV = Sequence.getIncrementByKV(result);
            KeyValue cacheSizeKV = Sequence.getCacheSizeKV(result);
            long value = PDataType.LONG.getCodec().decodeLong(keyValue.getValueArray(), keyValue.getValueOffset(), SortOrder.getDefault());
            long incrementBy = PDataType.LONG.getCodec().decodeLong(incrementByKV.getValueArray(), incrementByKV.getValueOffset(), SortOrder.getDefault());
            int cacheSize = PDataType.LONG.getCodec().decodeInt(cacheSizeKV.getValueArray(), cacheSizeKV.getValueOffset(), SortOrder.getDefault());
            byte[] valueBuffer = new byte[PDataType.LONG.getByteSize().intValue()];
            PDataType.LONG.getCodec().encodeLong(value += incrementBy * (long)cacheSize, valueBuffer, 0);
            Put put = new Put(row, keyValue.getTimestamp());
            KeyValue newCurrentValueKV = KeyValueUtil.newKeyValue(row, 0, row.length, keyValue.getFamilyArray(), keyValue.getFamilyOffset(), keyValue.getFamilyLength(), keyValue.getQualifierArray(), keyValue.getQualifierOffset(), keyValue.getQualifierLength(), keyValue.getTimestamp(), valueBuffer, 0, valueBuffer.length);
            put.add(newCurrentValueKV);
            Mutation[] mutations = new Mutation[]{put};
            region.batchMutate(mutations);
            Result result5 = Sequence.replaceCurrentValueKV(result, newCurrentValueKV);
            region.releaseRowLocks(locks);
            return result5;
        }
        finally {
            region.closeRegionOperation();
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public Result preAppend(ObserverContext<RegionCoprocessorEnvironment> e, Append append) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK]], but top level block is 11[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$org$apache$phoenix$coprocessor$SequenceRegionObserver$Op;

        static {
            $SwitchMap$org$apache$phoenix$coprocessor$SequenceRegionObserver$Op = new int[Op.values().length];
            try {
                1.$SwitchMap$org$apache$phoenix$coprocessor$SequenceRegionObserver$Op[Op.RETURN_SEQUENCE.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$phoenix$coprocessor$SequenceRegionObserver$Op[Op.DROP_SEQUENCE.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$org$apache$phoenix$coprocessor$SequenceRegionObserver$Op[Op.CREATE_SEQUENCE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }

    public static enum Op {
        CREATE_SEQUENCE,
        DROP_SEQUENCE,
        RETURN_SEQUENCE;

    }
}

