/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import java.io.IOException;
import java.sql.SQLException;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.CoprocessorException;
import org.apache.hadoop.hbase.coprocessor.CoprocessorService;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.cache.GlobalCache;
import org.apache.phoenix.cache.TenantCache;
import org.apache.phoenix.coprocessor.ServerCachingProtocol;
import org.apache.phoenix.coprocessor.generated.ServerCachingProtos;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.protobuf.ProtobufUtil;

public class ServerCachingEndpointImpl
extends ServerCachingProtos.ServerCachingService
implements CoprocessorService,
Coprocessor {
    private RegionCoprocessorEnvironment env;

    @Override
    public void addServerCache(RpcController controller, ServerCachingProtos.AddServerCacheRequest request, RpcCallback<ServerCachingProtos.AddServerCacheResponse> done) {
        ImmutableBytesPtr tenantId = null;
        if (request.hasTenantId()) {
            tenantId = new ImmutableBytesPtr(request.getTenantId().toByteArray());
        }
        TenantCache tenantCache = GlobalCache.getTenantCache(this.env, tenantId);
        ImmutableBytesWritable cachePtr = ProtobufUtil.toImmutableBytesWritable(request.getCachePtr());
        try {
            Class<?> serverCacheFactoryClass = Class.forName(request.getCacheFactory().getClassName());
            ServerCachingProtocol.ServerCacheFactory cacheFactory = (ServerCachingProtocol.ServerCacheFactory)serverCacheFactoryClass.newInstance();
            tenantCache.addServerCache(new ImmutableBytesPtr(request.getCacheId().toByteArray()), cachePtr, cacheFactory);
        }
        catch (Throwable e) {
            ProtobufUtil.setControllerException(controller, new IOException(e));
        }
        ServerCachingProtos.AddServerCacheResponse.Builder responseBuilder = ServerCachingProtos.AddServerCacheResponse.newBuilder();
        responseBuilder.setReturn(true);
        ServerCachingProtos.AddServerCacheResponse result = responseBuilder.build();
        done.run(result);
    }

    @Override
    public void removeServerCache(RpcController controller, ServerCachingProtos.RemoveServerCacheRequest request, RpcCallback<ServerCachingProtos.RemoveServerCacheResponse> done) {
        ImmutableBytesPtr tenantId = null;
        if (request.hasTenantId()) {
            tenantId = new ImmutableBytesPtr(request.getTenantId().toByteArray());
        }
        TenantCache tenantCache = GlobalCache.getTenantCache(this.env, tenantId);
        try {
            tenantCache.removeServerCache(new ImmutableBytesPtr(request.getCacheId().toByteArray()));
        }
        catch (SQLException e) {
            ProtobufUtil.setControllerException(controller, new IOException(e));
        }
        ServerCachingProtos.RemoveServerCacheResponse.Builder responseBuilder = ServerCachingProtos.RemoveServerCacheResponse.newBuilder();
        responseBuilder.setReturn(true);
        ServerCachingProtos.RemoveServerCacheResponse result = responseBuilder.build();
        done.run(result);
    }

    @Override
    public void start(CoprocessorEnvironment env) throws IOException {
        if (!(env instanceof RegionCoprocessorEnvironment)) {
            throw new CoprocessorException("Must be loaded on a table region!");
        }
        this.env = (RegionCoprocessorEnvironment)env;
    }

    @Override
    public void stop(CoprocessorEnvironment arg0) throws IOException {
    }

    @Override
    public Service getService() {
        return this;
    }
}

