/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.coprocessor;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.WritableUtils;
import org.apache.phoenix.coprocessor.BaseRegionScanner;
import org.apache.phoenix.coprocessor.BaseScannerRegionObserver;
import org.apache.phoenix.coprocessor.HashJoinRegionScanner;
import org.apache.phoenix.coprocessor.generated.PTableProtos;
import org.apache.phoenix.exception.ValueTypeIncompatibleException;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.ExpressionType;
import org.apache.phoenix.expression.aggregator.Aggregator;
import org.apache.phoenix.expression.aggregator.Aggregators;
import org.apache.phoenix.expression.aggregator.ServerAggregators;
import org.apache.phoenix.hbase.index.util.GenericKeyValueBuilder;
import org.apache.phoenix.hbase.index.util.KeyValueBuilder;
import org.apache.phoenix.join.HashJoinInfo;
import org.apache.phoenix.join.ScanProjector;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.ConstraintViolationException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PDataType;
import org.apache.phoenix.schema.PRow;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.PTableImpl;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.tuple.MultiKeyValueTuple;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.KeyValueUtil;
import org.apache.phoenix.util.ScanUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UngroupedAggregateRegionObserver
extends BaseScannerRegionObserver {
    public static final String UNGROUPED_AGG = "UngroupedAgg";
    public static final String DELETE_AGG = "DeleteAgg";
    public static final String UPSERT_SELECT_TABLE = "UpsertSelectTable";
    public static final String UPSERT_SELECT_EXPRS = "UpsertSelectExprs";
    public static final String DELETE_CQ = "DeleteCQ";
    public static final String DELETE_CF = "DeleteCF";
    public static final String EMPTY_CF = "EmptyCF";
    private static final Logger logger = LoggerFactory.getLogger(UngroupedAggregateRegionObserver.class);
    private KeyValueBuilder kvBuilder;

    @Override
    public void start(CoprocessorEnvironment e) throws IOException {
        super.start(e);
        this.kvBuilder = GenericKeyValueBuilder.INSTANCE;
    }

    private static void commitBatch(HRegion region, List<Mutation> mutations, byte[] indexUUID) throws IOException {
        if (indexUUID != null) {
            for (Mutation m : mutations) {
                m.setAttribute("IdxUUID", indexUUID);
            }
        }
        Mutation[] mutationArray = new Mutation[mutations.size()];
        region.batchMutate(mutations.toArray(mutationArray));
    }

    public static void serializeIntoScan(Scan scan) {
        scan.setAttribute("_UngroupedAgg", QueryConstants.TRUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected RegionScanner doPostScannerOpen(ObserverContext<RegionCoprocessorEnvironment> c, final Scan scan, RegionScanner s) throws IOException {
        byte[] isUngroupedAgg = scan.getAttribute("_UngroupedAgg");
        if (isUngroupedAgg == null) {
            return s;
        }
        ScanProjector p = ScanProjector.deserializeProjectorFromScan(scan);
        HashJoinInfo j = HashJoinInfo.deserializeHashJoinFromScan(scan);
        RegionScanner theScanner = s;
        if (p != null || j != null) {
            theScanner = new HashJoinRegionScanner(s, p, j, ScanUtil.getTenantId(scan), c.getEnvironment());
        }
        final RegionScanner innerScanner = theScanner;
        byte[] indexUUID = scan.getAttribute("IdxUUID");
        PTable projectedTable = null;
        List<Expression> selectExpressions = null;
        byte[] upsertSelectTable = scan.getAttribute("_UpsertSelectTable");
        boolean isUpsert = false;
        boolean isDelete = false;
        byte[] deleteCQ = null;
        byte[] deleteCF = null;
        Object values = null;
        byte[] emptyCF = null;
        ImmutableBytesWritable ptr = null;
        if (upsertSelectTable != null) {
            isUpsert = true;
            projectedTable = UngroupedAggregateRegionObserver.deserializeTable(upsertSelectTable);
            selectExpressions = UngroupedAggregateRegionObserver.deserializeExpressions(scan.getAttribute("_UpsertSelectExprs"));
            values = new byte[projectedTable.getPKColumns().size()][];
            ptr = new ImmutableBytesWritable();
        } else {
            byte[] isDeleteAgg = scan.getAttribute("_DeleteAgg");
            boolean bl = isDelete = isDeleteAgg != null && Bytes.compareTo(PDataType.TRUE_BYTES, isDeleteAgg) == 0;
            if (!isDelete) {
                deleteCF = scan.getAttribute("_DeleteCF");
                deleteCQ = scan.getAttribute("_DeleteCQ");
            }
            emptyCF = scan.getAttribute("_EmptyCF");
        }
        int batchSize = 0;
        long ts = scan.getTimeRange().getMax();
        HRegion region = c.getEnvironment().getRegion();
        List<Mutation> mutations = Collections.emptyList();
        if (isDelete || isUpsert || deleteCQ != null && deleteCF != null || emptyCF != null) {
            mutations = Lists.newArrayListWithExpectedSize(1024);
            batchSize = c.getEnvironment().getConfiguration().getInt("phoenix.mutate.batchSize", 1000);
        }
        ServerAggregators aggregators = ServerAggregators.deserialize(scan.getAttribute("_Aggs"), c.getEnvironment().getConfiguration());
        Aggregator[] rowAggregators = aggregators.getAggregators();
        boolean hasAny = false;
        MultiKeyValueTuple result = new MultiKeyValueTuple();
        if (logger.isInfoEnabled()) {
            logger.info("Starting ungrouped coprocessor scan " + scan);
        }
        long rowCount = 0L;
        region.startRegionOperation();
        try {
            boolean hasMore;
            do {
                block28: {
                    ArrayList<Cell> results = new ArrayList<Cell>();
                    hasMore = innerScanner.nextRaw(results);
                    if (results.isEmpty()) continue;
                    ++rowCount;
                    result.setKeyValues(results);
                    try {
                        if (isDelete) {
                            Cell firstKV = (Cell)results.get(0);
                            Delete delete = new Delete(firstKV.getRowArray(), firstKV.getRowOffset(), firstKV.getRowLength(), ts);
                            mutations.add(delete);
                        } else if (isUpsert) {
                            int i;
                            Arrays.fill((Object[])values, null);
                            List<PColumn> projectedColumns = projectedTable.getColumns();
                            for (i = 0; i < projectedTable.getPKColumns().size(); ++i) {
                                Expression expression = selectExpressions.get(i);
                                if (!expression.evaluate(result, ptr)) continue;
                                values[i] = ptr.copyBytes();
                                if (expression.getSortOrder() == projectedColumns.get(i).getSortOrder()) continue;
                                SortOrder.invert(values[i], 0, values[i], 0, values[i].length);
                            }
                            projectedTable.newKey(ptr, (byte[][])values);
                            PRow row = projectedTable.newRow(this.kvBuilder, ts, ptr, (byte[][])new byte[0][]);
                            while (i < projectedColumns.size()) {
                                Expression expression = selectExpressions.get(i);
                                if (expression.evaluate(result, ptr)) {
                                    PColumn column = projectedColumns.get(i);
                                    Object value = expression.getDataType().toObject(ptr, column.getSortOrder());
                                    if (!column.getDataType().isSizeCompatible(ptr, value, column.getDataType(), expression.getMaxLength(), expression.getScale(), column.getMaxLength(), column.getScale())) {
                                        throw new ValueTypeIncompatibleException(column.getDataType(), column.getMaxLength(), column.getScale());
                                    }
                                    column.getDataType().coerceBytes(ptr, value, expression.getDataType(), expression.getMaxLength(), expression.getScale(), expression.getSortOrder(), column.getMaxLength(), column.getScale(), column.getSortOrder());
                                    byte[] bytes = ByteUtil.copyKeyBytesIfNecessary(ptr);
                                    row.setValue(column, bytes);
                                }
                                ++i;
                            }
                            for (Mutation mutation : row.toRowMutations()) {
                                mutations.add(mutation);
                            }
                        } else if (deleteCF != null && deleteCQ != null && (emptyCF == null || result.getValue(deleteCF, deleteCQ) != null)) {
                            Delete delete = new Delete(((Cell)results.get(0)).getRowArray(), ((Cell)results.get(0)).getRowOffset(), ((Cell)results.get(0)).getRowLength());
                            delete.deleteColumns(deleteCF, deleteCQ, ts);
                            mutations.add(delete);
                        }
                        if (emptyCF != null) {
                            HashSet timeStamps = Sets.newHashSetWithExpectedSize(results.size());
                            for (Cell kv : results) {
                                long kvts = kv.getTimestamp();
                                if (timeStamps.contains(kvts)) continue;
                                Put put = new Put(kv.getRowArray(), kv.getRowOffset(), kv.getRowLength());
                                put.add(emptyCF, QueryConstants.EMPTY_COLUMN_BYTES, kvts, ByteUtil.EMPTY_BYTE_ARRAY);
                                mutations.add(put);
                            }
                        }
                        if (mutations.isEmpty() || batchSize <= 0 || mutations.size() % batchSize != 0) break block28;
                        UngroupedAggregateRegionObserver.commitBatch(region, mutations, indexUUID);
                        mutations.clear();
                    }
                    catch (ConstraintViolationException e) {
                        logger.error("Failed to create row in " + region.getRegionNameAsString() + " with values " + SchemaUtil.toString(values), e);
                        continue;
                    }
                }
                ((Aggregators)aggregators).aggregate(rowAggregators, result);
                hasAny = true;
            } while (hasMore);
        }
        finally {
            innerScanner.close();
            region.closeRegionOperation();
        }
        if (logger.isInfoEnabled()) {
            logger.info("Finished scanning " + rowCount + " rows for ungrouped coprocessor scan " + scan);
        }
        if (!mutations.isEmpty()) {
            UngroupedAggregateRegionObserver.commitBatch(region, mutations, indexUUID);
        }
        final boolean hadAny = hasAny;
        KeyValue keyValue = null;
        if (hadAny) {
            byte[] value = aggregators.toBytes(rowAggregators);
            keyValue = KeyValueUtil.newKeyValue(QueryConstants.UNGROUPED_AGG_ROW_KEY, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Long.MAX_VALUE, value, 0, value.length);
        }
        final KeyValue aggKeyValue = keyValue;
        BaseRegionScanner scanner = new BaseRegionScanner(){
            private boolean done;
            {
                this.done = !hadAny;
            }

            @Override
            public HRegionInfo getRegionInfo() {
                return innerScanner.getRegionInfo();
            }

            @Override
            public boolean isFilterDone() {
                return this.done;
            }

            @Override
            public void close() throws IOException {
                innerScanner.close();
            }

            @Override
            public boolean next(List<Cell> results) throws IOException {
                if (this.done) {
                    return false;
                }
                this.done = true;
                results.add(aggKeyValue);
                return false;
            }

            @Override
            public long getMaxResultSize() {
                return scan.getMaxResultSize();
            }
        };
        return scanner;
    }

    private static PTable deserializeTable(byte[] b) {
        try {
            PTableProtos.PTable ptableProto = PTableProtos.PTable.parseFrom(b);
            return PTableImpl.createFromProto(ptableProto);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<Expression> deserializeExpressions(byte[] b) {
        ByteArrayInputStream stream = new ByteArrayInputStream(b);
        try {
            DataInputStream input = new DataInputStream(stream);
            int size = WritableUtils.readVInt(input);
            ArrayList<Expression> selectExpressions = Lists.newArrayListWithExpectedSize(size);
            for (int i = 0; i < size; ++i) {
                ExpressionType type = ExpressionType.values()[WritableUtils.readVInt(input)];
                Expression selectExpression = type.newInstance();
                selectExpression.readFields(input);
                selectExpressions.add(selectExpression);
            }
            ArrayList<Expression> arrayList = selectExpressions;
            return arrayList;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static byte[] serialize(PTable projectedTable) {
        PTableProtos.PTable ptableProto = PTableImpl.toProto(projectedTable);
        return ptableProto.toByteArray();
    }

    public static byte[] serialize(List<Expression> selectExpressions) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        try {
            DataOutputStream output = new DataOutputStream(stream);
            WritableUtils.writeVInt(output, selectExpressions.size());
            for (int i = 0; i < selectExpressions.size(); ++i) {
                Expression expression = selectExpressions.get(i);
                WritableUtils.writeVInt(output, ExpressionType.valueOf(expression).ordinal());
                expression.write(output);
            }
            byte[] byArray = stream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

