/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.exception;

import java.sql.SQLException;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.util.SchemaUtil;

public class SQLExceptionInfo {
    public static final String SCHEMA_NAME = "schemaName";
    public static final String TABLE_NAME = "tableName";
    public static final String FAMILY_NAME = "familyName";
    public static final String COLUMN_NAME = "columnName";
    private final Throwable rootCause;
    private final SQLExceptionCode code;
    private final String message;
    private final String schemaName;
    private final String tableName;
    private final String familyName;
    private final String columnName;

    private SQLExceptionInfo(Builder builder) {
        this.code = builder.code;
        this.rootCause = builder.rootCause;
        this.message = builder.message;
        this.schemaName = builder.schemaName;
        this.tableName = builder.tableName;
        this.familyName = builder.familyName;
        this.columnName = builder.columnName;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.code.toString());
        if (this.message != null) {
            builder.append(" ").append(this.message);
        }
        String columnDisplayName = SchemaUtil.getMetaDataEntityName(this.schemaName, this.tableName, this.familyName, this.columnName);
        if (this.columnName != null) {
            builder.append(" ").append(COLUMN_NAME).append("=").append(columnDisplayName);
        } else if (this.familyName != null) {
            builder.append(" ").append(FAMILY_NAME).append("=").append(columnDisplayName);
        } else if (this.tableName != null) {
            builder.append(" ").append(TABLE_NAME).append("=").append(columnDisplayName);
        } else if (this.schemaName != null) {
            builder.append(" ").append(SCHEMA_NAME).append("=").append(columnDisplayName);
        }
        return builder.toString();
    }

    public SQLException buildException() {
        return this.code.getExceptionFactory().newException(this);
    }

    public Throwable getRootCause() {
        return this.rootCause;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public SQLExceptionCode getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public static class Builder {
        private Throwable rootCause;
        private SQLExceptionCode code;
        private String message;
        private String schemaName;
        private String tableName;
        private String familyName;
        private String columnName;

        public Builder(SQLExceptionCode code) {
            this.code = code;
        }

        public Builder setRootCause(Throwable t) {
            this.rootCause = t;
            return this;
        }

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        public Builder setSchemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public Builder setTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder setFamilyName(String familyName) {
            this.familyName = familyName;
            return this;
        }

        public Builder setColumnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public SQLExceptionInfo build() {
            return new SQLExceptionInfo(this);
        }

        public String toString() {
            return this.code.toString();
        }
    }
}

